/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.shape.PathUtils;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.tk.TextHelper;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;

public final class Text
extends javafx.scene.shape.Shape {
    private StringProperty text;
    private DoubleProperty x;
    private DoubleProperty y;
    @Styleable(property="-fx-font", inherits=true)
    private ObjectProperty<Font> font;
    @Styleable(property="-fx-text-origin", initial="baseline")
    private ObjectProperty<VPos> textOrigin;
    private ObjectProperty<TextBoundsType> boundsType;
    private DoubleProperty wrappingWidth;
    @Styleable(property="-fx-underline", initial="false")
    private BooleanProperty underline;
    @Styleable(property="-fx-strikethrough", initial="false")
    private BooleanProperty strikethrough;
    @Styleable(property="-fx-text-alignment", initial="left", inherits=true)
    private ObjectProperty<TextAlignment> textAlignment;
    private ReadOnlyDoubleWrapper baselineOffset;
    @Deprecated
    private ObjectProperty<PathElement[]> impl_selectionShape;
    @Deprecated
    private IntegerProperty impl_selectionStart;
    @Deprecated
    private IntegerProperty impl_selectionEnd;
    @Deprecated
    private ObjectProperty<PathElement[]> impl_caretShape;
    @Deprecated
    private IntegerProperty impl_caretPosition;
    @Deprecated
    private BooleanProperty impl_caretBias;
    private TextHelper textHelper;
    private RectBounds impl_layoutBounds = new RectBounds();
    private boolean impl_layoutBoundsInvalid = true;
    private ObjectProperty<Paint> selectionFill;

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGText();
    }

    PGText getPGText() {
        return (PGText)this.impl_getPGNode();
    }

    public Text() {
        this.setPickOnBounds(true);
        this.getDecorationShapes();
        this.setBaselineOffset(Toolkit.getToolkit().getFontLoader().getFontMetrics(this.getFontInternal()).getAscent());
    }

    public Text(String string) {
        this();
        this.setText(string);
    }

    public Text(double d, double d2, String string) {
        this(string);
        this.setX(d);
        this.setY(d2);
    }

    public final void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.textProperty().set(string);
    }

    public final String getText() {
        return this.text == null ? "" : (String)this.text.get();
    }

    private String getTextInternal() {
        String string = this.getText();
        return string == null ? "" : string;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(""){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                    Text.this.setImpl_selectionStart(-1);
                    Text.this.setImpl_selectionEnd(-1);
                    Text.this.impl_geomChanged();
                    String string = this.get();
                    if (string == null && !this.isBound()) {
                        this.set("");
                    }
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "text";
                }
            };
        }
        return this.text;
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFont(Font font) {
        this.fontProperty().set(font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    private Font getFontInternal() {
        Font font = this.getFont();
        return font != null ? font : Font.getDefault();
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new ObjectPropertyBase<Font>(Font.getDefault()){

                @Override
                public void invalidated() {
                    Text.this.impl_cssPropertyInvalidated(StyleableProperties.FONT);
                    Text.this.impl_markDirty(DirtyBits.TEXT_FONT);
                    Text.this.impl_geomChanged();
                    Text.this.setBaselineOffset(Toolkit.getToolkit().getFontLoader().getFontMetrics(Text.this.getFontInternal()).getAscent());
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setTextOrigin(VPos vPos) {
        this.textOriginProperty().set(vPos);
    }

    public final VPos getTextOrigin() {
        return this.textOrigin == null ? VPos.BASELINE : (VPos)((Object)this.textOrigin.get());
    }

    public final ObjectProperty<VPos> textOriginProperty() {
        if (this.textOrigin == null) {
            this.textOrigin = new ObjectPropertyBase<VPos>(VPos.BASELINE){

                @Override
                public void invalidated() {
                    Text.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_ORIGIN);
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "textOrigin";
                }
            };
        }
        return this.textOrigin;
    }

    public final void setBoundsType(TextBoundsType textBoundsType) {
        this.boundsTypeProperty().set(textBoundsType);
    }

    public final TextBoundsType getBoundsType() {
        return this.boundsType == null ? TextBoundsType.LOGICAL : (TextBoundsType)((Object)this.boundsType.get());
    }

    public final ObjectProperty<TextBoundsType> boundsTypeProperty() {
        if (this.boundsType == null) {
            this.boundsType = new ObjectPropertyBase<TextBoundsType>(TextBoundsType.LOGICAL){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "boundsType";
                }
            };
        }
        return this.boundsType;
    }

    public final void setWrappingWidth(double d) {
        this.wrappingWidthProperty().set(d);
    }

    public final double getWrappingWidth() {
        return this.wrappingWidth == null ? 0.0 : this.wrappingWidth.get();
    }

    public final DoubleProperty wrappingWidthProperty() {
        if (this.wrappingWidth == null) {
            this.wrappingWidth = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "wrappingWidth";
                }
            };
        }
        return this.wrappingWidth;
    }

    public final void setUnderline(boolean bl) {
        this.underlineProperty().set(bl);
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.get();
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_cssPropertyInvalidated(StyleableProperties.UNDERLINE);
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "underline";
                }
            };
        }
        return this.underline;
    }

    public final void setStrikethrough(boolean bl) {
        this.strikethroughProperty().set(bl);
    }

    public final boolean isStrikethrough() {
        return this.strikethrough == null ? false : this.strikethrough.get();
    }

    public final BooleanProperty strikethroughProperty() {
        if (this.strikethrough == null) {
            this.strikethrough = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_cssPropertyInvalidated(StyleableProperties.STRIKETHROUGH);
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "strikethrough";
                }
            };
        }
        return this.strikethrough;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().set(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new ObjectPropertyBase<TextAlignment>(TextAlignment.LEFT){

                @Override
                public void invalidated() {
                    Text.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_ALIGNMENT);
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    private void setBaselineOffset(double d) {
        this.baselineOffsetPropertyImpl().set(d);
    }

    @Override
    public final double getBaselineOffset() {
        return this.baselineOffset == null ? 0.0 : this.baselineOffset.get();
    }

    public final ReadOnlyDoubleProperty baselineOffsetProperty() {
        return this.baselineOffsetPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper baselineOffsetPropertyImpl() {
        if (this.baselineOffset == null) {
            this.baselineOffset = new ReadOnlyDoubleWrapper(this, "baselineOffset");
        }
        return this.baselineOffset;
    }

    @Override
    @Deprecated
    protected void impl_geomChanged() {
        this.getDecorationShapes();
        super.impl_geomChanged();
    }

    @Deprecated
    public final void setImpl_selectionShape(PathElement[] pathElementArray) {
        this.impl_selectionShapeProperty().set(pathElementArray);
    }

    @Deprecated
    public final PathElement[] getImpl_selectionShape() {
        return this.impl_selectionShape == null ? null : (PathElement[])this.impl_selectionShape.get();
    }

    @Deprecated
    public final ObjectProperty<PathElement[]> impl_selectionShapeProperty() {
        if (this.impl_selectionShape == null) {
            this.impl_selectionShape = new SimpleObjectProperty<PathElement[]>(this, "impl_selectionShape");
        }
        return this.impl_selectionShape;
    }

    @Deprecated
    public final void setImpl_selectionStart(int n) {
        this.impl_selectionStartProperty().set(n);
    }

    @Deprecated
    public final int getImpl_selectionStart() {
        return this.impl_selectionStart == null ? -1 : this.impl_selectionStart.get();
    }

    @Deprecated
    public final IntegerProperty impl_selectionStartProperty() {
        if (this.impl_selectionStart == null) {
            this.impl_selectionStart = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_selectionStart";
                }
            };
        }
        return this.impl_selectionStart;
    }

    @Deprecated
    public final void setImpl_selectionEnd(int n) {
        this.impl_selectionEndProperty().set(n);
    }

    @Deprecated
    public final int getImpl_selectionEnd() {
        return this.impl_selectionEnd == null ? -1 : this.impl_selectionEnd.get();
    }

    @Deprecated
    public final IntegerProperty impl_selectionEndProperty() {
        if (this.impl_selectionEnd == null) {
            this.impl_selectionEnd = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_selectionEnd";
                }
            };
        }
        return this.impl_selectionEnd;
    }

    @Override
    @Deprecated
    protected void impl_strokeOrFillChanged() {
        this.impl_markDirty(DirtyBits.TEXT_SELECTION);
    }

    @Deprecated
    public final void setImpl_caretShape(PathElement[] pathElementArray) {
        this.impl_caretShapeProperty().set(pathElementArray);
    }

    @Deprecated
    public final PathElement[] getImpl_caretShape() {
        return this.impl_caretShape == null ? null : (PathElement[])this.impl_caretShape.get();
    }

    @Deprecated
    public final ObjectProperty<PathElement[]> impl_caretShapeProperty() {
        if (this.impl_caretShape == null) {
            this.impl_caretShape = new SimpleObjectProperty<PathElement[]>(this, "impl_caretShape");
        }
        return this.impl_caretShape;
    }

    @Deprecated
    public final void setImpl_caretPosition(int n) {
        this.impl_caretPositionProperty().set(n);
    }

    @Deprecated
    public final int getImpl_caretPosition() {
        return this.impl_caretPosition == null ? -1 : this.impl_caretPosition.get();
    }

    @Deprecated
    public final IntegerProperty impl_caretPositionProperty() {
        if (this.impl_caretPosition == null) {
            this.impl_caretPosition = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_caretPosition";
                }
            };
        }
        return this.impl_caretPosition;
    }

    @Deprecated
    public final void setImpl_caretBias(boolean bl) {
        this.impl_caretBiasProperty().set(bl);
    }

    @Deprecated
    public final boolean isImpl_caretBias() {
        return this.impl_caretBias == null ? true : this.impl_caretBias.get();
    }

    @Deprecated
    public final BooleanProperty impl_caretBiasProperty() {
        if (this.impl_caretBias == null) {
            this.impl_caretBias = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_caretBias";
                }
            };
        }
        return this.impl_caretBias;
    }

    @Deprecated
    public HitInfo impl_hitTestChar(Point2D point2D) {
        return Toolkit.getToolkit().convertHitInfoToFX(this.getTextHelper().getHitInfo((float)point2D.getX(), (float)point2D.getY()));
    }

    @Deprecated
    public PathElement[] impl_getRangeShape(int n, int n2) {
        Object object = this.getTextHelper().getRangeShape(n, n2);
        return Toolkit.getToolkit().convertShapeToFXPath(object);
    }

    @Deprecated
    public PathElement[] impl_getUnderlineShape(int n, int n2) {
        Object object = this.getTextHelper().getUnderlineShape(n, n2);
        return Toolkit.getToolkit().convertShapeToFXPath(object);
    }

    private void getDecorationShapes() {
        if (this.getImpl_caretPosition() >= 0) {
            int n = this.getImpl_caretPosition() - (this.isImpl_caretBias() ? 0 : 1);
            Scene.impl_setAllowPGAccess(true);
            Object object = this.getTextHelper().getCaretShape(n, this.isImpl_caretBias());
            Scene.impl_setAllowPGAccess(false);
            this.setImpl_caretShape(Toolkit.getToolkit().convertShapeToFXPath(object));
        } else {
            this.setImpl_caretShape(null);
        }
        if (this.getImpl_selectionStart() >= 0 && this.getImpl_selectionEnd() >= 0) {
            Scene.impl_setAllowPGAccess(true);
            Object object = this.getTextHelper().getSelectionShape();
            Scene.impl_setAllowPGAccess(false);
            this.setImpl_selectionShape(Toolkit.getToolkit().convertShapeToFXPath(object));
        } else {
            this.setImpl_selectionShape(null);
        }
    }

    @Deprecated
    public void impl_displaySoftwareKeyboard(boolean bl) {
    }

    private TextHelper getTextHelper() {
        if (this.textHelper == null) {
            this.textHelper = Toolkit.getToolkit().createTextHelper(this);
        }
        return this.textHelper;
    }

    @Override
    @Deprecated
    public void impl_notifyLayoutBoundsChanged() {
        this.impl_layoutBoundsInvalid = true;
        super.impl_notifyLayoutBoundsChanged();
    }

    @Deprecated
    public BaseBounds impl_computeLayoutBoundsInt(RectBounds rectBounds) {
        if (this.getBoundsType() == TextBoundsType.VISUAL && this.getTextInternal().equals("")) {
            return rectBounds.makeEmpty();
        }
        return this.getTextHelper().computeLayoutBounds(rectBounds);
    }

    @Override
    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        if (this.impl_layoutBoundsInvalid) {
            this.impl_computeLayoutBoundsInt(this.impl_layoutBounds);
            this.impl_layoutBoundsInvalid = false;
        }
        return new BoundingBox(this.impl_layoutBounds.getMinX(), this.impl_layoutBounds.getMinY(), this.impl_layoutBounds.getWidth(), this.impl_layoutBounds.getHeight());
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.impl_mode == PGShape.Mode.EMPTY || this.getTextInternal().equals("") && this.getBoundsType() == TextBoundsType.VISUAL) {
            return baseBounds.makeEmpty();
        }
        return this.getTextHelper().computeBounds(baseBounds, baseTransform);
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return this.getTextHelper().contains((float)d, (float)d2);
    }

    @Override
    @Deprecated
    public Shape impl_configShape() {
        Object object = this.getTextHelper().getShape();
        PathElement[] pathElementArray = Toolkit.getToolkit().convertShapeToFXPath(object);
        return PathUtils.configShape(Arrays.asList(pathElementArray), false);
    }

    @Deprecated
    public ObjectProperty<Paint> impl_selectionFillProperty() {
        if (this.selectionFill == null) {
            this.selectionFill = new SimpleObjectProperty<Color>(this, "selectionFill", Color.WHITE);
        }
        return this.selectionFill;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if (string.equals("-fx-font")) {
            this.setFont((Font)object);
        } else if (string.equals("-fx-underline")) {
            this.setUnderline((Boolean)object);
        } else if (string.equals("-fx-strikethrough")) {
            this.setStrikethrough((Boolean)object);
        } else if (string.equals("-fx-text-alignment")) {
            this.setTextAlignment((TextAlignment)((Object)object));
        } else if (string.equals("-fx-text-origin")) {
            this.setTextOrigin((VPos)((Object)object));
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if (string.equals("-fx-font")) {
            return this.font == null || !this.font.isBound();
        }
        if (string.equals("-fx-underline")) {
            return this.underline == null || !this.underline.isBound();
        }
        if (string.equals("-fx-strikethrough")) {
            return this.strikethrough == null || !this.strikethrough.isBound();
        }
        if (string.equals("-fx-text-alignment")) {
            return this.textAlignment == null || !this.textAlignment.isBound();
        }
        if (string.equals("-fx-text-origin")) {
            return this.textOrigin == null || !this.textOrigin.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private void updatePGText() {
        Object object;
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            this.getPGText().setLocation((float)this.getX(), (float)this.getY());
        }
        if (this.impl_isDirty(DirtyBits.TEXT_ATTRS)) {
            object = this.getPGText();
            object.setTextBoundsType(this.getBoundsType().ordinal());
            object.setTextOrigin(this.getTextOrigin().ordinal());
            object.setWrappingWidth((float)this.getWrappingWidth());
            object.setUnderline(this.isUnderline());
            object.setStrikethrough(this.isStrikethrough());
            object.setTextAlignment(this.getTextAlignment().ordinal());
        }
        if (this.impl_isDirty(DirtyBits.TEXT_FONT)) {
            this.getPGText().setFont(this.getFontInternal().impl_getNativeFont());
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.getPGText().setText(this.getTextInternal());
        }
        if (this.impl_isDirty(DirtyBits.TEXT_SELECTION)) {
            if (this.getImpl_selectionStart() >= 0 && this.getImpl_selectionEnd() >= 0) {
                this.getPGText().setLogicalSelection(this.getImpl_selectionStart(), this.getImpl_selectionEnd());
                object = this.getStroke();
                Paint paint = this.selectionFill == null ? null : (Paint)this.selectionFill.get();
                Object object2 = object == null ? null : ((Paint)object).impl_getPlatformPaint();
                Object object3 = paint == null ? null : paint.impl_getPlatformPaint();
                this.getPGText().setSelectionPaint(object2, object3);
            } else {
                this.getPGText().setLogicalSelection(0, 0);
            }
        }
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        this.updatePGText();
    }

    private static class StyleableProperties {
        private static final StyleableProperty FONT = new StyleableProperty(Text.class, "font", StyleableProperty.FONT.getSubProperties());
        private static final StyleableProperty UNDERLINE = new StyleableProperty(Text.class, "underline");
        private static final StyleableProperty STRIKETHROUGH = new StyleableProperty(Text.class, "strikethrough");
        private static final StyleableProperty TEXT_ALIGNMENT = new StyleableProperty(Text.class, "textAlignment");
        private static final StyleableProperty TEXT_ORIGIN = new StyleableProperty(Text.class, "textOrigin");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(javafx.scene.shape.Shape.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, UNDERLINE, STRIKETHROUGH, TEXT_ALIGNMENT, TEXT_ORIGIN);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

