/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGCircle;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Circle
extends Shape {
    private final Ellipse2D shape = new Ellipse2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -72;
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private DoubleProperty radius;

    public Circle(double d) {
        this.setRadius(d);
    }

    public Circle(double d, Paint paint) {
        this.setRadius(d);
        this.setFill(paint);
    }

    public Circle() {
    }

    public Circle(double d, double d2, double d3) {
        this.setCenterX(d);
        this.setCenterY(d2);
        this.setRadius(d3);
    }

    public Circle(double d, double d2, double d3, Paint paint) {
        this.setCenterX(d);
        this.setCenterY(d2);
        this.setRadius(d3);
        this.setFill(paint);
    }

    public final void setCenterX(double d) {
        this.centerXProperty().set(d);
    }

    public final double getCenterX() {
        return this.centerX == null ? 0.0 : this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Circle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Circle.this;
                }

                @Override
                public String getName() {
                    return "centerX";
                }
            };
        }
        return this.centerX;
    }

    public final void setCenterY(double d) {
        this.centerYProperty().set(d);
    }

    public final double getCenterY() {
        return this.centerY == null ? 0.0 : this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Circle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Circle.this;
                }

                @Override
                public String getName() {
                    return "centerY";
                }
            };
        }
        return this.centerY;
    }

    public final void setRadius(double d) {
        this.radiusProperty().set(d);
    }

    public final double getRadius() {
        return this.radius == null ? 0.0 : this.radius.get();
    }

    @Deprecated
    protected void impl_radiusChanged() {
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    Circle.this.impl_radiusChanged();
                    Circle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Circle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Circle.this;
                }

                @Override
                public String getName() {
                    return "radius";
                }
            };
        }
        return this.radius;
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGCircle();
    }

    PGCircle getPGCircle() {
        return (PGCircle)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    protected PGShape.StrokeLineJoin toPGLineJoin(StrokeLineJoin strokeLineJoin) {
        return PGShape.StrokeLineJoin.BEVEL;
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d;
        double d2;
        double d3;
        if (this.impl_mode == PGShape.Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        if ((baseTransform.getType() & 0xFFFFFFB8) != 0) {
            return this.computeShapeBounds(baseBounds, baseTransform, this.impl_configShape());
        }
        double d4 = this.getRadius();
        double d5 = this.getCenterX() - d4;
        double d6 = this.getCenterY() - d4;
        double d7 = d3 = 2.0 * d4;
        if (this.impl_mode == PGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                d /= 2.0;
            }
            d2 = 0.0;
        }
        return this.computeBounds(baseBounds, baseTransform, d, d2, d5, d6, d3, d7);
    }

    @Override
    @Deprecated
    public Ellipse2D impl_configShape() {
        double d = this.getRadius();
        this.shape.setFrame((float)(this.getCenterX() - d), (float)(this.getCenterY() - d), (float)(d * 2.0), (float)(d * 2.0));
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            PGCircle pGCircle = this.getPGCircle();
            pGCircle.updateCircle((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadius());
        }
    }
}

