/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.tk.Toolkit;
import java.util.Collections;
import java.util.List;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public final class RadialGradient
extends Paint {
    private double focusAngle;
    private double focusDistance;
    private double centerX;
    private double centerY;
    private double radius;
    private boolean proportional;
    private CycleMethod cycleMethod;
    private List<Stop> stops;
    private Object platformPaint;
    private int hash;

    public final double getFocusAngle() {
        return this.focusAngle;
    }

    public final double getFocusDistance() {
        return this.focusDistance;
    }

    public final double getCenterX() {
        return this.centerX;
    }

    public final double getCenterY() {
        return this.centerY;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public final CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    public RadialGradient(double d, double d2, double d3, double d4, double d5, boolean bl, CycleMethod cycleMethod, Stop ... stopArray) {
        this.focusAngle = d;
        this.focusDistance = d2;
        this.centerX = d3;
        this.centerY = d4;
        this.radius = d5;
        this.proportional = bl;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Collections.unmodifiableList(RadialGradient.getNonNullStops(stopArray));
    }

    public RadialGradient(double d, double d2, double d3, double d4, double d5, boolean bl, CycleMethod cycleMethod, List<Stop> list) {
        this.focusAngle = d;
        this.focusDistance = d2;
        this.centerX = d3;
        this.centerY = d4;
        this.radius = d5;
        this.proportional = bl;
        this.cycleMethod = cycleMethod == null ? CycleMethod.NO_CYCLE : cycleMethod;
        this.stops = Collections.unmodifiableList(RadialGradient.getNonNullStops(list.toArray(new Stop[list.size()])));
    }

    @Override
    @Deprecated
    public Object impl_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint((Paint)this);
        }
        return this.platformPaint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadialGradient) {
            RadialGradient radialGradient = (RadialGradient)object;
            if (this.focusAngle != radialGradient.focusAngle || this.focusDistance != radialGradient.focusDistance || this.centerX != radialGradient.centerX || this.centerY != radialGradient.centerY || this.radius != radialGradient.radius || this.proportional != radialGradient.proportional || this.cycleMethod != radialGradient.cycleMethod) {
                return false;
            }
            return ((Object)this.stops).equals(radialGradient.stops);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 17L;
            l = 37L * l + Double.doubleToLongBits(this.focusAngle);
            l = 37L * l + Double.doubleToLongBits(this.focusDistance);
            l = 37L * l + Double.doubleToLongBits(this.centerX);
            l = 37L * l + Double.doubleToLongBits(this.centerY);
            l = 37L * l + Double.doubleToLongBits(this.radius);
            l = 37L * l + (long)(this.proportional ? 1231 : 1237);
            l = 37L * l + (long)this.cycleMethod.hashCode();
            for (Stop stop : this.stops) {
                l = 37L * l + (long)stop.hashCode();
            }
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RadialGradient[focusAngle=").append(this.focusAngle).append(",focusDistance=").append(this.focusDistance).append(",centerX=").append(this.centerX).append(",centerY=").append(this.centerY).append(",radius=").append(this.radius).append(",proportional=").append(this.proportional).append(",cycleMethod=").append((Object)this.cycleMethod).append(",stops=<");
        if (this.stops.isEmpty()) {
            stringBuilder.append("empty");
        } else {
            for (Stop stop : this.stops) {
                stringBuilder.append(stop).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(">]");
        return stringBuilder.toString();
    }
}

