/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import java.util.Arrays;
import java.util.List;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;

public final class LinearGradientBuilder {
    private CycleMethod cycleMethod;
    private double endX = 1.0;
    private double endY = 1.0;
    private boolean proportional = true;
    private double startX;
    private double startY;
    private List<Stop> stops;

    protected LinearGradientBuilder() {
    }

    public static LinearGradientBuilder create() {
        return new LinearGradientBuilder();
    }

    public LinearGradientBuilder cycleMethod(CycleMethod cycleMethod) {
        this.cycleMethod = cycleMethod;
        return this;
    }

    public LinearGradientBuilder endX(double d) {
        this.endX = d;
        return this;
    }

    public LinearGradientBuilder endY(double d) {
        this.endY = d;
        return this;
    }

    public LinearGradientBuilder proportional(boolean bl) {
        this.proportional = bl;
        return this;
    }

    public LinearGradientBuilder startX(double d) {
        this.startX = d;
        return this;
    }

    public LinearGradientBuilder startY(double d) {
        this.startY = d;
        return this;
    }

    public LinearGradientBuilder stops(List<Stop> list) {
        this.stops = list;
        return this;
    }

    public LinearGradientBuilder stops(Stop ... stopArray) {
        return this.stops(Arrays.asList(stopArray));
    }

    public LinearGradient build() {
        LinearGradient linearGradient = new LinearGradient(this.startX, this.startY, this.endX, this.endY, this.proportional, this.cycleMethod, this.stops);
        return linearGradient;
    }
}

