/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.Utils;
import com.sun.javafx.tk.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Interpolatable;
import javafx.scene.paint.Paint;

public class Color
extends Paint
implements Interpolatable<Color> {
    private static final double DARKER_BRIGHTER_FACTOR = 0.7;
    private static final double SATURATE_DESATURATE_FACTOR = 0.7;
    public static final Color TRANSPARENT = Color.color(0.0, 0.0, 0.0, 0.0);
    public static final Color ALICEBLUE = Color.rgb(240, 248, 255);
    public static final Color ANTIQUEWHITE = Color.rgb(250, 235, 215);
    public static final Color AQUA = Color.rgb(0, 255, 255);
    public static final Color AQUAMARINE = Color.rgb(127, 255, 212);
    public static final Color AZURE = Color.rgb(240, 255, 255);
    public static final Color BEIGE = Color.rgb(245, 245, 220);
    public static final Color BISQUE = Color.rgb(255, 228, 196);
    public static final Color BLACK = Color.rgb(0, 0, 0);
    public static final Color BLANCHEDALMOND = Color.rgb(255, 235, 205);
    public static final Color BLUE = Color.rgb(0, 0, 255);
    public static final Color BLUEVIOLET = Color.rgb(138, 43, 226);
    public static final Color BROWN = Color.rgb(165, 42, 42);
    public static final Color BURLYWOOD = Color.rgb(222, 184, 135);
    public static final Color CADETBLUE = Color.rgb(95, 158, 160);
    public static final Color CHARTREUSE = Color.rgb(127, 255, 0);
    public static final Color CHOCOLATE = Color.rgb(210, 105, 30);
    public static final Color CORAL = Color.rgb(255, 127, 80);
    public static final Color CORNFLOWERBLUE = Color.rgb(100, 149, 237);
    public static final Color CORNSILK = Color.rgb(255, 248, 220);
    public static final Color CRIMSON = Color.rgb(220, 20, 60);
    public static final Color CYAN = Color.rgb(0, 255, 255);
    public static final Color DARKBLUE = Color.rgb(0, 0, 139);
    public static final Color DARKCYAN = Color.rgb(0, 139, 139);
    public static final Color DARKGOLDENROD = Color.rgb(184, 134, 11);
    public static final Color DARKGRAY = Color.rgb(169, 169, 169);
    public static final Color DARKGREEN = Color.rgb(0, 100, 0);
    public static final Color DARKGREY = DARKGRAY;
    public static final Color DARKKHAKI = Color.rgb(189, 183, 107);
    public static final Color DARKMAGENTA = Color.rgb(139, 0, 139);
    public static final Color DARKOLIVEGREEN = Color.rgb(85, 107, 47);
    public static final Color DARKORANGE = Color.rgb(255, 140, 0);
    public static final Color DARKORCHID = Color.rgb(153, 50, 204);
    public static final Color DARKRED = Color.rgb(139, 0, 0);
    public static final Color DARKSALMON = Color.rgb(233, 150, 122);
    public static final Color DARKSEAGREEN = Color.rgb(143, 188, 143);
    public static final Color DARKSLATEBLUE = Color.rgb(72, 61, 139);
    public static final Color DARKSLATEGRAY;
    public static final Color DARKSLATEGREY;
    public static final Color DARKTURQUOISE;
    public static final Color DARKVIOLET;
    public static final Color DEEPPINK;
    public static final Color DEEPSKYBLUE;
    public static final Color DIMGRAY;
    public static final Color DIMGREY;
    public static final Color DODGERBLUE;
    public static final Color FIREBRICK;
    public static final Color FLORALWHITE;
    public static final Color FORESTGREEN;
    public static final Color FUCHSIA;
    public static final Color GAINSBORO;
    public static final Color GHOSTWHITE;
    public static final Color GOLD;
    public static final Color GOLDENROD;
    public static final Color GRAY;
    public static final Color GREEN;
    public static final Color GREENYELLOW;
    public static final Color GREY;
    public static final Color HONEYDEW;
    public static final Color HOTPINK;
    public static final Color INDIANRED;
    public static final Color INDIGO;
    public static final Color IVORY;
    public static final Color KHAKI;
    public static final Color LAVENDER;
    public static final Color LAVENDERBLUSH;
    public static final Color LAWNGREEN;
    public static final Color LEMONCHIFFON;
    public static final Color LIGHTBLUE;
    public static final Color LIGHTCORAL;
    public static final Color LIGHTCYAN;
    public static final Color LIGHTGOLDENRODYELLOW;
    public static final Color LIGHTGRAY;
    public static final Color LIGHTGREEN;
    public static final Color LIGHTGREY;
    public static final Color LIGHTPINK;
    public static final Color LIGHTSALMON;
    public static final Color LIGHTSEAGREEN;
    public static final Color LIGHTSKYBLUE;
    public static final Color LIGHTSLATEGRAY;
    public static final Color LIGHTSLATEGREY;
    public static final Color LIGHTSTEELBLUE;
    public static final Color LIGHTYELLOW;
    public static final Color LIME;
    public static final Color LIMEGREEN;
    public static final Color LINEN;
    public static final Color MAGENTA;
    public static final Color MAROON;
    public static final Color MEDIUMAQUAMARINE;
    public static final Color MEDIUMBLUE;
    public static final Color MEDIUMORCHID;
    public static final Color MEDIUMPURPLE;
    public static final Color MEDIUMSEAGREEN;
    public static final Color MEDIUMSLATEBLUE;
    public static final Color MEDIUMSPRINGGREEN;
    public static final Color MEDIUMTURQUOISE;
    public static final Color MEDIUMVIOLETRED;
    public static final Color MIDNIGHTBLUE;
    public static final Color MINTCREAM;
    public static final Color MISTYROSE;
    public static final Color MOCCASIN;
    public static final Color NAVAJOWHITE;
    public static final Color NAVY;
    public static final Color OLDLACE;
    public static final Color OLIVE;
    public static final Color OLIVEDRAB;
    public static final Color ORANGE;
    public static final Color ORANGERED;
    public static final Color ORCHID;
    public static final Color PALEGOLDENROD;
    public static final Color PALEGREEN;
    public static final Color PALETURQUOISE;
    public static final Color PALEVIOLETRED;
    public static final Color PAPAYAWHIP;
    public static final Color PEACHPUFF;
    public static final Color PERU;
    public static final Color PINK;
    public static final Color PLUM;
    public static final Color POWDERBLUE;
    public static final Color PURPLE;
    public static final Color RED;
    public static final Color ROSYBROWN;
    public static final Color ROYALBLUE;
    public static final Color SADDLEBROWN;
    public static final Color SALMON;
    public static final Color SANDYBROWN;
    public static final Color SEAGREEN;
    public static final Color SEASHELL;
    public static final Color SIENNA;
    public static final Color SILVER;
    public static final Color SKYBLUE;
    public static final Color SLATEBLUE;
    public static final Color SLATEGRAY;
    public static final Color SLATEGREY;
    public static final Color SNOW;
    public static final Color SPRINGGREEN;
    public static final Color STEELBLUE;
    public static final Color TAN;
    public static final Color TEAL;
    public static final Color THISTLE;
    public static final Color TOMATO;
    public static final Color TURQUOISE;
    public static final Color VIOLET;
    public static final Color WHEAT;
    public static final Color WHITE;
    public static final Color WHITESMOKE;
    public static final Color YELLOW;
    public static final Color YELLOWGREEN;
    private float red;
    private float green;
    private float blue;
    private float opacity = 1.0f;
    private Object platformPaint;

    public static Color color(double d, double d2, double d3, double d4) {
        return new Color(d, d2, d3, d4);
    }

    public static Color color(double d, double d2, double d3) {
        return new Color(d, d2, d3, 1.0);
    }

    public static Color rgb(int n, int n2, int n3, double d) {
        Color.checkRGB(n, n2, n3);
        return new Color((double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0, d);
    }

    public static Color rgb(int n, int n2, int n3) {
        Color.checkRGB(n, n2, n3);
        return new Color((double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0, 1.0);
    }

    public static Color grayRgb(int n) {
        return Color.rgb(n, n, n);
    }

    public static Color grayRgb(int n, double d) {
        return Color.rgb(n, n, n, d);
    }

    public static Color gray(double d, double d2) {
        return new Color(d, d, d, d2);
    }

    public static Color gray(double d) {
        return Color.gray(d, 1.0);
    }

    private static void checkRGB(int n, int n2, int n3) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Color.rgb's red parameter (" + n + ") expects color values 0-255");
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("Color.rgb's green parameter (" + n2 + ") expects color values 0-255");
        }
        if (n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("Color.rgb's blue parameter (" + n3 + ") expects color values 0-255");
        }
    }

    public static Color hsb(double d, double d2, double d3, double d4) {
        Color.checkSB(d2, d3);
        double[] dArray = Utils.HSBtoRGB(d, d2, d3);
        Color color = new Color(dArray[0], dArray[1], dArray[2], d4);
        return color;
    }

    public static Color hsb(double d, double d2, double d3) {
        return Color.hsb(d, d2, d3, 1.0);
    }

    private static void checkSB(double d, double d2) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Color.hsb's saturation parameter (" + d + ") expects values 0.0-1.0");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Color.hsb's brightness parameter (" + d2 + ") expects values 0.0-1.0");
        }
    }

    public static Color web(String string, double d) {
        if (string == null) {
            throw new NullPointerException("The color components or name must be specified");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        String string2 = string.toLowerCase();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        } else if (string2.startsWith("0x")) {
            string2 = string2.substring(2);
        } else {
            Color color = NamedColors.get(string2);
            if (color != null) {
                if (d == 1.0) {
                    return color;
                }
                return Color.color(color.red, color.green, color.blue, d);
            }
        }
        int n = string2.length();
        try {
            if (n == 3) {
                int n2 = Integer.parseInt(string2.substring(0, 1), 16);
                int n3 = Integer.parseInt(string2.substring(1, 2), 16);
                int n4 = Integer.parseInt(string2.substring(2, 3), 16);
                return Color.color((double)n2 / 15.0, (double)n3 / 15.0, (double)n4 / 15.0, d);
            }
            if (n == 4) {
                int n5 = Integer.parseInt(string2.substring(0, 1), 16);
                int n6 = Integer.parseInt(string2.substring(1, 2), 16);
                int n7 = Integer.parseInt(string2.substring(2, 3), 16);
                int n8 = Integer.parseInt(string2.substring(3, 4), 16);
                return Color.color((double)n5 / 15.0, (double)n6 / 15.0, (double)n7 / 15.0, d * (double)n8 / 15.0);
            }
            if (n == 6) {
                int n9 = Integer.parseInt(string2.substring(0, 2), 16);
                int n10 = Integer.parseInt(string2.substring(2, 4), 16);
                int n11 = Integer.parseInt(string2.substring(4, 6), 16);
                return Color.rgb(n9, n10, n11, d);
            }
            if (n == 8) {
                int n12 = Integer.parseInt(string2.substring(0, 2), 16);
                int n13 = Integer.parseInt(string2.substring(2, 4), 16);
                int n14 = Integer.parseInt(string2.substring(4, 6), 16);
                int n15 = Integer.parseInt(string2.substring(6, 8), 16);
                return Color.rgb(n12, n13, n14, d * (double)n15 / 255.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    public static Color web(String string) {
        return Color.web(string, 1.0);
    }

    private static int to32BitInteger(int n, int n2, int n3, int n4) {
        int n5 = n;
        n5 <<= 8;
        n5 |= n2;
        n5 <<= 8;
        n5 |= n3;
        n5 <<= 8;
        return n5 |= n4;
    }

    public double getHue() {
        return Utils.RGBtoHSB(this.red, this.green, this.blue)[0];
    }

    public double getSaturation() {
        return Utils.RGBtoHSB(this.red, this.green, this.blue)[1];
    }

    public double getBrightness() {
        return Utils.RGBtoHSB(this.red, this.green, this.blue)[2];
    }

    public Color deriveColor(double d, double d2, double d3, double d4) {
        double[] dArray = Utils.RGBtoHSB(this.red, this.green, this.blue);
        double d5 = dArray[2];
        if (d5 == 0.0 && d3 > 1.0) {
            d5 = 0.05;
        }
        double d6 = ((dArray[0] + d) % 360.0 + 360.0) % 360.0;
        double d7 = Math.max(Math.min(dArray[1] * d2, 1.0), 0.0);
        d5 = Math.max(Math.min(d5 * d3, 1.0), 0.0);
        double d8 = Math.max(Math.min((double)this.opacity * d4, 1.0), 0.0);
        return Color.hsb(d6, d7, d5, d8);
    }

    public Color brighter() {
        return this.deriveColor(0.0, 1.0, 1.4285714285714286, 1.0);
    }

    public Color darker() {
        return this.deriveColor(0.0, 1.0, 0.7, 1.0);
    }

    public Color saturate() {
        return this.deriveColor(0.0, 1.4285714285714286, 1.0, 1.0);
    }

    public Color desaturate() {
        return this.deriveColor(0.0, 0.7, 1.0, 1.0);
    }

    public Color grayscale() {
        double d = 0.21 * (double)this.red + 0.71 * (double)this.green + 0.07 * (double)this.blue;
        return Color.color(d, d, d, this.opacity);
    }

    public Color invert() {
        return Color.color(1.0 - (double)this.red, 1.0 - (double)this.green, 1.0 - (double)this.blue, this.opacity);
    }

    public final double getRed() {
        return this.red;
    }

    public final double getGreen() {
        return this.green;
    }

    public final double getBlue() {
        return this.blue;
    }

    public final double getOpacity() {
        return this.opacity;
    }

    public Color(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Color's red value (" + d + ") must be in the range 0.0-1.0");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Color's green value (" + d2 + ") must be in the range 0.0-1.0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("Color's blue value (" + d3 + ") must be in the range 0.0-1.0");
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("Color's opacity value (" + d4 + ") must be in the range 0.0-1.0");
        }
        this.red = (float)d;
        this.green = (float)d2;
        this.blue = (float)d3;
        this.opacity = (float)d4;
    }

    @Override
    @Deprecated
    public Object impl_getPlatformPaint() {
        if (this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint(this);
        }
        return this.platformPaint;
    }

    @Override
    public Color interpolate(Color color, double d) {
        return new Color((double)this.red + (double)(color.red - this.red) * d, (double)this.green + (double)(color.green - this.green) * d, (double)this.blue + (double)(color.blue - this.blue) * d, (double)this.opacity + (double)(color.opacity - this.opacity) * d);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return this.red == color.red && this.green == color.green && this.blue == color.blue && this.opacity == color.opacity;
        }
        return false;
    }

    public int hashCode() {
        int n = (int)Math.round((double)this.red * 255.0);
        int n2 = (int)Math.round((double)this.green * 255.0);
        int n3 = (int)Math.round((double)this.blue * 255.0);
        int n4 = (int)Math.round((double)this.opacity * 255.0);
        return Color.to32BitInteger(n, n2, n3, n4);
    }

    public String toString() {
        int n = (int)Math.round((double)this.red * 255.0);
        int n2 = (int)Math.round((double)this.green * 255.0);
        int n3 = (int)Math.round((double)this.blue * 255.0);
        return "Color[red=" + n + ",green=" + n2 + ",blue=" + n3 + ",opacity=" + this.opacity + "]";
    }

    static {
        DARKSLATEGREY = DARKSLATEGRAY = Color.rgb(47, 79, 79);
        DARKTURQUOISE = Color.rgb(0, 206, 209);
        DARKVIOLET = Color.rgb(148, 0, 211);
        DEEPPINK = Color.rgb(255, 20, 147);
        DEEPSKYBLUE = Color.rgb(0, 191, 255);
        DIMGREY = DIMGRAY = Color.rgb(105, 105, 105);
        DODGERBLUE = Color.rgb(30, 144, 255);
        FIREBRICK = Color.rgb(178, 34, 34);
        FLORALWHITE = Color.rgb(255, 250, 240);
        FORESTGREEN = Color.rgb(34, 139, 34);
        FUCHSIA = Color.rgb(255, 0, 255);
        GAINSBORO = Color.rgb(220, 220, 220);
        GHOSTWHITE = Color.rgb(248, 248, 255);
        GOLD = Color.rgb(255, 215, 0);
        GOLDENROD = Color.rgb(218, 165, 32);
        GRAY = Color.rgb(128, 128, 128);
        GREEN = Color.rgb(0, 128, 0);
        GREENYELLOW = Color.rgb(173, 255, 47);
        GREY = GRAY;
        HONEYDEW = Color.rgb(240, 255, 240);
        HOTPINK = Color.rgb(255, 105, 180);
        INDIANRED = Color.rgb(205, 92, 92);
        INDIGO = Color.rgb(75, 0, 130);
        IVORY = Color.rgb(255, 255, 240);
        KHAKI = Color.rgb(240, 230, 140);
        LAVENDER = Color.rgb(230, 230, 250);
        LAVENDERBLUSH = Color.rgb(255, 240, 245);
        LAWNGREEN = Color.rgb(124, 252, 0);
        LEMONCHIFFON = Color.rgb(255, 250, 205);
        LIGHTBLUE = Color.rgb(173, 216, 230);
        LIGHTCORAL = Color.rgb(240, 128, 128);
        LIGHTCYAN = Color.rgb(224, 255, 255);
        LIGHTGOLDENRODYELLOW = Color.rgb(250, 250, 210);
        LIGHTGRAY = Color.rgb(211, 211, 211);
        LIGHTGREEN = Color.rgb(144, 238, 144);
        LIGHTGREY = LIGHTGRAY;
        LIGHTPINK = Color.rgb(255, 182, 193);
        LIGHTSALMON = Color.rgb(255, 160, 122);
        LIGHTSEAGREEN = Color.rgb(32, 178, 170);
        LIGHTSKYBLUE = Color.rgb(135, 206, 250);
        LIGHTSLATEGREY = LIGHTSLATEGRAY = Color.rgb(119, 136, 153);
        LIGHTSTEELBLUE = Color.rgb(176, 196, 222);
        LIGHTYELLOW = Color.rgb(255, 255, 224);
        LIME = Color.rgb(0, 255, 0);
        LIMEGREEN = Color.rgb(50, 205, 50);
        LINEN = Color.rgb(250, 240, 230);
        MAGENTA = Color.rgb(255, 0, 255);
        MAROON = Color.rgb(128, 0, 0);
        MEDIUMAQUAMARINE = Color.rgb(102, 205, 170);
        MEDIUMBLUE = Color.rgb(0, 0, 205);
        MEDIUMORCHID = Color.rgb(186, 85, 211);
        MEDIUMPURPLE = Color.rgb(147, 112, 219);
        MEDIUMSEAGREEN = Color.rgb(60, 179, 113);
        MEDIUMSLATEBLUE = Color.rgb(123, 104, 238);
        MEDIUMSPRINGGREEN = Color.rgb(0, 250, 154);
        MEDIUMTURQUOISE = Color.rgb(72, 209, 204);
        MEDIUMVIOLETRED = Color.rgb(199, 21, 133);
        MIDNIGHTBLUE = Color.rgb(25, 25, 112);
        MINTCREAM = Color.rgb(245, 255, 250);
        MISTYROSE = Color.rgb(255, 228, 225);
        MOCCASIN = Color.rgb(255, 228, 181);
        NAVAJOWHITE = Color.rgb(255, 222, 173);
        NAVY = Color.rgb(0, 0, 128);
        OLDLACE = Color.rgb(253, 245, 230);
        OLIVE = Color.rgb(128, 128, 0);
        OLIVEDRAB = Color.rgb(107, 142, 35);
        ORANGE = Color.rgb(255, 165, 0);
        ORANGERED = Color.rgb(255, 69, 0);
        ORCHID = Color.rgb(218, 112, 214);
        PALEGOLDENROD = Color.rgb(238, 232, 170);
        PALEGREEN = Color.rgb(152, 251, 152);
        PALETURQUOISE = Color.rgb(175, 238, 238);
        PALEVIOLETRED = Color.rgb(219, 112, 147);
        PAPAYAWHIP = Color.rgb(255, 239, 213);
        PEACHPUFF = Color.rgb(255, 218, 185);
        PERU = Color.rgb(205, 133, 63);
        PINK = Color.rgb(255, 192, 203);
        PLUM = Color.rgb(221, 160, 221);
        POWDERBLUE = Color.rgb(176, 224, 230);
        PURPLE = Color.rgb(128, 0, 128);
        RED = Color.rgb(255, 0, 0);
        ROSYBROWN = Color.rgb(188, 143, 143);
        ROYALBLUE = Color.rgb(65, 105, 225);
        SADDLEBROWN = Color.rgb(139, 69, 19);
        SALMON = Color.rgb(250, 128, 114);
        SANDYBROWN = Color.rgb(244, 164, 96);
        SEAGREEN = Color.rgb(46, 139, 87);
        SEASHELL = Color.rgb(255, 245, 238);
        SIENNA = Color.rgb(160, 82, 45);
        SILVER = Color.rgb(192, 192, 192);
        SKYBLUE = Color.rgb(135, 206, 235);
        SLATEBLUE = Color.rgb(106, 90, 205);
        SLATEGREY = SLATEGRAY = Color.rgb(112, 128, 144);
        SNOW = Color.rgb(255, 250, 250);
        SPRINGGREEN = Color.rgb(0, 255, 127);
        STEELBLUE = Color.rgb(70, 130, 180);
        TAN = Color.rgb(210, 180, 140);
        TEAL = Color.rgb(0, 128, 128);
        THISTLE = Color.rgb(216, 191, 216);
        TOMATO = Color.rgb(255, 99, 71);
        TURQUOISE = Color.rgb(64, 224, 208);
        VIOLET = Color.rgb(238, 130, 238);
        WHEAT = Color.rgb(245, 222, 179);
        WHITE = Color.rgb(255, 255, 255);
        WHITESMOKE = Color.rgb(245, 245, 245);
        YELLOW = Color.rgb(255, 255, 0);
        YELLOWGREEN = Color.rgb(154, 205, 50);
    }

    private static final class NamedColors {
        private static final Map<String, Color> namedColors = NamedColors.createNamedColors();

        private NamedColors() {
        }

        private static Color get(String string) {
            return namedColors.get(string);
        }

        private static Map<String, Color> createNamedColors() {
            HashMap<String, Color> hashMap = new HashMap<String, Color>(256);
            hashMap.put("aliceblue", ALICEBLUE);
            hashMap.put("antiquewhite", ANTIQUEWHITE);
            hashMap.put("aqua", AQUA);
            hashMap.put("aquamarine", AQUAMARINE);
            hashMap.put("azure", AZURE);
            hashMap.put("beige", BEIGE);
            hashMap.put("bisque", BISQUE);
            hashMap.put("black", BLACK);
            hashMap.put("blanchedalmond", BLANCHEDALMOND);
            hashMap.put("blue", BLUE);
            hashMap.put("blueviolet", BLUEVIOLET);
            hashMap.put("brown", BROWN);
            hashMap.put("burlywood", BURLYWOOD);
            hashMap.put("cadetblue", CADETBLUE);
            hashMap.put("chartreuse", CHARTREUSE);
            hashMap.put("chocolate", CHOCOLATE);
            hashMap.put("coral", CORAL);
            hashMap.put("cornflowerblue", CORNFLOWERBLUE);
            hashMap.put("cornsilk", CORNSILK);
            hashMap.put("crimson", CRIMSON);
            hashMap.put("cyan", CYAN);
            hashMap.put("darkblue", DARKBLUE);
            hashMap.put("darkcyan", DARKCYAN);
            hashMap.put("darkgoldenrod", DARKGOLDENROD);
            hashMap.put("darkgray", DARKGRAY);
            hashMap.put("darkgreen", DARKGREEN);
            hashMap.put("darkgrey", DARKGREY);
            hashMap.put("darkkhaki", DARKKHAKI);
            hashMap.put("darkmagenta", DARKMAGENTA);
            hashMap.put("darkolivegreen", DARKOLIVEGREEN);
            hashMap.put("darkorange", DARKORANGE);
            hashMap.put("darkorchid", DARKORCHID);
            hashMap.put("darkred", DARKRED);
            hashMap.put("darksalmon", DARKSALMON);
            hashMap.put("darkseagreen", DARKSEAGREEN);
            hashMap.put("darkslateblue", DARKSLATEBLUE);
            hashMap.put("darkslategray", DARKSLATEGRAY);
            hashMap.put("darkslategrey", DARKSLATEGREY);
            hashMap.put("darkturquoise", DARKTURQUOISE);
            hashMap.put("darkviolet", DARKVIOLET);
            hashMap.put("deeppink", DEEPPINK);
            hashMap.put("deepskyblue", DEEPSKYBLUE);
            hashMap.put("dimgray", DIMGRAY);
            hashMap.put("dimgrey", DIMGREY);
            hashMap.put("dodgerblue", DODGERBLUE);
            hashMap.put("firebrick", FIREBRICK);
            hashMap.put("floralwhite", FLORALWHITE);
            hashMap.put("forestgreen", FORESTGREEN);
            hashMap.put("fuchsia", FUCHSIA);
            hashMap.put("gainsboro", GAINSBORO);
            hashMap.put("ghostwhite", GHOSTWHITE);
            hashMap.put("gold", GOLD);
            hashMap.put("goldenrod", GOLDENROD);
            hashMap.put("gray", GRAY);
            hashMap.put("green", GREEN);
            hashMap.put("greenyellow", GREENYELLOW);
            hashMap.put("grey", GREY);
            hashMap.put("honeydew", HONEYDEW);
            hashMap.put("hotpink", HOTPINK);
            hashMap.put("indianred", INDIANRED);
            hashMap.put("indigo", INDIGO);
            hashMap.put("ivory", IVORY);
            hashMap.put("khaki", KHAKI);
            hashMap.put("lavender", LAVENDER);
            hashMap.put("lavenderblush", LAVENDERBLUSH);
            hashMap.put("lawngreen", LAWNGREEN);
            hashMap.put("lemonchiffon", LEMONCHIFFON);
            hashMap.put("lightblue", LIGHTBLUE);
            hashMap.put("lightcoral", LIGHTCORAL);
            hashMap.put("lightcyan", LIGHTCYAN);
            hashMap.put("lightgoldenrodyellow", LIGHTGOLDENRODYELLOW);
            hashMap.put("lightgray", LIGHTGRAY);
            hashMap.put("lightgreen", LIGHTGREEN);
            hashMap.put("lightgrey", LIGHTGREY);
            hashMap.put("lightpink", LIGHTPINK);
            hashMap.put("lightsalmon", LIGHTSALMON);
            hashMap.put("lightseagreen", LIGHTSEAGREEN);
            hashMap.put("lightskyblue", LIGHTSKYBLUE);
            hashMap.put("lightslategray", LIGHTSLATEGRAY);
            hashMap.put("lightslategrey", LIGHTSLATEGREY);
            hashMap.put("lightsteelblue", LIGHTSTEELBLUE);
            hashMap.put("lightyellow", LIGHTYELLOW);
            hashMap.put("lime", LIME);
            hashMap.put("limegreen", LIMEGREEN);
            hashMap.put("linen", LINEN);
            hashMap.put("magenta", MAGENTA);
            hashMap.put("maroon", MAROON);
            hashMap.put("mediumaquamarine", MEDIUMAQUAMARINE);
            hashMap.put("mediumblue", MEDIUMBLUE);
            hashMap.put("mediumorchid", MEDIUMORCHID);
            hashMap.put("mediumpurple", MEDIUMPURPLE);
            hashMap.put("mediumseagreen", MEDIUMSEAGREEN);
            hashMap.put("mediumslateblue", MEDIUMSLATEBLUE);
            hashMap.put("mediumspringgreen", MEDIUMSPRINGGREEN);
            hashMap.put("mediumturquoise", MEDIUMTURQUOISE);
            hashMap.put("mediumvioletred", MEDIUMVIOLETRED);
            hashMap.put("midnightblue", MIDNIGHTBLUE);
            hashMap.put("mintcream", MINTCREAM);
            hashMap.put("mistyrose", MISTYROSE);
            hashMap.put("moccasin", MOCCASIN);
            hashMap.put("navajowhite", NAVAJOWHITE);
            hashMap.put("navy", NAVY);
            hashMap.put("oldlace", OLDLACE);
            hashMap.put("olive", OLIVE);
            hashMap.put("olivedrab", OLIVEDRAB);
            hashMap.put("orange", ORANGE);
            hashMap.put("orangered", ORANGERED);
            hashMap.put("orchid", ORCHID);
            hashMap.put("palegoldenrod", PALEGOLDENROD);
            hashMap.put("palegreen", PALEGREEN);
            hashMap.put("paleturquoise", PALETURQUOISE);
            hashMap.put("palevioletred", PALEVIOLETRED);
            hashMap.put("papayawhip", PAPAYAWHIP);
            hashMap.put("peachpuff", PEACHPUFF);
            hashMap.put("peru", PERU);
            hashMap.put("pink", PINK);
            hashMap.put("plum", PLUM);
            hashMap.put("powderblue", POWDERBLUE);
            hashMap.put("purple", PURPLE);
            hashMap.put("red", RED);
            hashMap.put("rosybrown", ROSYBROWN);
            hashMap.put("royalblue", ROYALBLUE);
            hashMap.put("saddlebrown", SADDLEBROWN);
            hashMap.put("salmon", SALMON);
            hashMap.put("sandybrown", SANDYBROWN);
            hashMap.put("seagreen", SEAGREEN);
            hashMap.put("seashell", SEASHELL);
            hashMap.put("sienna", SIENNA);
            hashMap.put("silver", SILVER);
            hashMap.put("skyblue", SKYBLUE);
            hashMap.put("slateblue", SLATEBLUE);
            hashMap.put("slategray", SLATEGRAY);
            hashMap.put("slategrey", SLATEGREY);
            hashMap.put("snow", SNOW);
            hashMap.put("springgreen", SPRINGGREEN);
            hashMap.put("steelblue", STEELBLUE);
            hashMap.put("tan", TAN);
            hashMap.put("teal", TEAL);
            hashMap.put("thistle", THISTLE);
            hashMap.put("tomato", TOMATO);
            hashMap.put("transparent", TRANSPARENT);
            hashMap.put("turquoise", TURQUOISE);
            hashMap.put("violet", VIOLET);
            hashMap.put("wheat", WHEAT);
            hashMap.put("white", WHITE);
            hashMap.put("whitesmoke", WHITESMOKE);
            hashMap.put("yellow", YELLOW);
            hashMap.put("yellowgreen", YELLOWGREEN);
            return hashMap;
        }
    }
}

