/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.media.jfxmedia.events.MetadataListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.metadata.MetadataParser;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.image.Image;
import javafx.scene.media.AudioTrack;
import javafx.scene.media.MediaException;
import javafx.scene.media.Track;
import javafx.scene.media.VideoTrack;
import javafx.util.Duration;

public final class Media {
    private ReadOnlyObjectWrapper<MediaException> error;
    private ObjectProperty<Runnable> onError;
    private MetadataListener metadataListener = new _MetadataListener();
    private ObservableMap<String, Object> metadata;
    private final ObservableMap<String, Object> metadataBacking;
    private ReadOnlyIntegerWrapper width;
    private ReadOnlyIntegerWrapper height;
    private ReadOnlyObjectWrapper<Duration> duration;
    private ObservableList<Track> tracks;
    private final ObservableList<Track> tracksBacking;
    private ObservableMap<String, Duration> markers;
    private final String source;
    private final Locator jfxLocator;
    private MetadataParser jfxParser;

    private void setError(MediaException mediaException) {
        this.errorPropertyImpl().set(mediaException);
    }

    public final MediaException getError() {
        return this.error == null ? null : (MediaException)this.error.get();
    }

    public ReadOnlyObjectProperty<MediaException> errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaException> errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyObjectWrapper<MediaException>(){

                @Override
                protected void invalidated() {
                    if (Media.this.getOnError() != null) {
                        Platform.runLater(Media.this.getOnError());
                    }
                }

                @Override
                public Object getBean() {
                    return Media.this;
                }

                @Override
                public String getName() {
                    return "error";
                }
            };
        }
        return this.error;
    }

    public final void setOnError(Runnable runnable) {
        this.onErrorProperty().set(runnable);
    }

    public final Runnable getOnError() {
        return this.onError == null ? null : (Runnable)this.onError.get();
    }

    public ObjectProperty<Runnable> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<Runnable>(){

                @Override
                protected void invalidated() {
                    if (this.get() != null && Media.this.getError() != null) {
                        Platform.runLater((Runnable)this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Media.this;
                }

                @Override
                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final ObservableMap<String, Object> getMetadata() {
        return this.metadata;
    }

    final void setWidth(int n) {
        this.widthPropertyImpl().set(n);
    }

    public final int getWidth() {
        return this.width == null ? 0 : this.width.get();
    }

    public ReadOnlyIntegerProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyIntegerWrapper(this, "width");
        }
        return this.width;
    }

    final void setHeight(int n) {
        this.heightPropertyImpl().set(n);
    }

    public final int getHeight() {
        return this.height == null ? 0 : this.height.get();
    }

    public ReadOnlyIntegerProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyIntegerWrapper(this, "height");
        }
        return this.height;
    }

    final void setDuration(Duration duration) {
        this.durationPropertyImpl().set(duration);
    }

    public final Duration getDuration() {
        return this.duration == null ? Duration.UNKNOWN : (Duration)this.duration.get();
    }

    public ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.durationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> durationPropertyImpl() {
        if (this.duration == null) {
            this.duration = new ReadOnlyObjectWrapper(this, "duration");
        }
        return this.duration;
    }

    public final ObservableList<Track> getTracks() {
        return this.tracks;
    }

    public final ObservableMap<String, Duration> getMarkers() {
        return this.markers;
    }

    public Media(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        Locator locator = null;
        try {
            this.jfxLocator = locator = new Locator(uRI);
            if (locator.canBlock()) {
                InitLocator initLocator = new InitLocator();
                Thread thread = new Thread(initLocator);
                thread.setDaemon(true);
                thread.start();
            } else {
                locator.init();
                this.runMetadataParser();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MediaException(MediaException.Type.MEDIA_UNAVAILABLE, fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new MediaException(MediaException.Type.MEDIA_INACCESSIBLE, iOException.getMessage());
        }
        catch (com.sun.media.jfxmedia.MediaException mediaException) {
            throw new MediaException(MediaException.Type.MEDIA_UNSUPPORTED, mediaException.getMessage());
        }
        this.source = string;
        this.metadataBacking = FXCollections.observableMap(new HashMap());
        this.metadata = FXCollections.unmodifiableObservableMap(this.metadataBacking);
        this.tracksBacking = FXCollections.observableArrayList();
        this.tracks = FXCollections.unmodifiableObservableList(this.tracksBacking);
        this.markers = FXCollections.observableMap(new HashMap());
    }

    private void runMetadataParser() {
        MetadataParser metadataParser = null;
        try {
            metadataParser = MetadataParser.createMetadataParser(this.jfxLocator);
            metadataParser.addListener(this.metadataListener);
            metadataParser.startParser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jfxParser = metadataParser;
    }

    public String getSource() {
        return this.source;
    }

    Locator retrieveJfxLocator() {
        return this.jfxLocator;
    }

    void _updateMedia(com.sun.media.jfxmedia.Media media) {
        try {
            Object object;
            List<com.sun.media.jfxmedia.track.Track> list = media.getTracks();
            if (list != null) {
                object = new HashSet();
                for (com.sun.media.jfxmedia.track.Track track : list) {
                    Track track2;
                    com.sun.media.jfxmedia.track.Track track3;
                    if (track instanceof com.sun.media.jfxmedia.track.VideoTrack) {
                        track3 = (com.sun.media.jfxmedia.track.VideoTrack)track;
                        this.setWidth(((com.sun.media.jfxmedia.track.VideoTrack)track3).getFrameSize().getWidth());
                        this.setHeight(((com.sun.media.jfxmedia.track.VideoTrack)track3).getFrameSize().getHeight());
                        track2 = new VideoTrack((com.sun.media.jfxmedia.track.VideoTrack)track3);
                        object.add(track2);
                    } else if (track instanceof com.sun.media.jfxmedia.track.AudioTrack) {
                        track3 = (com.sun.media.jfxmedia.track.AudioTrack)track;
                        track2 = new AudioTrack((com.sun.media.jfxmedia.track.AudioTrack)track3);
                        object.add(track2);
                    }
                    this.tracksBacking.setAll((Collection<Track>)object);
                }
            }
            object = media.getMetadata();
            this.updateMetadata((Map<String, Object>)object);
        }
        catch (Exception exception) {
            this.setError(new MediaException(MediaException.Type.UNKNOWN, (Throwable)exception));
        }
    }

    void _setError(MediaException.Type type, String string) {
        this.setError(new MediaException(type, string));
    }

    private synchronized void updateMetadata(Map<String, Object> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                Object object;
                Object object2 = map.get(string);
                if (string.equals("image") && object2 instanceof byte[]) {
                    object = (byte[])object2;
                    Image image = new Image(new ByteArrayInputStream((byte[])object));
                    if (image.isError()) continue;
                    this.metadataBacking.put("image", image);
                    continue;
                }
                if (string.equals("duration") && object2 instanceof Long) {
                    object = new Duration(((Long)object2).longValue());
                    if (object == null) continue;
                    this.metadataBacking.put("duration", object);
                    continue;
                }
                this.metadataBacking.put(string, object2);
            }
        }
    }

    private class InitLocator
    implements Runnable {
        private InitLocator() {
        }

        @Override
        public void run() {
            try {
                Media.this.jfxLocator.init();
                Media.this.runMetadataParser();
            }
            catch (URISyntaxException uRISyntaxException) {
                Media.this._setError(MediaException.Type.OPERATION_UNSUPPORTED, uRISyntaxException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                Media.this._setError(MediaException.Type.MEDIA_UNAVAILABLE, fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                Media.this._setError(MediaException.Type.MEDIA_INACCESSIBLE, iOException.getMessage());
            }
            catch (com.sun.media.jfxmedia.MediaException mediaException) {
                Media.this._setError(MediaException.Type.MEDIA_UNSUPPORTED, mediaException.getMessage());
            }
            catch (Exception exception) {
                Media.this._setError(MediaException.Type.UNKNOWN, exception.getMessage());
            }
        }
    }

    private class _MetadataListener
    implements MetadataListener {
        private _MetadataListener() {
        }

        @Override
        public void onMetadata(final Map<String, Object> map) {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    Media.this.updateMetadata(map);
                    Media.this.jfxParser.removeListener(Media.this.metadataListener);
                    Media.this.jfxParser.stopParser();
                    Media.this.jfxParser = null;
                }
            });
        }
    }
}

