/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class VBox
extends Pane {
    private static final String MARGIN_CONSTRAINT = "vbox-margin";
    private static final String VGROW_CONSTRAINT = "vbox-vgrow";
    @Styleable(property="-fx-spacing", initial="0")
    private DoubleProperty spacing;
    @Styleable(property="-fx-alignment", initial="top-left")
    private ObjectProperty<Pos> alignment;
    @Styleable(property="-fx-fill-width", initial="true")
    private BooleanProperty fillWidth;
    private double[] areaHeights;

    public static void setVgrow(Node node, Priority priority) {
        VBox.setConstraint(node, VGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getVgrow(Node node) {
        return (Priority)((Object)VBox.getConstraint(node, VGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        VBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)VBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        VBox.setVgrow(node, null);
        VBox.setMargin(node, null);
    }

    public VBox() {
    }

    public VBox(double d) {
        this();
        this.setSpacing(d);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                    VBox.this.impl_cssPropertyInvalidated(StyleableProperties.SPACING);
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(d);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                    VBox.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final BooleanProperty fillWidthProperty() {
        if (this.fillWidth == null) {
            this.fillWidth = new BooleanPropertyBase(true){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                    VBox.this.impl_cssPropertyInvalidated(StyleableProperties.FILL_WIDTH);
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "fillWidth";
                }
            };
        }
        return this.fillWidth;
    }

    public final void setFillWidth(boolean bl) {
        this.fillWidthProperty().set(bl);
    }

    public final boolean isFillWidth() {
        return this.fillWidth == null ? true : this.fillWidth.get();
    }

    @Override
    public Orientation getContentBias() {
        if (this.isFillWidth()) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged() || node.getContentBias() != Orientation.HORIZONTAL) continue;
                return Orientation.HORIZONTAL;
            }
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getLeft() + this.computeMaxMinAreaWidth(list, this.getMargins(list), this.getAlignment().getHpos()) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.getInsets().getTop() + this.computeContentHeight(this.getAreaHeights(true, d)) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getLeft() + this.computeMaxPrefAreaWidth(list, this.getMargins(list), this.getAlignment().getHpos()) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.getInsets().getTop() + this.computeContentHeight(this.getAreaHeights(false, d)) + this.getInsets().getBottom();
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = VBox.getMargin(list.get(i));
        }
        return insetsArray;
    }

    private double[] getAreaHeights(boolean bl, double d) {
        List list = this.getManagedChildren();
        double[] dArray = new double[list.size()];
        double d2 = (d == -1.0 ? this.prefWidth(-1.0) : d) - this.snapSpace(this.getInsets().getLeft()) - this.snapSpace(this.getInsets().getRight());
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            Insets insets = VBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaHeight(node, insets, this.isFillWidth() ? d2 : node.minWidth(-1.0)) : this.computeChildPrefAreaHeight(node, insets, this.isFillWidth() ? d2 : node.prefWidth(-1.0));
        }
        return dArray;
    }

    private double computeContentHeight(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d + (double)(dArray.length - 1) * this.snapSpace(this.getSpacing());
    }

    @Override
    protected void layoutChildren() {
        double d;
        List<Node> list = this.getManagedChildren();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getLeft();
        double d6 = this.getInsets().getBottom();
        double d7 = this.getInsets().getRight();
        double d8 = this.snapSpace(this.getSpacing());
        double d9 = d2 - d5 - d7;
        double d10 = d3 - d4 - d6;
        this.areaHeights = this.getAreaHeights(false, d2);
        double d11 = d9;
        double d12 = this.computeContentHeight(this.areaHeights);
        double d13 = d10 - d12;
        if (d13 != 0.0) {
            d = this.adjustAreaHeights(list, Priority.ALWAYS, d13, this.isFillWidth() ? d9 : -1.0);
            d = this.adjustAreaHeights(list, Priority.SOMETIMES, d, this.isFillWidth() ? d9 : -1.0);
            d12 += d13 - d;
        }
        d = d5;
        double d14 = d4 + VBox.computeYOffset(d10, d12, this.getAlignment().getVpos());
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            this.layoutInArea(node, d, d14, d11, this.areaHeights[i], this.areaHeights[i], VBox.getMargin(node), this.isFillWidth(), true, this.getAlignment().getHpos(), this.getAlignment().getVpos());
            d14 += this.areaHeights[i] + d8;
        }
    }

    private double adjustAreaHeights(List<Node> list, Priority priority, double d, double d2) {
        Node[] nodeArray;
        boolean bl = d < 0.0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (!bl && VBox.getVgrow(node) != priority) continue;
            arrayList.add(node);
            arrayList2.add(node);
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            nodeArray = VBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaHeight(node, (Insets)nodeArray, d2) : this.computeChildMaxAreaHeight(node, (Insets)nodeArray, d2);
        }
        double d3 = d;
        while (Math.abs(d3) > 1.0 && arrayList2.size() > 0) {
            nodeArray = new Node[arrayList.size()];
            double d4 = d3 / (double)arrayList2.size();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Node node = (Node)arrayList2.get(i);
                int n = list.indexOf(node);
                double d5 = dArray[arrayList.indexOf(node)] - this.areaHeights[n];
                double d6 = Math.abs(d5) <= Math.abs(d4) ? d5 : d4;
                int n2 = n;
                this.areaHeights[n2] = this.areaHeights[n2] + d6;
                d3 -= d6;
                if (!(Math.abs(d6) < Math.abs(d4))) continue;
                nodeArray[i] = node;
            }
            for (Node node : nodeArray) {
                if (node == null) continue;
                arrayList2.remove(node);
            }
        }
        return d3;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-alignment".equals(string)) {
            this.setAlignment((Pos)((Object)object));
        } else if ("-fx-fill-width".equals(string)) {
            this.setFillWidth((Boolean)object);
        } else if ("-fx-spacing".equals(string)) {
            this.setSpacing((Double)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        if ("-fx-fill-width".equals(string)) {
            return this.fillWidth == null || !this.fillWidth.isBound();
        }
        if ("-fx-spacing".equals(string)) {
            return this.spacing == null || !this.spacing.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(VBox.class, "alignment");
        private static final StyleableProperty FILL_WIDTH = new StyleableProperty(VBox.class, "fillWidth");
        private static final StyleableProperty SPACING = new StyleableProperty(VBox.class, "spacing");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT, FILL_WIDTH, SPACING);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

