/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.TKDropEvent;
import java.util.EnumSet;
import java.util.Set;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.TransferMode;

public class DragEvent
extends InputEvent {
    public static final EventType<DragEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "DRAG");
    public static final EventType<DragEvent> DRAG_ENTERED_TARGET = new EventType<DragEvent>(ANY, "DRAG_ENTERED_TARGET");
    public static final EventType<DragEvent> DRAG_ENTERED = new EventType<DragEvent>(DRAG_ENTERED_TARGET, "DRAG_ENTERED");
    public static final EventType<DragEvent> DRAG_EXITED_TARGET = new EventType<DragEvent>(ANY, "DRAG_EXITED_TARGET");
    public static final EventType<DragEvent> DRAG_EXITED = new EventType<DragEvent>(DRAG_EXITED_TARGET, "DRAG_EXITED");
    public static final EventType<DragEvent> DRAG_OVER = new EventType<DragEvent>(ANY, "DRAG_OVER");
    public static final EventType<DragEvent> DRAG_DROPPED = new EventType<DragEvent>(ANY, "DRAG_DROPPED");
    public static final EventType<DragEvent> DRAG_DONE = new EventType<DragEvent>(ANY, "DRAG_DONE");
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private Object gestureSource;
    private Object gestureTarget;
    private TransferMode transferMode;
    private State state = new State();
    private TKDropEvent tkDropEvent;
    private Object tkRecognizedEvent;
    private Dragboard dragboard;

    private DragEvent(EventType<? extends DragEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private DragEvent(Object object, EventTarget eventTarget, EventType<? extends DragEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    @Deprecated
    public static DragEvent impl_copy(Object object, EventTarget eventTarget, Object object2, Object object3, Dragboard dragboard, DragEvent dragEvent) {
        DragEvent dragEvent2 = DragEvent.impl_copy(object, eventTarget, object2, object3, dragEvent, null);
        dragEvent2.dragboard = dragboard;
        return dragEvent2;
    }

    @Deprecated
    public static DragEvent impl_copy(Object object, EventTarget eventTarget, DragEvent dragEvent, EventType<DragEvent> eventType) {
        return DragEvent.impl_copy(object, eventTarget, dragEvent.getGestureSource(), dragEvent.getGestureTarget(), dragEvent, eventType);
    }

    @Deprecated
    public static DragEvent impl_copy(Object object, EventTarget eventTarget, Object object2, Object object3, DragEvent dragEvent, EventType<DragEvent> eventType) {
        return DragEvent.impl_copy(object, eventTarget, object2, object3, dragEvent.getTransferMode(), dragEvent, eventType);
    }

    @Deprecated
    public static DragEvent impl_copy(Object object, EventTarget eventTarget, Object object2, Object object3, TransferMode transferMode, DragEvent dragEvent, EventType<DragEvent> eventType) {
        DragEvent dragEvent2 = DragEvent.impl_dragEvent(object, eventTarget, object2, object3, dragEvent.x, dragEvent.y, dragEvent.screenX, dragEvent.screenY, dragEvent.transferMode, eventType != null ? eventType : dragEvent.getEventType(), dragEvent.dragboard);
        dragEvent.recomputeCoordinatesToSource(dragEvent2, object);
        dragEvent2.tkDropEvent = dragEvent.tkDropEvent;
        dragEvent2.tkRecognizedEvent = dragEvent.tkRecognizedEvent;
        dragEvent2.transferMode = transferMode;
        if (eventType == DRAG_DROPPED || eventType == DRAG_DONE) {
            dragEvent2.state.accepted = transferMode != null;
            dragEvent2.state.acceptedTrasferMode = transferMode;
        }
        return dragEvent2;
    }

    private static DragEvent impl_dragEvent(Object object, EventTarget eventTarget, Object object2, Object object3, double d, double d2, double d3, double d4, TransferMode transferMode, EventType<? extends DragEvent> eventType, Dragboard dragboard) {
        DragEvent dragEvent = new DragEvent(object, eventTarget, eventType);
        dragEvent.gestureSource = object2;
        dragEvent.gestureTarget = object3;
        dragEvent.x = d;
        dragEvent.y = d2;
        dragEvent.screenX = d3;
        dragEvent.screenY = d4;
        dragEvent.sceneX = d;
        dragEvent.sceneY = d2;
        dragEvent.transferMode = transferMode;
        dragEvent.dragboard = dragboard;
        return dragEvent;
    }

    private void recomputeCoordinatesToSource(DragEvent dragEvent, Object object) {
        if (dragEvent.getEventType() == DRAG_DONE) {
            return;
        }
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.x, this.y), this.source, object);
        dragEvent.x = point2D.getX();
        dragEvent.y = point2D.getY();
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        DragEvent dragEvent = (DragEvent)super.copyFor(object, eventTarget);
        this.recomputeCoordinatesToSource(dragEvent, object);
        return dragEvent;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final Object getGestureSource() {
        return this.gestureSource;
    }

    public final Object getGestureTarget() {
        return this.gestureTarget;
    }

    public final TransferMode getTransferMode() {
        return this.transferMode;
    }

    public final boolean isAccepted() {
        return this.state.accepted;
    }

    public final TransferMode getAcceptedTransferMode() {
        return this.state.acceptedTrasferMode;
    }

    @Deprecated
    public Object impl_getAcceptingObject() {
        return this.state.acceptingObject;
    }

    public final Dragboard getDragboard() {
        return this.dragboard;
    }

    @Deprecated
    public Dragboard impl_getPlatformDragboard() {
        if (this.tkDropEvent == null) {
            return null;
        }
        return this.tkDropEvent.getDragboard();
    }

    private static TransferMode chooseTransferMode(Set<TransferMode> set, TransferMode[] transferModeArray, TransferMode transferMode) {
        TransferMode transferMode2 = null;
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        for (TransferMode transferMode3 : transferModeArray) {
            if (!set.contains((Object)transferMode3)) continue;
            enumSet.add(transferMode3);
        }
        if (enumSet.contains((Object)transferMode)) {
            transferMode2 = transferMode;
        } else if (enumSet.contains((Object)TransferMode.MOVE)) {
            transferMode2 = TransferMode.MOVE;
        } else if (enumSet.contains((Object)TransferMode.COPY)) {
            transferMode2 = TransferMode.COPY;
        } else if (enumSet.contains((Object)TransferMode.LINK)) {
            transferMode2 = TransferMode.LINK;
        }
        return transferMode2;
    }

    public void acceptTransferModes(TransferMode ... transferModeArray) {
        if (this.dragboard == null || this.dragboard.getTransferModes() == null || this.transferMode == null) {
            this.state.accepted = false;
            return;
        }
        TransferMode transferMode = DragEvent.chooseTransferMode(this.dragboard.getTransferModes(), transferModeArray, this.transferMode);
        if (transferMode == null && this.getEventType() == DRAG_DROPPED) {
            throw new IllegalStateException("Accepting unsupported transfer modes inside DRAG_DROPPED handler");
        }
        boolean bl = this.state.accepted = transferMode != null;
        if (this.tkDropEvent != null) {
            if (this.state.accepted) {
                this.tkDropEvent.accept();
            } else {
                this.tkDropEvent.reject();
            }
        }
        this.state.acceptedTrasferMode = transferMode;
        this.state.acceptingObject = this.state.accepted ? this.source : null;
    }

    public void setDropCompleted(boolean bl) {
        if (this.getEventType() != DRAG_DROPPED) {
            throw new IllegalStateException("setDropCompleted can be called only from DRAG_DROPPED handler");
        }
        if (this.tkDropEvent != null) {
            this.tkDropEvent.dropComplete(bl);
        }
        this.state.dropCompleted = bl;
    }

    public boolean isDropCompleted() {
        return this.state.dropCompleted;
    }

    @Deprecated
    public void impl_setRecognizedEvent(Object object) {
        this.tkRecognizedEvent = object;
    }

    @Deprecated
    public static DragEvent impl_create(double d, double d2, double d3, double d4, TransferMode transferMode, Dragboard dragboard, TKDropEvent tKDropEvent) {
        DragEvent dragEvent = new DragEvent((EventType<? extends DragEvent>)ANY);
        dragEvent.x = d;
        dragEvent.y = d2;
        dragEvent.screenX = d3;
        dragEvent.screenY = d4;
        dragEvent.sceneX = d;
        dragEvent.sceneY = d2;
        dragEvent.transferMode = transferMode;
        dragEvent.dragboard = dragboard;
        dragEvent.tkDropEvent = tKDropEvent;
        return dragEvent;
    }

    @Deprecated
    public static DragEvent impl_create(EventType<DragEvent> eventType, Object object, EventTarget eventTarget, Object object2, Object object3, double d, double d2, double d3, double d4, TransferMode transferMode, Dragboard dragboard, TKDropEvent tKDropEvent) {
        DragEvent dragEvent = new DragEvent(object, eventTarget, (EventType<? extends DragEvent>)eventType);
        dragEvent.gestureSource = object2;
        dragEvent.gestureTarget = object3;
        dragEvent.x = d;
        dragEvent.y = d2;
        dragEvent.screenX = d3;
        dragEvent.screenY = d4;
        dragEvent.sceneX = d;
        dragEvent.sceneY = d2;
        dragEvent.transferMode = transferMode;
        dragEvent.dragboard = dragboard;
        dragEvent.tkDropEvent = tKDropEvent;
        return dragEvent;
    }

    private class State {
        boolean accepted = false;
        boolean dropCompleted = false;
        TransferMode acceptedTrasferMode = null;
        Object acceptingObject = null;

        private State() {
        }
    }
}

