/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.WeakEventHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class TreeView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_COMMIT");
    private boolean treeItemCountDirty = true;
    private final EventHandler<TreeItem.TreeModificationEvent<T>> rootEvent = new EventHandler<TreeItem.TreeModificationEvent<T>>(){

        @Override
        public void handle(TreeItem.TreeModificationEvent<T> treeModificationEvent) {
            boolean bl = false;
            for (EventType<? extends Event> eventType = treeModificationEvent.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                if (!eventType.equals(TreeItem.treeItemCountChangeEvent())) continue;
                bl = true;
                break;
            }
            if (bl) {
                TreeView.this.treeItemCountDirty = true;
                TreeView.this.requestLayout();
            }
        }
    };
    private WeakEventHandler weakRootEventListener;
    private ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactory;
    private ObjectProperty<TreeItem<T>> root = new ObjectPropertyBase<TreeItem<T>>(){
        private WeakReference<TreeItem<T>> weakOldItem;

        @Override
        protected void invalidated() {
            TreeItem treeItem;
            TreeItem treeItem2;
            TreeItem treeItem3 = treeItem2 = this.weakOldItem == null ? null : (TreeItem)this.weakOldItem.get();
            if (treeItem2 != null && TreeView.this.weakRootEventListener != null) {
                treeItem2.removeEventHandler(TreeItem.treeNotificationEvent(), TreeView.this.weakRootEventListener);
            }
            if ((treeItem = TreeView.this.getRoot()) != null) {
                TreeView.this.weakRootEventListener = new WeakEventHandler(treeItem, TreeItem.treeNotificationEvent(), TreeView.this.rootEvent);
                TreeView.this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), TreeView.this.weakRootEventListener);
                this.weakOldItem = new WeakReference(treeItem);
            }
            TreeView.this.setTreeItemCount(0);
            TreeView.this.updateRootExpanded();
        }

        @Override
        public Object getBean() {
            return TreeView.this;
        }

        @Override
        public String getName() {
            return "root";
        }
    };
    private BooleanProperty showRoot;
    private ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModel;
    private ObjectProperty<FocusModel<TreeItem<T>>> focusModel;
    private IntegerProperty treeItemCount = new SimpleIntegerProperty(this, "impl_treeItemCount", 0);
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TreeItem<T>> editingItem;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCommit;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCancel;

    public static <T> EventType<EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public static int getNodeLevel(TreeItem<?> treeItem) {
        if (treeItem == null) {
            return -1;
        }
        int n = 0;
        for (TreeItem<?> treeItem2 = treeItem.getParent(); treeItem2 != null; treeItem2 = treeItem2.getParent()) {
            ++n;
        }
        return n;
    }

    public TreeView() {
        this(null);
    }

    public TreeView(TreeItem<T> treeItem) {
        this.getStyleClass().setAll((String[])new String[]{"tree-view"});
        this.setRoot(treeItem);
        this.updateTreeItemCount();
        TreeViewBitSetSelectionModel treeViewBitSetSelectionModel = new TreeViewBitSetSelectionModel(this);
        this.setSelectionModel(treeViewBitSetSelectionModel);
        this.setFocusModel(new TreeViewFocusModel(this));
    }

    public final void setCellFactory(Callback<TreeView<T>, TreeCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<TreeView<T>, TreeCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<TreeView<T>, TreeCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setRoot(TreeItem<T> treeItem) {
        this.rootProperty().set(treeItem);
    }

    public final TreeItem<T> getRoot() {
        return this.root == null ? null : (TreeItem)this.root.get();
    }

    public final ObjectProperty<TreeItem<T>> rootProperty() {
        return this.root;
    }

    public final void setShowRoot(boolean bl) {
        this.showRootProperty().set(bl);
    }

    public final boolean isShowRoot() {
        return this.showRoot == null ? true : this.showRoot.get();
    }

    public final BooleanProperty showRootProperty() {
        if (this.showRoot == null) {
            this.showRoot = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    TreeView.this.updateRootExpanded();
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "showRoot";
                }
            };
        }
        return this.showRoot;
    }

    public final void setSelectionModel(MultipleSelectionModel<TreeItem<T>> multipleSelectionModel) {
        this.selectionModelProperty().set(multipleSelectionModel);
    }

    public final MultipleSelectionModel<TreeItem<T>> getSelectionModel() {
        return this.selectionModel == null ? null : (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModelProperty() {
        if (this.selectionModel == null) {
            this.selectionModel = new SimpleObjectProperty<MultipleSelectionModel<TreeItem<T>>>(this, "selectionModel");
        }
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<TreeItem<T>> focusModel) {
        this.focusModelProperty().set(focusModel);
    }

    public final FocusModel<TreeItem<T>> getFocusModel() {
        return this.focusModel == null ? null : (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<TreeItem<T>>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<TreeItem<T>>>(this, "focusModel");
        }
        return this.focusModel;
    }

    private void setTreeItemCount(int n) {
        this.impl_treeItemCountProperty().set(n);
    }

    @Deprecated
    public final int impl_getTreeItemCount() {
        return this.treeItemCount.get();
    }

    @Deprecated
    public final IntegerProperty impl_treeItemCountProperty() {
        return this.treeItemCount;
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingItem(TreeItem<T> treeItem) {
        this.editingItemPropertyImpl().set(treeItem);
    }

    public final TreeItem<T> getEditingItem() {
        return this.editingItem == null ? null : (TreeItem)this.editingItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> editingItemProperty() {
        return this.editingItemPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeItem<T>> editingItemPropertyImpl() {
        if (this.editingItem == null) {
            this.editingItem = new ReadOnlyObjectWrapper(this, "editingItem");
        }
        return this.editingItem;
    }

    public final void setOnEditStart(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editStartEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "onEditStart";
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditCommit() {
        return this.onEditCommit == null ? null : (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editCommitEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "onEditCommit";
                }
            };
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<EditEvent<T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<EditEvent<T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new ObjectPropertyBase<EventHandler<EditEvent<T>>>(){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editCancelEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "onEditCancel";
                }
            };
        }
        return this.onEditCancel;
    }

    @Override
    protected void layoutChildren() {
        if (this.treeItemCountDirty) {
            this.updateTreeItemCount();
            this.treeItemCountDirty = false;
        }
        super.layoutChildren();
    }

    public void edit(TreeItem<T> treeItem) {
        this.setEditingItem(treeItem);
    }

    public void scrollTo(int n) {
        this.getProperties().put("VirtualContainerBase.scrollToIndex", n);
    }

    public int getRow(TreeItem<T> treeItem) {
        if (treeItem == null) {
            return -1;
        }
        if (this.isShowRoot() && treeItem.equals(this.getRoot())) {
            return 0;
        }
        int n = 0;
        TreeItem<T> treeItem2 = treeItem;
        TreeItem<T> treeItem3 = treeItem.getParent();
        while (!treeItem2.equals(this.getRoot()) && treeItem3 != null) {
            ObservableList<TreeItem<T>> observableList = treeItem3.getChildren();
            int n2 = observableList.indexOf(treeItem2);
            for (int i = n2 - 1; i > -1; --i) {
                TreeItem treeItem4 = (TreeItem)observableList.get(i);
                if (treeItem4 == null) continue;
                n += this.getExpandedDescendantCount(treeItem4);
                if (!treeItem4.equals(this.getRoot())) continue;
                if (!this.isShowRoot()) {
                    return -1;
                }
                return n;
            }
            treeItem2 = treeItem3;
            treeItem3 = treeItem3.getParent();
            ++n;
        }
        return treeItem3 == null && n == 0 ? -1 : (this.isShowRoot() ? n : n - 1);
    }

    public TreeItem<T> getTreeItem(int n) {
        int n2 = this.isShowRoot() ? n : n + 1;
        return this.getItem(this.getRoot(), n2);
    }

    private int getExpandedDescendantCount(TreeItem<T> treeItem) {
        if (treeItem == null) {
            return 0;
        }
        if (treeItem.isLeaf()) {
            return 1;
        }
        return treeItem.getExpandedDescendentCount();
    }

    private void updateTreeItemCount() {
        if (this.getRoot() == null) {
            this.setTreeItemCount(0);
        } else if (!this.getRoot().isExpanded()) {
            this.setTreeItemCount(1);
        } else {
            int n = this.getExpandedDescendantCount(this.getRoot());
            if (!this.isShowRoot()) {
                --n;
            }
            this.setTreeItemCount(n);
        }
    }

    private TreeItem getItem(TreeItem<T> treeItem, int n) {
        if (treeItem == null) {
            return null;
        }
        if (n == 0) {
            return treeItem;
        }
        if (n >= this.getExpandedDescendantCount(treeItem)) {
            return null;
        }
        int n2 = n - 1;
        ObservableList<TreeItem<T>> observableList = treeItem.getChildren();
        if (observableList != null) {
            for (TreeItem treeItem2 : observableList) {
                TreeItem treeItem3 = this.getItem(treeItem2, n2);
                n2 -= this.getExpandedDescendantCount(treeItem2);
                if (treeItem3 == null) continue;
                return treeItem3;
            }
        }
        return null;
    }

    private void updateRootExpanded() {
        if (!this.isShowRoot() && this.getRoot() != null && !this.getRoot().isExpanded()) {
            this.getRoot().setExpanded(true);
        }
        this.updateTreeItemCount();
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    static class TreeViewFocusModel<T>
    extends FocusModel<TreeItem<T>> {
        private final TreeView<T> treeView;
        private final ChangeListener rootPropertyListener = new ChangeListener<TreeItem<T>>(){

            @Override
            public void changed(ObservableValue<? extends TreeItem<T>> observableValue, TreeItem<T> treeItem, TreeItem<T> treeItem2) {
                TreeViewFocusModel.this.updateTreeEventListener(treeItem, treeItem2);
            }
        };
        private final WeakChangeListener weakRootPropertyListener = new WeakChangeListener(this.rootPropertyListener);
        private EventHandler<TreeItem.TreeModificationEvent<T>> treeItemListener = new EventHandler<TreeItem.TreeModificationEvent<T>>(){

            @Override
            public void handle(TreeItem.TreeModificationEvent<T> treeModificationEvent) {
                int n = TreeViewFocusModel.this.treeView.getRow(treeModificationEvent.getTreeItem());
                if (n >= TreeViewFocusModel.this.getFocusedIndex()) {
                    return;
                }
                int n2 = 0;
                if (treeModificationEvent.wasExpanded()) {
                    n2 = treeModificationEvent.getTreeItem().getExpandedDescendentCount() - 1;
                } else if (treeModificationEvent.wasCollapsed()) {
                    n2 = -treeModificationEvent.getTreeItem().previousExpandedDescendentCount + 1;
                } else if (treeModificationEvent.wasAdded()) {
                    n2 = treeModificationEvent.getTreeItem().isExpanded() ? treeModificationEvent.getAddedSize() : 0;
                } else if (treeModificationEvent.wasRemoved()) {
                    n2 = treeModificationEvent.getTreeItem().isExpanded() ? -treeModificationEvent.getRemovedSize() : 0;
                }
                TreeViewFocusModel.this.focus(TreeViewFocusModel.this.getFocusedIndex() + n2);
            }
        };
        private WeakEventHandler weakTreeItemListener;

        public TreeViewFocusModel(TreeView<T> treeView) {
            this.treeView = treeView;
            this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
            this.updateTreeEventListener(null, treeView.getRoot());
        }

        private void updateTreeEventListener(TreeItem<T> treeItem, TreeItem<T> treeItem2) {
            if (treeItem != null && this.weakTreeItemListener != null) {
                treeItem.removeEventHandler(TreeItem.treeItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (treeItem2 != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<T>>(treeItem2, TreeItem.treeItemCountChangeEvent(), this.treeItemListener);
                treeItem2.addEventHandler(TreeItem.treeItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        protected int getItemCount() {
            return this.treeView == null ? -1 : this.treeView.impl_getTreeItemCount();
        }

        @Override
        protected TreeItem<T> getModelItem(int n) {
            if (this.treeView == null) {
                return null;
            }
            if (n < 0 || n >= this.treeView.impl_getTreeItemCount()) {
                return null;
            }
            return this.treeView.getTreeItem(n);
        }
    }

    static class TreeViewBitSetSelectionModel<T>
    extends MultipleSelectionModelBase<TreeItem<T>> {
        private ChangeListener rootPropertyListener = new ChangeListener<TreeItem<T>>(){

            @Override
            public void changed(ObservableValue<? extends TreeItem<T>> observableValue, TreeItem<T> treeItem, TreeItem<T> treeItem2) {
                TreeViewBitSetSelectionModel.this.setSelectedIndex(-1);
                TreeViewBitSetSelectionModel.this.updateTreeEventListener(treeItem, treeItem2);
            }
        };
        private EventHandler<TreeItem.TreeModificationEvent<T>> treeItemListener = new EventHandler<TreeItem.TreeModificationEvent<T>>(){

            @Override
            public void handle(TreeItem.TreeModificationEvent<T> treeModificationEvent) {
                int n = TreeViewBitSetSelectionModel.this.treeView.getRow(treeModificationEvent.getTreeItem());
                int n2 = 0;
                if (treeModificationEvent.wasExpanded()) {
                    n2 = treeModificationEvent.getTreeItem().getExpandedDescendentCount() - 1;
                    ++n;
                } else if (treeModificationEvent.wasCollapsed()) {
                    int n3 = TreeViewBitSetSelectionModel.this.treeView.getRow(treeModificationEvent.getTreeItem());
                    int n4 = treeModificationEvent.getTreeItem().previousExpandedDescendentCount;
                    boolean bl = false;
                    for (int i = n3; i <= n3 + n4; ++i) {
                        if (!TreeViewBitSetSelectionModel.this.isSelected(i)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        TreeViewBitSetSelectionModel.this.select(n);
                    }
                    n2 = -treeModificationEvent.getTreeItem().previousExpandedDescendentCount + 1;
                    ++n;
                } else if (treeModificationEvent.wasAdded()) {
                    n2 = treeModificationEvent.getTreeItem().isExpanded() ? treeModificationEvent.getAddedSize() : 0;
                } else if (treeModificationEvent.wasRemoved()) {
                    int n5;
                    n2 = treeModificationEvent.getTreeItem().isExpanded() ? -treeModificationEvent.getRemovedSize() : 0;
                    ObservableList<Integer> observableList = TreeViewBitSetSelectionModel.this.getSelectedIndices();
                    for (int i = 0; i < observableList.size() && !TreeViewBitSetSelectionModel.this.getSelectedItems().isEmpty() && (n5 = ((Integer)observableList.get(i)).intValue()) <= TreeViewBitSetSelectionModel.this.getSelectedItems().size(); ++i) {
                        TreeItem treeItem = (TreeItem)TreeViewBitSetSelectionModel.this.getSelectedItems().get(n5);
                        if (treeItem != null && !treeModificationEvent.getRemovedChildren().contains(treeItem)) continue;
                        TreeViewBitSetSelectionModel.this.clearSelection(n5);
                    }
                }
                TreeViewBitSetSelectionModel.this.shiftSelection(n, n2);
            }
        };
        private WeakChangeListener weakRootPropertyListener = new WeakChangeListener(this.rootPropertyListener);
        private WeakEventHandler weakTreeItemListener;
        private final TreeView<T> treeView;

        public TreeViewBitSetSelectionModel(TreeView<T> treeView) {
            if (treeView == null) {
                throw new IllegalArgumentException("TreeView can not be null");
            }
            this.treeView = treeView;
            this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
            this.updateTreeEventListener(null, treeView.getRoot());
        }

        private void updateTreeEventListener(TreeItem<T> treeItem, TreeItem<T> treeItem2) {
            if (treeItem != null && this.weakTreeItemListener != null) {
                treeItem.removeEventHandler(TreeItem.treeItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (treeItem2 != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<T>>(treeItem2, TreeItem.treeItemCountChangeEvent(), this.treeItemListener);
                treeItem2.addEventHandler(TreeItem.treeItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        public void select(TreeItem<T> treeItem) {
            for (TreeItem<T> treeItem2 = treeItem; treeItem2 != null; treeItem2 = treeItem2.getParent()) {
                treeItem2.setExpanded(true);
            }
            ((TreeView)this.treeView).updateTreeItemCount();
            int n = this.treeView.getRow(treeItem);
            if (n == -1) {
                this.setSelectedItem(treeItem);
            } else {
                this.select(n);
            }
        }

        @Override
        protected void focus(int n) {
            if (this.treeView.getFocusModel() != null) {
                this.treeView.getFocusModel().focus(n);
            }
        }

        @Override
        protected int getFocusedIndex() {
            if (this.treeView.getFocusModel() == null) {
                return -1;
            }
            return this.treeView.getFocusModel().getFocusedIndex();
        }

        @Override
        protected int getItemCount() {
            return this.treeView == null ? 0 : this.treeView.impl_getTreeItemCount();
        }

        @Override
        public TreeItem<T> getModelItem(int n) {
            if (this.treeView == null) {
                return null;
            }
            if (n < 0 || n >= this.treeView.impl_getTreeItemCount()) {
                return null;
            }
            return this.treeView.getTreeItem(n);
        }
    }

    public static class EditEvent<T>
    extends Event {
        private final T oldValue;
        private final T newValue;
        private final transient TreeItem<T> treeItem;

        public EditEvent(TreeView<T> treeView, EventType<? extends EditEvent> eventType, TreeItem<T> treeItem, T t, T t2) {
            super(treeView, Event.NULL_SOURCE_TARGET, eventType);
            this.oldValue = t;
            this.newValue = t2;
            this.treeItem = treeItem;
        }

        @Override
        public TreeView<T> getSource() {
            return (TreeView)super.getSource();
        }

        public TreeItem<T> getTreeItem() {
            return this.treeItem;
        }

        public T getNewValue() {
            return this.newValue;
        }

        public T getOldValue() {
            return this.oldValue;
        }
    }

    private static class StyleableProperties {
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

