/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextInputControl;

public class TextField
extends TextInputControl {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 12;
    private StringProperty promptText = new SimpleStringProperty(this, "promptText", ""){

        @Override
        protected void invalidated() {
            String string = this.get();
            if (string != null && string.contains("\n")) {
                string = string.replace("\n", "");
                this.set(string);
            }
        }
    };
    private IntegerProperty prefColumnCount = new IntegerPropertyBase(12){

        @Override
        public void set(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("value cannot be negative.");
            }
            super.set(n);
        }

        @Override
        public Object getBean() {
            return TextField.this;
        }

        @Override
        public String getName() {
            return "prefColumnCount";
        }
    };
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            TextField.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return TextField.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };

    public TextField() {
        this("");
    }

    public TextField(String string) {
        super(new TextFieldContent());
        this.getStyleClass().add("text-field");
        this.setText(string);
    }

    public CharSequence getCharacters() {
        return ((TextFieldContent)this.getContent()).characters;
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String string) {
        this.promptText.set(string);
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int n) {
        this.prefColumnCount.setValue(n);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    private static final class TextFieldContent
    implements TextInputControl.Content {
        private ExpressionHelper<String> helper = null;
        private StringBuilder characters = new StringBuilder();

        private TextFieldContent() {
        }

        @Override
        public String get(int n, int n2) {
            return this.characters.substring(n, n2);
        }

        @Override
        public void insert(int n, String string) {
            string = TextInputControl.filterInput(string, true, true);
            this.characters.insert(n, string);
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        @Override
        public void delete(int n, int n2) {
            this.characters.delete(n, n2);
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        @Override
        public int length() {
            return this.characters.length();
        }

        @Override
        public String get() {
            return this.characters.toString();
        }

        @Override
        public void addListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public String getValue() {
            return this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }
    }
}

