/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Arrays;
import java.util.Collection;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControlBuilder;

public class TextAreaBuilder<B extends TextAreaBuilder<B>>
extends TextInputControlBuilder<B> {
    private int __set;
    private Collection<? extends CharSequence> paragraphs;
    private int prefColumnCount;
    private int prefRowCount;
    private double scrollLeft;
    private double scrollTop;
    private boolean wrapText;

    protected TextAreaBuilder() {
    }

    public static TextAreaBuilder<?> create() {
        return new TextAreaBuilder();
    }

    public void applyTo(TextArea textArea) {
        super.applyTo(textArea);
        int n = this.__set;
        if ((n & 1) != 0) {
            textArea.getParagraphs().setAll(this.paragraphs);
        }
        if ((n & 2) != 0) {
            textArea.setPrefColumnCount(this.prefColumnCount);
        }
        if ((n & 4) != 0) {
            textArea.setPrefRowCount(this.prefRowCount);
        }
        if ((n & 8) != 0) {
            textArea.setScrollLeft(this.scrollLeft);
        }
        if ((n & 0x10) != 0) {
            textArea.setScrollTop(this.scrollTop);
        }
        if ((n & 0x20) != 0) {
            textArea.setWrapText(this.wrapText);
        }
    }

    public B paragraphs(Collection<? extends CharSequence> collection) {
        this.paragraphs = collection;
        this.__set |= 1;
        return (B)this;
    }

    public B paragraphs(CharSequence ... charSequenceArray) {
        return this.paragraphs(Arrays.asList(charSequenceArray));
    }

    public B prefColumnCount(int n) {
        this.prefColumnCount = n;
        this.__set |= 2;
        return (B)this;
    }

    public B prefRowCount(int n) {
        this.prefRowCount = n;
        this.__set |= 4;
        return (B)this;
    }

    public B scrollLeft(double d) {
        this.scrollLeft = d;
        this.__set |= 8;
        return (B)this;
    }

    public B scrollTop(double d) {
        this.scrollTop = d;
        this.__set |= 0x10;
        return (B)this;
    }

    public B wrapText(boolean bl) {
        this.wrapText = bl;
        this.__set |= 0x20;
        return (B)this;
    }

    public TextArea build() {
        TextArea textArea = new TextArea();
        this.applyTo(textArea);
        return textArea;
    }
}

