/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.util.StringConverter;

public class Slider
extends Control {
    private DoubleProperty max;
    private DoubleProperty min;
    private DoubleProperty value;
    private BooleanProperty valueChanging;
    @Styleable(property="-fx-orientation", initial="vertical")
    private ObjectProperty<Orientation> orientation;
    @Styleable(property="-fx-show-tick-labels", initial="false")
    private BooleanProperty showTickLabels;
    @Styleable(property="-fx-show-tick-marks", initial="false")
    private BooleanProperty showTickMarks;
    @Styleable(property="-fx-major-tick-unit", initial="25")
    private DoubleProperty majorTickUnit;
    @Styleable(property="-fx-minor-tick-count", initial="3")
    private IntegerProperty minorTickCount;
    @Styleable(property="-fx-snap-to-ticks", initial="false")
    private BooleanProperty snapToTicks;
    private ObjectProperty<StringConverter<Double>> labelFormatter;
    @Styleable(property="-fx-block-increment", initial="10")
    private DoubleProperty blockIncrement;
    private static final String DEFAULT_STYLE_CLASS = "slider";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public Slider() {
        this.initialize();
    }

    public Slider(double d, double d2, double d3) {
        this.setMax(d2);
        this.setMin(d);
        this.setValue(d3);
        this.adjustValues();
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setMax(double d) {
        this.maxProperty().set(d);
    }

    public final double getMax() {
        return this.max == null ? 100.0 : this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new DoublePropertyBase(100.0){

                @Override
                protected void invalidated() {
                    if (this.get() < Slider.this.getMin()) {
                        Slider.this.setMin(this.get());
                    }
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "max";
                }
            };
        }
        return this.max;
    }

    public final void setMin(double d) {
        this.minProperty().set(d);
    }

    public final double getMin() {
        return this.min == null ? 0.0 : this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    if (this.get() > Slider.this.getMax()) {
                        Slider.this.setMax(this.get());
                    }
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "min";
                }
            };
        }
        return this.min;
    }

    public final void setValue(double d) {
        this.valueProperty().set(d);
    }

    public final double getValue() {
        return this.value == null ? 0.0 : this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public final void setValueChanging(boolean bl) {
        this.valueChangingProperty().set(bl);
    }

    public final boolean isValueChanging() {
        return this.valueChanging == null ? false : this.valueChanging.get();
    }

    public final BooleanProperty valueChangingProperty() {
        if (this.valueChanging == null) {
            this.valueChanging = new SimpleBooleanProperty(this, "valueChanging", false);
        }
        return this.valueChanging;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new ObjectPropertyBase<Orientation>(Orientation.HORIZONTAL){

                @Override
                protected void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
                    Slider.this.impl_pseudoClassStateChanged(Slider.PSEUDO_CLASS_VERTICAL);
                    Slider.this.impl_pseudoClassStateChanged(Slider.PSEUDO_CLASS_HORIZONTAL);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setShowTickLabels(boolean bl) {
        this.showTickLabelsProperty().set(bl);
    }

    public final boolean isShowTickLabels() {
        return this.showTickLabels == null ? false : this.showTickLabels.get();
    }

    public final BooleanProperty showTickLabelsProperty() {
        if (this.showTickLabels == null) {
            this.showTickLabels = new BooleanPropertyBase(false){

                @Override
                public void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.SHOW_TICK_LABELS);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "showTickLabels";
                }
            };
        }
        return this.showTickLabels;
    }

    public final void setShowTickMarks(boolean bl) {
        this.showTickMarksProperty().set(bl);
    }

    public final boolean isShowTickMarks() {
        return this.showTickMarks == null ? false : this.showTickMarks.get();
    }

    public final BooleanProperty showTickMarksProperty() {
        if (this.showTickMarks == null) {
            this.showTickMarks = new BooleanPropertyBase(false){

                @Override
                public void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.SHOW_TICK_MARKS);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "showTickMarks";
                }
            };
        }
        return this.showTickMarks;
    }

    public final void setMajorTickUnit(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
        }
        this.majorTickUnitProperty().set(d);
    }

    public final double getMajorTickUnit() {
        return this.majorTickUnit == null ? 25.0 : this.majorTickUnit.get();
    }

    public final DoubleProperty majorTickUnitProperty() {
        if (this.majorTickUnit == null) {
            this.majorTickUnit = new DoublePropertyBase(25.0){

                @Override
                public void invalidated() {
                    if (this.get() <= 0.0) {
                        throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
                    }
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.MAJOR_TICK_UNIT);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "majorTickUnit";
                }
            };
        }
        return this.majorTickUnit;
    }

    public final void setMinorTickCount(int n) {
        this.minorTickCountProperty().set(n);
    }

    public final int getMinorTickCount() {
        return this.minorTickCount == null ? 3 : this.minorTickCount.get();
    }

    public final IntegerProperty minorTickCountProperty() {
        if (this.minorTickCount == null) {
            this.minorTickCount = new IntegerPropertyBase(3){

                @Override
                public void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.MINOR_TICK_COUNT);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "minorTickCount";
                }
            };
        }
        return this.minorTickCount;
    }

    public final void setSnapToTicks(boolean bl) {
        this.snapToTicksProperty().set(bl);
    }

    public final boolean isSnapToTicks() {
        return this.snapToTicks == null ? false : this.snapToTicks.get();
    }

    public final BooleanProperty snapToTicksProperty() {
        if (this.snapToTicks == null) {
            this.snapToTicks = new BooleanPropertyBase(false){

                @Override
                public void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.SNAP_TO_TICKS);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "snapToTicks";
                }
            };
        }
        return this.snapToTicks;
    }

    public final void setLabelFormatter(StringConverter<Double> stringConverter) {
        this.labelFormatterProperty().set(stringConverter);
    }

    public final StringConverter<Double> getLabelFormatter() {
        return this.labelFormatter == null ? null : (StringConverter)this.labelFormatter.get();
    }

    public final ObjectProperty<StringConverter<Double>> labelFormatterProperty() {
        if (this.labelFormatter == null) {
            this.labelFormatter = new SimpleObjectProperty<StringConverter<Double>>(this, "labelFormatter");
        }
        return this.labelFormatter;
    }

    public final void setBlockIncrement(double d) {
        this.blockIncrementProperty().set(d);
    }

    public final double getBlockIncrement() {
        return this.blockIncrement == null ? 10.0 : this.blockIncrement.get();
    }

    public final DoubleProperty blockIncrementProperty() {
        if (this.blockIncrement == null) {
            this.blockIncrement = new DoublePropertyBase(10.0){

                @Override
                public void invalidated() {
                    Slider.this.impl_cssPropertyInvalidated(StyleableProperties.BLOCK_INCREMENT);
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "blockIncrement";
                }
            };
        }
        return this.blockIncrement;
    }

    public void adjustValue(double d) {
        double d2 = this.getMin();
        double d3 = this.getMax();
        if (d3 <= d2) {
            return;
        }
        d = d < d2 ? d2 : d;
        d = d > d3 ? d3 : d;
        this.setValue(this.snapValueToTicks(d));
    }

    public void increment() {
        this.adjustValue(this.getValue() + this.getBlockIncrement());
    }

    public void decrement() {
        this.adjustValue(this.getValue() - this.getBlockIncrement());
    }

    private void adjustValues() {
        if (this.getValue() < this.getMin() || this.getValue() > this.getMax()) {
            this.setValue(Utils.clamp(this.getMin(), this.getValue(), this.getMax()));
        }
    }

    private double snapValueToTicks(double d) {
        double d2 = d;
        if (this.isSnapToTicks()) {
            double d3 = 0.0;
            d3 = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int n = (int)((d2 - this.getMin()) / d3);
            double d4 = (double)n * d3 + this.getMin();
            double d5 = (double)(n + 1) * d3 + this.getMin();
            d2 = Utils.nearest(d4, d2, d5);
        }
        return Utils.clamp(this.getMin(), d2, this.getMax());
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-block-increment".equals(string)) {
            this.setBlockIncrement((Double)object);
        } else if ("-fx-show-tick-labels".equals(string)) {
            this.setShowTickLabels((Boolean)object);
        } else if ("-fx-show-tick-marks".equals(string)) {
            this.setShowTickMarks((Boolean)object);
        } else if ("-fx-snap-to-ticks".equals(string)) {
            this.setSnapToTicks((Boolean)object);
        } else if ("-fx-major-tick-unit".equals(string)) {
            this.setMajorTickUnit((Double)object);
        } else if ("-fx-minor-tick-count".equals(string)) {
            this.setMinorTickCount((int)((Double)object).doubleValue());
        } else if ("-fx-orientation".equals(string)) {
            this.setOrientation((Orientation)((Object)object));
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-block-increment".equals(string)) {
            return this.blockIncrement == null || !this.blockIncrement.isBound();
        }
        if ("-fx-show-tick-labels".equals(string)) {
            return this.showTickLabels == null || !this.showTickLabels.isBound();
        }
        if ("-fx-show-tick-marks".equals(string)) {
            return this.showTickMarks == null || !this.showTickMarks.isBound();
        }
        if ("-fx-snap-to-ticks".equals(string)) {
            return this.snapToTicks == null || !this.snapToTicks.isBound();
        }
        if ("-fx-major-tick-unit".equals(string)) {
            return this.majorTickUnit == null || !this.majorTickUnit.isBound();
        }
        if ("-fx-minor-tick-count".equals(string)) {
            return this.minorTickCount == null || !this.minorTickCount.isBound();
        }
        if ("-fx-orientation".equals(string)) {
            return this.orientation == null || !this.orientation.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty BLOCK_INCREMENT = new StyleableProperty(Slider.class, "blockIncrement");
        private static final StyleableProperty SHOW_TICK_LABELS = new StyleableProperty(Slider.class, "showTickLabels");
        private static final StyleableProperty SHOW_TICK_MARKS = new StyleableProperty(Slider.class, "showTickMarks");
        private static final StyleableProperty SNAP_TO_TICKS = new StyleableProperty(Slider.class, "snapToTicks");
        private static final StyleableProperty MAJOR_TICK_UNIT = new StyleableProperty(Slider.class, "majorTickUnit");
        private static final StyleableProperty MINOR_TICK_COUNT = new StyleableProperty(Slider.class, "minorTickCount");
        private static final StyleableProperty ORIENTATION = new StyleableProperty(Slider.class, "orientation");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, BLOCK_INCREMENT, SHOW_TICK_LABELS, SHOW_TICK_MARKS, SNAP_TO_TICKS, MAJOR_TICK_UNIT, MINOR_TICK_COUNT, ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

