/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ScrollPane
extends Control {
    @Styleable(property="-fx-hbar-policy", initial="as-needed")
    private ObjectProperty<ScrollBarPolicy> hbarPolicy;
    @Styleable(property="-fx-vbar-policy", initial="as-needed")
    private ObjectProperty<ScrollBarPolicy> vbarPolicy;
    private ObjectProperty<Node> content;
    private DoubleProperty hvalue;
    private DoubleProperty vvalue;
    private DoubleProperty hmin;
    private DoubleProperty vmin;
    private DoubleProperty hmax;
    private DoubleProperty vmax;
    @Styleable(property="-fx-fit-to-width", initial="false")
    private BooleanProperty fitToWidth;
    @Styleable(property="-fx-fit-to-height", initial="false")
    private BooleanProperty fitToHeight;
    @Styleable(property="-fx-pannable", initial="false")
    private BooleanProperty pannable;
    private DoubleProperty prefViewportWidth;
    private DoubleProperty prefViewportHeight;
    private ObjectProperty<Bounds> viewportBounds;
    private static final String DEFAULT_STYLE_CLASS = "scroll-pane";
    private static final String PSEUDO_CLASS_FIT_TO_WIDTH = "fitToWidth";
    private static final String PSEUDO_CLASS_FIT_TO_HEIGHT = "fitToHeight";
    private static final String PSEUDO_CLASS_PANNABLE = "pannable";
    private static final long PANNABLE_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("pannable");
    private static final long FIT_TO_WIDTH_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("fitToWidth");
    private static final long FIT_TO_HEIGHT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("fitToHeight");

    public ScrollPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setFocusTraversable(false);
    }

    public final void setHbarPolicy(ScrollBarPolicy scrollBarPolicy) {
        this.hbarPolicyProperty().set(scrollBarPolicy);
    }

    public final ScrollBarPolicy getHbarPolicy() {
        return this.hbarPolicy == null ? ScrollBarPolicy.AS_NEEDED : (ScrollBarPolicy)((Object)this.hbarPolicy.get());
    }

    public final ObjectProperty<ScrollBarPolicy> hbarPolicyProperty() {
        if (this.hbarPolicy == null) {
            this.hbarPolicy = new ObjectPropertyBase<ScrollBarPolicy>(ScrollBarPolicy.AS_NEEDED){

                @Override
                public void invalidated() {
                    ScrollPane.this.impl_cssPropertyInvalidated(StyleableProperties.HBAR_POLICY);
                }

                @Override
                public Object getBean() {
                    return ScrollPane.this;
                }

                @Override
                public String getName() {
                    return "hbarPolicy";
                }
            };
        }
        return this.hbarPolicy;
    }

    public final void setVbarPolicy(ScrollBarPolicy scrollBarPolicy) {
        this.vbarPolicyProperty().set(scrollBarPolicy);
    }

    public final ScrollBarPolicy getVbarPolicy() {
        return this.vbarPolicy == null ? ScrollBarPolicy.AS_NEEDED : (ScrollBarPolicy)((Object)this.vbarPolicy.get());
    }

    public final ObjectProperty<ScrollBarPolicy> vbarPolicyProperty() {
        if (this.vbarPolicy == null) {
            this.vbarPolicy = new ObjectPropertyBase<ScrollBarPolicy>(ScrollBarPolicy.AS_NEEDED){

                @Override
                public void invalidated() {
                    ScrollPane.this.impl_cssPropertyInvalidated(StyleableProperties.VBAR_POLICY);
                }

                @Override
                public Object getBean() {
                    return ScrollPane.this;
                }

                @Override
                public String getName() {
                    return "vbarPolicy";
                }
            };
        }
        return this.vbarPolicy;
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setHvalue(double d) {
        this.hvalueProperty().set(d);
    }

    public final double getHvalue() {
        return this.hvalue == null ? 0.0 : this.hvalue.get();
    }

    public final DoubleProperty hvalueProperty() {
        if (this.hvalue == null) {
            this.hvalue = new SimpleDoubleProperty(this, "hvalue");
        }
        return this.hvalue;
    }

    public final void setVvalue(double d) {
        this.vvalueProperty().set(d);
    }

    public final double getVvalue() {
        return this.vvalue == null ? 0.0 : this.vvalue.get();
    }

    public final DoubleProperty vvalueProperty() {
        if (this.vvalue == null) {
            this.vvalue = new SimpleDoubleProperty(this, "vvalue");
        }
        return this.vvalue;
    }

    public final void setHmin(double d) {
        this.hminProperty().set(d);
    }

    public final double getHmin() {
        return this.hmin == null ? 0.0 : this.hmin.get();
    }

    public final DoubleProperty hminProperty() {
        if (this.hmin == null) {
            this.hmin = new SimpleDoubleProperty(this, "hmin", 0.0);
        }
        return this.hmin;
    }

    public final void setVmin(double d) {
        this.vminProperty().set(d);
    }

    public final double getVmin() {
        return this.vmin == null ? 0.0 : this.vmin.get();
    }

    public final DoubleProperty vminProperty() {
        if (this.vmin == null) {
            this.vmin = new SimpleDoubleProperty(this, "vmin", 0.0);
        }
        return this.vmin;
    }

    public final void setHmax(double d) {
        this.hmaxProperty().set(d);
    }

    public final double getHmax() {
        return this.hmax == null ? 1.0 : this.hmax.get();
    }

    public final DoubleProperty hmaxProperty() {
        if (this.hmax == null) {
            this.hmax = new SimpleDoubleProperty(this, "hmax", 1.0);
        }
        return this.hmax;
    }

    public final void setVmax(double d) {
        this.vmaxProperty().set(d);
    }

    public final double getVmax() {
        return this.vmax == null ? 1.0 : this.vmax.get();
    }

    public final DoubleProperty vmaxProperty() {
        if (this.vmax == null) {
            this.vmax = new SimpleDoubleProperty(this, "vmax", 1.0);
        }
        return this.vmax;
    }

    public final void setFitToWidth(boolean bl) {
        this.fitToWidthProperty().set(bl);
    }

    public final boolean isFitToWidth() {
        return this.fitToWidth == null ? false : this.fitToWidth.get();
    }

    public final BooleanProperty fitToWidthProperty() {
        if (this.fitToWidth == null) {
            this.fitToWidth = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    ScrollPane.this.impl_cssPropertyInvalidated(StyleableProperties.FIT_TO_WIDTH);
                    ScrollPane.this.impl_pseudoClassStateChanged(ScrollPane.PSEUDO_CLASS_FIT_TO_WIDTH);
                }

                @Override
                public Object getBean() {
                    return ScrollPane.this;
                }

                @Override
                public String getName() {
                    return ScrollPane.PSEUDO_CLASS_FIT_TO_WIDTH;
                }
            };
        }
        return this.fitToWidth;
    }

    public final void setFitToHeight(boolean bl) {
        this.fitToHeightProperty().set(bl);
    }

    public final boolean isFitToHeight() {
        return this.fitToHeight == null ? false : this.fitToHeight.get();
    }

    public final BooleanProperty fitToHeightProperty() {
        if (this.fitToHeight == null) {
            this.fitToHeight = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    ScrollPane.this.impl_cssPropertyInvalidated(StyleableProperties.FIT_TO_HEIGHT);
                    ScrollPane.this.impl_pseudoClassStateChanged(ScrollPane.PSEUDO_CLASS_FIT_TO_HEIGHT);
                }

                @Override
                public Object getBean() {
                    return ScrollPane.this;
                }

                @Override
                public String getName() {
                    return ScrollPane.PSEUDO_CLASS_FIT_TO_HEIGHT;
                }
            };
        }
        return this.fitToHeight;
    }

    public final void setPannable(boolean bl) {
        this.pannableProperty().set(bl);
    }

    public final boolean isPannable() {
        return this.pannable == null ? false : this.pannable.get();
    }

    public final BooleanProperty pannableProperty() {
        if (this.pannable == null) {
            this.pannable = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    ScrollPane.this.impl_cssPropertyInvalidated(StyleableProperties.PANNABLE);
                    ScrollPane.this.impl_pseudoClassStateChanged(ScrollPane.PSEUDO_CLASS_PANNABLE);
                }

                @Override
                public Object getBean() {
                    return ScrollPane.this;
                }

                @Override
                public String getName() {
                    return ScrollPane.PSEUDO_CLASS_PANNABLE;
                }
            };
        }
        return this.pannable;
    }

    public final void setPrefViewportWidth(double d) {
        this.prefViewportWidthProperty().set(d);
    }

    public final double getPrefViewportWidth() {
        return this.prefViewportWidth == null ? 0.0 : this.prefViewportWidth.get();
    }

    public final DoubleProperty prefViewportWidthProperty() {
        if (this.prefViewportWidth == null) {
            this.prefViewportWidth = new SimpleDoubleProperty(this, "prefViewportWidth");
        }
        return this.prefViewportWidth;
    }

    public final void setPrefViewportHeight(double d) {
        this.prefViewportHeightProperty().set(d);
    }

    public final double getPrefViewportHeight() {
        return this.prefViewportHeight == null ? 0.0 : this.prefViewportHeight.get();
    }

    public final DoubleProperty prefViewportHeightProperty() {
        if (this.prefViewportHeight == null) {
            this.prefViewportHeight = new SimpleDoubleProperty(this, "prefViewportHeight");
        }
        return this.prefViewportHeight;
    }

    public final void setViewportBounds(Bounds bounds) {
        this.viewportBoundsProperty().set(bounds);
    }

    public final Bounds getViewportBounds() {
        return this.viewportBounds == null ? new BoundingBox(0.0, 0.0, 0.0, 0.0) : (Bounds)this.viewportBounds.get();
    }

    public final ObjectProperty<Bounds> viewportBoundsProperty() {
        if (this.viewportBounds == null) {
            this.viewportBounds = new SimpleObjectProperty<Bounds>(this, "viewportBounds");
        }
        return this.viewportBounds;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isPannable()) {
            l |= PANNABLE_PSEUDOCLASS_STATE;
        }
        if (this.isFitToWidth()) {
            l |= FIT_TO_WIDTH_PSEUDOCLASS_STATE;
        }
        if (this.isFitToHeight()) {
            l |= FIT_TO_HEIGHT_PSEUDOCLASS_STATE;
        }
        return l;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-hbar-policy".equals(string)) {
            this.setHbarPolicy((ScrollBarPolicy)((Object)object));
        } else if ("-fx-vbar-policy".equals(string)) {
            this.setVbarPolicy((ScrollBarPolicy)((Object)object));
        } else if ("-fx-fit-to-width".equals(string)) {
            this.setFitToWidth((Boolean)object);
        } else if ("-fx-fit-to-height".equals(string)) {
            this.setFitToHeight((Boolean)object);
        } else if ("-fx-pannable".equals(string)) {
            this.setPannable((Boolean)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-hbar-policy".equals(string)) {
            return this.hbarPolicy == null || !this.hbarPolicy.isBound();
        }
        if ("-fx-vbar-policy".equals(string)) {
            return this.vbarPolicy == null || !this.vbarPolicy.isBound();
        }
        if ("-fx-fit-to-width".equals(string)) {
            return this.fitToWidth == null || !this.fitToWidth.isBound();
        }
        if ("-fx-fit-to-height".equals(string)) {
            return this.fitToHeight == null || !this.fitToHeight.isBound();
        }
        if ("-fx-pannable".equals(string)) {
            return this.pannable == null || !this.pannable.isBound();
        }
        return super.impl_cssSettable(string);
    }

    public static enum ScrollBarPolicy {
        NEVER,
        ALWAYS,
        AS_NEEDED;

    }

    private static class StyleableProperties {
        private static final StyleableProperty HBAR_POLICY = new StyleableProperty(ScrollPane.class, "hbarPolicy");
        private static final StyleableProperty VBAR_POLICY = new StyleableProperty(ScrollPane.class, "vbarPolicy");
        private static final StyleableProperty FIT_TO_WIDTH = new StyleableProperty(ScrollPane.class, "fitToWidth");
        private static final StyleableProperty FIT_TO_HEIGHT = new StyleableProperty(ScrollPane.class, "fitToHeight");
        private static final StyleableProperty PANNABLE = new StyleableProperty(ScrollPane.class, "pannable");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, HBAR_POLICY, VBAR_POLICY, FIT_TO_WIDTH, FIT_TO_HEIGHT, PANNABLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

