/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public abstract class Labeled
extends Control {
    private StringProperty text;
    @Styleable(property="-fx-alignment", initial="center_left")
    private ObjectProperty<Pos> alignment;
    @Styleable(property="-fx-text-alignment", initial="left")
    private ObjectProperty<TextAlignment> textAlignment;
    @Styleable(property="-fx-text-overrun", initial="ellipsis")
    private ObjectProperty<OverrunStyle> textOverrun;
    @Styleable(property="-fx-wrap-text", initial="false")
    private BooleanProperty wrapText;
    @Styleable(property="-fx-font", inherits=true)
    private ObjectProperty<Font> font;
    @Styleable(property="-fx-graphic", converter="com.sun.javafx.css.converters.URLConverter")
    private ObjectProperty<Node> graphic;
    @Styleable(property="-fx-underline", initial="false")
    private BooleanProperty underline;
    @Styleable(property="-fx-content-display", initial="left")
    private ObjectProperty<ContentDisplay> contentDisplay;
    @Styleable(property="-fx-label-padding")
    private ReadOnlyObjectWrapper<Insets> labelPadding;
    @Styleable(property="-fx-graphic-text-gap", initial="4")
    private DoubleProperty graphicTextGap;
    @Styleable(property="-fx-text-fill", initial="black", inherits=true)
    private ObjectProperty<Paint> textFill;
    private BooleanProperty mnemonicParsing;
    private String cachedImageUrl = null;

    public Labeled() {
    }

    public Labeled(String string) {
        this.setText(string);
    }

    public Labeled(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text", "");
        }
        return this.text;
    }

    public final void setText(String string) {
        this.textProperty().setValue(string);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.CENTER_LEFT){

                @Override
                public void set(Pos pos) {
                    super.set(pos);
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new ObjectPropertyBase<TextAlignment>(TextAlignment.LEFT){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new ObjectPropertyBase<OverrunStyle>(OverrunStyle.ELLIPSIS){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_OVERRUN);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textOverrun";
                }
            };
        }
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return this.textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.WRAP_TEXT);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "wrapText";
                }
            };
        }
        return this.wrapText;
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(bl);
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    @Override
    public Orientation getContentBias() {
        return this.isWrapText() ? Orientation.HORIZONTAL : null;
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new ObjectPropertyBase<Font>(Font.getDefault()){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.FONT);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.GRAPHIC);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
        this.cachedImageUrl = null;
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new SimpleBooleanProperty(this, "underline");
        }
        return this.underline;
    }

    public final void setUnderline(boolean bl) {
        this.underlineProperty().setValue(bl);
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new ObjectPropertyBase<ContentDisplay>(ContentDisplay.LEFT){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.CONTENT_DISPLAY);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "contentDisplay";
                }
            };
        }
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return this.contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ReadOnlyObjectProperty<Insets> labelPaddingProperty() {
        return this.labelPaddingPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Insets> labelPaddingPropertyImpl() {
        if (this.labelPadding == null) {
            this.labelPadding = new ReadOnlyObjectWrapper<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                @Override
                public void invalidated() {
                    Insets insets = (Insets)this.get();
                    if (insets == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set labelPadding to null");
                    }
                    this.lastValidValue = insets;
                    Labeled.this.requestLayout();
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.LABEL_PADDING);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "labelPadding";
                }
            };
        }
        return this.labelPadding;
    }

    private void setLabelPadding(Insets insets) {
        this.labelPaddingPropertyImpl().set(insets);
    }

    public final Insets getLabelPadding() {
        return this.labelPadding == null ? Insets.EMPTY : (Insets)this.labelPadding.get();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new DoublePropertyBase(4.0){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.GRAPHIC_TEXT_GAP);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphicTextGap";
                }
            };
        }
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double d) {
        this.graphicTextGapProperty().setValue(d);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGap == null ? 4.0 : this.graphicTextGap.getValue();
    }

    public final void setTextFill(Paint paint) {
        this.textFillProperty().set(paint);
    }

    public final Paint getTextFill() {
        return this.textFill == null ? Color.BLACK : (Paint)this.textFill.get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new ObjectPropertyBase<Paint>((Paint)Color.BLACK){

                @Override
                public void invalidated() {
                    Labeled.this.impl_cssPropertyInvalidated(StyleableProperties.TEXT_FILL);
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textFill";
                }
            };
        }
        return this.textFill;
    }

    public final void setMnemonicParsing(boolean bl) {
        this.mnemonicParsingProperty().set(bl);
    }

    public final boolean isMnemonicParsing() {
        return this.mnemonicParsing == null ? false : this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty(this, "mnemonicParsing");
        }
        return this.mnemonicParsing;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-alignment".equals(string)) {
            this.setAlignment((Pos)((Object)object));
        } else if ("-fx-text-alignment".equals(string)) {
            this.setTextAlignment((TextAlignment)((Object)object));
        } else if ("-fx-text-fill".equals(string)) {
            this.setTextFill((Paint)object);
        } else if ("-fx-text-overrun".equals(string)) {
            this.setTextOverrun((OverrunStyle)((Object)object));
        } else if ("-fx-wrap-text".equals(string)) {
            this.setWrapText((Boolean)object);
        } else if ("-fx-font".equals(string)) {
            this.setFont((Font)object);
        } else if ("-fx-graphic".equals(string)) {
            String string2 = (String)object;
            if (string2 != null && !string2.equals(this.cachedImageUrl)) {
                this.setGraphic(new ImageView(new Image(string2)));
            }
            this.cachedImageUrl = string2;
        } else if ("-fx-underline".equals(string)) {
            this.setUnderline((Boolean)object);
        } else if ("-fx-content-display".equals(string)) {
            this.setContentDisplay((ContentDisplay)((Object)object));
        } else if ("-fx-label-padding".equals(string)) {
            this.setLabelPadding((Insets)object);
        } else if ("-fx-graphic-text-gap".equals(string)) {
            this.setGraphicTextGap((Double)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        if ("-fx-text-alignment".equals(string)) {
            return this.textAlignment == null || !this.textAlignment.isBound();
        }
        if ("-fx-text-fill".equals(string)) {
            return this.textFill == null || !this.textFill.isBound();
        }
        if ("-fx-text-overrun".equals(string)) {
            return this.textOverrun == null || !this.textOverrun.isBound();
        }
        if ("-fx-wrap-text".equals(string)) {
            return this.wrapText == null || !this.wrapText.isBound();
        }
        if ("-fx-font".equals(string)) {
            return this.font == null || !this.font.isBound();
        }
        if ("-fx-graphic".equals(string)) {
            return this.graphic == null || !this.graphic.isBound();
        }
        if ("-fx-content-display".equals(string)) {
            return this.contentDisplay == null || !this.contentDisplay.isBound();
        }
        if ("-fx-label-padding".equals(string)) {
            return this.labelPadding == null || !this.labelPadding.isBound();
        }
        if ("-fx-graphic-text-gap".equals(string)) {
            return this.graphicTextGap == null || !this.graphicTextGap.isBound();
        }
        if ("-fx-underline".equals(string)) {
            return this.underline == null || !this.underline.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty FONT = new StyleableProperty(Labeled.class, "font", StyleableProperty.FONT.getSubProperties());
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(Labeled.class, "alignment");
        private static final StyleableProperty TEXT_ALIGNMENT = new StyleableProperty(Labeled.class, "textAlignment");
        private static final StyleableProperty TEXT_FILL = new StyleableProperty(Labeled.class, "textFill");
        private static final StyleableProperty TEXT_OVERRUN = new StyleableProperty(Labeled.class, "textOverrun");
        private static final StyleableProperty WRAP_TEXT = new StyleableProperty(Labeled.class, "wrapText");
        private static final StyleableProperty GRAPHIC = new StyleableProperty(Labeled.class, "graphic");
        private static final StyleableProperty UNDERLINE = new StyleableProperty(Labeled.class, "underline");
        private static final StyleableProperty CONTENT_DISPLAY = new StyleableProperty(Labeled.class, "contentDisplay");
        private static final StyleableProperty LABEL_PADDING = new StyleableProperty(Labeled.class, "labelPadding");
        private static final StyleableProperty GRAPHIC_TEXT_GAP = new StyleableProperty(Labeled.class, "graphicTextGap");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, ALIGNMENT, TEXT_ALIGNMENT, TEXT_FILL, TEXT_OVERRUN, WRAP_TEXT, GRAPHIC, UNDERLINE, CONTENT_DISPLAY, LABEL_PADDING, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

