/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.scene.control.Cell;

public class IndexedCell<T>
extends Cell<T> {
    private ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper(this, "index", -1){

        @Override
        protected void invalidated() {
            IndexedCell.this.impl_pseudoClassStateChanged(IndexedCell.PSEUDO_CLASS_EVEN);
            IndexedCell.this.impl_pseudoClassStateChanged(IndexedCell.PSEUDO_CLASS_ODD);
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "indexed-cell";
    private static final String PSEUDO_CLASS_EVEN = "even";
    private static final String PSEUDO_CLASS_ODD = "odd";
    private static final long ODD_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("odd");
    private static final long EVEN_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("even");

    public IndexedCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final int getIndex() {
        return this.index.get();
    }

    public final ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    public void updateIndex(int n) {
        this.index.set(n);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getIndex() % 2 == 0 ? EVEN_PSEUDOCLASS_STATE : ODD_PSEUDOCLASS_STATE;
    }
}

