/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.layout.Region;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class PieChart
extends Chart {
    private int defaultColorIndex = 0;
    private static final double LABEL_TICK_GAP = 6.0;
    private static final double LABEL_BALL_RADIUS = 2.0;
    private double centerX;
    private double centerY;
    private double pieRadius;
    private Data begin = null;
    private final Path labelLinePath = new Path();
    private Legend legend = new Legend();
    private final ListChangeListener<Data> dataChangeListener = new ListChangeListener<Data>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public void onChanged(ListChangeListener.Change<? extends Data> change) {
            while (change.next()) {
                for (Data data : change.getRemoved()) {
                    data.setChart(null);
                }
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    void var3_9;
                    ((Data)PieChart.this.getData().get(i)).setChart(PieChart.this);
                    if (PieChart.this.begin == null) {
                        PieChart.this.begin = (Data)PieChart.this.getData().get(i);
                        PieChart.this.begin.next = null;
                        continue;
                    }
                    if (i == 0) {
                        ((Data)PieChart.this.getData().get(0)).next = PieChart.this.begin;
                        PieChart.this.begin = (Data)PieChart.this.getData().get(0);
                        continue;
                    }
                    Data data = PieChart.this.begin;
                    for (int j = 0; j < i - 1; ++j) {
                        Data data2 = ((Data)var3_9).next;
                    }
                    ((Data)PieChart.this.getData().get(i)).next = ((Data)var3_9).next;
                    ((Data)var3_9).next = (Data)PieChart.this.getData().get(i);
                }
                for (Data data : change.getRemoved()) {
                    PieChart.this.dataItemRemoved(data);
                }
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    Data data = (Data)PieChart.this.getData().get(i);
                    PieChart.this.dataItemAdded(i, data);
                }
                if (change.getRemoved().size() <= 0 && change.getFrom() >= change.getTo()) continue;
                PieChart.this.updateLegend();
            }
            PieChart.this.requestChartLayout();
        }
    };
    private ObjectProperty<ObservableList<Data>> data = new ObjectPropertyBase<ObservableList<Data>>(){
        private ObservableList<Data> old;

        @Override
        protected void invalidated() {
            ObservableList observableList = (ObservableList)this.getValue();
            if (this.old != null) {
                this.old.removeListener(PieChart.this.dataChangeListener);
            }
            if (observableList != null) {
                observableList.addListener(PieChart.this.dataChangeListener);
            }
            if (this.old != null || observableList != null) {
                int n;
                final List list = this.old != null ? this.old : Collections.emptyList();
                int n2 = n = observableList != null ? observableList.size() : 0;
                if (n > 0 || !list.isEmpty()) {
                    PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, n, observableList){

                        @Override
                        public List<Data> getRemoved() {
                            return list;
                        }

                        @Override
                        public boolean wasPermutated() {
                            return false;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
            } else if (this.old != null && this.old.size() > 0) {
                PieChart.this.dataChangeListener.onChanged(new NonIterableChange<Data>(0, 0, observableList){

                    @Override
                    public List<Data> getRemoved() {
                        return old;
                    }

                    @Override
                    public boolean wasPermutated() {
                        return false;
                    }

                    @Override
                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
            this.old = observableList;
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "data";
        }
    };
    @Styleable(property="-fx-start-angle", initial="0.0")
    private DoubleProperty startAngle = new DoublePropertyBase(0.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "startAngle";
        }
    };
    @Styleable(property="-fx-clockwise", initial="true")
    private BooleanProperty clockwise = new BooleanPropertyBase(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "clockwise";
        }
    };
    @Styleable(property="-fx-label-line-length", initial="20.0")
    private DoubleProperty labelLineLength = new DoublePropertyBase(20.0){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelLineLength";
        }
    };
    @Styleable(property="-fx-pie-label-visible", initial="true")
    private BooleanProperty labelsVisible = new BooleanPropertyBase(true){

        @Override
        public void invalidated() {
            this.get();
            PieChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return PieChart.this;
        }

        @Override
        public String getName() {
            return "labelsVisible";
        }
    };

    public final ObservableList<Data> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<Data> observableList) {
        this.data.setValue(observableList);
    }

    public final ObjectProperty<ObservableList<Data>> dataProperty() {
        return this.data;
    }

    public final double getStartAngle() {
        return this.startAngle.getValue();
    }

    public final void setStartAngle(double d) {
        this.startAngle.setValue(d);
    }

    public final DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public final void setClockwise(boolean bl) {
        this.clockwise.setValue(bl);
    }

    public final boolean isClockwise() {
        return this.clockwise.getValue();
    }

    public final BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public final double getLabelLineLength() {
        return this.labelLineLength.getValue();
    }

    public final void setLabelLineLength(double d) {
        this.labelLineLength.setValue(d);
    }

    public final DoubleProperty labelLineLengthProperty() {
        return this.labelLineLength;
    }

    public final void setLabelsVisible(boolean bl) {
        this.labelsVisible.setValue(bl);
    }

    public final boolean getLabelsVisible() {
        return this.labelsVisible.getValue();
    }

    public final BooleanProperty labelsVisibleProperty() {
        return this.labelsVisible;
    }

    public PieChart() {
        this(FXCollections.observableArrayList());
    }

    public PieChart(ObservableList<Data> observableList) {
        this.getChartChildren().add(this.labelLinePath);
        this.labelLinePath.getStyleClass().add("chart-pie-label-line");
        this.setLegend(this.legend);
        this.setData(observableList);
    }

    private void dataNameChanged(Data data) {
        this.requestChartLayout();
    }

    private void dataPieValueChanged(Data data) {
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue())), new KeyFrame(Duration.millis(500.0), new KeyValue(data.currentPieValueProperty(), data.getPieValue(), Interpolator.EASE_BOTH)));
        } else {
            data.setCurrentPieValue(data.getPieValue());
        }
    }

    private Node createArcRegion(int n, Data data) {
        Node node = data.getNode();
        if (node == null) {
            node = new Region();
            data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-pie", "data" + n, data.defaultColorStyleString});
        if (data.getPieValue() < 0.0) {
            node.getStyleClass().add("negative");
        }
        return node;
    }

    private Text createPieLabel(int n, Data data) {
        Text text = data.textNode;
        text.setText(data.getName());
        return text;
    }

    private void dataItemAdded(int n, final Data data) {
        data.defaultColorStyleString = "default-color" + this.defaultColorIndex % 8;
        ++this.defaultColorIndex;
        Node node = this.createArcRegion(n, data);
        final Text text = this.createPieLabel(n, data);
        data.getChart().getChartChildren().add(node);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue()), new KeyValue(data.radiusMultiplierProperty(), data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    text.setOpacity(0.0);
                    data.getChart().getChartChildren().add(text);
                    FadeTransition fadeTransition = new FadeTransition(Duration.millis(300.0), text);
                    fadeTransition.setToValue(1.0);
                    fadeTransition.play();
                }
            }, new KeyValue(data.currentPieValueProperty(), data.getPieValue(), Interpolator.EASE_BOTH), new KeyValue(data.radiusMultiplierProperty(), 1, Interpolator.EASE_BOTH)));
        } else {
            this.getChartChildren().add(text);
            data.setRadiusMultiplier(1.0);
            data.setCurrentPieValue(data.getPieValue());
        }
    }

    private void removeDataItemRef(Data data) {
        if (this.begin == data) {
            this.begin = data.next;
        } else {
            Data data2 = this.begin;
            while (data2 != null && data2.next != data) {
                data2 = data2.next;
            }
            if (data2 != null) {
                data2.next = data.next;
            }
        }
    }

    private void dataItemRemoved(final Data data) {
        final Node node = data.getNode();
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentPieValueProperty(), data.getCurrentPieValue()), new KeyValue(data.radiusMultiplierProperty(), data.getRadiusMultiplier())), new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    PieChart.this.getChartChildren().remove(node);
                    FadeTransition fadeTransition = new FadeTransition(Duration.millis(300.0), data.textNode);
                    fadeTransition.setFromValue(1.0);
                    fadeTransition.setToValue(0.0);
                    fadeTransition.setOnFinished(new EventHandler<ActionEvent>(){

                        @Override
                        public void handle(ActionEvent actionEvent) {
                            PieChart.this.getChartChildren().remove(data.textNode);
                        }
                    });
                    fadeTransition.play();
                    PieChart.this.removeDataItemRef(data);
                }
            }, new KeyValue(data.currentPieValueProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(data.radiusMultiplierProperty(), 0)));
        } else {
            this.getChartChildren().remove(data.textNode);
            this.getChartChildren().remove(node);
            this.removeDataItemRef(data);
        }
    }

    @Override
    protected void layoutChartChildren(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        int n;
        this.centerX = d3 / 2.0 + d2;
        this.centerY = d4 / 2.0 + d;
        double d8 = 0.0;
        Data data = this.begin;
        while (data != null) {
            d8 += Math.abs(data.getCurrentPieValue());
            data = data.next;
        }
        double d9 = d8 != 0.0 ? 360.0 / d8 : 0.0;
        this.labelLinePath.getElements().clear();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        ArrayList<LabelLayoutInfo> arrayList = null;
        if (this.getLabelsVisible()) {
            dArray = new double[this.getDataSize()];
            dArray2 = new double[this.getDataSize()];
            dArray3 = new double[this.getDataSize()];
            arrayList = new ArrayList<LabelLayoutInfo>();
            n = 0;
            double d14 = this.getStartAngle();
            Data data2 = this.begin;
            while (data2 != null) {
                double d15 = this.isClockwise() ? -d9 * Math.abs(data2.getCurrentPieValue()) : d9 * Math.abs(data2.getCurrentPieValue());
                dArray3[n] = PieChart.normalizeAngle(d14 + d15 / 2.0);
                boolean bl = !(dArray3[n] > -90.0) || !(dArray3[n] < 90.0);
                d7 = PieChart.calcX(dArray3[n], this.getLabelLineLength(), 0.0);
                d6 = PieChart.calcY(dArray3[n], this.getLabelLineLength(), 0.0);
                dArray[n] = d7;
                dArray2[n] = d6;
                if (d7 > 0.0) {
                    d10 = Math.min(d10, d7 - data2.textNode.getLayoutBounds().getWidth() - 6.0);
                } else {
                    d12 = Math.max(d12, d7 + data2.textNode.getLayoutBounds().getWidth() + 6.0);
                }
                if (d6 > 0.0) {
                    d13 = Math.max(d13, d6 + data2.textNode.getLayoutBounds().getMaxY());
                } else {
                    d11 = Math.min(d11, d6 + data2.textNode.getLayoutBounds().getMinY());
                }
                d14 += d15;
                ++n;
                data2 = data2.next;
            }
            double d16 = Math.max(Math.abs(d10), Math.abs(d12)) * 2.0;
            d5 = Math.max(Math.abs(d11), Math.abs(d13)) * 2.0;
            this.pieRadius = Math.min(d3 - d16, d4 - d5) / 2.0;
        } else {
            this.pieRadius = Math.min(d3, d4) / 2.0;
        }
        if (this.getChartChildren().size() > 0) {
            n = 0;
            Data data3 = this.begin;
            while (data3 != null) {
                data3.textNode.setVisible(this.getLabelsVisible());
                if (this.getLabelsVisible()) {
                    double d17 = this.isClockwise() ? -d9 * Math.abs(data3.getCurrentPieValue()) : d9 * Math.abs(data3.getCurrentPieValue());
                    boolean bl = !(dArray3[n] > -90.0) || !(dArray3[n] < 90.0);
                    d5 = PieChart.calcX(dArray3[n], this.pieRadius, this.centerX);
                    d7 = PieChart.calcY(dArray3[n], this.pieRadius, this.centerY);
                    d6 = bl ? dArray[n] + d5 - data3.textNode.getLayoutBounds().getMaxX() - 6.0 : dArray[n] + d5 - data3.textNode.getLayoutBounds().getMinX() + 6.0;
                    double d18 = dArray2[n] + d7 - data3.textNode.getLayoutBounds().getMinY() / 2.0 - 2.0;
                    double d19 = d5 + dArray[n];
                    double d20 = d7 + dArray2[n];
                    LabelLayoutInfo labelLayoutInfo = new LabelLayoutInfo(d5, d7, d19, d20, d6, d18, data3.textNode, Math.abs(d17));
                    arrayList.add(labelLayoutInfo);
                }
                ++n;
                data3 = data3.next;
            }
            this.resolveCollision(arrayList);
            double d21 = this.getStartAngle();
            Object object = this.begin;
            while (object != null) {
                Node node = ((Data)object).getNode();
                Arc arc = null;
                if (node != null && node instanceof Region) {
                    Region region = (Region)node;
                    if (region.impl_getShape() == null) {
                        arc = new Arc();
                        region.impl_setShape(arc);
                    } else {
                        arc = (Arc)region.impl_getShape();
                    }
                    region.impl_setShape(null);
                    region.impl_setShape(arc);
                    region.impl_setScaleShape(false);
                    region.impl_setPositionShape(false);
                }
                double d22 = this.isClockwise() ? -d9 * Math.abs(((Data)object).getCurrentPieValue()) : d9 * Math.abs(((Data)object).getCurrentPieValue());
                arc.setStartAngle(d21);
                arc.setLength(d22);
                arc.setType(ArcType.ROUND);
                arc.setRadiusX(this.pieRadius * ((Data)object).getRadiusMultiplier());
                arc.setRadiusY(this.pieRadius * ((Data)object).getRadiusMultiplier());
                node.setLayoutX(this.centerX);
                node.setLayoutY(this.centerY);
                d21 += d22;
                object = ((Data)object).next;
            }
            if (arrayList != null) {
                for (LabelLayoutInfo labelLayoutInfo : arrayList) {
                    if (!labelLayoutInfo.text.isVisible()) continue;
                    this.drawLabelLinePath(labelLayoutInfo);
                }
            }
        }
    }

    private void resolveCollision(ArrayList<LabelLayoutInfo> arrayList) {
        int n = this.begin != null ? (int)this.begin.textNode.getLayoutBounds().getHeight() : 0;
        int n2 = 0;
        for (int i = 1; arrayList != null && i < arrayList.size(); ++i) {
            LabelLayoutInfo labelLayoutInfo = arrayList.get(n2);
            LabelLayoutInfo labelLayoutInfo2 = arrayList.get(i);
            if (labelLayoutInfo.text.isVisible() && labelLayoutInfo2.text.isVisible() && (this.fuzzyGT(labelLayoutInfo2.textY, labelLayoutInfo.textY) ? this.fuzzyLT(labelLayoutInfo2.textY - (double)n - labelLayoutInfo.textY, 2.0) : this.fuzzyLT(labelLayoutInfo.textY - (double)n - labelLayoutInfo2.textY, 2.0)) && (this.fuzzyGT(labelLayoutInfo.textX, labelLayoutInfo2.textX) ? this.fuzzyLT(labelLayoutInfo.textX - labelLayoutInfo2.textX, labelLayoutInfo2.text.prefWidth(-1.0)) : this.fuzzyLT(labelLayoutInfo2.textX - labelLayoutInfo.textX, labelLayoutInfo.text.prefWidth(-1.0)))) {
                if (this.fuzzyLT(labelLayoutInfo.size, labelLayoutInfo2.size)) {
                    labelLayoutInfo.text.setVisible(false);
                    n2 = i;
                    continue;
                }
                labelLayoutInfo2.text.setVisible(false);
                continue;
            }
            n2 = i;
        }
    }

    private int fuzzyCompare(double d, double d2) {
        double d3 = 1.0E-5;
        return Math.abs(d - d2) < d3 ? 0 : (d < d2 ? -1 : 1);
    }

    private boolean fuzzyGT(double d, double d2) {
        return this.fuzzyCompare(d, d2) == 1;
    }

    private boolean fuzzyLT(double d, double d2) {
        return this.fuzzyCompare(d, d2) == -1;
    }

    private void drawLabelLinePath(LabelLayoutInfo labelLayoutInfo) {
        labelLayoutInfo.text.setLayoutX(labelLayoutInfo.textX);
        labelLayoutInfo.text.setLayoutY(labelLayoutInfo.textY);
        this.labelLinePath.getElements().add(new MoveTo(labelLayoutInfo.startX, labelLayoutInfo.startY));
        this.labelLinePath.getElements().add(new LineTo(labelLayoutInfo.endX, labelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new MoveTo(labelLayoutInfo.endX - 2.0, labelLayoutInfo.endY));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX, labelLayoutInfo.endY - 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX + 2.0, labelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX, labelLayoutInfo.endY + 2.0, false, true));
        this.labelLinePath.getElements().add(new ArcTo(2.0, 2.0, 90.0, labelLayoutInfo.endX - 2.0, labelLayoutInfo.endY, false, true));
        this.labelLinePath.getElements().add(new ClosePath());
    }

    private void updateLegend() {
        this.legend.setVertical(this.getLegendSide().equals((Object)Side.LEFT) || this.getLegendSide().equals((Object)Side.RIGHT));
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (Data data : this.getData()) {
                Legend.LegendItem legendItem = new Legend.LegendItem(data.getName());
                legendItem.getSymbol().getStyleClass().addAll((Collection<String>)data.getNode().getStyleClass());
                legendItem.getSymbol().getStyleClass().add("pie-legend-symbol");
                this.legend.getItems().add(legendItem);
            }
        }
    }

    private int getDataSize() {
        int n = 0;
        Data data = this.begin;
        while (data != null) {
            ++n;
            data = data.next;
        }
        return n;
    }

    private static double calcX(double d, double d2, double d3) {
        return d3 + d2 * Math.cos(Math.toRadians(-d));
    }

    private static double calcY(double d, double d2, double d3) {
        return d3 + d2 * Math.sin(Math.toRadians(-d));
    }

    private static double normalizeAngle(double d) {
        double d2 = d % 360.0;
        if (d2 <= -180.0) {
            d2 += 360.0;
        }
        if (d2 > 180.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-clockwise".equals(string)) {
            this.setClockwise((Boolean)object);
        } else if ("-fx-pie-label-visible".equals(string)) {
            this.setLabelsVisible((Boolean)object);
        } else if ("-fx-label-line-length".equals(string)) {
            this.setLabelLineLength((Double)object);
        } else if ("-fx-start-angle".equals(string)) {
            this.setStartAngle((Double)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-clockwise".equals(string)) {
            return this.clockwise == null || !this.clockwise.isBound();
        }
        if ("-fx-pie-label-visible".equals(string)) {
            return this.labelsVisible == null || !this.labelsVisible.isBound();
        }
        if ("-fx-label-line-length".equals(string)) {
            return this.labelLineLength == null || !this.labelLineLength.isBound();
        }
        if ("-fx-start-angle".equals(string)) {
            return this.startAngle == null || !this.startAngle.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty CLOCKWISE = new StyleableProperty(PieChart.class, "clockwise");
        private static final StyleableProperty LABELS_VISIBLE = new StyleableProperty(PieChart.class, "labelsVisible");
        private static final StyleableProperty LABEL_LINE_LENGTH = new StyleableProperty(PieChart.class, "labelLineLength");
        private static final StyleableProperty START_ANGLE = new StyleableProperty(PieChart.class, "startAngle");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Chart.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, CLOCKWISE, LABELS_VISIBLE, LABEL_LINE_LENGTH, START_ANGLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }

    public static final class Data {
        private Text textNode = new Text();
        private Data next = null;
        private String defaultColorStyleString;
        private ReadOnlyObjectWrapper<PieChart> chart = new ReadOnlyObjectWrapper(this, "chart");
        private StringProperty name = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                if (Data.this.getChart() != null) {
                    Data.this.getChart().dataNameChanged(Data.this);
                }
            }

            @Override
            public Object getBean() {
                return Data.this;
            }

            @Override
            public String getName() {
                return "name";
            }
        };
        private DoubleProperty pieValue = new DoublePropertyBase(){

            @Override
            protected void invalidated() {
                if (Data.this.getChart() != null) {
                    Data.this.getChart().dataPieValueChanged(Data.this);
                }
            }

            @Override
            public Object getBean() {
                return Data.this;
            }

            @Override
            public String getName() {
                return "pieValue";
            }
        };
        private DoubleProperty currentPieValue = new SimpleDoubleProperty(this, "currentPieValue");
        private DoubleProperty radiusMultiplier = new SimpleDoubleProperty(this, "radiusMultiplier");
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, "node");

        public final PieChart getChart() {
            return (PieChart)this.chart.getValue();
        }

        private void setChart(PieChart pieChart) {
            this.chart.setValue(pieChart);
        }

        public final ReadOnlyObjectProperty<PieChart> chartProperty() {
            return this.chart.getReadOnlyProperty();
        }

        public final void setName(String string) {
            this.name.setValue(string);
        }

        public final String getName() {
            return this.name.getValue();
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final double getPieValue() {
            return this.pieValue.getValue();
        }

        public final void setPieValue(double d) {
            this.pieValue.setValue(d);
        }

        public final DoubleProperty pieValueProperty() {
            return this.pieValue;
        }

        private double getCurrentPieValue() {
            return this.currentPieValue.getValue();
        }

        private void setCurrentPieValue(double d) {
            this.currentPieValue.setValue(d);
        }

        private DoubleProperty currentPieValueProperty() {
            return this.currentPieValue;
        }

        private double getRadiusMultiplier() {
            return this.radiusMultiplier.getValue();
        }

        private void setRadiusMultiplier(double d) {
            this.radiusMultiplier.setValue(d);
        }

        private DoubleProperty radiusMultiplierProperty() {
            return this.radiusMultiplier;
        }

        public Node getNode() {
            return (Node)this.node.getValue();
        }

        private void setNode(Node node) {
            this.node.setValue(node);
        }

        private ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        public Data(String string, double d) {
            this.setName(string);
            this.setPieValue(d);
            this.textNode.getStyleClass().add("chart-pie-label");
        }

        public String toString() {
            return "Data[" + this.getName() + "," + this.getPieValue() + "]";
        }
    }

    static final class LabelLayoutInfo {
        double startX;
        double startY;
        double endX;
        double endY;
        double textX;
        double textY;
        Text text;
        double size;

        public LabelLayoutInfo(double d, double d2, double d3, double d4, double d5, double d6, Text text, double d7) {
            this.startX = d;
            this.startY = d2;
            this.endX = d3;
            this.endY = d4;
            this.textX = d5;
            this.textY = d6;
            this.text = text;
            this.size = d7;
        }
    }
}

