/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.tk.Toolkit;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public abstract class Service<V>
implements Worker<V> {
    private static final PlatformLogger LOG = Toolkit.getToolkit().getLogger(Service.class.getName());
    private static final int THREAD_POOL_SIZE = 32;
    private static final long THREAD_TIME_OUT = 1000L;
    private static final BlockingQueue<Runnable> IO_QUEUE = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("javafx concurrent thread pool");
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof IllegalMonitorStateException)) {
                LOG.warning("Uncaught throwable in " + THREAD_GROUP.getName(), throwable);
            }
        }
    };
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(THREAD_GROUP, runnable);
            thread.setUncaughtExceptionHandler(UNCAUGHT_HANDLER);
            thread.setPriority(1);
            thread.setDaemon(true);
            return thread;
        }
    };
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(2, 32, 1000L, TimeUnit.MILLISECONDS, IO_QUEUE, THREAD_FACTORY, new ThreadPoolExecutor.AbortPolicy());
    private ObjectProperty<Worker.State> status = new SimpleObjectProperty<Worker.State>(this, "state", Worker.State.READY);
    private ObjectProperty<V> value = new SimpleObjectProperty<V>(this, "value");
    private ObjectProperty<Throwable> exception = new SimpleObjectProperty<Throwable>(this, "exception");
    private DoubleProperty workDone = new SimpleDoubleProperty(this, "workDone", -1.0);
    private DoubleProperty totalWorkToBeDone = new SimpleDoubleProperty(this, "totalWork", -1.0);
    private DoubleProperty progress = new SimpleDoubleProperty(this, "progress", -1.0);
    private BooleanProperty running = new SimpleBooleanProperty(this, "running", false);
    private StringProperty message = new SimpleStringProperty(this, "message", "");
    private StringProperty title = new SimpleStringProperty(this, "title", "");
    private ObjectProperty<Executor> executor = new SimpleObjectProperty<Executor>(this, "executor");
    private Task task;

    @Override
    public final Worker.State getState() {
        this.checkThread();
        return (Worker.State)((Object)this.status.get());
    }

    @Override
    public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
        this.checkThread();
        return this.status;
    }

    @Override
    public final V getValue() {
        this.checkThread();
        return (V)this.value.get();
    }

    @Override
    public final ReadOnlyObjectProperty<V> valueProperty() {
        this.checkThread();
        return this.value;
    }

    @Override
    public final Throwable getException() {
        this.checkThread();
        return (Throwable)this.exception.get();
    }

    @Override
    public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        this.checkThread();
        return this.exception;
    }

    @Override
    public final double getWorkDone() {
        this.checkThread();
        return this.workDone.get();
    }

    @Override
    public final ReadOnlyDoubleProperty workDoneProperty() {
        this.checkThread();
        return this.workDone;
    }

    @Override
    public final double getTotalWork() {
        this.checkThread();
        return this.totalWorkToBeDone.get();
    }

    @Override
    public final ReadOnlyDoubleProperty totalWorkProperty() {
        this.checkThread();
        return this.totalWorkToBeDone;
    }

    @Override
    public final double getProgress() {
        this.checkThread();
        return this.progress.get();
    }

    @Override
    public final ReadOnlyDoubleProperty progressProperty() {
        this.checkThread();
        return this.progress;
    }

    @Override
    public final boolean isRunning() {
        this.checkThread();
        return this.running.get();
    }

    @Override
    public final ReadOnlyBooleanProperty runningProperty() {
        this.checkThread();
        return this.running;
    }

    @Override
    public final String getMessage() {
        return (String)this.message.get();
    }

    @Override
    public final ReadOnlyStringProperty messageProperty() {
        return this.message;
    }

    @Override
    public final String getTitle() {
        return (String)this.title.get();
    }

    @Override
    public final ReadOnlyStringProperty titleProperty() {
        return this.title;
    }

    public final void setExecutor(Executor executor) {
        this.checkThread();
        this.executor.set(executor);
    }

    public final Executor getExecutor() {
        this.checkThread();
        return (Executor)this.executor.get();
    }

    public final ObjectProperty<Executor> executorProperty() {
        return this.executor;
    }

    @Override
    public final boolean cancel() {
        this.checkThread();
        if (this.task == null) {
            if (this.status.get() == Worker.State.CANCELLED || this.status.get() == Worker.State.SUCCEEDED) {
                return false;
            }
            this.status.set(Worker.State.CANCELLED);
            return true;
        }
        return this.task.cancel(true);
    }

    public void restart() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.reset();
        this.start();
    }

    public void reset() {
        Worker.State state = this.getState();
        if (state == Worker.State.SCHEDULED || state == Worker.State.RUNNING) {
            throw new IllegalStateException();
        }
        this.task = null;
        this.status.unbind();
        this.status.set(Worker.State.READY);
        this.value.unbind();
        this.value.set(null);
        this.exception.unbind();
        this.exception.set(null);
        this.workDone.unbind();
        this.workDone.set(-1.0);
        this.totalWorkToBeDone.unbind();
        this.totalWorkToBeDone.set(-1.0);
        this.progress.unbind();
        this.progress.set(-1.0);
        this.running.unbind();
        this.running.set(false);
        this.message.unbind();
        this.message.set("");
        this.title.unbind();
        this.title.set("");
    }

    public void start() {
        this.checkThread();
        if (this.getState() != Worker.State.READY) {
            throw new IllegalStateException("Can only start a Service in the READY state. Was in state " + (Object)((Object)this.getState()));
        }
        this.task = this.createTask();
        this.status.bind(this.task.stateProperty());
        this.value.bind(this.task.valueProperty());
        this.exception.bind(this.task.exceptionProperty());
        this.workDone.bind(this.task.workDoneProperty());
        this.totalWorkToBeDone.bind(this.task.totalWorkProperty());
        this.progress.bind(this.task.progressProperty());
        this.running.bind(this.task.runningProperty());
        this.message.bind(this.task.messageProperty());
        this.title.bind(this.task.titleProperty());
        this.task.setStatus(Worker.State.SCHEDULED);
        Executor executor = this.getExecutor();
        if (executor != null) {
            executor.execute(this.task);
        } else {
            this.executeManually();
        }
    }

    void executeManually() {
        EXECUTOR.execute(this.task);
    }

    protected abstract Task createTask();

    void checkThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Service must only be used from the FX Application Thread");
        }
    }

    static {
        EXECUTOR.allowCoreThreadTimeOut(true);
    }
}

