/*
 * Decompiled with CFR 0.152.
 */
package glass.mat;

import com.sun.glass.events.KeyEvent;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import java.util.Map;

public class Main
implements Launchable {
    static boolean reportRunLoop = System.getProperty("main.runLoop", "false").equals("true");
    static boolean reportPaints = System.getProperty("main.paints", "false").equals("true");
    static boolean reportLocks = System.getProperty("main.locks", "false").equals("true");
    static boolean reportViewEvents = System.getProperty("main.locks", "false").equals("true");
    static boolean reportWindowEvents = System.getProperty("main.locks", "false").equals("true");
    static boolean reportHeartBeat = System.getProperty("main.heartbeat", "false").equals("true");
    static boolean reportWaitBeat = System.getProperty("main.waitbeat", "false").equals("true");
    static boolean reportTimer = System.getProperty("main.timer", "false").equals("true");
    static int heartBeatPS = Integer.parseInt(System.getProperty("main.heartbeatps", "5"));
    static int timerPS = Integer.parseInt(System.getProperty("main.timerps", "5"));
    static final String TITLE = "MAT-Main:";
    private Window window;
    private View view;
    private Timer pulseTimer;
    private static Thread eventThread = null;
    private MenuItem action1Menu;
    private MenuItem action2Menu;

    public static void main(String[] args) {
        try {
            Application.Run(args, TITLE, new Main());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void checkThread(boolean on, String where) {
        boolean isOnEventThread = Application.checkEventThread(false, "");
        if (on && !isOnEventThread) {
            System.out.println("Warning: " + where + " not on EventThread!");
        }
        if (!on && isOnEventThread) {
            System.out.println("Warning: " + where + " should not on EventThread!");
        }
    }

    public void finishLaunching(String[] args) {
        System.out.println("In Application finishLaunching");
        System.out.println("number of args: " + args.length);
        for (int i = 0; i < args.length; ++i) {
            System.out.println("args[" + i + "]: " + args[i]);
        }
        System.out.println("com.sun.glass.ui.Platform java.class.path is set to " + System.getProperty("java.class.path"));
        System.out.println("com.sun.glass.ui.Platform java.library.path is set to " + System.getProperty("java.library.path"));
        System.out.println("com.sun.glass.ui.Platform user.dir is set to " + System.getProperty("user.dir"));
        if (reportHeartBeat) {
            System.out.println("Starting Heart Beat with " + heartBeatPS + " per sec");
            new Thread(new HeartBeat()).start();
        }
        if (reportWaitBeat) {
            System.out.println("Starting Wait Beat");
            new Thread(new WaitTest()).start();
        }
        if (reportTimer) {
            this.pulseTimer = Application.GetApplication().createTimer(new TimerBeat());
            this.pulseTimer.start(1000 / timerPS);
        }
        try {
            Application app = Application.GetApplication();
            Application.invokeAndWait(new Runnable(){

                public void run() {
                    System.out.println("Yes, invoke and wait should not block the event thread!");
                    Main.checkThread(true, "initial InvokeAndWait");
                }
            });
            this.view = app.createView(new MainViewPen());
            if (this.view == null) {
                throw new RuntimeException("view should not be null");
            }
            this.view.setEventHandler(new MainViewEventHandler());
            Screen screen = Screen.getMainScreen();
            if (screen == null) {
                throw new RuntimeException("screen should not be null");
            }
            System.out.println("Screen is " + screen);
            int x = (screen.getWidth() - this.view.getWidth()) / 2;
            int y = (screen.getHeight() - this.view.getHeight()) / 2;
            int windowMask = 49;
            this.window = app.createWindow(screen, windowMask);
            if (this.window == null) {
                throw new RuntimeException("window should not be null");
            }
            this.window.setResizable(true);
            this.window.setEventHandler(new MainWindowEventHandler());
            this.window.setBackground(1.0f, 1.0f, 0.0f);
            this.window.setView(this.view);
            this.window.setPosition(x, y);
            this.window.setContentSize(512, 512);
            this.window.setTitle(app.getName());
            this.addMenus(app);
            this.window.setVisible(true);
            Timer fpsPulse = Application.GetApplication().createTimer(new Runnable(){

                public void run() {
                    MainViewEventHandler eh = (MainViewEventHandler)Main.this.view.getEventHandler();
                    eh.handleRunLoop(Main.this.view, 0L);
                }
            });
            fpsPulse.start(33);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void action1() {
        if (this.action2Menu.isChecked()) {
            this.action2Menu.setChecked(false);
            this.action1Menu.setTitle("set bottom menu checked");
        } else {
            this.action2Menu.setChecked(true);
            this.action1Menu.setTitle("set bottom menu unchecked");
        }
    }

    void action2() {
        if (this.action1Menu.isEnabled()) {
            this.action1Menu.setEnabled(false);
            this.action2Menu.setTitle("set top menu enabled");
        } else {
            this.action1Menu.setEnabled(true);
            this.action2Menu.setTitle("set top menu disabled");
        }
    }

    public void addMenus(Application app) {
        Menu myMenu = app.createMenu(this.window.getTitle());
        this.action1Menu = app.createMenuItem("set bottom menu checked", new MenuItem.Callback(){

            public void action() {
                Main.this.action1();
            }
        });
        myMenu.add(this.action1Menu);
        this.action2Menu = app.createMenuItem("set top menu disabled", new MenuItem.Callback(){

            public void action() {
                Main.this.action2();
            }
        });
        myMenu.add(this.action2Menu);
        MenuBar myMenubar = app.createMenuBar();
        app.installDefaultMenus(myMenubar);
        app.installOptionalMenus(myMenubar);
        myMenubar.add(myMenu);
        this.window.setMenuBar(myMenubar);
    }

    public static class TimerBeat
    implements Runnable {
        int iteration = 0;

        public void run() {
            System.out.println("TIMER " + this.iteration);
            Main.checkThread(false, "pen.paint");
            Application.postOnEventQueue(new Runnable(){

                public void run() {
                    System.out.println("  PULSE " + TimerBeat.this.iteration);
                }
            });
            ++this.iteration;
        }
    }

    public static class HeartBeat
    implements Runnable {
        int counter = 1;
        int nextIteration = 1;

        public void run() {
            int hbps = 1000 / heartBeatPS;
            try {
                while (true) {
                    Application.postOnEventQueue(new TestRunnable(this.counter));
                    ++this.counter;
                    Thread.sleep(hbps);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private class TestRunnable
        implements Runnable {
            int iteration;

            TestRunnable(int iteration) {
                this.iteration = iteration;
            }

            public void run() {
                System.out.println("BEAT " + this.iteration);
                Main.checkThread(true, "postOnEventQueue");
                if (this.iteration != HeartBeat.this.nextIteration) {
                    throw new RuntimeException("Dropped runnable " + this.iteration + "!=" + HeartBeat.this.nextIteration);
                }
                ++HeartBeat.this.nextIteration;
            }
        }
    }

    public static class WaitTest
    implements Runnable {
        int counter = 1;
        int nextIteration = 1;

        public void run() {
            int hbps = 1000;
            try {
                while (true) {
                    Application.invokeAndWait(new TestRunnable(this.counter));
                    ++this.counter;
                    Thread.sleep(hbps);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private class TestRunnable
        implements Runnable {
            int iteration;

            TestRunnable(int iteration) {
                this.iteration = iteration;
            }

            public void run() {
                System.out.println("Invoke and Wait BEAT " + this.iteration);
                Main.checkThread(true, "InvokeAndWait");
                if (this.iteration != WaitTest.this.nextIteration) {
                    throw new RuntimeException("Dropped runnable " + this.iteration + "!=" + WaitTest.this.nextIteration);
                }
                ++WaitTest.this.nextIteration;
            }
        }
    }

    public class MainViewEventHandler
    extends View.EventHandler {
        public void handleRunLoop(View view, long time) {
            if (reportRunLoop) {
                System.out.println("MAT-Main:handleRunLoop()");
            }
            Pen pen = view.getPen();
            pen.begin();
            pen.paint(time, view.getWidth(), view.getHeight());
            pen.end();
        }

        public void handleViewEvent(View view, long time, int type) {
            Main.checkThread(true, "view.handleViewEvent");
            if (!reportViewEvents) {
                return;
            }
            switch (type) {
                case 432: {
                    System.out.println("MAT-Main:handleViewEvent(RESIZE)   " + view.getWidth() + "x" + view.getHeight());
                    break;
                }
                case 421: {
                    System.out.println("MAT-Main:handleViewEvent(ADD) ");
                    break;
                }
                case 422: {
                    System.out.println("MAT-Main:handleViewEvent(REMOVE) ");
                    break;
                }
                case 431: {
                    System.out.println("MAT-Main:handleViewEvent(REPAINT) ");
                    break;
                }
                case 411: {
                    if (!reportLocks) break;
                    System.out.println("MAT-Main:handleViewEvent(LOCKED) ");
                    break;
                }
                case 412: {
                    if (!reportLocks) break;
                    System.out.println("MAT-Main:handleViewEvent(UNLOCKED) ");
                    break;
                }
                default: {
                    System.out.println("MAT-Main:handleViewEvent(" + type + ") **UNKNOWN** ");
                }
            }
        }

        public void handleKeyEvent(View view, long time, int action, int keyCode, char[] keyChars, int modifiers) {
            if (!reportViewEvents) {
                return;
            }
            System.out.print("MAT-Main:handleKeyEvent(" + KeyEvent.getTypeString(action) + "," + this.keyCode(keyCode) + ",");
            if (keyChars != null) {
                System.out.print("\"");
                for (int c = 0; c < keyChars.length; ++c) {
                    System.out.print(keyChars[c]);
                }
                System.out.print("\",");
            } else {
                System.out.println("ERROR-NULL,");
            }
            System.out.println(modifiers + ")");
            if (action == 112 && keyChars.length > 0) {
                switch (keyChars[0]) {
                    case 'l': {
                        System.out.println("Location on screen window=" + Main.this.window.getX() + "," + Main.this.window.getY() + " view=" + view.getX() + "," + view.getY());
                        break;
                    }
                    case 's': {
                        System.out.println("Setting Location on screen to " + Main.this.window.getX() + "," + Main.this.window.getY());
                        Main.this.window.setPosition(Main.this.window.getX(), Main.this.window.getY());
                        break;
                    }
                    case 'c': {
                        int newX = (Screen.getMainScreen().getWidth() - view.getWidth()) / 2;
                        int newY = (Screen.getMainScreen().getHeight() - view.getHeight()) / 2;
                        System.out.println("Moving Location on screen to " + newX + "," + newY);
                        Main.this.window.setPosition(newX, newY);
                    }
                }
            }
        }

        public void handleMouseEvent(View view, long time, int type, int button, int x, int y, int xAbs, int yAbs, int clickCount, int modifiers, boolean isPopupTrigger) {
            if (!reportViewEvents) {
                return;
            }
            System.out.println("MAT-Main:handleMouseEvent(" + this.mouseType(type) + "," + this.mouseID(button) + "," + x + "," + y + "," + xAbs + "," + yAbs + "," + clickCount + "," + modifiers + "," + isPopupTrigger + ")");
        }

        String keyCode(int keycode) {
            switch (keycode) {
                case 48: {
                    return "VK_0";
                }
                case 49: {
                    return "VK_1";
                }
                case 50: {
                    return "VK_2";
                }
                case 51: {
                    return "VK_3";
                }
                case 52: {
                    return "VK_4";
                }
                case 53: {
                    return "VK_5";
                }
                case 54: {
                    return "VK_6";
                }
                case 55: {
                    return "VK_7";
                }
                case 56: {
                    return "VK_8";
                }
                case 57: {
                    return "VK_9";
                }
                case 65: {
                    return "VK_A";
                }
                case 107: {
                    return "VK_ADD";
                }
                case 150: {
                    return "VK_AMPERSAND";
                }
                case 151: {
                    return "VK_ASTERISK";
                }
                case 512: {
                    return "VK_AT";
                }
                case 66: {
                    return "VK_B";
                }
                case 8: {
                    return "VK_BACKSPACE";
                }
                case 192: {
                    return "VK_BACK_QUOTE";
                }
                case 92: {
                    return "VK_BACK_SLASH";
                }
                case 161: {
                    return "VK_BRACELEFT";
                }
                case 162: {
                    return "VK_BRACERIGHT";
                }
                case 67: {
                    return "VK_C";
                }
                case 20: {
                    return "VK_CAPS_LOCK";
                }
                case 514: {
                    return "VK_CIRCUMFLEX";
                }
                case 12: {
                    return "VK_CLEAR";
                }
                case 93: {
                    return "VK_CLOSE_BRACKET";
                }
                case 513: {
                    return "VK_COLON";
                }
                case 44: {
                    return "VK_COMMA";
                }
                case 68: {
                    return "VK_D";
                }
                case 110: {
                    return "VK_DECIMAL";
                }
                case 127: {
                    return "VK_DELETE";
                }
                case 111: {
                    return "VK_DIVIDE";
                }
                case 515: {
                    return "VK_DOLLAR";
                }
                case 152: {
                    return "VK_DOUBLE_QUOTE";
                }
                case 40: {
                    return "VK_DOWN";
                }
                case 69: {
                    return "VK_E";
                }
                case 35: {
                    return "VK_END";
                }
                case 10: {
                    return "VK_ENTER";
                }
                case 61: {
                    return "VK_EQUALS";
                }
                case 27: {
                    return "VK_ESCAPE";
                }
                case 516: {
                    return "VK_EURO_SIGN";
                }
                case 517: {
                    return "VK_EXCLAMATION";
                }
                case 70: {
                    return "VK_F";
                }
                case 112: {
                    return "VK_F1";
                }
                case 121: {
                    return "VK_F10";
                }
                case 122: {
                    return "VK_F11";
                }
                case 123: {
                    return "VK_F12";
                }
                case 113: {
                    return "VK_F2";
                }
                case 114: {
                    return "VK_F3";
                }
                case 115: {
                    return "VK_F4";
                }
                case 116: {
                    return "VK_F5";
                }
                case 117: {
                    return "VK_F6";
                }
                case 118: {
                    return "VK_F7";
                }
                case 119: {
                    return "VK_F8";
                }
                case 120: {
                    return "VK_F9";
                }
                case 71: {
                    return "VK_G";
                }
                case 160: {
                    return "VK_GREATER";
                }
                case 72: {
                    return "VK_H";
                }
                case 156: {
                    return "VK_HELP";
                }
                case 36: {
                    return "VK_HOME";
                }
                case 73: {
                    return "VK_I";
                }
                case 155: {
                    return "VK_INSERT";
                }
                case 518: {
                    return "VK_INV_EXCLAMATION";
                }
                case 74: {
                    return "VK_J";
                }
                case 75: {
                    return "VK_K";
                }
                case 76: {
                    return "VK_L";
                }
                case 37: {
                    return "VK_LEFT";
                }
                case 519: {
                    return "VK_LEFT_PARENTHESIS";
                }
                case 153: {
                    return "VK_LESS";
                }
                case 77: {
                    return "VK_M";
                }
                case 45: {
                    return "VK_MINUS";
                }
                case 106: {
                    return "VK_MULTIPLY";
                }
                case 78: {
                    return "VK_N";
                }
                case 520: {
                    return "VK_NUMBER_SIGN";
                }
                case 96: {
                    return "VK_NUMPAD0";
                }
                case 97: {
                    return "VK_NUMPAD1";
                }
                case 98: {
                    return "VK_NUMPAD2";
                }
                case 99: {
                    return "VK_NUMPAD3";
                }
                case 100: {
                    return "VK_NUMPAD4";
                }
                case 101: {
                    return "VK_NUMPAD5";
                }
                case 102: {
                    return "VK_NUMPAD6";
                }
                case 103: {
                    return "VK_NUMPAD7";
                }
                case 104: {
                    return "VK_NUMPAD8";
                }
                case 105: {
                    return "VK_NUMPAD9";
                }
                case 144: {
                    return "VK_NUM_LOCK";
                }
                case 79: {
                    return "VK_O";
                }
                case 91: {
                    return "VK_OPEN_BRACKET";
                }
                case 80: {
                    return "VK_P";
                }
                case 34: {
                    return "VK_PAGE_DOWN";
                }
                case 33: {
                    return "VK_PAGE_UP";
                }
                case 19: {
                    return "VK_PAUSE";
                }
                case 46: {
                    return "VK_PERIOD";
                }
                case 521: {
                    return "VK_PLUS";
                }
                case 154: {
                    return "VK_PRINTSCREEN";
                }
                case 81: {
                    return "VK_Q";
                }
                case 222: {
                    return "VK_QUOTE";
                }
                case 82: {
                    return "VK_R";
                }
                case 39: {
                    return "VK_RIGHT";
                }
                case 522: {
                    return "VK_RIGHT_PARENTHESIS";
                }
                case 83: {
                    return "VK_S";
                }
                case 145: {
                    return "VK_SCROLL_LOCK";
                }
                case 59: {
                    return "VK_SEMICOLON";
                }
                case 108: {
                    return "VK_SEPARATOR";
                }
                case 47: {
                    return "VK_SLASH";
                }
                case 32: {
                    return "VK_SPACE";
                }
                case 109: {
                    return "VK_SUBTRACT";
                }
                case 84: {
                    return "VK_T";
                }
                case 9: {
                    return "VK_TAB";
                }
                case 85: {
                    return "VK_U";
                }
                case 0: {
                    return "VK_UNDEFINED";
                }
                case 523: {
                    return "VK_UNDERSCORE";
                }
                case 38: {
                    return "VK_UP";
                }
                case 86: {
                    return "VK_V";
                }
                case 87: {
                    return "VK_W";
                }
                case 88: {
                    return "VK_X";
                }
                case 89: {
                    return "VK_Y";
                }
                case 90: {
                    return "VK_Z";
                }
            }
            return "(" + keycode + ")";
        }

        String mouseType(int type) {
            switch (type) {
                case 221: {
                    return "DOWN";
                }
                case 222: {
                    return "UP";
                }
                case 223: {
                    return "DRAG";
                }
                case 225: {
                    return "ENTER";
                }
                case 226: {
                    return "EXIT";
                }
                case 227: {
                    return "CLICK";
                }
                case 224: {
                    return "MOVE";
                }
            }
            return "unknown! (" + type + ")";
        }

        String mouseID(int button) {
            switch (button) {
                case 211: {
                    return "NONE";
                }
                case 212: {
                    return "LEFT";
                }
                case 213: {
                    return "RIGHT";
                }
                case 214: {
                    return "OTHER";
                }
            }
            return "unknown! (" + button + ")";
        }
    }

    public class MainWindowEventHandler
    extends Window.EventHandler {
        public void handleWindowEvent(Window window, long time, int type) {
            if (!reportWindowEvents) {
                return;
            }
            switch (type) {
                case 521: {
                    System.out.println("MAT-Main:handleWindowEvent(CLOSE) ");
                    System.out.println("Calling Window.close()");
                    window.close();
                    break;
                }
                case 522: {
                    System.out.println("MAT-Main:handleWindowEvent(DESTROY) ");
                    break;
                }
                case 545: {
                    System.out.println("MAT-Main:handleWindowEvent(FOCUS_DISABLED)");
                    break;
                }
                case 542: {
                    System.out.println("MAT-Main:handleWindowEvent(FOCUS_GAINED)");
                    break;
                }
                case 541: {
                    System.out.println("MAT-Main:handleWindowEvent(FOCUS_LOST)");
                    break;
                }
                case 532: {
                    System.out.println("MAT-Main:handleWindowEvent(MAXIMIZE)");
                    break;
                }
                case 531: {
                    System.out.println("MAT-Main:handleWindowEvent(MINIMIZE)");
                    break;
                }
                case 512: {
                    System.out.println("MAT-Main:handleWindowEvent(MOVE) " + window.getX() + "," + window.getY());
                    break;
                }
                case 511: {
                    System.out.println("MAT-Main:handleWindowEvent(RESIZE) " + window.getWidth() + "X" + window.getHeight());
                    break;
                }
                case 533: {
                    System.out.println("MAT-Main:handleWindowEvent(RESTORE)");
                }
            }
        }
    }

    class MainViewPen
    extends Pen {
        MainViewPen() {
        }

        public Map getCapabilities() {
            return this.addCapability(null, View.Capability.k3dKey, Boolean.FALSE);
        }

        public void paint(long time, int width, int height) {
            if (reportPaints) {
                System.out.println("MAT-Main:MainViewPen.paint()");
            }
            Main.checkThread(false, "pen.paint");
        }
    }
}

