/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.network;

import com.sun.webpane.webkit.network.ByteBufferAllocator;
import com.sun.webpane.webkit.network.ByteBufferPool;
import com.sun.webpane.webkit.network.DirectoryURLConnection;
import com.sun.webpane.webkit.network.FormDataElement;
import com.sun.webpane.webkit.network.NetworkContext;
import com.sun.webpane.webkit.network.URLConsumer;
import com.sun.webpane.webkit.network.URLs;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;
import sun.net.ConnectionResetException;

public class URLFetcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(URLFetcher.class.getName());
    private static final int MAX_REDIRECTS = 10;
    private static final int MAX_BUF_COUNT = 3;
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private String url;
    private final long privateData;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final URLConsumer callbacks;
    private volatile boolean canceled = false;
    private final NetworkContext context;
    private final ByteBufferPool byteBufferPool;
    private int redirectCount = 0;
    private final boolean isSynchronous;
    private InputStream is = null;
    private final ByteBuffer dBuff;
    private URLConnection connection;

    URLFetcher(NetworkContext networkContext, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l, URLConsumer uRLConsumer, ByteBufferPool byteBufferPool) {
        this.url = string;
        this.privateData = l;
        this.method = string2;
        this.headers = string3;
        this.formDataElements = formDataElementArray;
        this.callbacks = uRLConsumer;
        this.context = networkContext;
        this.byteBufferPool = byteBufferPool;
        this.isSynchronous = false;
        this.dBuff = null;
    }

    public URLFetcher(NetworkContext networkContext, String string, String string2) {
        this.url = string;
        this.privateData = 0L;
        this.headers = string2;
        this.callbacks = null;
        this.context = networkContext;
        this.byteBufferPool = null;
        this.isSynchronous = true;
        try {
            this.connection = URLs.newURL(string).openConnection();
        }
        catch (Exception exception) {
            this.canceled = true;
            this.dBuff = null;
            return;
        }
        this.dBuff = ByteBuffer.allocateDirect(8192);
    }

    public ByteBuffer getDirectBuffer() {
        return this.dBuff;
    }

    long getPrivateData() {
        return this.privateData;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        logger.log(Level.FINEST, "Cancel job: " + this.url);
        this.canceled = true;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                URLFetcher.this.doRun();
                return null;
            }
        }, this.context.getPage().getAccessControlContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        Throwable throwable = null;
        int n = 0;
        try {
            while (true) {
                int n2;
                String string = this.url;
                if (this.url.startsWith("file:") && (n2 = this.url.indexOf(63)) != -1) {
                    string = this.url.substring(0, n2);
                }
                URLConnection uRLConnection = URLs.newURL(string).openConnection();
                this.prepareConnection(uRLConnection);
                String string2 = null;
                try {
                    this.sendRequest(uRLConnection);
                    string2 = this.receiveResponse(uRLConnection);
                }
                finally {
                    URLFetcher.close(uRLConnection);
                }
                if (string2 != null) {
                    if (this.redirectCount++ >= 10) {
                        throw new TooManyRedirectsException();
                    }
                    this.url = string2;
                    if (this.method.equals(GET) || this.method.equals(HEAD)) continue;
                    this.method = GET;
                    this.formDataElements = null;
                    continue;
                }
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throwable = malformedURLException;
            n = 2;
        }
        catch (AccessControlException accessControlException) {
            throwable = accessControlException;
            n = 8;
        }
        catch (UnknownHostException unknownHostException) {
            throwable = unknownHostException;
            n = 1;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            throwable = noRouteToHostException;
            n = 6;
        }
        catch (ConnectException connectException) {
            throwable = connectException;
            n = 4;
        }
        catch (ConnectionResetException connectionResetException) {
            throwable = connectionResetException;
            n = 5;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            throwable = sSLHandshakeException;
            n = 3;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throwable = socketTimeoutException;
            n = 7;
        }
        catch (InvalidResponseException invalidResponseException) {
            throwable = invalidResponseException;
            n = 9;
        }
        catch (TooManyRedirectsException tooManyRedirectsException) {
            throwable = tooManyRedirectsException;
            n = 10;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n = 99;
        }
        if (throwable != null) {
            if (n == 99) {
                logger.log(Level.WARNING, "Unexpected error", throwable);
            } else {
                logger.log(Level.FINEST, null, throwable);
            }
            this.callbacks.error(this.url, n, throwable.getMessage(), this);
        }
    }

    private void prepareConnection(URLConnection uRLConnection) throws IOException {
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(3600000);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Accept-Language", "en-us,en;q=0.5");
        uRLConnection.setRequestProperty("Accept-Encoding", "gzip");
        uRLConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        if (this.headers != null && this.headers.length() > 0) {
            for (String string : this.headers.split("\n")) {
                int n = string.indexOf(58);
                if (n <= 0) continue;
                uRLConnection.addRequestProperty(string.substring(0, n), string.substring(n + 2));
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setRequestMethod(this.method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(URLConnection uRLConnection) throws IOException {
        OutputStream outputStream = null;
        try {
            long l = 0L;
            if (this.formDataElements != null && uRLConnection instanceof HttpURLConnection) {
                uRLConnection.setDoOutput(true);
                for (FormDataElement formDataElement : this.formDataElements) {
                    formDataElement.open();
                    l += formDataElement.getSize();
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                if (l <= Integer.MAX_VALUE) {
                    httpURLConnection.setFixedLengthStreamingMode((int)l);
                } else {
                    httpURLConnection.setChunkedStreamingMode(0);
                }
            }
            int n = this.method.equals(GET) || this.method.equals(HEAD) ? 3 : 1;
            uRLConnection.setConnectTimeout(uRLConnection.getConnectTimeout() / n);
            int n2 = 0;
            while (!this.canceled) {
                try {
                    uRLConnection.connect();
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (++n2 < n) continue;
                    throw socketTimeoutException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new MalformedURLException(this.url);
                }
            }
            if (this.formDataElements != null && uRLConnection instanceof HttpURLConnection) {
                outputStream = uRLConnection.getOutputStream();
                byte[] byArray = new byte[4096];
                long l2 = 0L;
                for (FormDataElement formDataElement : this.formDataElements) {
                    int n3;
                    InputStream inputStream = formDataElement.getInputStream();
                    while ((n3 = inputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n3);
                        this.callbacks.didSendData(l2 += (long)n3, l, this);
                    }
                    formDataElement.close();
                }
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.formDataElements != null && uRLConnection instanceof HttpURLConnection) {
                for (FormDataElement formDataElement : this.formDataElements) {
                    try {
                        formDataElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String receiveResponse(URLConnection uRLConnection) throws IOException, InterruptedException {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (this.canceled) {
            return null;
        }
        InputStream inputStream = null;
        if (uRLConnection instanceof HttpURLConnection) {
            object3 = (HttpURLConnection)uRLConnection;
            n = ((HttpURLConnection)object3).getResponseCode();
            if (n == -1) {
                throw new InvalidResponseException();
            }
            if (this.canceled) {
                return null;
            }
            if (n == 304) {
                this.callbacks.writeHeaders(this.url, uRLConnection, this);
                this.callbacks.endOfContent(this);
                return null;
            }
            if (n >= 300 && n < 306 || n == 307) {
                URL uRL;
                String string = ((URLConnection)object3).getHeaderField("Location");
                if (string == null) {
                    throw new InvalidResponseException();
                }
                try {
                    uRL = URLs.newURL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = URLs.newURL(uRLConnection.getURL(), string);
                }
                return uRL.toExternalForm();
            }
            if (n >= 400 && !this.method.equals(HEAD)) {
                inputStream = ((HttpURLConnection)object3).getErrorStream();
            }
        }
        if (this.url.startsWith("ftp:") || this.url.startsWith("ftps:")) {
            boolean bl = false;
            n = 0;
            object2 = uRLConnection.getURL().getPath();
            if (object2 == null || ((String)object2).isEmpty() || ((String)object2).endsWith("/") || ((String)object2).contains(";type=d")) {
                bl = true;
            } else {
                object = uRLConnection.getContentType();
                if ("text/plain".equalsIgnoreCase((String)object) || "text/html".equalsIgnoreCase((String)object)) {
                    bl = true;
                    n = 1;
                }
            }
            if (bl) {
                uRLConnection = new DirectoryURLConnection(uRLConnection, n != 0);
            }
        }
        if (this.url.startsWith("file:") && "text/plain".equals(uRLConnection.getContentType()) && uRLConnection.getHeaderField("content-length") == null) {
            uRLConnection = new DirectoryURLConnection(uRLConnection);
        }
        this.callbacks.writeHeaders(this.url, uRLConnection, this);
        if (this.method.equals(HEAD)) {
            this.callbacks.endOfContent(this);
            return null;
        }
        object3 = null;
        ByteBufferAllocator byteBufferAllocator = this.byteBufferPool.newAllocator(3);
        object2 = null;
        try {
            object = new byte[8192];
            int n2 = 0;
            while (true) {
                block35: {
                    try {
                        n2 = 0;
                        if (object3 == null) {
                            object3 = inputStream != null ? inputStream : uRLConnection.getInputStream();
                            String string = uRLConnection.getContentEncoding();
                            if (string != null) {
                                if ("gzip".equalsIgnoreCase(string)) {
                                    object3 = new GZIPInputStream((InputStream)object3);
                                }
                                if ("deflate".equalsIgnoreCase(string)) {
                                    object3 = new InflaterInputStream((InputStream)object3);
                                }
                            }
                        }
                        n2 = ((InputStream)object3).read((byte[])object);
                    }
                    catch (EOFException eOFException) {
                        n2 = 0;
                        break block35;
                    }
                    if (!this.canceled && n2 == 0) continue;
                }
                if (!this.canceled && n2 > 0 && this.callbacks != null) {
                    if (null == object2) {
                        object2 = byteBufferAllocator.allocate();
                    }
                    if (((Buffer)object2).remaining() > n2) {
                        ((ByteBuffer)object2).put((byte[])object, 0, n2);
                    } else {
                        int n3 = ((Buffer)object2).remaining();
                        int n4 = n2 - n3;
                        ((ByteBuffer)object2).put((byte[])object, 0, n3);
                        ((ByteBuffer)object2).flip();
                        this.callbacks.writeContent((ByteBuffer)object2, byteBufferAllocator, this);
                        object2 = null;
                        if (n4 > 0) {
                            object2 = byteBufferAllocator.allocate();
                            ((ByteBuffer)object2).put((byte[])object, n3, n4);
                        }
                    }
                }
                if (n2 <= 0 || this.canceled) break;
            }
            if (!this.canceled) {
                if (object2 != null && ((Buffer)object2).position() > 0) {
                    ((ByteBuffer)object2).flip();
                    this.callbacks.writeContent((ByteBuffer)object2, byteBufferAllocator, this);
                    object2 = null;
                }
                this.callbacks.endOfContent(this);
            }
        }
        finally {
            if (object2 != null) {
                byteBufferAllocator.release((ByteBuffer)object2);
            }
        }
        return null;
    }

    private static void close(URLConnection uRLConnection) {
        InputStream inputStream;
        if (uRLConnection instanceof HttpURLConnection && (inputStream = ((HttpURLConnection)uRLConnection).getErrorStream()) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            uRLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int connectSynchronous() {
        if (!this.isSynchronous || this.dBuff == null) {
            return -1;
        }
        if (this.is == null) {
            if (this.headers != null && this.headers.length() > 0) {
                String[] stringArray;
                for (String string : stringArray = this.headers.split("\n")) {
                    int n = string.indexOf(58);
                    if (n <= 0) continue;
                    this.connection.addRequestProperty(string.substring(0, n), string.substring(n + 2));
                }
            }
            try {
                this.is = this.connection.getInputStream();
                if (this.connection instanceof HttpURLConnection) {
                    return ((HttpURLConnection)this.connection).getResponseCode();
                }
                return 200;
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return -1;
    }

    public int readSynchronous() {
        this.dBuff.rewind();
        if (!this.isSynchronous || this.dBuff == null || this.is == null) {
            return -1;
        }
        int n = 0;
        byte[] byArray = new byte[this.dBuff.capacity()];
        try {
            n = this.is.read(byArray);
        }
        catch (IOException iOException) {
            return -1;
        }
        if (n > 0) {
            this.dBuff.put(byArray, 0, n);
        }
        if (n == -1) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private static class TooManyRedirectsException
    extends IOException {
        private TooManyRedirectsException() {
            super("Too many redirects");
        }
    }

    private static class InvalidResponseException
    extends IOException {
        private InvalidResponseException() {
            super("Invalid server response");
        }
    }
}

