/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSPrimitiveValueImpl;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

public class RectImpl
implements Rect {
    protected final long peer;
    protected final long contextPeer;

    protected long getPeer() {
        return this.peer;
    }

    static Rect getImpl(long peer, long contextPeer) {
        return new RectImpl(peer, contextPeer);
    }

    RectImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof RectImpl) {
            return this.peer == ((RectImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    @Override
    public CSSPrimitiveValue getTop() {
        long p = RectImpl.getTopImpl(this.getPeer());
        return p == 0L ? null : CSSPrimitiveValueImpl.getImpl(p, this.contextPeer);
    }

    static native long getTopImpl(long var0);

    @Override
    public CSSPrimitiveValue getRight() {
        long p = RectImpl.getRightImpl(this.getPeer());
        return p == 0L ? null : CSSPrimitiveValueImpl.getImpl(p, this.contextPeer);
    }

    static native long getRightImpl(long var0);

    @Override
    public CSSPrimitiveValue getBottom() {
        long p = RectImpl.getBottomImpl(this.getPeer());
        return p == 0L ? null : CSSPrimitiveValueImpl.getImpl(p, this.contextPeer);
    }

    static native long getBottomImpl(long var0);

    @Override
    public CSSPrimitiveValue getLeft() {
        long p = RectImpl.getLeftImpl(this.getPeer());
        return p == 0L ? null : CSSPrimitiveValueImpl.getImpl(p, this.contextPeer);
    }

    static native long getLeftImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            RectImpl.dispose(this.peer);
        }
    }
}

