/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit;

import java.text.BreakIterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCTextBoundaries {
    private static final Logger log = Logger.getLogger(WCTextBoundaries.class.getName());
    private static BreakIterator breakIterator = BreakIterator.getWordInstance(Locale.getDefault());

    private WCTextBoundaries() {
    }

    public static void findWordBoundary(String string, int n, int[] nArray) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "findWordBoundary({0}, {1}))", new Object[]{string, n});
        }
        breakIterator.setText(string);
        int n2 = string.length();
        nArray[0] = n > 0 ? breakIterator.preceding(n) : 0;
        int n3 = nArray[1] = n == n2 ? n2 : breakIterator.next();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "findWordBoundary = [{0}, {1}])", new Object[]{nArray[0], nArray[1]});
        }
    }

    public static int findNextWordFromIndex(String string, int n, boolean bl) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "findNextWordFromIndex({0}, {1}, {2}))", new Object[]{string, n, bl});
        }
        breakIterator.setText(string);
        if (bl) {
            breakIterator.following(n);
        } else {
            breakIterator.preceding(n);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "findNextWordFromIndex = {0}", new Object[]{breakIterator.current()});
        }
        return breakIterator.current();
    }
}

