/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.theme;

import com.sun.javafx.scene.control.skin.ScrollBarSkin;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.ScrollBarTheme;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.sg.Accessor;
import com.sun.webpane.sg.theme.RenderThemeImpl;
import com.sun.webpane.sg.theme.Renderer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;

public class ScrollBarThemeImpl
extends ScrollBarTheme {
    private static final Logger log = Logger.getLogger(ScrollBarThemeImpl.class.getName());
    private WeakReference<ScrollBar> testSBRef = new WeakReference<Object>(null);
    private boolean thicknessInitialized = false;
    private Accessor accessor;
    private RenderThemeImpl.Pool<ScrollBarWidget> pool;

    public ScrollBarThemeImpl(final Accessor accessor) {
        this.accessor = accessor;
        this.pool = new RenderThemeImpl.Pool<ScrollBarWidget>(new RenderThemeImpl.Pool.Notifier<ScrollBarWidget>(){

            @Override
            public void notifyRemoved(ScrollBarWidget scrollBarWidget) {
                accessor.removeChild(scrollBarWidget);
            }
        }, ScrollBarWidget.class);
        accessor.addViewListener(new RenderThemeImpl.ViewListener(this.pool, accessor){

            @Override
            public void invalidated(Observable observable) {
                super.invalidated(observable);
                ScrollBarWidget scrollBarWidget = new ScrollBarWidget();
                this.accessor.addChild(scrollBarWidget);
                ScrollBarThemeImpl.this.testSBRef = new WeakReference<ScrollBarWidget>(scrollBarWidget);
            }
        });
    }

    private static Orientation convertOrientation(int n) {
        return n == 1 ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    public void adjustScrollBar(ScrollBar scrollBar, int n, int n2, int n3) {
        this.adjustScrollBar(scrollBar, n, n2, n3, 1, 1, 1);
    }

    public void adjustScrollBar(ScrollBar scrollBar, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 <= n5) {
            return;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n6 - n5) {
            n4 = n6 - n5;
        }
        Orientation orientation = ScrollBarThemeImpl.convertOrientation(n3);
        int n7 = ScrollBarTheme.getThickness();
        if (scrollBar.getOrientation() != orientation) {
            scrollBar.setOrientation(orientation);
        }
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            if (scrollBar.getWidth() != (double)n7 || scrollBar.getHeight() != (double)n2) {
                scrollBar.resize(n7, n2);
            }
        } else if (scrollBar.getWidth() != (double)n || scrollBar.getHeight() != (double)n7) {
            scrollBar.resize(n, n7);
        }
        if (scrollBar.getMax() != (double)n6 || scrollBar.getVisibleAmount() != (double)n5) {
            scrollBar.setValue(0.0);
            scrollBar.setMax(n6);
            scrollBar.setVisibleAmount(n5);
        }
        if (n6 > n5) {
            float f = (float)n6 / (float)(n6 - n5);
            if (scrollBar.getValue() != (double)((float)n4 * f)) {
                scrollBar.setValue((float)n4 * f);
            }
        }
    }

    @Override
    public Ref createWidget(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        ScrollBarWidget scrollBarWidget = this.pool.get(l);
        if (scrollBarWidget == null) {
            scrollBarWidget = new ScrollBarWidget();
            this.pool.put(l, scrollBarWidget);
            this.accessor.addChild(scrollBarWidget);
        }
        this.adjustScrollBar(scrollBarWidget, n, n2, n3, n4, n5, n6);
        return new ScrollBarRef(scrollBarWidget);
    }

    @Override
    public void paint(WCGraphicsContext wCGraphicsContext, Ref ref, int n, int n2, int n3, int n4) {
        ScrollBar scrollBar = (ScrollBar)((ScrollBarRef)ref).asControl();
        if (scrollBar == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}, {1} {2}x{3}], {4}", new Object[]{n, n2, scrollBar.getWidth(), scrollBar.getHeight(), scrollBar.getOrientation() == Orientation.VERTICAL ? "VERTICAL" : "HORIZONTAL"});
        }
        wCGraphicsContext.saveState();
        wCGraphicsContext.translate(n, n2);
        Renderer.getRenderer().render(scrollBar, wCGraphicsContext);
        wCGraphicsContext.restoreState();
    }

    @Override
    public int hitTest(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        ScrollBar scrollBar;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}, {1} {2}x{3}], {4}", new Object[]{n7, n8, n, n2, n3 == 1 ? "VERTICAL" : "HORIZONTAL"});
        }
        if ((scrollBar = (ScrollBar)this.testSBRef.get()) == null) {
            return 0;
        }
        Node node = ScrollBarThemeImpl.getThumb(scrollBar);
        Node node2 = ScrollBarThemeImpl.getTrack(scrollBar);
        Node node3 = ScrollBarThemeImpl.getDecButton(scrollBar);
        Node node4 = ScrollBarThemeImpl.getIncButton(scrollBar);
        this.adjustScrollBar(scrollBar, n, n2, n3, n4, n5, n6);
        if (n3 == 1) {
            n13 = n14 = n7;
            n12 = n14;
            n11 = n8 - (int)node3.getLayoutBounds().getHeight();
            n10 = n11 - (int)node.getTranslateY();
            n9 = n11 - (int)node2.getLayoutBounds().getHeight();
        } else {
            n9 = n10 = n8;
            n11 = n10;
            n12 = n7 - (int)node3.getLayoutBounds().getWidth();
            n14 = n12 - (int)node.getTranslateX();
            n13 = n12 - (int)node2.getLayoutBounds().getWidth();
        }
        if (node.contains(n14, n10)) {
            log.finer("thumb");
            return 8;
        }
        if (node2.contains(n12, n11)) {
            if (n3 == 1 && node.getTranslateY() >= (double)n11 || n3 == 0 && node.getTranslateX() >= (double)n12) {
                log.finer("back track");
                return 4;
            }
            if (n3 == 1 && node.getTranslateY() < (double)n11 || n3 == 0 && node.getTranslateX() < (double)n12) {
                log.finer("forward track");
                return 16;
            }
        } else {
            if (node3.contains(n7, n8)) {
                log.finer("back button");
                return 1;
            }
            if (node4.contains(n13, n9)) {
                log.finer("forward button");
                return 2;
            }
        }
        log.finer("no part");
        return 0;
    }

    @Override
    public int getThumbLength(int n, int n2, int n3, int n4, int n5, int n6) {
        ScrollBar scrollBar = (ScrollBar)this.testSBRef.get();
        if (scrollBar == null) {
            return 0;
        }
        Node node = ScrollBarThemeImpl.getThumb(scrollBar);
        this.adjustScrollBar(scrollBar, n, n2, n3, n4, n5, n6);
        double d = 0.0;
        d = n3 == 1 ? node.getLayoutBounds().getHeight() : node.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "thumb length: {0}", d);
        return (int)d;
    }

    @Override
    public int getTrackPosition(int n, int n2, int n3) {
        ScrollBar scrollBar = (ScrollBar)this.testSBRef.get();
        if (scrollBar == null) {
            return 0;
        }
        Node node = ScrollBarThemeImpl.getDecButton(scrollBar);
        this.adjustScrollBar(scrollBar, n, n2, n3);
        double d = 0.0;
        d = n3 == 1 ? node.getLayoutBounds().getHeight() : node.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "track position: {0}", d);
        return (int)d;
    }

    @Override
    public int getTrackLength(int n, int n2, int n3) {
        ScrollBar scrollBar = (ScrollBar)this.testSBRef.get();
        if (scrollBar == null) {
            return 0;
        }
        Node node = ScrollBarThemeImpl.getTrack(scrollBar);
        this.adjustScrollBar(scrollBar, n, n2, n3);
        double d = 0.0;
        d = n3 == 1 ? node.getLayoutBounds().getHeight() : node.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "track length: {0}", d);
        return (int)d;
    }

    @Override
    public int getThumbPosition(int n, int n2, int n3, int n4, int n5, int n6) {
        ScrollBar scrollBar = (ScrollBar)this.testSBRef.get();
        if (scrollBar == null) {
            return 0;
        }
        Node node = ScrollBarThemeImpl.getThumb(scrollBar);
        this.adjustScrollBar(scrollBar, n, n2, n3, n4, n5, n6);
        double d = 0.0;
        d = n3 == 1 ? node.getTranslateY() : node.getTranslateX();
        log.log(Level.FINEST, "thumb position: {0}", d);
        return (int)d;
    }

    private void initializeThickness() {
        ScrollBar scrollBar = (ScrollBar)this.testSBRef.get();
        if (scrollBar == null) {
            return;
        }
        ScrollBarSkin scrollBarSkin = (ScrollBarSkin)scrollBar.getSkin();
        int n = (int)scrollBarSkin.getMinWidth();
        if (n != 0 && ScrollBarTheme.getThickness() != n) {
            ScrollBarTheme.setThickness(n);
        }
        this.thicknessInitialized = true;
    }

    private static Node getThumb(ScrollBar scrollBar) {
        return (Node)ScrollBarThemeImpl.getFieldValue("thumb", ScrollBarSkin.class, scrollBar.getSkin());
    }

    private static Node getTrack(ScrollBar scrollBar) {
        return (Node)ScrollBarThemeImpl.getFieldValue("track", ScrollBarSkin.class, scrollBar.getSkin());
    }

    private static Node getIncButton(ScrollBar scrollBar) {
        return (Node)ScrollBarThemeImpl.getFieldValue("incButton", ScrollBarSkin.class, scrollBar.getSkin());
    }

    private static Node getDecButton(ScrollBar scrollBar) {
        return (Node)ScrollBarThemeImpl.getFieldValue("decButton", ScrollBarSkin.class, scrollBar.getSkin());
    }

    private static Object getFieldValue(String string, Class clazz, Object object) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static class ScrollBarRef
    extends Ref {
        private WeakReference<ScrollBarWidget> sbRef;

        public ScrollBarRef(ScrollBarWidget scrollBarWidget) {
            this.sbRef = new WeakReference<ScrollBarWidget>(scrollBarWidget);
        }

        public Control asControl() {
            return (Control)this.sbRef.get();
        }
    }

    private class ScrollBarWidget
    extends ScrollBar
    implements RenderThemeImpl.Widget {
        ScrollBarWidget() {
            this.setOrientation(Orientation.VERTICAL);
            this.setMin(0.0);
            this.setManaged(false);
        }

        @Override
        public void impl_updatePG() {
            super.impl_updatePG();
            if (!ScrollBarThemeImpl.this.thicknessInitialized) {
                ScrollBarThemeImpl.this.initializeThickness();
            }
        }

        @Override
        public RenderThemeImpl.WidgetType getType() {
            return RenderThemeImpl.WidgetType.SCROLLBAR;
        }
    }
}

