/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.GraphicsResource;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.SharedBufferManager;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCImageFrame;
import com.sun.webpane.platform.graphics.WCImgDecoder;
import com.sun.webpane.sg.prism.PrismImage;
import com.sun.webpane.sg.prism.WCImageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCImgDecoderImpl
extends WCImgDecoder {
    private static final Logger log = Logger.getLogger(WCImgDecoderImpl.class.getName());
    private SharedBufferManager sbm;
    private long pObserver = 0L;
    private long pImage = 0L;
    private int imageWidth = -1;
    private int imageHeight = -1;
    private ImageFrame[] frames;
    private PrismImage[] images;
    ImageLoadListener readerListener = new ImageLoadListener(){

        @Override
        public void imageLoadProgress(ImageLoader imageLoader, float f) {
        }

        @Override
        public void imageLoadWarning(ImageLoader imageLoader, String string) {
        }

        @Override
        public void imageLoadMetaData(ImageLoader imageLoader, ImageMetadata imageMetadata) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X Image size %dx%d", WCImgDecoderImpl.this.pObserver, imageMetadata.imageWidth, imageMetadata.imageHeight));
            }
            if (WCImgDecoderImpl.this.imageWidth < imageMetadata.imageWidth) {
                WCImgDecoderImpl.this.imageWidth = imageMetadata.imageWidth;
            }
            if (WCImgDecoderImpl.this.imageHeight < imageMetadata.imageHeight) {
                WCImgDecoderImpl.this.imageHeight = imageMetadata.imageHeight;
            }
        }
    };

    @Override
    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Destroy image decoder", this.pObserver));
        }
        this.pObserver = 0L;
        this.pImage = 0L;
        if (this.sbm != null) {
            this.sbm.release();
        }
    }

    @Override
    public void setObserver(long l, long l2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X setObserver, image %X", l, l2));
        }
        this.pObserver = l;
        this.pImage = l2;
    }

    @Override
    public String getFilenameExtension() {
        return ".img";
    }

    @Override
    public void setImageData(long l, int n, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X setImageData: size %d, all %s", this.pObserver, n, bl));
        }
        if (this.sbm == null) {
            this.sbm = SharedBufferManager.createInstance();
        }
        this.sbm.update(l, n, bl);
        if (!bl) {
            this.images = null;
            this.loadFrames(this.sbm.getInputStream(false));
        }
    }

    @Override
    public void loadFromResource(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Load image from resource '%s'", this.pObserver, string));
        }
        String string2 = WCGraphicsManager.getResourceName(string);
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X Unable to open resource '%s'", this.pObserver, string2));
            }
            return;
        }
        this.loadFrames(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFrames(InputStream inputStream) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Decoding frames", this.pObserver));
        }
        try {
            this.frames = ImageStorage.loadAll(inputStream, this.readerListener, 0, 0, true, false);
            this.notifyNativeObserver(this.pObserver, this.pImage);
        }
        catch (ImageStorageException imageStorageException) {
            this.frames = null;
            this.images = null;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int getFrameCount() {
        int n;
        int n2 = n = this.frames != null ? this.frames.length : 0;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X frame count = %d", this.pObserver, n));
        }
        return n == 0 ? 1 : n;
    }

    @Override
    public boolean isImageSizeAvailable() {
        boolean bl;
        boolean bl2 = bl = this.imageWidth > -1;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X size available = %b", this.pObserver, bl));
        }
        return bl;
    }

    @Override
    public void getImageSize(int[] nArray) {
        if (this.imageWidth > -1) {
            nArray[0] = this.imageWidth;
            nArray[1] = this.imageHeight;
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X image size = %dx%d", this.pObserver, nArray[0], nArray[1]));
        }
    }

    @Override
    public WCImageFrame getFrame(int n) {
        ImageFrame imageFrame = this.getImageFrame(n);
        if (imageFrame != null) {
            ImageStorage.ImageType imageType = imageFrame.getImageType();
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X getFrame(%d), image type = %s", new Object[]{this.pObserver, n, imageType}));
            }
            PrismImage prismImage = this.getPrismImage(n, imageFrame);
            return new Frame(prismImage);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X FAILED getFrame(%d)", this.pObserver, n));
        }
        return null;
    }

    @Override
    public float getFrameDuration(int n) {
        ImageFrame imageFrame = this.getImageFrame(n);
        if (imageFrame != null) {
            float f;
            ImageMetadata imageMetadata = imageFrame.getMetadata();
            float f2 = f = imageMetadata == null || imageMetadata.delayTime == null ? 0.0f : (float)imageMetadata.delayTime.intValue() / 1000.0f;
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X frame duration (%d) = %.2f", this.pObserver, n, Float.valueOf(f)));
            }
            return f < 0.011f ? 0.1f : f;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X FAILED frame duration (%d)", this.pObserver, n));
        }
        return 0.0f;
    }

    @Override
    public int[] getFrameSize(int n) {
        ImageFrame imageFrame = this.getImageFrame(n);
        if (imageFrame != null) {
            PrismImage prismImage = this.getPrismImage(n, imageFrame);
            int n2 = prismImage.getWidth();
            int n3 = prismImage.getHeight();
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X frame size (%d) = %dx%d", this.pObserver, n, n2, n3));
            }
            return new int[]{n2, n3};
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X FAILED frame size (%d)", this.pObserver, n));
        }
        return new int[]{0, 0};
    }

    private ImageFrame getImageFrame(int n) {
        return n >= 0 && this.frames != null && this.frames.length > n ? this.frames[n] : null;
    }

    private PrismImage getPrismImage(int n, ImageFrame imageFrame) {
        if (this.images == null) {
            this.images = new PrismImage[this.frames.length];
        }
        if (this.images[n] == null) {
            this.images[n] = new WCImageImpl(imageFrame);
            ImageMetadata imageMetadata = imageFrame.getMetadata();
            if (imageMetadata != null && imageMetadata.disposalMethod != null) {
                int n2 = imageMetadata.imageLeftPosition;
                int n3 = imageMetadata.imageTopPosition;
                PrismImage prismImage = this.getPrismImage(n - 1);
                if (prismImage != null || n2 != 0 || n3 != 0 || this.imageWidth != imageMetadata.imageWidth || this.imageHeight != imageMetadata.imageHeight) {
                    this.images[n] = this.createImage(null, prismImage, this.images[n], n2, n3);
                }
            }
        }
        return this.images[n];
    }

    private PrismImage getPrismImage(int n) {
        if (n < 0) {
            return null;
        }
        ImageFrame imageFrame = this.frames[n];
        ImageMetadata imageMetadata = imageFrame.getMetadata();
        if (imageMetadata.disposalMethod != 2 && imageMetadata.disposalMethod != 3) {
            return this.getPrismImage(n, imageFrame);
        }
        PrismImage prismImage = this.getPrismImage(n - 1);
        return prismImage != null && imageMetadata.disposalMethod != 3 ? this.createImage(imageMetadata, prismImage, null, 0, 0) : prismImage;
    }

    private PrismImage createImage(final ImageMetadata imageMetadata, final PrismImage prismImage, final PrismImage prismImage2, final int n, final int n2) {
        final AtomicReference atomicReference = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Invoker.getInvoker().invokeOnRenderThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RenderingContext renderingContext = null;
                GraphicsResource graphicsResource = null;
                try {
                    WCImageImpl wCImageImpl;
                    IntBuffer intBuffer;
                    ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                    renderingContext = resourceFactory.createRenderingContext(null);
                    renderingContext.begin();
                    graphicsResource = resourceFactory.createRTTexture(WCImgDecoderImpl.this.imageWidth, WCImgDecoderImpl.this.imageHeight);
                    Graphics graphics = graphicsResource.createGraphics();
                    if (prismImage != null) {
                        prismImage.draw(graphics, 0, 0, prismImage.getWidth(), prismImage.getHeight(), 0, 0, prismImage.getWidth(), prismImage.getHeight());
                    }
                    if (imageMetadata != null) {
                        int n5 = imageMetadata.imageTopPosition;
                        int n22 = imageMetadata.imageLeftPosition;
                        int n3 = n22 + imageMetadata.imageWidth;
                        int n4 = n5 + imageMetadata.imageHeight;
                        graphics.clearQuad(n22, n5, n3, n4);
                    }
                    if (prismImage2 != null) {
                        prismImage2.draw(graphics, n, n2, n + prismImage2.getWidth(), n2 + prismImage2.getHeight(), 0, 0, prismImage2.getWidth(), prismImage2.getHeight());
                    }
                    if ((intBuffer = IntBuffer.allocate(WCImgDecoderImpl.this.imageWidth * WCImgDecoderImpl.this.imageHeight)) != null) {
                        intBuffer.rewind();
                        graphicsResource.readPixels(intBuffer);
                        wCImageImpl = new WCImageImpl(intBuffer, WCImgDecoderImpl.this.imageWidth, WCImgDecoderImpl.this.imageHeight);
                    } else {
                        wCImageImpl = new WCImageImpl(WCImgDecoderImpl.this.imageWidth, WCImgDecoderImpl.this.imageHeight);
                    }
                    atomicReference.set(wCImageImpl);
                }
                catch (Exception exception) {
                    assert (false) : "Exception in WCImgDecoderImpl.createImage RenderJob" + exception.getMessage();
                }
                finally {
                    if (renderingContext != null) {
                        renderingContext.end();
                    }
                    if (graphicsResource != null) {
                        graphicsResource.dispose();
                    }
                    countDownLatch.countDown();
                }
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (PrismImage)atomicReference.get();
    }

    static class Frame
    extends WCImageFrame {
        WCImage image;

        public Frame(WCImage wCImage) {
            this.image = wCImage;
        }

        @Override
        public WCImage getFrame() {
            return this.image;
        }

        @Override
        public void destroyDecodedData() {
            this.image = null;
        }
    }
}

