/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.T2KFontFactory;
import com.sun.t2k.T2KFontFile;
import com.sun.t2k.T2KFontStrikeDesc;
import com.sun.t2k.T2KGlyph;
import com.sun.t2k.T2KMetrics;
import com.sun.t2k.T2KStrikeDisposer;
import java.util.HashMap;
import java.util.Map;

public class T2KFontStrike
implements FontStrike {
    private long pScalerContext = 0L;
    private T2KFontFile fontResource;
    T2KStrikeDisposer disposer;
    Map<Integer, FontStrike.Glyph> glyphMap = new HashMap<Integer, FontStrike.Glyph>();
    float size;
    private BaseTransform transform;
    public double[] matrix;
    T2KMetrics metrics;
    boolean drawShapes = false;
    Affine2D invTx = null;
    int aaMode;
    boolean gdiLCDGlyphs = false;
    int gdiSize;
    private T2KFontStrikeDesc desc;
    private float[] styleMetrics;
    private int hash;

    @Override
    public synchronized void clearDesc() {
        this.fontResource.strikeMap.remove(this.desc);
    }

    T2KFontStrike(T2KFontFile t2KFontFile, float f, BaseTransform baseTransform, T2KFontStrikeDesc t2KFontStrikeDesc) {
        this.fontResource = t2KFontFile;
        this.size = f;
        this.desc = t2KFontStrikeDesc;
        boolean bl = PrismFontLoader.isLCDTextSupported();
        this.aaMode = bl ? t2KFontStrikeDesc.aaMode : 2;
        int n = 0;
        boolean bl2 = false;
        float f2 = 1.0f;
        float f3 = 0.0f;
        this.matrix = new double[4];
        if (baseTransform.isTranslateOrIdentity()) {
            this.transform = BaseTransform.IDENTITY_TRANSFORM;
            this.matrix[0] = this.matrix[3] = (double)f;
        } else {
            BaseTransform baseTransform2 = baseTransform;
            Affine2D affine2D = new Affine2D(baseTransform2.getMxx(), baseTransform2.getMyx(), baseTransform2.getMxy(), baseTransform2.getMyy(), 0.0, 0.0);
            this.transform = affine2D;
            this.invTx = new Affine2D(affine2D);
            try {
                this.invTx.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.invTx = null;
            }
            this.matrix[0] = affine2D.getMxx() * (double)f;
            this.matrix[1] = affine2D.getMyx() * (double)f;
            this.matrix[2] = affine2D.getMxy() * (double)f;
            this.matrix[3] = affine2D.getMyy() * (double)f;
        }
        float f4 = 80.0f;
        if (Math.abs(this.matrix[0]) > (double)f4 || Math.abs(this.matrix[1]) > (double)f4 || Math.abs(this.matrix[2]) > (double)f4 || Math.abs(this.matrix[3]) > (double)f4) {
            this.drawShapes = true;
        } else if (T2KFontFactory.isWindows && this.aaMode == 4 && this.matrix[0] == this.matrix[3] && this.matrix[1] == 0.0 && this.matrix[2] == 0.0) {
            this.gdiLCDGlyphs = true;
            this.gdiSize = (int)(this.matrix[0] + 0.5);
        }
        this.pScalerContext = t2KFontFile.createScalerContext(this.matrix, this.aaMode, n, bl2, f2, f3);
        this.disposer = new T2KStrikeDisposer(t2KFontFile, t2KFontStrikeDesc, this.pScalerContext);
    }

    long getScalerContext() {
        return this.pScalerContext;
    }

    @Override
    public FontStrike.Metrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.fontResource.getFontMetrics(this.pScalerContext, this.size);
        }
        return this.metrics;
    }

    @Override
    public FontResource getFontResource() {
        return this.fontResource;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public boolean drawAsShapes() {
        return this.drawShapes;
    }

    @Override
    public int getAAMode() {
        return this.aaMode;
    }

    @Override
    public BaseTransform getTransform() {
        return this.transform;
    }

    @Override
    public boolean supportsGlyphImages() {
        return true;
    }

    @Override
    public int getNumGlyphs() {
        return this.fontResource.getNumGlyphs();
    }

    public CharToGlyphMapper getGlyphMapper() {
        return this.fontResource.getGlyphMapper();
    }

    @Override
    public FontStrike.Glyph getGlyph(char c) {
        int n = this.fontResource.getGlyphMapper().charToGlyph((int)c);
        return this.getGlyph(n);
    }

    private native long getLCDGlyphFromWindows(String var1, boolean var2, boolean var3, int var4, int var5, boolean var6);

    private long getGlyphFromWindows(int n) {
        String string = this.fontResource.getFamilyName();
        boolean bl = this.fontResource.isBold();
        boolean bl2 = this.fontResource.isItalic();
        return this.getLCDGlyphFromWindows(string, bl, bl2, this.gdiSize, n, true);
    }

    @Override
    public FontStrike.Glyph getGlyph(int n) {
        FontStrike.Glyph glyph = this.glyphMap.get(n);
        if (glyph == null) {
            if (this.drawAsShapes()) {
                float f = this.fontResource.getAdvance(n, this.size);
                glyph = new T2KGlyph(this, n, f);
            } else {
                long l = 0L;
                long l2 = 0L;
                if (this.gdiLCDGlyphs) {
                    l = l2 = this.getGlyphFromWindows(n);
                }
                if (l == 0L) {
                    l = this.fontResource.getGlyphImage(this.pScalerContext, n);
                }
                glyph = new T2KGlyph(this, n, l);
                if (l2 != 0L) {
                    float f;
                    float f2 = f = this.fontResource.getAdvance(n, this.size);
                    float f3 = 0.0f;
                    if (this.invTx != null) {
                        Point2D point2D = new Point2D(f, 0.0f);
                        this.transform.transform(point2D, point2D);
                        f2 = point2D.x;
                        f3 = point2D.y;
                    }
                    ((T2KGlyph)glyph).setAdvance(f, f2, f3);
                }
            }
            this.glyphMap.put(n, glyph);
        }
        return glyph;
    }

    @Override
    public RectBounds getStringVisualBounds(String string) {
        if (string == null || string.length() == 0) {
            return new RectBounds();
        }
        float[] fArray = new float[4];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        CharToGlyphMapper charToGlyphMapper = this.fontResource.getGlyphMapper();
        int n = charToGlyphMapper.charToGlyph((int)string.charAt(0));
        this.fontResource.getGlyphBoundingBox(n, this.size, fArray);
        f = fArray[0];
        f2 = fArray[1];
        f3 = fArray[2];
        f4 = fArray[3];
        int n2 = string.length();
        if (n2 == 1) {
            return new RectBounds(f, f2, f3, f4);
        }
        float f5 = this.fontResource.getAdvance(n, this.size);
        for (int i = 1; i < n2; ++i) {
            n = charToGlyphMapper.charToGlyph((int)string.charAt(i));
            this.fontResource.getGlyphBoundingBox(n, this.size, fArray);
            if (fArray[0] + f5 < f) {
                f = fArray[0] + f5;
            }
            if (fArray[1] < f2) {
                f2 = fArray[1];
            }
            if (fArray[2] + f5 > f3) {
                f3 = fArray[2] + f5;
            }
            if (fArray[3] > f4) {
                f4 = fArray[3];
            }
            if (i >= n2 - 1) continue;
            float f6 = this.fontResource.getAdvance(n, this.size);
            f5 += f6;
        }
        return new RectBounds(f, f2, f3, f4);
    }

    @Override
    public float getStringWidth(String string) {
        float f = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            f += this.getCharAdvance(string.charAt(i));
        }
        return f;
    }

    @Override
    public float getStringHeight(String string) {
        return this.getMetrics().getLineHeight();
    }

    @Override
    public RectBounds getStringBounds(String string) {
        if (string == null) {
            return new RectBounds();
        }
        float f = this.getStringWidth(string);
        FontStrike.Metrics metrics = this.getMetrics();
        RectBounds rectBounds = new RectBounds(0.0f, metrics.getAscent(), f, metrics.getDescent() + metrics.getLineGap());
        return rectBounds;
    }

    @Override
    public Shape getOutline(String string, BaseTransform baseTransform) {
        Path2D path2D = new Path2D();
        this.getOutline(string, baseTransform, path2D);
        return path2D;
    }

    @Override
    public void getOutline(String string, BaseTransform baseTransform, Path2D path2D) {
        path2D.reset();
        if (string == null) {
            return;
        }
        float f = 0.0f;
        float f2 = this.getMetrics().getLineHeight();
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        Affine2D affine2D = new Affine2D();
        float f3 = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            affine2D.setTransform(baseTransform);
            char c = string.charAt(i);
            if (c == '\n') {
                f3 -= f2;
                f = 0.0f;
                continue;
            }
            FontStrike.Glyph glyph = this.getGlyph(c);
            Shape shape = glyph.getShape();
            affine2D.translate(f, f3);
            path2D.append(shape.getPathIterator(affine2D), false);
            f += glyph.getAdvance();
        }
    }

    Path2D getGlyphOutline(T2KGlyph t2KGlyph) {
        return this.getGlyphOutline(t2KGlyph.getGlyphCode());
    }

    Path2D getGlyphOutline(int n) {
        Path2D path2D = this.fontResource.getGlyphOutline(this.pScalerContext, n);
        if (this.invTx != null) {
            path2D.transform(this.invTx);
        }
        return path2D;
    }

    RectBounds getGlyphBounds(T2KGlyph t2KGlyph) {
        return this.fontResource.getGlyphBounds(this.pScalerContext, t2KGlyph.getGlyphCode());
    }

    int[] getGlyphInfo(long l) {
        return this.fontResource.getGlyphInfo(l);
    }

    byte[] getGlyphPixelData(long l) {
        return this.fontResource.getGlyphPixelData(l);
    }

    float getGlyphPixelYAdvance(long l) {
        float f = this.fontResource.getGlyphYAdvance(l);
        return f;
    }

    float getGlyphPixelXAdvance(long l) {
        float f = this.fontResource.getGlyphXAdvance(l);
        return f;
    }

    float getGlyphAdvance(long l) {
        float f = this.getGlyphPixelXAdvance(l);
        if (this.invTx != null) {
            float f2 = this.getGlyphPixelYAdvance(l);
            Point2D point2D = new Point2D(f, f2);
            this.invTx.transform(point2D, point2D);
            return point2D.x;
        }
        return f;
    }

    @Override
    public float getCharAdvance(char c) {
        int n = this.fontResource.getGlyphMapper().charToGlyph((int)c);
        return this.fontResource.getAdvance(n, this.size);
    }

    private void getStyleMetrics() {
        if (this.styleMetrics == null) {
            this.styleMetrics = this.fontResource.getStyleMetrics(this.size);
        }
    }

    @Override
    public float getStrikeThroughOffset() {
        this.getStyleMetrics();
        return this.styleMetrics[0];
    }

    @Override
    public float getStrikeThroughThickness() {
        this.getStyleMetrics();
        return this.styleMetrics[1];
    }

    @Override
    public float getUnderLineOffset() {
        this.getStyleMetrics();
        return this.styleMetrics[2];
    }

    @Override
    public float getUnderLineThickness() {
        this.getStyleMetrics();
        return this.styleMetrics[3];
    }

    void freeGlyph(long l) {
        this.fontResource.freeGlyph(l);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof T2KFontStrike)) {
            return false;
        }
        T2KFontStrike t2KFontStrike = (T2KFontStrike)object;
        return this.size == t2KFontStrike.size && this.matrix[0] == t2KFontStrike.matrix[0] && this.matrix[1] == t2KFontStrike.matrix[1] && this.matrix[2] == t2KFontStrike.matrix[2] && this.matrix[3] == t2KFontStrike.matrix[3] && this.fontResource.equals(t2KFontStrike.fontResource);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = Float.floatToIntBits(this.size) + Float.floatToIntBits((float)this.matrix[0]) + Float.floatToIntBits((float)this.matrix[1]) + Float.floatToIntBits((float)this.matrix[2]) + Float.floatToIntBits((float)this.matrix[3]);
        this.hash = 71 * this.hash + this.fontResource.hashCode();
        return this.hash;
    }

    public String toString() {
        return "FontStrike: " + super.toString() + " font resource = " + this.fontResource + " size = " + this.size + " matrix = {" + this.matrix[0] + ", " + this.matrix[1] + ", " + this.matrix[2] + ", " + this.matrix[3] + "}";
    }
}

