/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;

public class TimelineClipCore {
    private static final int UNDEFINED_KEYFRAME = -1;
    private static final double EPSILON = 1.0E-12;
    Timeline timeline;
    private KeyFrame[] keyFrames = new KeyFrame[0];
    private ClipInterpolator clipInterpolator;
    private boolean aborted = false;
    private int lastKF = -1;
    private double curTime = 0.0;

    public TimelineClipCore(Timeline timeline) {
        this.timeline = timeline;
        this.clipInterpolator = ClipInterpolator.create(this.keyFrames);
    }

    public void setKeyFrames(KeyFrame[] keyFrameArray) {
        this.keyFrames = keyFrameArray;
        this.clipInterpolator = this.clipInterpolator.setKeyFrames(keyFrameArray);
    }

    public void notifyCurrentRateChanged() {
        if (this.timeline.getStatus() != Animation.Status.RUNNING) {
            this.clearLastKeyFrame();
        }
    }

    public void abort() {
        this.aborted = true;
    }

    private void clearLastKeyFrame() {
        this.lastKF = -1;
    }

    public void jumpTo(long l) {
        double d = (double)l / 6.0;
        this.lastKF = -1;
        this.curTime = d;
        if (this.timeline.getStatus() != Animation.Status.STOPPED) {
            this.clipInterpolator.interpolate(d);
        }
    }

    public void start(boolean bl) {
        this.clearLastKeyFrame();
        this.clipInterpolator.validate(bl);
        if (this.curTime > 0.0) {
            this.clipInterpolator.interpolate(this.curTime);
        }
    }

    public void playTo(long l) {
        boolean bl;
        double d = (double)l / 6.0;
        this.aborted = false;
        boolean bl2 = bl = this.curTime <= d;
        if (bl) {
            int n = this.lastKF == -1 ? 0 : (this.keyFrames[this.lastKF].getTime().toMillis() <= this.curTime ? this.lastKF + 1 : this.lastKF);
            int n2 = this.keyFrames.length;
            for (int i = n; i < n2; ++i) {
                double d2 = this.keyFrames[i].getTime().toMillis();
                if (d2 > d) {
                    this.lastKF = i - 1;
                } else {
                    if (!(d2 >= this.curTime)) continue;
                    this.visitKeyFrame(i, d2);
                    if (!this.aborted) {
                        continue;
                    }
                }
                break;
            }
        } else {
            int n;
            for (int i = n = this.lastKF == -1 ? this.keyFrames.length - 1 : (this.keyFrames[this.lastKF].getTime().toMillis() >= this.curTime ? this.lastKF - 1 : this.lastKF); i >= 0; --i) {
                double d3 = this.keyFrames[i].getTime().toMillis();
                if (d3 < d) {
                    this.lastKF = i + 1;
                } else {
                    if (!(d3 <= this.curTime)) continue;
                    this.visitKeyFrame(i, d3);
                    if (!this.aborted) {
                        continue;
                    }
                }
                break;
            }
        }
        if (!this.aborted && (this.lastKF == -1 || Math.abs(this.keyFrames[this.lastKF].getTime().toMillis() - d) > 1.0E-12 || this.keyFrames[this.lastKF].getOnFinished() == null)) {
            this.setTime(d);
            this.clipInterpolator.interpolate(d);
        }
    }

    private void setTime(double d) {
        this.curTime = d;
        this.timeline.impl_setCurrentTicks(Math.round(6.0 * d));
    }

    private void visitKeyFrame(int n, double d) {
        if (n != this.lastKF) {
            this.lastKF = n;
            KeyFrame keyFrame = this.keyFrames[n];
            EventHandler<ActionEvent> eventHandler = keyFrame.getOnFinished();
            if (eventHandler != null) {
                this.setTime(d);
                this.clipInterpolator.interpolate(d);
                eventHandler.handle(new ActionEvent(keyFrame, null));
            }
        }
    }
}

