/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.opengl;

import com.sun.prism.opengl.GLException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GLUniformData {
    private String name;
    private int location;
    private int rows;
    private int columns;
    private int count;
    private Object data;
    private boolean isMatrix;

    public GLUniformData(String string, int n) {
        this.init(string, 1, new Integer(n));
    }

    public GLUniformData(String string, float f) {
        this.init(string, 1, new Float(f));
    }

    public GLUniformData(String string, int n, IntBuffer intBuffer) {
        this.init(string, n, intBuffer);
    }

    public GLUniformData(String string, int n, FloatBuffer floatBuffer) {
        this.init(string, n, floatBuffer);
    }

    public GLUniformData(String string, int n, int n2, FloatBuffer floatBuffer) {
        this.init(string, n, n2, floatBuffer);
    }

    public void setData(int n) {
        this.init(new Integer(n));
    }

    public void setData(float f) {
        this.init(new Float(f));
    }

    public void setData(IntBuffer intBuffer) {
        this.init(intBuffer);
    }

    public void setData(FloatBuffer floatBuffer) {
        this.init(floatBuffer);
    }

    public int intValue() {
        return (Integer)this.data;
    }

    public float floatValue() {
        return ((Float)this.data).floatValue();
    }

    public IntBuffer intBufferValue() {
        return (IntBuffer)this.data;
    }

    public FloatBuffer floatBufferValue() {
        return (FloatBuffer)this.data;
    }

    public String toString() {
        return "GLUniformData[name " + this.name + ", location " + this.location + ", size " + this.rows + "*" + this.columns + ", count " + this.count + ", matrix " + this.isMatrix + ", data " + this.data + "]";
    }

    private void init(String string, int n, int n2, Object object) {
        if (2 > n || n > 4 || 2 > n2 || n2 > 4) {
            throw new GLException("rowsXcolumns must be within [2..4]X[2..4], is: " + n + "X" + n2);
        }
        this.name = string;
        this.rows = n;
        this.columns = n2;
        this.isMatrix = true;
        this.location = -1;
        this.init(object);
    }

    private void init(String string, int n, Object object) {
        if (1 > n || n > 4) {
            throw new GLException("components must be within [1..4], is: " + n);
        }
        this.name = string;
        this.columns = n;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.init(object);
    }

    private void init(Object object) {
        if (object instanceof Buffer) {
            int n = this.rows * this.columns;
            Buffer buffer = (Buffer)object;
            if (buffer.limit() < n || 0 != buffer.limit() % n) {
                throw new GLException("data buffer size invalid: new buffer limit: " + buffer.limit() + "\n\t" + this);
            }
            this.count = buffer.limit() / (this.rows * this.columns);
        } else {
            if (this.isMatrix) {
                throw new GLException("Atom type not allowed for matrix : " + this);
            }
            this.count = 1;
        }
        this.data = object;
    }

    public String getName() {
        return this.name;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int n) {
        this.location = n;
    }

    public Object getObject() {
        return this.data;
    }

    public Buffer getBuffer() {
        return this.data instanceof Buffer ? (Buffer)this.data : null;
    }

    public boolean isBuffer() {
        return this.data instanceof Buffer;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public int count() {
        return this.count;
    }

    public int components() {
        return this.rows * this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }
}

