/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.nativewindow.impl;

import com.sun.prism.nativewindow.impl.Debug;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoaderBase {
    public static final boolean DEBUG;
    private static final HashSet loaded;
    private static LoaderAction loaderAction;
    private static final Class customLauncherClass;
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("NativeLibLoaderBase Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        NativeLibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        NativeLibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        NativeLibLoaderBase.loaderAction = loaderAction;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl) {
        if (loaderAction != null && !NativeLibLoaderBase.isLoaded(string)) {
            loaderAction.loadLibrary(string, stringArray, bl);
        }
    }

    public static void loadNativeWindow(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NativeLibLoaderBase.loadLibrary("prism_nativewindow_" + string, null, false);
                return null;
            }
        });
    }

    private static void loadLibraryInternal(String string) {
        try {
            Class<?> clazz = Class.forName("com.sun.javafx.runtime.NativeLibLoader");
            Method method = clazz.getDeclaredMethod("loadLibrary", String.class);
            method.invoke(null, string);
        }
        catch (Throwable throwable) {
            System.loadLibrary(string);
        }
    }

    static {
        String string;
        DEBUG = Debug.debug("NativeLibLoader");
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        Class<?> clazz = null;
        Method method = null;
        if (Debug.getBooleanProperty("sun.jnlp.applet.launcher", false)) {
            try {
                clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                method = clazz.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    throwable.printStackTrace();
                }
                clazz = null;
                method = null;
            }
        }
        if (null == clazz && null != (string = Debug.getProperty("jnlp.launcher.class", false))) {
            try {
                clazz = Class.forName(string);
                method = clazz.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    throwable.printStackTrace();
                }
                clazz = null;
                method = null;
            }
        }
        customLauncherClass = clazz;
        customLoadLibraryMethod = method;
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        public void loadLibrary(String string, String[] stringArray, boolean bl) {
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (NativeLibLoaderBase.isLoaded(stringArray[i])) continue;
                    try {
                        NativeLibLoaderBase.loadLibraryInternal(stringArray[i]);
                        NativeLibLoaderBase.addLoaded(stringArray[i]);
                        if (!DEBUG) continue;
                        System.err.println("NativeLibLoaderBase preloaded " + stringArray[i]);
                        continue;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) continue;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            NativeLibLoaderBase.loadLibraryInternal(string);
            NativeLibLoaderBase.addLoaded(string);
            if (DEBUG) {
                System.err.println("NativeLibLoaderBase    loaded " + string);
            }
        }
    }

    public static interface LoaderAction {
        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

