/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class BaseShaderGraphics
extends BaseGraphics
implements ShaderGraphics,
ReadbackGraphics {
    private static Affine2D TEMP_TX2D = new Affine2D();
    private static Affine3D TEMP_TX3D = new Affine3D();
    private final BaseShaderContext context;
    private Shader externalShader;
    private boolean isComplexPaint;
    private static final float FRINGE_FACTOR;
    private static final double SQRT_2;

    protected BaseShaderGraphics(BaseShaderContext baseShaderContext, RenderTarget renderTarget) {
        super(baseShaderContext, renderTarget);
        this.context = baseShaderContext;
    }

    BaseShaderContext getContext() {
        return this.context;
    }

    boolean isComplexPaint() {
        return this.isComplexPaint;
    }

    @Override
    public void getPaintShaderTransform(Affine3D affine3D) {
        affine3D.setTransform(this.getTransformNoClone());
    }

    public Shader getExternalShader() {
        return this.externalShader;
    }

    @Override
    public void setExternalShader(Shader shader) {
        this.externalShader = shader;
        this.context.setExternalShader(this, shader);
    }

    @Override
    public void setPaint(Paint paint) {
        Gradient gradient;
        this.isComplexPaint = paint.getType().isGradient() ? (gradient = (Gradient)paint).getNumStops() > 12 : false;
        super.setPaint(paint);
    }

    @Override
    public void drawTexture(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (texture instanceof MultiTexture) {
            this.drawMultiTexture((MultiTexture)texture, f, f2, f3, f4, f5, f6, f7, f8);
        } else {
            super.drawTexture(texture, f, f2, f3, f4, f5, f6, f7, f8);
        }
    }

    private static float calculateScaleFactor(float f, float f2) {
        if (f == f2) {
            return 1.0f;
        }
        return (f - 1.0f) / f2;
    }

    protected void drawMultiTexture(MultiTexture multiTexture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        Texture texture;
        Texture texture2;
        Texture[] textureArray;
        Shader shader;
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f3 += this.transX;
            f4 += this.transY;
        }
        if (null == (shader = this.context.validateTextureOp(this, baseTransform, textureArray = multiTexture.getTextures(), multiTexture.getPixelFormat()))) {
            return;
        }
        if (multiTexture.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            Texture texture3 = textureArray[0];
            texture2 = textureArray[2];
            texture = textureArray[1];
            f14 = multiTexture.getContentWidth();
            f13 = multiTexture.getContentHeight();
            f12 = BaseShaderGraphics.calculateScaleFactor(f14, texture3.getPhysicalWidth());
            f11 = BaseShaderGraphics.calculateScaleFactor(f13, texture3.getPhysicalHeight());
            if (textureArray.length > 3) {
                Texture texture4 = textureArray[3];
                f10 = BaseShaderGraphics.calculateScaleFactor(f14, texture4.getPhysicalWidth());
                f9 = BaseShaderGraphics.calculateScaleFactor(f13, texture4.getPhysicalHeight());
            } else {
                f9 = 0.0f;
                f10 = 0.0f;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported multitexture format " + (Object)((Object)multiTexture.getPixelFormat()));
        }
        float f15 = (float)Math.floor((double)f14 / 2.0);
        float f16 = (float)Math.floor((double)f13 / 2.0);
        float f17 = BaseShaderGraphics.calculateScaleFactor(f15, texture2.getPhysicalWidth());
        float f18 = BaseShaderGraphics.calculateScaleFactor(f16, texture2.getPhysicalHeight());
        float f19 = BaseShaderGraphics.calculateScaleFactor(f15, texture.getPhysicalWidth());
        float f20 = BaseShaderGraphics.calculateScaleFactor(f16, texture.getPhysicalHeight());
        shader.setConstant("lumaAlphaScale", f12, f11, f10, f9);
        shader.setConstant("cbCrScale", f17, f18, f19, f20);
        float f21 = f5 / f14;
        float f22 = f6 / f13;
        float f23 = f7 / f14;
        float f24 = f8 / f13;
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f, f2, f3, f4, f21, f22, f23, f24);
    }

    @Override
    public void drawTextureRaw2(Texture texture, Texture texture2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f3 += this.transX;
            f4 += this.transY;
        }
        this.context.validateTextureOp(this, baseTransform, texture, texture2, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    public void drawMappedTextureRaw2(Texture texture, Texture texture2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f3 += this.transX;
            f4 += this.transY;
        }
        this.context.validateTextureOp(this, baseTransform, texture, texture2, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addMappedQuad(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20);
    }

    private void renderWithComplexPaint(Shape shape, BasicStroke basicStroke, float f, float f2, float f3, float f4) {
        this.context.flushVertexBuffer();
        BaseTransform baseTransform = this.getTransformNoClone();
        MaskData maskData = ShapeUtil.rasterizeShape(shape, basicStroke, this.getFinalClipNoClone(), baseTransform, true);
        int n = maskData.getWidth();
        int n2 = maskData.getHeight();
        float f5 = maskData.getOriginX();
        float f6 = maskData.getOriginY();
        float f7 = f5 + (float)n;
        float f8 = f6 + (float)n2;
        Gradient gradient = (Gradient)this.paint;
        TEMP_TX2D.setToTranslation(-f5, -f6);
        TEMP_TX2D.concatenate(baseTransform);
        Texture texture = this.context.getGradientTexture(gradient, TEMP_TX2D, n, n2, maskData, f, f2, f3, f4);
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = f9 + (float)n / (float)texture.getPhysicalWidth();
        float f12 = f10 + (float)n2 / (float)texture.getPhysicalHeight();
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        this.context.validateTextureOp(this, IDENT, texture, null, texture.getPixelFormat());
        vertexBuffer.addQuad(f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    protected void renderShape(Shape shape, BasicStroke basicStroke, float f, float f2, float f3, float f4) {
        if (this.isComplexPaint) {
            this.renderWithComplexPaint(shape, basicStroke, f, f2, f3, f4);
            return;
        }
        this.context.flushVertexBuffer();
        BaseTransform baseTransform = this.getTransformNoClone();
        MaskData maskData = ShapeUtil.rasterizeShape(shape, basicStroke, this.getFinalClipNoClone(), baseTransform, true);
        Texture texture = this.context.getMaskTexture(maskData);
        int n = maskData.getWidth();
        int n2 = maskData.getHeight();
        float f5 = maskData.getOriginX();
        float f6 = maskData.getOriginY();
        float f7 = f5 + (float)n;
        float f8 = f6 + (float)n2;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = f9 + (float)n / (float)texture.getPhysicalWidth();
        float f12 = f10 + (float)n2 / (float)texture.getPhysicalHeight();
        this.context.validatePaintOp(this, IDENT, texture, f, f2, f3, f4);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f5, f6, f7, f8, f9, f10, f11, f12);
    }

    private static float getStrokeExpansionFactor(BasicStroke basicStroke) {
        if (basicStroke.getType() == 2) {
            return 1.0f;
        }
        if (basicStroke.getType() == 0) {
            return 0.5f;
        }
        return 0.0f;
    }

    private BaseTransform extract3Dremainder(BaseTransform baseTransform) {
        if (baseTransform.is2D()) {
            return IDENT;
        }
        TEMP_TX3D.setTransform(baseTransform);
        TEMP_TX2D.setTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
        try {
            TEMP_TX2D.invert();
            TEMP_TX3D.concatenate(TEMP_TX2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return TEMP_TX3D;
    }

    private void renderGeneralRoundedRect(float f, float f2, float f3, float f4, float f5, float f6, BaseShaderContext.MaskType maskType, BasicStroke basicStroke) {
        BaseTransform baseTransform;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        if (basicStroke == null) {
            f18 = f;
            f17 = f2;
            f16 = f3;
            f15 = f4;
            f14 = 0.0f;
            f13 = 0.0f;
        } else {
            float f19 = basicStroke.getLineWidth();
            float f20 = BaseShaderGraphics.getStrokeExpansionFactor(basicStroke) * f19;
            f18 = f - f20;
            f17 = f2 - f20;
            f16 = f3 + (f20 *= 2.0f);
            f15 = f4 + f20;
            if (f5 > 0.0f && f6 > 0.0f) {
                f5 += f20;
                f6 += f20;
            } else if (basicStroke.getLineJoin() == 1) {
                f5 = f6 = f20;
            } else {
                f6 = 0.0f;
                f5 = 0.0f;
            }
            f13 = (f16 - f19 * 2.0f) / f16;
            f14 = (f15 - f19 * 2.0f) / f15;
            if (f13 <= 0.0f || f14 <= 0.0f) {
                maskType = maskType.getFillType();
            }
        }
        BaseTransform baseTransform2 = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            f12 = 1.0f;
            f11 = 1.0f;
            f10 = 0.0f;
            f9 = 0.0f;
            f8 = f18 + this.transX;
            f7 = f17 + this.transY;
            baseTransform = IDENT;
        } else {
            baseTransform = this.extract3Dremainder(baseTransform2);
            f11 = (float)baseTransform2.getMxx();
            f10 = (float)baseTransform2.getMxy();
            f9 = (float)baseTransform2.getMyx();
            f12 = (float)baseTransform2.getMyy();
            f8 = f18 * f11 + f17 * f10 + (float)baseTransform2.getMxt();
            f7 = f18 * f9 + f17 * f12 + (float)baseTransform2.getMyt();
        }
        float f21 = f5 / f16;
        float f22 = f6 / f15;
        this.renderGeneralRoundedPgram(f8, f7, f11 *= f16, f9 *= f16, f10 *= f15, f12 *= f15, f21, f22, f13, f14, baseTransform, maskType, f, f2, f3, f4);
    }

    private void renderGeneralRoundedPgram(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, BaseTransform baseTransform, BaseShaderContext.MaskType maskType, float f11, float f12, float f13, float f14) {
        float f15;
        float f16;
        float f17 = BaseShaderGraphics.len(f3, f4);
        float f18 = BaseShaderGraphics.len(f5, f6);
        if (f17 == 0.0f || f18 == 0.0f) {
            return;
        }
        float f19 = f;
        float f20 = f2;
        float f21 = f + f3;
        float f22 = f2 + f4;
        float f23 = f + f5;
        float f24 = f2 + f6;
        float f25 = f21 + f5;
        float f26 = f22 + f6;
        float f27 = (f3 * f6 - f4 * f5) * 0.5f;
        float f28 = f27 / f18;
        float f29 = f27 / f17;
        if (f28 < 0.0f) {
            f28 = -f28;
        }
        if (f29 < 0.0f) {
            f29 = -f29;
        }
        float f30 = f3 / f17;
        float f31 = f4 / f17;
        float f32 = f5 / f18;
        float f33 = f6 / f18;
        float f34 = -f5 * (f30 + f32) - f6 * (f31 + f33);
        float f35 = f6 * f3 - f5 * f4;
        float f36 = f34 / f35;
        float f37 = FRINGE_FACTOR * Math.signum(f36);
        float f38 = (f36 * f3 + f31) * f37;
        float f39 = (f36 * f4 - f30) * f37;
        f19 += f38;
        f20 += f39;
        f25 -= f38;
        f26 -= f39;
        f34 = f4 * (f33 - f31) - f3 * (f30 - f32);
        f36 = f34 / f35;
        f37 = FRINGE_FACTOR * Math.signum(f36);
        f38 = (f36 * f5 + f33) * f37;
        f39 = (f36 * f6 - f32) * f37;
        f21 += f38;
        f22 += f39;
        f23 -= f38;
        f24 -= f39;
        float f40 = (f19 + f25) * 0.5f;
        float f41 = (f20 + f26) * 0.5f;
        float f42 = f40 * f33 - f41 * f32;
        float f43 = f40 * f31 - f41 * f30;
        float f44 = f19 * f33 - f20 * f32 - f42;
        float f45 = f19 * f31 - f20 * f30 - f43;
        float f46 = f21 * f33 - f22 * f32 - f42;
        float f47 = f21 * f31 - f22 * f30 - f43;
        float f48 = f23 * f33 - f24 * f32 - f42;
        float f49 = f23 * f31 - f24 * f30 - f43;
        float f50 = f25 * f33 - f26 * f32 - f42;
        float f51 = f25 * f31 - f26 * f30 - f43;
        if (maskType == BaseShaderContext.MaskType.DRAW_ROUNDRECT || maskType == BaseShaderContext.MaskType.FILL_ROUNDRECT) {
            f16 = f28 * f7;
            f15 = f29 * f8;
            if ((double)f16 < 0.5 || (double)f15 < 0.5) {
                maskType = maskType == BaseShaderContext.MaskType.DRAW_ROUNDRECT ? BaseShaderContext.MaskType.DRAW_PGRAM : BaseShaderContext.MaskType.FILL_PGRAM;
            } else {
                float f52;
                float f53;
                float f54 = f28 - f16;
                float f55 = f29 - f15;
                if (maskType == BaseShaderContext.MaskType.DRAW_ROUNDRECT) {
                    float f56 = f28 * f9;
                    float f57 = f29 * f10;
                    f53 = f56 - f54;
                    f52 = f57 - f55;
                    if (f53 < 0.5f || f52 < 0.5f) {
                        f53 = f56;
                        f52 = f57;
                        maskType = BaseShaderContext.MaskType.DRAW_SEMIROUNDRECT;
                    } else {
                        f53 = 1.0f / f53;
                        f52 = 1.0f / f52;
                    }
                } else {
                    f52 = 0.0f;
                    f53 = 0.0f;
                }
                f16 = 1.0f / f16;
                f15 = 1.0f / f15;
                Shader shader = this.context.validatePaintOp(this, baseTransform, maskType, f11, f12, f13, f14, f16, f15, f53, f52, 0.0f, 0.0f);
                shader.setConstant("oinvarcradii", f16, f15);
                if (maskType == BaseShaderContext.MaskType.DRAW_ROUNDRECT) {
                    shader.setConstant("iinvarcradii", f53, f52);
                } else if (maskType == BaseShaderContext.MaskType.DRAW_SEMIROUNDRECT) {
                    shader.setConstant("idim", f53, f52);
                }
                f28 = f54;
                f29 = f55;
            }
        }
        if (maskType == BaseShaderContext.MaskType.DRAW_PGRAM || maskType == BaseShaderContext.MaskType.DRAW_ELLIPSE) {
            f16 = f28 * f9;
            f15 = f29 * f10;
            if (maskType == BaseShaderContext.MaskType.DRAW_ELLIPSE) {
                if ((double)Math.abs(f28 - f29) < 0.01) {
                    maskType = BaseShaderContext.MaskType.DRAW_CIRCLE;
                    f29 = (float)Math.min(1.0, (double)(f29 * f29) * Math.PI);
                    f15 = (float)Math.min(1.0, (double)(f15 * f15) * Math.PI);
                } else {
                    f28 = 1.0f / f28;
                    f29 = 1.0f / f29;
                    f16 = 1.0f / f16;
                    f15 = 1.0f / f15;
                }
            }
            Shader shader = this.context.validatePaintOp(this, baseTransform, maskType, f11, f12, f13, f14, f16, f15, 0.0f, 0.0f, 0.0f, 0.0f);
            shader.setConstant("idim", f16, f15);
        } else if (maskType == BaseShaderContext.MaskType.FILL_ELLIPSE) {
            if ((double)Math.abs(f28 - f29) < 0.01) {
                maskType = BaseShaderContext.MaskType.FILL_CIRCLE;
                f29 = (float)Math.min(1.0, (double)(f29 * f29) * Math.PI);
            } else {
                f28 = 1.0f / f28;
                f29 = 1.0f / f29;
                f44 *= f28;
                f45 *= f29;
                f46 *= f28;
                f47 *= f29;
                f48 *= f28;
                f49 *= f29;
                f50 *= f28;
                f51 *= f29;
            }
            this.context.validatePaintOp(this, baseTransform, maskType, f11, f12, f13, f14);
        } else if (maskType == BaseShaderContext.MaskType.FILL_PGRAM) {
            this.context.validatePaintOp(this, baseTransform, maskType, f11, f12, f13, f14);
        }
        this.context.getVertexBuffer().addMappedPgram(f19, f20, f21, f22, f23, f24, f25, f26, f44, f45, f46, f47, f48, f49, f50, f51, f28, f29);
    }

    @Override
    public void fillRect(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f, f2, f3, f4, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, f, f2, f3, f4);
            return;
        }
        this.renderGeneralRoundedRect(f, f2, f3, f4, 0.0f, 0.0f, BaseShaderContext.MaskType.FILL_PGRAM, null);
    }

    @Override
    public void fillEllipse(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchEllipse.setFrame(f, f2, f3, f4);
            this.renderWithComplexPaint(scratchEllipse, null, f, f2, f3, f4);
            return;
        }
        this.renderGeneralRoundedRect(f, f2, f3, f4, f3, f4, BaseShaderContext.MaskType.FILL_ELLIPSE, null);
    }

    @Override
    public void fillRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
        f5 = Math.min(Math.abs(f5), f3);
        f6 = Math.min(Math.abs(f6), f4);
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f, f2, f3, f4, f5, f6);
            this.renderWithComplexPaint(scratchRRect, null, f, f2, f3, f4);
            return;
        }
        this.renderGeneralRoundedRect(f, f2, f3, f4, f5, f6, BaseShaderContext.MaskType.FILL_ROUNDRECT, null);
    }

    @Override
    public void fillQuad(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        if (f <= f3) {
            f8 = f;
            f7 = f3 - f;
        } else {
            f8 = f3;
            f7 = f - f3;
        }
        if (f2 <= f4) {
            f6 = f2;
            f5 = f4 - f2;
        } else {
            f6 = f4;
            f5 = f2 - f4;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f8, f6, f7, f5, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, f8, f6, f7, f5);
            return;
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f8 += this.transX;
            f6 += this.transY;
        }
        this.context.validatePaintOp(this, baseTransform, BaseShaderContext.MaskType.SOLID, f8, f6, f7, f5);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f8, f6, f8 + f7, f6 + f5);
    }

    @Override
    public void fillTriangles(VertexBuffer vertexBuffer, int n, float f, float f2, float f3, float f4) {
        if (this.isComplexPaint) {
            throw new AssertionError((Object)"fillTriangles() not supported for complex paints");
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        this.context.validatePaintOp(this, baseTransform, BaseShaderContext.MaskType.SOLID, f, f2, f3, f4);
        VertexBuffer vertexBuffer2 = this.context.getVertexBuffer();
        vertexBuffer2.addVerts(vertexBuffer, n);
    }

    void fillCubicCurves(VertexBuffer vertexBuffer, int n, float f, float f2, float f3, float f4) {
        if (this.isComplexPaint) {
            throw new AssertionError((Object)"fillCubicCurves() not supported for complex paints");
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        this.context.validatePaintOp(this, baseTransform, BaseShaderContext.MaskType.FILL_CUBICCURVE, f, f2, f3, f4);
        VertexBuffer vertexBuffer2 = this.context.getVertexBuffer();
        vertexBuffer2.addVerts(vertexBuffer, n);
    }

    private static boolean canUseStrokeShader(BasicStroke basicStroke) {
        return !basicStroke.isDashed() && (basicStroke.getType() == 1 || basicStroke.getLineJoin() == 1 || basicStroke.getLineJoin() == 0 && (double)basicStroke.getMiterLimit() >= SQRT_2);
    }

    @Override
    public void drawRect(float f, float f2, float f3, float f4) {
        if (f3 < 0.0f || f4 < 0.0f) {
            return;
        }
        if (f3 == 0.0f || f4 == 0.0f) {
            this.drawLine(f, f2, f + f3, f2 + f4);
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f, f2, f3, f4, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, this.stroke, f, f2, f3, f4);
            return;
        }
        if (BaseShaderGraphics.canUseStrokeShader(this.stroke)) {
            this.renderGeneralRoundedRect(f, f2, f3, f4, 0.0f, 0.0f, BaseShaderContext.MaskType.DRAW_PGRAM, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(f, f2, f3, f4, 0.0f, 0.0f);
        this.renderShape(scratchRRect, this.stroke, f, f2, f3, f4);
    }

    private boolean checkInnerCurvature(float f, float f2) {
        float f3 = this.stroke.getLineWidth() * (1.0f - BaseShaderGraphics.getStrokeExpansionFactor(this.stroke));
        return (f -= f3) <= 0.0f || (f2 -= f3) <= 0.0f || f * 2.0f > f2 && f2 * 2.0f > f;
    }

    @Override
    public void drawEllipse(float f, float f2, float f3, float f4) {
        if (f3 < 0.0f || f4 < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(f3, f4)) {
            this.renderGeneralRoundedRect(f, f2, f3, f4, f3, f4, BaseShaderContext.MaskType.DRAW_ELLIPSE, this.stroke);
            return;
        }
        scratchEllipse.setFrame(f, f2, f3, f4);
        this.renderShape(scratchEllipse, this.stroke, f, f2, f3, f4);
    }

    @Override
    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
        f5 = Math.min(Math.abs(f5), f3);
        f6 = Math.min(Math.abs(f6), f4);
        if (f3 < 0.0f || f4 < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(f5, f6)) {
            this.renderGeneralRoundedRect(f, f2, f3, f4, f5, f6, BaseShaderContext.MaskType.DRAW_ROUNDRECT, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(f, f2, f3, f4, f5, f6);
        this.renderShape(scratchRRect, this.stroke, f, f2, f3, f4);
    }

    @Override
    public void drawLine(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        BaseTransform baseTransform;
        float f7;
        float f8;
        float f9;
        float f10;
        if (f <= f3) {
            f10 = f;
            f9 = f3 - f;
        } else {
            f10 = f3;
            f9 = f - f3;
        }
        if (f2 <= f4) {
            f8 = f2;
            f7 = f4 - f2;
        } else {
            f8 = f4;
            f7 = f2 - f4;
        }
        if (this.stroke.getType() == 1) {
            return;
        }
        if (this.isComplexPaint) {
            scratchLine.setLine(f, f2, f3, f4);
            this.renderWithComplexPaint(scratchLine, this.stroke, f10, f8, f9, f7);
            return;
        }
        int n = this.stroke.getEndCap();
        if (n == 1 || this.stroke.isDashed()) {
            scratchLine.setLine(f, f2, f3, f4);
            this.renderShape(scratchLine, this.stroke, f10, f8, f9, f7);
            return;
        }
        float f11 = this.stroke.getLineWidth();
        float f12 = f3 - f;
        float f13 = f4 - f2;
        BaseTransform baseTransform2 = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            double d = baseTransform2.getMxt();
            double d2 = baseTransform2.getMyt();
            f = (float)((double)f + d);
            f2 = (float)((double)f2 + d2);
            f3 = (float)((double)f3 + d);
            f4 = (float)((double)f4 + d2);
            baseTransform = IDENT;
        } else {
            baseTransform = this.extract3Dremainder(baseTransform2);
            double[] dArray = new double[]{f, f2, f3, f4};
            baseTransform2.transform(dArray, 0, dArray, 0, 2);
            f = (float)dArray[0];
            f2 = (float)dArray[1];
            f3 = (float)dArray[2];
            f4 = (float)dArray[3];
        }
        f12 = f3 - f;
        f13 = f4 - f2;
        float f14 = BaseShaderGraphics.len(f12, f13);
        if (f14 == 0.0f) {
            if (n == 0) {
                return;
            }
            f6 = f11;
            f5 = 0.0f;
        } else {
            f6 = f11 * f12 / f14;
            f5 = f11 * f13 / f14;
        }
        if (this.stroke.getType() == 2) {
            f6 *= 2.0f;
            f5 *= 2.0f;
        }
        float f15 = f + f5 / 2.0f;
        float f16 = f2 - f6 / 2.0f;
        if (n == 2) {
            f15 -= f6 / 2.0f;
            f16 -= f5 / 2.0f;
            f12 += f6;
            f13 += f5;
        }
        this.renderGeneralRoundedPgram(f15, f16, -f5, f6, f12, f13, 0.0f, 0.0f, 0.0f, 0.0f, baseTransform, BaseShaderContext.MaskType.FILL_PGRAM, f10, f8, f9, f7);
    }

    private static float len(float f, float f2) {
        return f == 0.0f ? Math.abs(f2) : (f2 == 0.0f ? Math.abs(f) : (float)Math.sqrt(f * f + f2 * f2));
    }

    @Override
    public void drawString(String string, FontStrike fontStrike, float f, float f2) {
        this.drawString(string, fontStrike, f, f2, null, 0, 0);
    }

    @Override
    public void drawString(String string, FontStrike fontStrike, float f, float f2, Color color, int n, int n2) {
        Object object;
        float f3;
        if (this.isComplexPaint || fontStrike.drawAsShapes()) {
            BaseTransform baseTransform = BaseTransform.getTranslateInstance(f, f2);
            Shape shape = fontStrike.getOutline(string, baseTransform);
            this.fill(shape);
            return;
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f = Math.round(f);
            f2 = Math.round(f2);
        }
        if (!(fontStrike.getAAMode() != 4 || this.getRenderTarget().isOpaque() && baseTransform.isIdentity())) {
            FontResource fontResource = fontStrike.getFontResource();
            f3 = fontStrike.getSize();
            BaseTransform baseTransform2 = fontStrike.getTransform();
            fontStrike = fontResource.getStrike(f3, baseTransform2, 2);
        }
        float f4 = 0.0f;
        f3 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.paint.getType().isGradient() && ((Gradient)this.paint).isProportional()) {
            object = fontStrike.getStringBounds(string);
            f4 = f;
            f3 = f2 + fontStrike.getMetrics().getAscent();
            f5 = ((RectBounds)object).getWidth();
            f6 = ((RectBounds)object).getHeight();
        }
        object = new Point2D(f, f2);
        baseTransform.transform((Point2D)object, (Point2D)object);
        f = ((Point2D)object).x;
        f2 = ((Point2D)object).y;
        GlyphCache glyphCache = this.context.getGlyphCache(fontStrike);
        Texture texture = glyphCache.getBackingStore();
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (fontStrike.getAAMode() == 4 && this.getRenderTarget().isOpaque()) {
            this.context.flushVertexBuffer();
            this.context.validateLCDBuffer(this.getRenderTarget());
            int n3 = this.getRenderTarget().getPhysicalHeight();
            int n4 = this.getRenderTarget().getPhysicalWidth();
            int n5 = this.context.getLCDBuffer().getPhysicalHeight();
            int n6 = this.context.getLCDBuffer().getPhysicalWidth();
            RectBounds rectBounds = fontStrike.getStringBounds(string);
            f4 = f - 1.0f;
            f3 = f2 + fontStrike.getMetrics().getAscent();
            f5 = rectBounds.getWidth() + 2.0f;
            f6 = rectBounds.getHeight() + 1.0f;
            BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)this.context.getLCDBuffer().createGraphics();
            this.context.validateLCDOp(baseShaderGraphics, baseTransform, (Texture)((Object)this.getRenderTarget()), texture, true);
            f7 = f4 / (float)n4;
            f8 = f3 / (float)n3;
            f10 = (f4 + f5) / (float)n4;
            f9 = (f3 + f6) / (float)n3;
            baseShaderGraphics.drawLCDBuffer(f4, f3, f5, f6, f7, f8, f10, f9);
            this.context.flushVertexBuffer();
            this.context.setRenderTarget(this);
            Shader shader = this.context.validateLCDOp(this, baseTransform, this.context.getLCDBuffer(), texture, false);
            float f11 = 1.3f;
            float f12 = 0.7692308f;
            shader.setConstant("invGamma", f12);
            shader.setConstant("gamma", f11);
            Color color2 = (Color)this.getPaint();
            shader.setConstant("srcClr", (float)Math.pow(color2.getRed(), f11), (float)Math.pow(color2.getGreen(), f11), (float)Math.pow(color2.getBlue(), f11), (float)Math.pow(color2.getAlpha(), f11));
            glyphCache.renderLCD(this.context, string, f, f2, n6, n5);
            this.context.flushVertexBuffer();
        } else {
            this.context.validatePaintOp(this, BaseTransform.IDENTITY_TRANSFORM, texture, f4, f3, f5, f6);
            if (color != null && n != n2 && this.getPaint() instanceof Color) {
                glyphCache.renderWithColorRange(this.context, string, f, f2, n, n2, color, (Color)this.getPaint());
            } else {
                glyphCache.render(this.context, string, f, f2);
            }
        }
    }

    private void drawLCDBuffer(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.context.setRenderTarget(this);
        this.context.getVertexBuffer().addQuad(f, f2, f + f3, f2 + f4, f5, f6, f7, f8);
    }

    @Override
    public boolean canReadBack() {
        RenderTarget renderTarget = this.getRenderTarget();
        return renderTarget instanceof ReadbackRenderTarget && ((ReadbackRenderTarget)renderTarget).getBackBuffer() != null;
    }

    @Override
    public RTTexture readBack(Rectangle rectangle) {
        RenderTarget renderTarget = this.getRenderTarget();
        this.context.flushVertexBuffer();
        this.context.validateLCDBuffer(renderTarget);
        RTTexture rTTexture = this.context.getLCDBuffer();
        Texture texture = ((ReadbackRenderTarget)renderTarget).getBackBuffer();
        float f = rectangle.x;
        float f2 = rectangle.y;
        float f3 = f + (float)rectangle.width;
        float f4 = f2 + (float)rectangle.height;
        BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)rTTexture.createGraphics();
        baseShaderGraphics.setCompositeMode(CompositeMode.SRC);
        this.context.validateTextureOp((BaseGraphics)baseShaderGraphics, IDENT, texture, texture.getPixelFormat());
        baseShaderGraphics.drawTexture(texture, 0.0f, 0.0f, rectangle.width, rectangle.height, f, f2, f3, f4);
        this.context.flushVertexBuffer();
        this.context.setRenderTarget(this);
        return rTTexture;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture rTTexture) {
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("prism.primshaderpad");
            }
        });
        if (string == null) {
            FRINGE_FACTOR = -0.5f;
        } else {
            FRINGE_FACTOR = -Float.valueOf(string).floatValue();
            System.out.println("Prism ShaderGraphics primitive shader pad = " + FRINGE_FACTOR);
        }
        SQRT_2 = Math.sqrt(2.0);
    }
}

