/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class BaseResourceFactory
implements ResourceFactory {
    private static final Map<Image, Texture> texCache = new WeakHashMap<Image, Texture>();
    private final ArrayList<WeakReference<ResourceFactoryListener>> listeners = new ArrayList(1);

    @Override
    public void addFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        this.listeners.add(new WeakReference<ResourceFactoryListener>(resourceFactoryListener));
    }

    @Override
    public void removeFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        ListIterator<WeakReference<ResourceFactoryListener>> listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            ResourceFactoryListener resourceFactoryListener2 = (ResourceFactoryListener)listIterator.next().get();
            if (resourceFactoryListener2 != null && resourceFactoryListener != resourceFactoryListener2) continue;
            listIterator.remove();
        }
    }

    @Override
    public boolean isDeviceReady() {
        return true;
    }

    protected void notifyReset() {
        WeakReference[] weakReferenceArray;
        texCache.clear();
        for (WeakReference weakReference : weakReferenceArray = this.listeners.toArray(new WeakReference[0])) {
            ResourceFactoryListener resourceFactoryListener;
            ResourceFactoryListener resourceFactoryListener2 = resourceFactoryListener = weakReference == null ? null : (ResourceFactoryListener)weakReference.get();
            if (resourceFactoryListener == null) continue;
            resourceFactoryListener.factoryReset();
        }
    }

    protected void notifyReleased() {
        WeakReference[] weakReferenceArray;
        texCache.clear();
        for (WeakReference weakReference : weakReferenceArray = this.listeners.toArray(new WeakReference[0])) {
            ResourceFactoryListener resourceFactoryListener;
            ResourceFactoryListener resourceFactoryListener2 = resourceFactoryListener = weakReference == null ? null : (ResourceFactoryListener)weakReference.get();
            if (resourceFactoryListener == null) continue;
            resourceFactoryListener.factoryReleased();
        }
    }

    @Override
    public boolean isOffscreenRenderingSupported() {
        return true;
    }

    @Override
    public Texture getCachedTexture(Image image) {
        return this.getCachedTexture(image, true);
    }

    @Override
    public Texture getCachedTexture(Image image, boolean bl) {
        if (image == null) {
            throw new IllegalArgumentException("Image must be non-null");
        }
        Texture texture = texCache.get(image);
        if (texture == null) {
            texture = this.createTexture(image, Texture.Usage.DEFAULT, bl);
            texCache.put(image, texture);
        }
        return texture;
    }

    @Override
    public Texture createTexture(Image image) {
        return this.createTexture(image, Texture.Usage.DEFAULT, true);
    }

    @Override
    public Texture createTexture(Image image, Texture.Usage usage, boolean bl) {
        int n;
        int n2;
        PixelFormat pixelFormat = image.getPixelFormat();
        Texture texture = this.createTexture(pixelFormat, usage, n2 = image.getWidth(), n = image.getHeight(), bl);
        if (texture != null) {
            texture.update(image, 0, 0, n2, n, true);
        }
        return texture;
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, int n, int n2) {
        return this.createTexture(pixelFormat, usage, n, n2, true);
    }

    @Override
    public Texture createMaskTexture(int n, int n2) {
        return this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DEFAULT, n, n2, false);
    }

    @Override
    public Texture createFloatTexture(int n, int n2) {
        return this.createTexture(PixelFormat.FLOAT_XYZW, Texture.Usage.DEFAULT, n, n2, false);
    }
}

