/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.RectShadowGraphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public abstract class BaseGraphics
implements RectShadowGraphics {
    private static final PrismCameraImpl DEFAULT_CAMERA = PrismParallelCameraImpl.getInstance();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f);
    private static final Paint DEFAULT_PAINT = Color.WHITE;
    protected static final RoundRectangle2D scratchRRect = new RoundRectangle2D();
    protected static final Ellipse2D scratchEllipse = new Ellipse2D();
    protected static final Line2D scratchLine = new Line2D();
    protected static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    private final Affine3D transform3D = new Affine3D();
    private PrismCameraImpl camera = DEFAULT_CAMERA;
    private RectBounds devClipRect;
    private RectBounds finalClipRect;
    private Rectangle clipRect;
    private int clipRectIndex;
    private boolean hasPreCullingBits = false;
    private float extraAlpha = 1.0f;
    private CompositeMode compMode;
    private boolean depthBuffer = false;
    private boolean depthTest = false;
    protected Paint paint = DEFAULT_PAINT;
    protected BasicStroke stroke = DEFAULT_STROKE;
    protected boolean isSimpleTranslate = true;
    protected float transX;
    protected float transY;
    private final BaseContext context;
    private final RenderTarget renderTarget;
    private GeneralTransform3D pvTx;

    protected BaseGraphics(BaseContext baseContext, RenderTarget renderTarget) {
        this.context = baseContext;
        this.renderTarget = renderTarget;
        int n = renderTarget.getContentX();
        int n2 = renderTarget.getContentY();
        this.devClipRect = new RectBounds(n, n2, renderTarget.getContentWidth() - n, renderTarget.getContentHeight() - n2);
        this.finalClipRect = new RectBounds(this.devClipRect);
        this.compMode = CompositeMode.SRC_OVER;
        if (baseContext != null) {
            baseContext.setRenderTarget(this);
        }
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.context.getResourceFactory();
    }

    @Override
    public BaseTransform getTransformNoClone() {
        return this.transform3D;
    }

    @Override
    public void setTransform(BaseTransform baseTransform) {
        if (baseTransform == null) {
            this.transform3D.setToIdentity();
        } else {
            this.transform3D.setTransform(baseTransform);
        }
        this.validateTransformAndPaint();
    }

    @Override
    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.transform3D.setTransform(d, d2, d3, d4, d5, d6);
        this.validateTransformAndPaint();
    }

    @Override
    public void setTransform3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.transform3D.setTransform(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.validateTransformAndPaint();
    }

    @Override
    public void transform(BaseTransform baseTransform) {
        this.transform3D.concatenate(baseTransform);
        this.validateTransformAndPaint();
    }

    @Override
    public void translate(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            this.transform3D.translate(f, f2);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void translate(float f, float f2, float f3) {
        if (f != 0.0f || f2 != 0.0f || f3 != 0.0f) {
            this.transform3D.translate(f, f2, f3);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void scale(float f, float f2) {
        if (f != 1.0f || f2 != 1.0f) {
            this.transform3D.scale(f, f2);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void scale(float f, float f2, float f3) {
        if (f != 1.0f || f2 != 1.0f || f3 != 1.0f) {
            this.transform3D.scale(f, f2, f3);
            this.validateTransformAndPaint();
        }
    }

    @Override
    public void setWindowProjViewTx(GeneralTransform3D generalTransform3D) {
        this.pvTx = generalTransform3D;
    }

    @Override
    public GeneralTransform3D getWindowProjViewTxNoClone() {
        return this.pvTx;
    }

    @Override
    public void setClipRectIndex(int n) {
        this.clipRectIndex = n;
    }

    @Override
    public int getClipRectIndex() {
        return this.clipRectIndex;
    }

    @Override
    public void setHasPreCullingBits(boolean bl) {
        this.hasPreCullingBits = bl;
    }

    @Override
    public boolean hasPreCullingBits() {
        return this.hasPreCullingBits;
    }

    private void validateTransformAndPaint() {
        if (this.transform3D.isTranslateOrIdentity() && this.paint.getType() == Paint.Type.COLOR) {
            this.isSimpleTranslate = true;
            this.transX = (float)this.transform3D.getMxt();
            this.transY = (float)this.transform3D.getMyt();
        } else {
            this.isSimpleTranslate = false;
            this.transX = 0.0f;
            this.transY = 0.0f;
        }
    }

    @Override
    public PrismCameraImpl getCameraNoClone() {
        return this.camera;
    }

    @Override
    public boolean hasOrthoCamera() {
        return this.camera == DEFAULT_CAMERA;
    }

    @Override
    public void setDepthTest(boolean bl) {
        this.depthTest = bl;
    }

    @Override
    public boolean isDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthBuffer(boolean bl) {
        this.depthBuffer = bl;
    }

    @Override
    public boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    @Override
    public void setCamera(PrismCameraImpl prismCameraImpl) {
        this.camera = prismCameraImpl;
    }

    @Override
    public Rectangle getClipRect() {
        return this.clipRect != null ? new Rectangle(this.clipRect) : null;
    }

    @Override
    public Rectangle getClipRectNoClone() {
        return this.clipRect;
    }

    @Override
    public RectBounds getFinalClipNoClone() {
        return this.finalClipRect;
    }

    @Override
    public void setClipRect(Rectangle rectangle) {
        this.finalClipRect.setBounds(this.devClipRect);
        if (rectangle == null) {
            this.clipRect = null;
        } else {
            this.clipRect = new Rectangle(rectangle);
            this.finalClipRect.intersectWith(rectangle);
        }
    }

    @Override
    public float getExtraAlpha() {
        return this.extraAlpha;
    }

    @Override
    public void setExtraAlpha(float f) {
        this.extraAlpha = f;
    }

    @Override
    public CompositeMode getCompositeMode() {
        return this.compMode;
    }

    @Override
    public void setCompositeMode(CompositeMode compositeMode) {
        this.compMode = compositeMode;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        this.validateTransformAndPaint();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
    }

    @Override
    public void clear() {
        this.clear(Color.TRANSPARENT);
    }

    public abstract void fillTriangles(VertexBuffer var1, int var2, float var3, float var4, float var5, float var6);

    protected abstract void renderShape(Shape var1, BasicStroke var2, float var3, float var4, float var5, float var6);

    @Override
    public void fill(Shape shape) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.paint.isProportional()) {
            RectBounds rectBounds = shape.getBounds();
            f = rectBounds.getMinX();
            f2 = rectBounds.getMinY();
            f3 = rectBounds.getWidth();
            f4 = rectBounds.getHeight();
        }
        this.renderShape(shape, null, f, f2, f3, f4);
    }

    @Override
    public void draw(Shape shape) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.paint.isProportional()) {
            RectBounds rectBounds = shape.getBounds();
            f = rectBounds.getMinX();
            f2 = rectBounds.getMinY();
            f3 = rectBounds.getWidth();
            f4 = rectBounds.getHeight();
        }
        this.renderShape(shape, this.stroke, f, f2, f3, f4);
    }

    @Override
    public void drawTexture(Texture texture, float f, float f2, float f3, float f4) {
        this.drawTexture(texture, f, f2, f + f3, f2 + f4, 0.0f, 0.0f, f3, f4);
    }

    @Override
    public void drawTexture(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.drawTextureVO(texture, 1.0f, 1.0f, f, f2, f3, f4, f5, f6, f7, f8);
    }

    @Override
    public void drawTextureVO(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        PixelFormat pixelFormat;
        float f11 = f3;
        float f12 = f4;
        float f13 = f5 - f3;
        float f14 = f6 - f4;
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f3 += this.transX;
            f4 += this.transY;
            f5 += this.transX;
            f6 += this.transY;
        }
        if ((pixelFormat = texture.getPixelFormat()) == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, baseTransform, texture, f11, f12, f13, f14);
        } else {
            this.context.validateTextureOp(this, baseTransform, texture, pixelFormat);
        }
        float f15 = texture.getPhysicalWidth();
        float f16 = texture.getPhysicalHeight();
        float f17 = texture.getContentX();
        float f18 = texture.getContentY();
        float f19 = (f17 + f7) / f15;
        float f20 = (f18 + f8) / f16;
        float f21 = (f17 + f9) / f15;
        float f22 = (f18 + f10) / f16;
        Texture.WrapMode wrapMode = texture.getWrapMode();
        texture.setWrapMode(Texture.WrapMode.CLAMP_TO_EDGE);
        boolean bl = f17 == 0.0f && f18 == 0.0f && f7 == 0.0f && f8 == 0.0f;
        boolean bl2 = f9 == f15 && f10 == f16 && bl;
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        if (baseTransform.isTranslateOrIdentity() || !texture.getLinearFiltering() || bl2) {
            if (f == 1.0f && f2 == 1.0f) {
                vertexBuffer.addQuad(f3, f4, f5, f6, f19, f20, f21, f22);
            } else {
                vertexBuffer.addQuadVO(f, f2, f3, f4, f5, f6, f19, f20, f21, f22);
            }
        } else {
            float f23 = f19 + 1.0f / (2.0f * f15);
            float f24 = f20 + 1.0f / (2.0f * f16);
            float f25 = f21 - 1.0f / (2.0f * f15);
            float f26 = f22 - 1.0f / (2.0f * f16);
            float f27 = f23 + 1.0E-4f;
            float f28 = f24 + 1.0E-4f;
            float f29 = f25 - 1.0E-4f;
            float f30 = f26 - 1.0E-4f;
            float f31 = f3 + 0.5f;
            float f32 = f4 + 0.5f;
            float f33 = f5 - 0.5f;
            float f34 = f6 - 0.5f;
            if (bl) {
                vertexBuffer.addQuadVO(f, f2, f3, f4, f33, f34, f19, f20, f25, f26);
                vertexBuffer.addQuadVO(f, f2, f33, f4, f5, f34, f29, f20, f25, f26);
                vertexBuffer.addQuadVO(f2, f2, f3, f34, f33, f6, f19, f30, f25, f26);
                vertexBuffer.addQuadVO(f2, f2, f33, f34, f5, f6, f29, f30, f25, f26);
            } else {
                vertexBuffer.addQuadVO(f, f2, f31, f32, f33, f34, f23, f24, f25, f26);
                vertexBuffer.addQuadVO(f, f2, f3, f32, f31, f34, f23, f24, f27, f26);
                vertexBuffer.addQuadVO(f, f2, f33, f32, f5, f34, f29, f24, f25, f26);
                vertexBuffer.addQuadVO(f, f, f31, f4, f33, f32, f23, f24, f25, f28);
                vertexBuffer.addQuadVO(f2, f2, f31, f34, f33, f6, f23, f30, f25, f26);
                vertexBuffer.addQuadVO(f, f, f3, f4, f31, f32, f23, f24, f27, f28);
                vertexBuffer.addQuadVO(f, f, f33, f4, f5, f32, f29, f24, f25, f28);
                vertexBuffer.addQuadVO(f2, f2, f3, f34, f31, f6, f23, f30, f27, f26);
                vertexBuffer.addQuadVO(f2, f2, f33, f34, f5, f6, f29, f30, f25, f26);
            }
        }
        texture.setWrapMode(wrapMode);
    }

    @Override
    public void drawTextureRaw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        PixelFormat pixelFormat;
        float f9 = f;
        float f10 = f2;
        float f11 = f3 - f;
        float f12 = f4 - f2;
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f3 += this.transX;
            f4 += this.transY;
        }
        if ((pixelFormat = texture.getPixelFormat()) == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, baseTransform, texture, f9, f10, f11, f12);
        } else {
            this.context.validateTextureOp(this, baseTransform, texture, pixelFormat);
        }
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @Override
    public void drawMappedTextureRaw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        PixelFormat pixelFormat;
        float f13 = f;
        float f14 = f2;
        float f15 = f3 - f;
        float f16 = f4 - f2;
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f += this.transX;
            f2 += this.transY;
            f3 += this.transX;
            f4 += this.transY;
        }
        if ((pixelFormat = texture.getPixelFormat()) == PixelFormat.BYTE_ALPHA) {
            this.context.validatePaintOp(this, baseTransform, texture, f13, f14, f15, f16);
        } else {
            this.context.validateTextureOp(this, baseTransform, texture, pixelFormat);
        }
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addMappedQuad(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }
}

