/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.d3d.D3DContext;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.paint.Color;
import java.nio.Buffer;

class D3DVertexBuffer
extends VertexBuffer {
    private D3DContext context;
    private int color;

    D3DVertexBuffer(D3DContext d3DContext, int n, boolean bl) {
        super(n, bl);
        this.context = d3DContext;
    }

    @Override
    public void setPerVertexColor(Color color, float f) {
        float f2 = color.getAlpha() * f;
        int n = (int)(color.getRed() * f2 * 255.0f);
        int n2 = (int)(color.getGreen() * f2 * 255.0f);
        int n3 = (int)(color.getBlue() * f2 * 255.0f);
        int n4 = (int)(f2 * 255.0f);
        this.color = n4 << 24 | n << 16 | n2 << 8 | n3;
    }

    @Override
    public void setPerVertexColor(float f) {
        int n = (int)(f * 255.0f);
        this.color = n << 24 | n << 16 | n << 8 | n;
    }

    @Override
    public void putColor() {
        this.buf.putInt(this.color);
    }

    @Override
    public void putColor(float f) {
        int n = (int)(f * 255.0f);
        int n2 = n << 24 | n << 16 | n << 8 | n;
        this.buf.putInt(n2);
    }

    @Override
    public void putColor(int n, float f, float f2, float f3, float f4) {
        int n2 = n * 32 + 12;
        int n3 = (int)(f * 255.0f);
        int n4 = (int)(f2 * 255.0f);
        int n5 = (int)(f3 * 255.0f);
        int n6 = (int)(f4 * 255.0f);
        int n7 = n6 << 24 | n3 << 16 | n4 << 8 | n5;
        this.buf.putInt(n2, n7);
    }

    @Override
    public void putColor(int n, float f) {
        int n2 = n * 32 + 12;
        int n3 = (int)(f * 255.0f);
        int n4 = n3 << 24 | n3 << 16 | n3 << 8 | n3;
        this.buf.putInt(n2, n4);
    }

    @Override
    protected void flush(int n) {
        if (this.isLightweight) {
            throw new InternalError("Should not be called for lightweight vertex buffers");
        }
        long l = D3DVertexBuffer.nFlush(this.context.getContextHandle(), this.buf, n);
        this.context.validate(l);
    }

    private static native long nFlush(long var0, Buffer var2, int var3);
}

