/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMedia
extends Media {
    private long refNativeMedia;
    private int[] preferredPixelFormats = null;
    private final Object markerMutex = new Object();
    private boolean isDisposed = false;

    private native int nativeInitNativeMedia(Locator var1, String var2, long var3, boolean var5, long[] var6);

    private native int nativeAddMarker(long var1, String var3, double var4);

    private native int nativeRemoveMarker(long var1, String var3, double[] var4);

    private native int nativeRemoveAllMarkers(long var1);

    private native int nativeGetMarkers(long var1, Map<String, Double> var3);

    private native void nativeDispose(long var1);

    NativeMedia(Locator locator, Track[] tracks, boolean isForPlayback) {
        super(locator, tracks);
        long[] nativeMediaHandle = new long[1];
        MediaError ret = MediaError.getFromCode(this.nativeInitNativeMedia(locator, locator.getContentType(), locator.getContentLength(), isForPlayback, nativeMediaHandle));
        if (ret != MediaError.ERROR_NONE) {
            MediaUtils.nativeError(this, ret);
        }
        this.refNativeMedia = nativeMediaHandle[0];
    }

    long getNativeMediaRef() {
        return this.refNativeMedia;
    }

    @Override
    public void addTrack(Track track) {
        super.addTrack(track);
    }

    @Override
    public void addMetadata(Map<String, Object> metadata) {
        super.addMetadata(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMarker(String markerName, double presentationTime) {
        if (markerName == null) {
            throw new IllegalArgumentException("markerName == null!");
        }
        if (presentationTime < 0.0) {
            throw new IllegalArgumentException("presentationTime < 0.0!");
        }
        Object object = this.markerMutex;
        synchronized (object) {
            this.nativeAddMarker(this.refNativeMedia, markerName, presentationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Double> getMarkers() {
        Object object = this.markerMutex;
        synchronized (object) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            MediaError ret = MediaError.getFromCode(this.nativeGetMarkers(this.refNativeMedia, map));
            if (ret != MediaError.ERROR_NONE) {
                MediaUtils.nativeError(this, ret);
            }
            return map.isEmpty() ? null : Collections.unmodifiableMap(new HashMap<String, Double>(map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double removeMarker(String markerName) {
        if (markerName == null) {
            throw new IllegalArgumentException("markerName == null!");
        }
        Object object = this.markerMutex;
        synchronized (object) {
            double[] markerTime = new double[1];
            MediaError ret = MediaError.getFromCode(this.nativeRemoveMarker(this.refNativeMedia, markerName, markerTime));
            if (ret != MediaError.ERROR_NONE) {
                MediaUtils.nativeError(this, ret);
            }
            return markerTime[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMarkers() {
        Object object = this.markerMutex;
        synchronized (object) {
            MediaError ret = MediaError.getFromCode(this.nativeRemoveAllMarkers(this.refNativeMedia));
            if (ret != MediaError.ERROR_NONE) {
                MediaUtils.nativeError(this, ret);
            }
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.nativeDispose(this.refNativeMedia);
            this.isDisposed = true;
            this.refNativeMedia = 0L;
        }
    }
}

