/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.effects.AudioSpectrum;

public class NativeAudioSpectrum
implements AudioSpectrum {
    private static float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static int DEFAULT_BANDS = 128;
    public static double DEFAULT_INTERVAL = 0.1;
    public static int DEFAULT_THRESHOLD = -60;
    private long refMedia;
    private float[] magnitudes = EMPTY_FLOAT_ARRAY;
    private float[] phases = EMPTY_FLOAT_ARRAY;

    private native boolean nativeGetEnabled(long var1);

    private native void nativeSetEnabled(long var1, boolean var3);

    private native void nativeSetBands(long var1, int var3, float[] var4, float[] var5);

    private native double nativeGetInterval(long var1);

    private native void nativeSetInterval(long var1, double var3);

    private native int nativeGetThreshold(long var1);

    private native void nativeSetThreshold(long var1, int var3);

    NativeAudioSpectrum(long refMedia) {
        if (refMedia == 0L) {
            throw new IllegalArgumentException("Invalid native media reference");
        }
        this.refMedia = refMedia;
        this.setBandsAmount(DEFAULT_BANDS);
    }

    public boolean getEnabled() {
        return this.nativeGetEnabled(this.refMedia);
    }

    public void setEnabled(boolean enabled) {
        this.nativeSetEnabled(this.refMedia, enabled);
    }

    public void setBandsAmount(int bands) {
        if (bands > 1) {
            this.magnitudes = new float[bands];
            for (int i = 0; i < this.magnitudes.length; ++i) {
                this.magnitudes[i] = Float.NEGATIVE_INFINITY;
            }
        } else {
            this.magnitudes = EMPTY_FLOAT_ARRAY;
            this.phases = EMPTY_FLOAT_ARRAY;
            throw new IllegalArgumentException("Number of bands must at least be 2");
        }
        this.phases = new float[bands];
        this.nativeSetBands(this.refMedia, bands, this.magnitudes, this.phases);
    }

    public double getInterval() {
        return this.nativeGetInterval(this.refMedia);
    }

    public void setInterval(double interval) {
        if (!(interval * 1.0E9 >= 1.0)) {
            throw new IllegalArgumentException("Interval can't be less that 1 nanosecond");
        }
        this.nativeSetInterval(this.refMedia, interval);
    }

    public int getSensitivityThreshold() {
        return this.nativeGetThreshold(this.refMedia);
    }

    public void setSensitivityThreshold(int threshold) {
        if (threshold > 0) {
            throw new IllegalArgumentException(String.format("Sensitivity threshold must be less than 0: %d", threshold));
        }
        this.nativeSetThreshold(this.refMedia, threshold);
    }

    public float[] getMagnitudes() {
        return this.magnitudes;
    }

    public float[] getPhases() {
        return this.phases;
    }
}

