/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CountDownLatch;

public class Locator {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private static final long CONNECTION_RETRY_INTERVAL = 1000L;
    protected String contentType = "application/octet-stream";
    protected long contentLength = -1L;
    protected URI uri;
    private String uriString = null;
    private String scheme = null;
    private String protocol = null;
    private boolean canBlock = false;
    private CountDownLatch readySignal = new CountDownLatch(1);

    private static LocatorConnection getConnection(URI uri, final String requestMethod) throws MalformedURLException, IOException {
        LocatorConnection locatorConnection = null;
        final URI uri2 = uri;
        locatorConnection = AccessController.doPrivileged(new PrivilegedAction<LocatorConnection>(){

            @Override
            public LocatorConnection run() {
                try {
                    LocatorConnection locatorConnection = new LocatorConnection();
                    HttpURLConnection connection = (HttpURLConnection)uri2.toURL().openConnection();
                    connection.setRequestMethod(requestMethod);
                    locatorConnection.responseCode = connection.getResponseCode();
                    if (connection.getResponseCode() == 200) {
                        locatorConnection.connection = connection;
                        return locatorConnection;
                    }
                    connection.disconnect();
                    locatorConnection.connection = null;
                    return locatorConnection;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        return locatorConnection;
    }

    private InputStream getInputStream(URI uri) throws MalformedURLException, IOException {
        final URL url = uri.toURL();
        final URLConnection connection = url.openConnection();
        InputStream inputStream = null;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    Locator.this.contentLength = connection.getContentLength();
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return inputStream;
    }

    public Locator(URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new NullPointerException("uri == null!");
        }
        this.uriString = uri.toASCIIString();
        this.scheme = uri.getScheme();
        if (this.scheme == null) {
            throw new IllegalArgumentException("uri.getScheme() == null!");
        }
        this.scheme = this.scheme.toLowerCase();
        if (this.scheme.equals("jar")) {
            URI subURI = new URI(this.uriString.substring(4));
            this.protocol = subURI.getScheme();
            if (this.protocol == null) {
                throw new IllegalArgumentException("uri.getScheme() == null!");
            }
            this.protocol = this.protocol.toLowerCase();
        } else {
            this.protocol = this.scheme;
        }
        if (!this.protocol.equals("file") && !this.protocol.equals("http")) {
            throw new UnsupportedOperationException("Unsupported protocol \"" + this.protocol + "\"");
        }
        if (this.protocol.equals("http")) {
            this.canBlock = true;
        }
        this.uri = uri;
    }

    public boolean canBlock() {
        return this.canBlock;
    }

    public void init() throws URISyntaxException, IOException, FileNotFoundException {
        try {
            int index;
            int firstSlash = this.uriString.indexOf("/");
            if (firstSlash != -1 && this.uriString.charAt(firstSlash + 1) != '/') {
                if (this.protocol.equals("file")) {
                    this.uriString = this.uriString.replaceFirst("/", "///");
                } else if (this.protocol.equals("http")) {
                    this.uriString = this.uriString.replaceFirst("/", "//");
                }
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1 && this.protocol.equals("file") && (index = this.uriString.indexOf("/~/")) != -1) {
                this.uriString = this.uriString.substring(0, index) + System.getProperty("user.home") + this.uriString.substring(index + 2);
            }
            this.uri = new URI(this.uriString);
            boolean isConnected = false;
            boolean isMediaUnAvailable = false;
            boolean isMediaSupported = true;
            for (int numConnectionAttempts = 0; numConnectionAttempts < 5; ++numConnectionAttempts) {
                block30: {
                    try {
                        if (this.scheme.equals("http")) {
                            LocatorConnection locatorConnection = null;
                            locatorConnection = Locator.getConnection(this.uri, "HEAD");
                            if (locatorConnection == null || locatorConnection.connection == null) {
                                locatorConnection = Locator.getConnection(this.uri, "GET");
                            }
                            if (locatorConnection != null && locatorConnection.connection != null) {
                                isConnected = true;
                                this.contentType = locatorConnection.connection.getContentType();
                                this.contentLength = locatorConnection.connection.getContentLength();
                                locatorConnection.connection.disconnect();
                            } else if (locatorConnection != null && locatorConnection.responseCode == 404) {
                                isMediaUnAvailable = true;
                            }
                        } else if (this.scheme.equals("file") || this.scheme.equals("jar")) {
                            InputStream stream = this.getInputStream(this.uri);
                            stream.close();
                            isConnected = true;
                            this.contentType = MediaUtils.filenameToContentType(this.uriString);
                        }
                        if (isConnected) {
                            if (this.contentType.equals("audio/x-wav")) {
                                this.contentType = this.getContentTypeFromFileSignature(this.uri);
                                if (MediaManager.canPlayContentType(this.contentType)) break;
                                isMediaSupported = false;
                                break;
                            }
                            if (MediaManager.canPlayContentType(this.contentType)) break;
                            this.contentType = MediaUtils.filenameToContentType(this.uriString);
                            if (this.contentType.equals(DEFAULT_CONTENT_TYPE)) {
                                this.contentType = this.getContentTypeFromFileSignature(this.uri);
                            }
                            if (MediaManager.canPlayContentType(this.contentType)) break;
                            isMediaSupported = false;
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        if (numConnectionAttempts + 1 < 5) break block30;
                        throw ioe;
                    }
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (!isConnected) {
                if (isMediaUnAvailable) {
                    throw new FileNotFoundException("media is unavailable (" + this.uri.toString() + ")");
                }
                throw new IOException("could not connect to media (" + this.uri.toString() + ")");
            }
            if (!isMediaSupported) {
                throw new MediaException("media type not supported (" + this.uri.toString() + ")");
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (MediaException e) {
            throw e;
        }
        finally {
            this.readySignal.countDown();
        }
    }

    public String getContentType() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.contentType;
    }

    public long getContentLength() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.contentLength;
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return "{LocatorURI uri: " + this.uri.toString() + "}";
    }

    public String getStringLocation() {
        return this.uri.toString();
    }

    public ConnectionHolder createConnectionHolder() throws IOException {
        String scheme = this.uri.getScheme().toLowerCase();
        if ("file".equals(scheme)) {
            return ConnectionHolder.createFileConectionHolder(this.uri);
        }
        return ConnectionHolder.createURIConnectionHolder(this.uri);
    }

    private String getContentTypeFromFileSignature(URI uri) throws MalformedURLException, IOException {
        String type = DEFAULT_CONTENT_TYPE;
        InputStream stream = this.getInputStream(uri);
        byte[] signature = new byte[22];
        stream.read(signature);
        stream.close();
        type = MediaUtils.fileSignatureToContentType(signature);
        return type;
    }

    private static class LocatorConnection {
        public HttpURLConnection connection = null;
        public int responseCode = 200;

        private LocatorConnection() {
        }
    }
}

