/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.Track;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Media {
    private Locator locator;
    private final List<Track> tracks = new ArrayList<Track>();
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    protected Media(Locator locator, Track[] tracks) {
        if (locator == null) {
            throw new IllegalArgumentException("locator == null!");
        }
        this.locator = locator;
        if (tracks != null) {
            for (int i = 0; i < tracks.length; ++i) {
                this.addTrack(tracks[i]);
            }
        }
    }

    public abstract void addMarker(String var1, double var2);

    public abstract double removeMarker(String var1);

    public abstract void removeAllMarkers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMetadata() {
        Map<String, Object> returnValue;
        Map<String, Object> map = this.metadata;
        synchronized (map) {
            returnValue = this.metadata.isEmpty() ? null : Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Track> getTracks() {
        List<Track> returnValue;
        List<Track> list = this.tracks;
        synchronized (list) {
            returnValue = this.tracks.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<Track>(this.tracks));
        }
        return returnValue;
    }

    public abstract Map<String, Double> getMarkers();

    public Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrack(Track track) {
        if (track == null) {
            throw new IllegalArgumentException("track == null!");
        }
        List<Track> list = this.tracks;
        synchronized (list) {
            this.tracks.add(track);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetadata(Map<String, Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata == null!");
        }
        Map<String, Object> map = metadata;
        synchronized (map) {
            this.metadata.putAll(metadata);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.tracks != null && !this.tracks.isEmpty()) {
            for (Track track : this.tracks) {
                buffer.append(track);
                buffer.append("\n");
            }
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            buffer.append("Metadata {\n");
            for (String key : this.metadata.keySet()) {
                Object value = this.metadata.get(key);
                buffer.append("    ");
                buffer.append(key);
                buffer.append(": ");
                if (value instanceof Calendar) {
                    Calendar cal = (Calendar)value;
                    buffer.append(cal.get(1) + "-" + cal.get(2) + "-" + cal.get(5));
                } else {
                    buffer.append(value);
                }
                buffer.append("\n");
            }
            buffer.append("}\n");
        }
        return buffer.toString();
    }
}

