/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.GlassAppletWindow;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler;
import com.sun.javafx.tk.quantum.OverlayWarning;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.impl.PrismSettings;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.util.List;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class WindowStage
extends GlassStage {
    PushbroomScaler scaler;
    StageStyle style;
    Window platformWindow;
    MenuBar menubar;
    String title;
    private OverlayWarning warning = null;
    private boolean transparent = false;
    private boolean isPrimaryStage = false;
    private boolean isAppletStage = false;
    private boolean isInFullScreen = false;
    private TKStage owner = null;
    private Window ownerWindow = null;
    private Modality modality = Modality.NONE;
    private boolean inEventHandler = false;
    private static WindowStage activeFullScreenWindow = null;
    private static GlassAppletWindow appletWindow = null;
    private boolean trustedFullScreen = false;
    private static final Permission fullScreenPermission = new AllPermission();
    private boolean fullScreenFromUserEvent = false;
    private boolean platformWindowClosed = false;

    static void setAppletWindow(GlassAppletWindow glassAppletWindow) {
        appletWindow = glassAppletWindow;
    }

    static GlassAppletWindow getAppletWindow() {
        return appletWindow;
    }

    public WindowStage(boolean bl) {
        this(bl, StageStyle.DECORATED, false, Modality.NONE, null);
    }

    public WindowStage(boolean bl, StageStyle stageStyle) {
        this(bl, stageStyle, false, Modality.NONE, null);
    }

    public final WindowStage init() {
        this.initPlatformWindow();
        this.platformWindow.setEventHandler(new GlassWindowEventHandler(this));
        this.platformWindow.setMinimumSize(0, 0);
        this.initMenuBar();
        return this;
    }

    public WindowStage(boolean bl, StageStyle stageStyle, boolean bl2, Modality modality, TKStage tKStage) {
        super(bl);
        this.transparent = stageStyle == StageStyle.TRANSPARENT;
        this.style = stageStyle;
        this.isPrimaryStage = bl2;
        if (null != appletWindow && bl2) {
            this.isAppletStage = true;
        }
        if (tKStage == null) {
            if (modality == Modality.WINDOW_MODAL) {
                modality = Modality.NONE;
            }
        } else if (tKStage instanceof WindowStage) {
            this.ownerWindow = ((WindowStage)tKStage).platformWindow;
        } else {
            System.err.println("Error: Unsupported type of owner " + tKStage);
        }
        this.owner = tKStage;
        this.modality = modality;
    }

    protected void initPlatformWindow() {
        int n = 0;
        Application application = Application.GetApplication();
        if (this.isPrimaryStage && null != appletWindow) {
            this.platformWindow = application.createWindow(appletWindow.getGlassWindow().getNativeWindow());
        } else if (this.style == StageStyle.DECORATED) {
            n = 113;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
            this.platformWindow.setResizable(true);
        } else if (this.style == StageStyle.UTILITY) {
            n = 21;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
        } else {
            n = (this.transparent ? 2 : 0) | 0x10;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
        }
    }

    protected Window getPlatformWindow() {
        return this.platformWindow;
    }

    protected TKStage getOwner() {
        return this.owner;
    }

    protected void initMenuBar() {
        Application application = Application.GetApplication();
        this.menubar = application.createMenuBar();
        application.installDefaultMenus(this.menubar);
        this.platformWindow.setMenuBar(this.menubar);
    }

    StageStyle getStyle() {
        return this.style;
    }

    @Override
    public TKScene createTKScene(boolean bl) {
        return new ViewScene(this.verbose, bl);
    }

    @Override
    public void setScene(TKScene tKScene) {
        super.setScene(tKScene);
        if (this.scene != null) {
            View view = ((ViewScene)this.scene).getPlatformView();
            this.platformWindow.setView(view);
            this.requestFocus();
            this.applyFullScreen();
        } else {
            this.platformWindow.setView(null);
        }
    }

    @Override
    public void setBounds(float f, float f2, boolean bl, boolean bl2, float f3, float f4, float f5, float f6) {
        if (this.isAppletStage || Float.isNaN(f) || Float.isNaN(f2)) {
            bl2 = false;
            bl = false;
        }
        this.platformWindow.setBounds((int)f, (int)f2, bl, bl2, (int)f3, (int)f4, (int)f5, (int)f6);
    }

    @Override
    public void setIcons(List list) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        if (PrismSettings.isMac) {
            n4 = 128;
            n3 = 128;
        } else {
            n4 = 32;
            n3 = 32;
        }
        if (list == null || list.size() < 1) {
            return;
        }
        int n5 = this.platformWindow.getWidth();
        int n6 = this.platformWindow.getHeight();
        Object object2 = null;
        double d = 3.0;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            int n7;
            int n8;
            object = (Image)list.get(i);
            if (object == null || ((Image)object).getPixelFormat() != PixelFormat.BYTE_RGB && ((Image)object).getPixelFormat() != PixelFormat.BYTE_BGRA_PRE && ((Image)object).getPixelFormat() != PixelFormat.BYTE_GRAY) continue;
            n2 = ((Image)object).getWidth();
            n = ((Image)object).getHeight();
            if (n2 <= 0 || n <= 0) continue;
            double d3 = Math.min((double)n3 / (double)n2, (double)n4 / (double)n);
            double d4 = 1.0;
            if (d3 >= 2.0) {
                d3 = Math.floor(d3);
                n8 = n2 * (int)d3;
                n7 = n * (int)d3;
                d4 = 1.0 - 0.5 / d3;
            } else if (d3 >= 1.0) {
                d3 = 1.0;
                n8 = n2;
                n7 = n;
                d4 = 0.0;
            } else if (d3 >= 0.75) {
                d3 = 0.75;
                n8 = n2 * 3 / 4;
                n7 = n * 3 / 4;
                d4 = 0.3;
            } else if (d3 >= 0.6666) {
                d3 = 0.6666;
                n8 = n2 * 2 / 3;
                n7 = n * 2 / 3;
                d4 = 0.33;
            } else {
                d2 = Math.ceil(1.0 / d3);
                d3 = 1.0 / d2;
                n8 = (int)Math.round((double)n2 / d2);
                n7 = (int)Math.round((double)n / d2);
                d4 = 1.0 - 1.0 / d2;
            }
            d2 = ((double)n5 - (double)n8) / (double)n5 + ((double)n6 - (double)n7) / (double)n6 + d4;
            if (d2 < d) {
                object2 = object;
            }
            if (d2 == 0.0) break;
        }
        if (object2 == null) {
            return;
        }
        this.scaler = ScalerFactory.createScaler(((Image)object2).getWidth(), ((Image)object2).getHeight(), ((Image)object2).getBytesPerPixelUnit(), n3, n4, true);
        ByteBuffer byteBuffer = (ByteBuffer)((Image)object2).getPixelBuffer();
        object = new byte[byteBuffer.limit()];
        n2 = ((Image)object2).getHeight();
        for (n = 0; n < n2; ++n) {
            byteBuffer.position(n * ((Image)object2).getScanlineStride());
            byteBuffer.get((byte[])object, 0, ((Image)object2).getScanlineStride());
            if (this.scaler == null) continue;
            this.scaler.putSourceScanline((byte[])object, 0);
        }
        byteBuffer.rewind();
        Image image = ((Image)object2).iconify(this.scaler.getDestination(), n3, n4);
        this.platformWindow.setIcon(PixelUtils.imageToPixels(image));
    }

    @Override
    public void setTitle(String string) {
        if (this.platformWindow == null) {
            this.title = string;
        } else {
            this.platformWindow.setTitle(string);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            if (this.modality == Modality.WINDOW_MODAL) {
                assert (this.owner != null);
                ((WindowStage)this.owner).setEnabled(true);
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(true);
            } else if (this.owner != null) {
                ((WindowStage)this.owner).requestToFront();
            }
        }
        this.platformWindow.setVisible(bl);
        super.setVisible(bl);
        if (bl) {
            if (this.modality == Modality.WINDOW_MODAL) {
                assert (this.owner != null);
                ((WindowStage)this.owner).setEnabled(false);
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(false);
            }
            if (this.isAppletStage && null != appletWindow) {
                appletWindow.assertStageOrder();
            }
        }
        this.applyFullScreen();
    }

    @Override
    boolean isVisible() {
        return this.platformWindow.isVisible();
    }

    @Override
    public void setOpacity(float f) {
        this.platformWindow.setAlpha(f);
    }

    public boolean needsUpdateWindow() {
        return this.transparent && Application.GetApplication().shouldUpdateWindow();
    }

    @Override
    public void setIconified(boolean bl) {
        if (this.platformWindow.isMinimized() && bl || !this.platformWindow.isMinimized() && !bl) {
            return;
        }
        if (this.platformWindow.minimize(bl) != bl) {
            throw new RuntimeException("WindowStage.setIconified failed");
        }
    }

    @Override
    public void setResizable(boolean bl) {
        this.platformWindow.setResizable(bl);
    }

    boolean isTrustedFullScreen() {
        return this.trustedFullScreen;
    }

    void exitFullScreen() {
        if (this.stageListener != null) {
            this.stageListener.changedFullscreen(false);
        } else {
            this.setFullScreen(false);
        }
    }

    private boolean hasPermission(Permission permission) {
        try {
            if (System.getSecurityManager() != null) {
                this.getAccessControlContext().checkPermission(permission);
            }
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    private void applyFullScreen() {
        View view = this.platformWindow.getView();
        if (this.isVisible() && view != null && view.isInFullscreen() != this.isInFullScreen) {
            if (this.isInFullScreen) {
                this.trustedFullScreen = this.hasPermission(fullScreenPermission);
                if (!this.trustedFullScreen && !this.fullScreenFromUserEvent) {
                    this.exitFullScreen();
                } else {
                    view.enterFullscreen(false, false, false);
                    this.warning = new OverlayWarning((ViewScene)this.scene);
                    this.warning.warn();
                }
            } else {
                if (this.warning != null) {
                    this.warning.cancel();
                    this.warning = null;
                }
                view.exitFullscreen(false);
            }
            this.fullScreenFromUserEvent = false;
        }
    }

    @Override
    public void setFullScreen(boolean bl) {
        if (this.isInFullScreen == bl) {
            return;
        }
        this.initSecurityContext();
        if (this.isInEventHandler()) {
            this.fullScreenFromUserEvent = true;
        }
        if (bl && activeFullScreenWindow != null) {
            activeFullScreenWindow.setFullScreen(false);
        }
        this.isInFullScreen = bl;
        this.applyFullScreen();
        if (bl) {
            activeFullScreenWindow = this;
        }
    }

    void fullscreenChanged(boolean bl) {
        if (!bl && this == activeFullScreenWindow) {
            activeFullScreenWindow = null;
        }
        if (this.stageListener != null) {
            this.stageListener.changedFullscreen(bl);
        }
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void toFront() {
        this.platformWindow.toFront();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void close() {
        super.close();
        if (!this.platformWindowClosed) {
            this.platformWindow.close();
        }
    }

    @Override
    protected void setPlatformWindowClosed() {
        this.platformWindowClosed = true;
    }

    @Override
    public boolean isTopLevel() {
        return this.owner == null;
    }

    @Override
    public boolean grabFocus() {
        return this.platformWindow.grabFocus();
    }

    @Override
    public void ungrabFocus() {
        this.platformWindow.ungrabFocus();
    }

    @Override
    public void requestFocus(FocusCause focusCause) {
        switch (focusCause) {
            case TRAVERSED_FORWARD: {
                this.platformWindow.requestFocus(543);
                break;
            }
            case TRAVERSED_BACKWARD: {
                this.platformWindow.requestFocus(544);
                break;
            }
            case ACTIVATED: {
                this.platformWindow.requestFocus(542);
                break;
            }
            case DEACTIVATED: {
                this.platformWindow.requestFocus(541);
            }
        }
    }

    @Override
    protected void setPlatformEnabled(boolean bl) {
        if (!this.platformWindowClosed) {
            this.platformWindow.setEnabled(bl);
        }
        if (!bl) {
            GlassStage.removeActiveWindow(this);
        }
    }

    void setEnabled(boolean bl) {
        if (this.owner != null && this.owner instanceof WindowStage) {
            ((WindowStage)this.owner).setEnabled(bl);
        }
        this.setPlatformEnabled(bl);
        if (bl) {
            this.requestToFront();
            if (this.isAppletStage && null != appletWindow) {
                appletWindow.assertStageOrder();
            }
        }
    }

    void windowsSetEnabled(boolean bl) {
        for (GlassStage glassStage : windows) {
            if (glassStage == this) continue;
            glassStage.setPlatformEnabled(bl);
            if (!bl) continue;
            glassStage.requestToFront();
        }
    }

    @Override
    protected void requestToFront() {
        this.platformWindow.toFront();
        this.platformWindow.requestFocus();
    }

    public void setInEventHandler(boolean bl) {
        this.inEventHandler = bl;
    }

    public boolean isInEventHandler() {
        return this.inEventHandler;
    }
}

