/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.paint.ImagePattern;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.sg.PGArc;
import com.sun.javafx.sg.PGCircle;
import com.sun.javafx.sg.PGCubicCurve;
import com.sun.javafx.sg.PGEllipse;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.PGLine;
import com.sun.javafx.sg.PGMediaView;
import com.sun.javafx.sg.PGPath;
import com.sun.javafx.sg.PGPolygon;
import com.sun.javafx.sg.PGPolyline;
import com.sun.javafx.sg.PGQuadCurve;
import com.sun.javafx.sg.PGRectangle;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGSVGPath;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.prism.NGArc;
import com.sun.javafx.sg.prism.NGCircle;
import com.sun.javafx.sg.prism.NGCubicCurve;
import com.sun.javafx.sg.prism.NGEllipse;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGLine;
import com.sun.javafx.sg.prism.NGMediaView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import com.sun.javafx.sg.prism.NGPolygon;
import com.sun.javafx.sg.prism.NGPolyline;
import com.sun.javafx.sg.prism.NGQuadCurve;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.sg.prism.NGSVGPath;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.svgpath.parser.Path2DProducer;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TextHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.desktop.AppletWindow;
import com.sun.javafx.tk.desktop.DesktopToolkit;
import com.sun.javafx.tk.desktop.MasterTimer;
import com.sun.javafx.tk.quantum.CollectedFuture;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassAppletWindow;
import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PathIteratorHelper;
import com.sun.javafx.tk.quantum.PerformanceTrackerImpl;
import com.sun.javafx.tk.quantum.PopupStage;
import com.sun.javafx.tk.quantum.PrismEventUtils;
import com.sun.javafx.tk.quantum.PrismImageLoader2;
import com.sun.javafx.tk.quantum.PrismTextHelper;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.ExternalImageTools;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Stop;
import com.sun.prism.render.CompletionListener;
import com.sun.prism.render.RenderJob;
import com.sun.prism.render.ToolkitInterface;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.ConditionalFeature;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class QuantumToolkit
extends DesktopToolkit
implements Launchable,
ToolkitInterface {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private static boolean debug = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.debug");
        }
    });
    private static Integer pulseHZ = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("javafx.animation.pulse");
        }
    });
    private AtomicBoolean toolkitRunning = new AtomicBoolean(false);
    private AtomicBoolean animationRunning = new AtomicBoolean(false);
    private AtomicBoolean nextPulseRequested = new AtomicBoolean(false);
    private AtomicBoolean pulseRunning = new AtomicBoolean(false);
    private CountDownLatch launchLatch = new CountDownLatch(1);
    protected final int PULSE_INTERVAL = (int)(TimeUnit.SECONDS.toMillis(1L) / (long)this.getRefreshRate());
    protected final int FULLSPEED_INTERVAL = 1;
    private Runnable pulseRunnable;
    private Runnable userRunnable;
    private Runnable timerRunnable;
    private Timer pulseTimer = null;
    private Thread shutdownHook = null;
    private QuantumRenderer renderer;
    private ClassLoader ccl;
    private final PerformanceTrackerImpl perfTracker = new PerformanceTrackerImpl();
    private int counter = 0;
    private static ScreenConfigurationAccessor screenAccessor = new ScreenConfigurationAccessor(){

        @Override
        public int getMinX(Object object) {
            return ((Screen)object).getX();
        }

        @Override
        public int getMinY(Object object) {
            return ((Screen)object).getY();
        }

        @Override
        public int getWidth(Object object) {
            return ((Screen)object).getWidth();
        }

        @Override
        public int getHeight(Object object) {
            return ((Screen)object).getHeight();
        }

        @Override
        public int getVisualMinX(Object object) {
            return ((Screen)object).getVisibleX();
        }

        @Override
        public int getVisualMinY(Object object) {
            return ((Screen)object).getVisibleY();
        }

        @Override
        public int getVisualWidth(Object object) {
            return ((Screen)object).getVisibleWidth();
        }

        @Override
        public int getVisualHeight(Object object) {
            return ((Screen)object).getVisibleHeight();
        }

        @Override
        public float getDPI(Object object) {
            return ((Screen)object).getResolutionX();
        }
    };
    private Map contextMap = Collections.synchronizedMap(new HashMap());
    private DelayedRunnable animationRunnable;
    private Comparator<Stop> stopOffsetComparator = new Comparator<Stop>(){

        @Override
        public int compare(Stop stop, Stop stop2) {
            return Float.compare(stop.getOffset(), stop2.getOffset());
        }
    };
    static BasicStroke tmpStroke = new BasicStroke();
    private QuantumClipboard clipboard;
    private QuantumClipboard dragSourceClipboard;
    private GlassScene dragSourceScene;

    @Override
    public boolean init() {
        if (PrismSettings.isMac) {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.version");
                }
            });
            if (string.startsWith("10.4") || string.startsWith("10.5")) {
                throw new RuntimeException("JavaFX requires Mac OSX 10.6 or higher to run");
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty("java.awt.headless", "true");
                    return null;
                }
            });
        }
        this.renderer = QuantumRenderer.getToolkit();
        if (PrismSettings.shutdownHook) {
            this.shutdownHook = new Thread("Glass/Prism Shutdown Hook"){

                @Override
                public void run() {
                    QuantumToolkit.this.dispose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        return true;
    }

    @Override
    public void startup(Runnable runnable) {
        this.ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.userRunnable = runnable;
            Application.Run(null, "Glass application", this);
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        try {
            this.launchLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void assertToolkitRunning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishLaunching(String[] stringArray) {
        Thread thread = Thread.currentThread();
        if (!this.toolkitRunning.getAndSet(true)) {
            thread.setName("JavaFX Application Thread");
            thread.setContextClassLoader(this.ccl);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    System.out.println(thread.getName() + " uncaught: " + throwable.getClass().getName());
                    throwable.printStackTrace();
                }
            });
            QuantumToolkit.setFxUserThread(thread);
            this.pulseRunnable = new Runnable(){

                @Override
                public void run() {
                    QuantumToolkit.this.pulse();
                }
            };
            this.timerRunnable = new Runnable(){

                @Override
                public void run() {
                    CollectedFuture collectedFuture = CollectedFuture.getInstance();
                    if (debug) {
                        System.out.println((QuantumToolkit.this.animationRunning.get() ? "A" : "a") + (QuantumToolkit.this.nextPulseRequested.get() ? "R" : "r") + (collectedFuture.hasDirty().get() ? "D" : "d") + (collectedFuture.hasUpload().get() ? "U" : "u") + (QuantumToolkit.this.pulseRunning.get() ? "P" : "p"));
                    }
                    if ((QuantumToolkit.this.animationRunning.get() || QuantumToolkit.this.nextPulseRequested.get() || collectedFuture.hasDirty().get()) && !QuantumToolkit.this.pulseRunning.getAndSet(true)) {
                        Application.postOnEventQueue(QuantumToolkit.this.pulseRunnable);
                    }
                }
            };
            this.pulseTimer = Application.GetApplication().createTimer(this.timerRunnable);
            Application.GetApplication().setEventHandler(new Application.EventHandler(){

                @Override
                public void handleQuitAction(Application application, long l) {
                    GlassStage.requestClosingAllWindows();
                }
            });
        }
        this.launchLatch.countDown();
        try {
            Application.invokeAndWait(this.userRunnable);
            if (this.getMasterTimer().isFullspeed()) {
                this.pulseTimer.start(1);
            } else {
                this.pulseTimer.start(this.PULSE_INTERVAL);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            PerformanceTracker.logEvent("Toolkit.startup - finished");
        }
    }

    @Override
    public void checkFxUserThread() {
        super.checkFxUserThread();
        this.renderer.checkRendererIdle();
    }

    protected static Thread getFxUserThread() {
        return Toolkit.getFxUserThread();
    }

    @Override
    public Future addRenderJob(RenderJob renderJob) {
        return this.renderer.submitRenderJob(renderJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pulse() {
        try {
            this.nextPulseRequested.set(false);
            if (this.animationRunnable != null) {
                this.animationRunning.set(true);
                this.animationRunnable.run();
            } else {
                this.animationRunning.set(false);
            }
            this.firePulse();
            CollectedFuture.getInstance().repaintAll();
            CollectedFuture.getInstance().uploadAll();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.pulseRunning.set(false);
        }
    }

    public boolean isPulseRunning() {
        return this.pulseRunning.get();
    }

    @Override
    public PerformanceTracker getPerformanceTracker() {
        return this.perfTracker;
    }

    @Override
    public PerformanceTracker createPerformanceTracker() {
        return new PerformanceTrackerImpl();
    }

    @Override
    public AppletWindow createAppletWindow(long l) {
        GlassAppletWindow glassAppletWindow = new GlassAppletWindow(l);
        WindowStage.setAppletWindow(glassAppletWindow);
        return glassAppletWindow;
    }

    @Override
    public void closeAppletWindow() {
        GlassAppletWindow glassAppletWindow = WindowStage.getAppletWindow();
        if (null != glassAppletWindow) {
            glassAppletWindow.dispose();
            WindowStage.setAppletWindow(null);
        }
    }

    @Override
    public TKStage createTKStage(StageStyle stageStyle) {
        this.assertToolkitRunning();
        return new WindowStage(verbose, stageStyle).init();
    }

    @Override
    public TKStage createTKStage(StageStyle stageStyle, boolean bl, Modality modality, TKStage tKStage) {
        this.assertToolkitRunning();
        return new WindowStage(verbose, stageStyle, bl, modality, tKStage).init();
    }

    @Override
    public void enterNestedEventLoop() {
        Object object = Application.enterNestedEventLoop();
    }

    @Override
    public void exitNestedEventLoop() {
        Application.leaveNestedEventLoop(null);
    }

    @Override
    public TKStage createTKPopupStage(StageStyle stageStyle, Object object) {
        this.assertToolkitRunning();
        return new PopupStage(verbose, object).init();
    }

    @Override
    public TKStage createTKEmbeddedStage(HostInterface hostInterface) {
        this.assertToolkitRunning();
        return new EmbeddedStage(hostInterface);
    }

    @Override
    public ScreenConfigurationAccessor setScreenConfigurationListener(final TKScreenConfigurationListener tKScreenConfigurationListener) {
        Screen.setCallback(new Screen.SettingsChangedCallback(){

            @Override
            public void settingsChanged() {
                QuantumToolkit.notifyScreenListener(tKScreenConfigurationListener);
            }
        });
        return screenAccessor;
    }

    private static void notifyScreenListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        tKScreenConfigurationListener.screenConfigurationChanged();
    }

    @Override
    public Object getPrimaryScreen() {
        return Screen.getMainScreen();
    }

    @Override
    public List<?> getScreens() {
        return Screen.getScreens();
    }

    @Override
    public ImageLoader loadImage(String string, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2(string, n, n2, bl, bl2);
    }

    @Override
    public ImageLoader loadImage(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2(inputStream, n, n2, bl, bl2);
    }

    public AbstractRemoteResource<? extends ImageLoader> loadImageAsync(AsyncOperationListener asyncOperationListener, String string, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2.AsyncImageLoader(asyncOperationListener, string, n, n2, bl, bl2);
    }

    @Override
    public void defer(Runnable runnable) {
        if (!this.toolkitRunning.get()) {
            throw new IllegalStateException("Attempt to call defer when toolkit not running");
        }
        Application.invokeLater(runnable);
    }

    @Override
    public void exit() {
        this.notifyShutdownHooks();
        this.pulseTimer.stop();
        this.dispose();
        Application application = Application.GetApplication();
        application.terminate();
        super.exit();
    }

    public void dispose() {
        if (this.toolkitRunning.compareAndSet(true, false)) {
            this.renderer.stopRenderer();
            if (PrismSettings.shutdownHook) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isForwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && !keyEvent.isShiftDown();
    }

    @Override
    public boolean isBackwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public int getRefreshRate() {
        if (pulseHZ == null) {
            return 60;
        }
        return pulseHZ;
    }

    @Override
    public void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        if (delayedRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = delayedRunnable;
    }

    @Override
    public void requestNextPulse() {
        this.nextPulseRequested.set(true);
    }

    @Override
    public void waitFor(Toolkit.Task task) {
        if (task.isFinished()) {
            return;
        }
    }

    @Override
    public PrismPerspectiveCameraImpl createPerspectiveCamera() {
        return new PrismPerspectiveCameraImpl();
    }

    @Override
    public PrismParallelCameraImpl createParallelCamera() {
        return PrismParallelCameraImpl.getInstance();
    }

    @Override
    protected Object createColorPaint(Color color) {
        return new com.sun.prism.paint.Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    private com.sun.prism.paint.Color toPrismColor(Color color) {
        return (com.sun.prism.paint.Color)color.impl_getPlatformPaint();
    }

    private List<Stop> convertStops(List<javafx.scene.paint.Stop> list) {
        boolean bl = false;
        double d = Double.NEGATIVE_INFINITY;
        ArrayList<Stop> arrayList = new ArrayList<Stop>();
        for (javafx.scene.paint.Stop stop : list) {
            if (d > stop.getOffset()) {
                bl = true;
            }
            d = stop.getOffset();
            arrayList.add(new Stop(this.toPrismColor(stop.getColor()), (float)QuantumToolkit.clampStopOffset(stop.getOffset())));
        }
        if (bl) {
            Collections.sort(arrayList, this.stopOffsetComparator);
        }
        return arrayList;
    }

    @Override
    protected Object createLinearGradientPaint(javafx.scene.paint.LinearGradient linearGradient) {
        int n = 2;
        CycleMethod cycleMethod = linearGradient.getCycleMethod();
        if (cycleMethod == CycleMethod.NO_CYCLE) {
            n = 0;
        } else if (cycleMethod == CycleMethod.REFLECT) {
            n = 1;
        }
        List<Stop> list = this.convertStops(linearGradient.getStops());
        return new LinearGradient((float)linearGradient.getStartX(), (float)linearGradient.getStartY(), (float)linearGradient.getEndX(), (float)linearGradient.getEndY(), null, linearGradient.isProportional(), n, list);
    }

    @Override
    protected Object createRadialGradientPaint(RadialGradient radialGradient) {
        float f = (float)radialGradient.getCenterX();
        float f2 = (float)radialGradient.getCenterY();
        float f3 = (float)radialGradient.getFocusAngle();
        float f4 = (float)radialGradient.getFocusDistance();
        int n = 0;
        n = radialGradient.getCycleMethod() == CycleMethod.NO_CYCLE ? 0 : (radialGradient.getCycleMethod() == CycleMethod.REFLECT ? 1 : 2);
        List<Stop> list = this.convertStops(radialGradient.getStops());
        return new com.sun.prism.paint.RadialGradient(f, f2, f3, f4, (float)radialGradient.getRadius(), null, radialGradient.isProportional(), n, list);
    }

    @Override
    protected Object createImagePatternPaint(ImagePattern imagePattern) {
        if (imagePattern.getImage() == null) {
            return com.sun.prism.paint.Color.TRANSPARENT;
        }
        return new com.sun.prism.paint.ImagePattern((com.sun.prism.Image)imagePattern.getImage().impl_getPlatformImage(), imagePattern.getX(), imagePattern.getY(), imagePattern.getWidth(), imagePattern.getHeight(), imagePattern.isProportional());
    }

    void initStroke(PGShape.StrokeType strokeType, double d, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f) {
        int n = strokeType == PGShape.StrokeType.CENTERED ? 0 : (strokeType == PGShape.StrokeType.INSIDE ? 1 : 2);
        int n2 = strokeLineCap == PGShape.StrokeLineCap.BUTT ? 0 : (strokeLineCap == PGShape.StrokeLineCap.SQUARE ? 2 : 1);
        int n3 = strokeLineJoin == PGShape.StrokeLineJoin.BEVEL ? 2 : (strokeLineJoin == PGShape.StrokeLineJoin.MITER ? 0 : 1);
        tmpStroke.set(n, (float)d, n2, n3, f);
    }

    @Override
    public void accumulateStrokeBounds(Shape shape, float[] fArray, PGShape.StrokeType strokeType, double d, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f, BaseTransform baseTransform) {
        this.initStroke(strokeType, d, strokeLineCap, strokeLineJoin, f);
        if (baseTransform.isTranslateOrIdentity()) {
            tmpStroke.accumulateShapeBounds(fArray, shape, baseTransform);
        } else {
            Shape.accumulate(fArray, tmpStroke.createStrokedShape(shape), baseTransform);
        }
    }

    @Override
    public boolean strokeContains(Shape shape, double d, double d2, PGShape.StrokeType strokeType, double d3, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f) {
        this.initStroke(strokeType, d3, strokeLineCap, strokeLineJoin, f);
        return tmpStroke.createStrokedShape(shape).contains((float)d, (float)d2);
    }

    @Override
    public Dimension2D getBestCursorSize(int n, int n2) {
        return CursorUtils.getBestCursorSize(n, n2);
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    public int getKeyCodeForChar(String string) {
        return string.length() == 1 ? com.sun.glass.events.KeyEvent.getKeyCodeForChar(string.charAt(0)) : 0;
    }

    @Override
    public MouseEvent convertMouseEventToFX(Object object) {
        if (object instanceof GlassPrismMouseEvent) {
            return PrismEventUtils.glassMouseEventToFX((GlassPrismMouseEvent)object);
        }
        if (object instanceof MouseEvent) {
            return (MouseEvent)object;
        }
        return null;
    }

    @Override
    public KeyEvent convertKeyEventToFX(Object object) {
        if (object instanceof GlassPrismKeyEvent) {
            return PrismEventUtils.glassKeyEventToFX((GlassPrismKeyEvent)object);
        }
        if (object instanceof KeyEvent) {
            return (KeyEvent)object;
        }
        return null;
    }

    @Override
    public InputMethodEvent convertInputMethodEventToFX(Object object) {
        if (object instanceof GlassPrismInputMethodEvent) {
            return PrismEventUtils.glassInputMethodEventToFX((GlassPrismInputMethodEvent)object);
        }
        if (object instanceof InputMethodEvent) {
            return (InputMethodEvent)object;
        }
        return null;
    }

    @Override
    public PathElement[] convertShapeToFXPath(Object object) {
        if (object == null) {
            return new PathElement[0];
        }
        ArrayList<MoveTo> arrayList = new ArrayList<MoveTo>();
        Shape shape = (Shape)object;
        PathIterator pathIterator = shape.getPathIterator(null);
        PathIteratorHelper pathIteratorHelper = new PathIteratorHelper(pathIterator);
        PathIteratorHelper.Struct struct = new PathIteratorHelper.Struct();
        while (!pathIteratorHelper.isDone()) {
            PathElement pathElement;
            boolean bl = pathIteratorHelper.getWindingRule() == 0;
            int n = pathIteratorHelper.currentSegment(struct);
            if (n == 0) {
                pathElement = new MoveTo(struct.f0, struct.f1);
            } else if (n == 1) {
                pathElement = new LineTo(struct.f0, struct.f1);
            } else if (n == 2) {
                pathElement = new QuadCurveTo(struct.f0, struct.f1, struct.f2, struct.f3);
            } else if (n == 3) {
                pathElement = new CubicCurveTo(struct.f0, struct.f1, struct.f2, struct.f3, struct.f4, struct.f5);
            } else if (n == 4) {
                pathElement = new ClosePath();
            } else {
                throw new IllegalStateException("Invalid element type: " + n);
            }
            pathIteratorHelper.next();
            arrayList.add((MoveTo)pathElement);
        }
        return arrayList.toArray(new PathElement[arrayList.size()]);
    }

    @Override
    public HitInfo convertHitInfoToFX(Object object) {
        Integer n = (Integer)object;
        HitInfo hitInfo = new HitInfo();
        hitInfo.setCharIndex(n);
        hitInfo.setLeading(true);
        return hitInfo;
    }

    @Override
    public Filterable toFilterable(Image image) {
        return PrImage.create((com.sun.prism.Image)image.impl_getPlatformImage());
    }

    @Override
    public FilterContext getFilterContext(Object object) {
        if (object == null || !(object instanceof Screen)) {
            return PrFilterContext.getDefaultInstance();
        }
        Screen screen = (Screen)object;
        return PrFilterContext.getInstance(screen);
    }

    @Override
    public AbstractMasterTimer getMasterTimer() {
        return MasterTimer.getInstance();
    }

    @Override
    public FontLoader getFontLoader() {
        return PrismFontLoader.getInstance();
    }

    @Override
    public TextHelper createTextHelper(Text text) {
        return new PrismTextHelper(text);
    }

    @Override
    public PGArc createPGArc() {
        return new NGArc();
    }

    @Override
    public PGCircle createPGCircle() {
        return new NGCircle();
    }

    @Override
    public PGCubicCurve createPGCubicCurve() {
        return new NGCubicCurve();
    }

    @Override
    public PGEllipse createPGEllipse() {
        return new NGEllipse();
    }

    @Override
    public PGLine createPGLine() {
        return new NGLine();
    }

    @Override
    public PGPath createPGPath() {
        return new NGPath();
    }

    @Override
    public PGSVGPath createPGSVGPath() {
        return new NGSVGPath();
    }

    @Override
    public PGPolygon createPGPolygon() {
        return new NGPolygon();
    }

    @Override
    public PGPolyline createPGPolyline() {
        return new NGPolyline();
    }

    @Override
    public PGQuadCurve createPGQuadCurve() {
        return new NGQuadCurve();
    }

    @Override
    public PGRectangle createPGRectangle() {
        return new NGRectangle();
    }

    @Override
    public PGImageView createPGImageView() {
        return new NGImageView();
    }

    @Override
    public PGMediaView createPGMediaView() {
        return new NGMediaView();
    }

    @Override
    public PGGroup createPGGroup() {
        return new NGGroup();
    }

    @Override
    public PGText createPGText() {
        return new NGText();
    }

    @Override
    public PGRegion createPGRegion() {
        return new NGRegion();
    }

    @Override
    public Object createSVGPathObject(SVGPath sVGPath) {
        try {
            return Path2DProducer.createPath(new StringReader(sVGPath.getContent()), sVGPath.getFillRule());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Path2D createSVGPath2D(SVGPath sVGPath) {
        try {
            return Path2DProducer.createPath(new StringReader(sVGPath.getContent()), sVGPath.getFillRule());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean imageContains(Object object, float f, float f2) {
        com.sun.prism.Image image = (com.sun.prism.Image)object;
        int n = (int)f + image.getMinX();
        int n2 = (int)f2 + image.getMinY();
        if (image.getPixelFormat().isOpaque()) {
            return true;
        }
        if (image.getPixelFormat() == PixelFormat.INT_ARGB_PRE) {
            int n3;
            IntBuffer intBuffer = (IntBuffer)image.getPixelBuffer();
            return (intBuffer.get(n3 = n + n2 * image.getRowLength()) & 0xFF000000) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_BGRA_PRE) {
            int n4;
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            return (byteBuffer.get((n4 = n * image.getBytesPerPixelUnit() + n2 * image.getScanlineStride()) + 3) & 0xFF) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_ALPHA) {
            int n5;
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            return (byteBuffer.get(n5 = n * image.getBytesPerPixelUnit() + n2 * image.getScanlineStride()) & 0xFF) != 0;
        }
        return true;
    }

    @Override
    public boolean isSupported(ConditionalFeature conditionalFeature) {
        if (conditionalFeature == ConditionalFeature.SCENE3D) {
            return GraphicsPipeline.getPipeline().is3DSupported();
        }
        if (conditionalFeature == ConditionalFeature.EFFECT) {
            return GraphicsPipeline.getPipeline().isEffectSupported();
        }
        if (conditionalFeature == ConditionalFeature.SHAPE_CLIP) {
            return true;
        }
        if (conditionalFeature == ConditionalFeature.INPUT_METHOD) {
            return false;
        }
        return false;
    }

    @Override
    public TKClipboard getSystemClipboard() {
        if (this.clipboard == null) {
            this.clipboard = QuantumClipboard.getClipboardInstance(new ClipboardAssistance("SYSTEM"));
        }
        return this.clipboard;
    }

    @Override
    public TKClipboard getNamedClipboard(String string) {
        return null;
    }

    @Override
    public DragEvent convertDragRecognizedEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDragGestureToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public DragEvent convertDragSourceEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDragSourceEventToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public DragEvent convertDropTargetEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDropTargetEventToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public Dragboard createDragboard() {
        QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(new ClipboardAssistance("DND"){

            @Override
            public void actionPerformed(int n) {
                if (QuantumToolkit.this.dragSourceClipboard != null && QuantumToolkit.this.dragSourceScene != null && ((QuantumToolkit)QuantumToolkit.this).dragSourceScene.dragSourceListener != null) {
                    Dragboard dragboard = Dragboard.impl_create(QuantumToolkit.this.dragSourceClipboard);
                    GlassDragEvent glassDragEvent = new GlassDragEvent(2, 0, 0, 0, 0, dragboard, 0, QuantumToolkit.this.dragSourceScene, n);
                    ((QuantumToolkit)QuantumToolkit.this).dragSourceScene.dragSourceListener.dragDropEnd(glassDragEvent);
                }
                QuantumToolkit.this.dragSourceClipboard = null;
                QuantumToolkit.this.dragSourceScene = null;
            }
        });
        return Dragboard.impl_create(quantumClipboard);
    }

    @Override
    public void startDrag(Object object, Set<TransferMode> set, TKDragSourceListener tKDragSourceListener, Dragboard dragboard) {
        GlassScene glassScene;
        Object object2;
        if (dragboard == null) {
            throw new IllegalArgumentException("dragboard should not be null");
        }
        if (object instanceof GlassDragEvent) {
            object2 = (GlassDragEvent)object;
            glassScene = ((GlassDragEvent)object2).getGlassScene();
        } else if (object instanceof GlassScene) {
            glassScene = (GlassScene)object;
        } else {
            throw new IllegalArgumentException("o should be either a GlassScene, or a GlassDragEvent instance");
        }
        glassScene.setTKDragSourceListener(tKDragSourceListener);
        this.dragSourceClipboard = object2 = (QuantumClipboard)dragboard.impl_getPeer();
        this.dragSourceScene = glassScene;
        ((QuantumClipboard)object2).setSupportedTransferMode(set);
        ((QuantumClipboard)object2).flush();
        ((QuantumClipboard)object2).close();
    }

    @Override
    public void enableDrop(TKScene tKScene, TKDropTargetListener tKDropTargetListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDropTargetListener(tKDropTargetListener);
    }

    @Override
    public void registerDragGestureListener(TKScene tKScene, Set<TransferMode> set, TKDragGestureListener tKDragGestureListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDragGestureListener(tKDragGestureListener);
    }

    @Override
    public boolean isAppletDragSupported() {
        return false;
    }

    @Override
    public void installInputMethodRequests(TKScene tKScene, InputMethodRequests inputMethodRequests) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setInputMethodRequests(inputMethodRequests);
    }

    @Override
    public boolean isExternalFormatSupported(Class clazz) {
        return ExternalImageTools.isFormatSupported(clazz);
    }

    @Override
    public ImageLoader loadPlatformImage(Object object) {
        if (object instanceof PlatformImage) {
            return (PlatformImage)object;
        }
        if (object instanceof com.sun.prism.Image) {
            return new PlatformImage((com.sun.prism.Image)object);
        }
        ExternalImageTools.IImporter iImporter = ExternalImageTools.getImporter(object);
        if (iImporter != null) {
            return new PlatformImage(iImporter.loadExternalImage(object));
        }
        throw new UnsupportedOperationException("unsupported class for loadPlatformImage");
    }

    @Override
    public Object renderToImage(Toolkit.ImageRenderingContext imageRenderingContext) {
        Object object = imageRenderingContext.platformImage;
        final Toolkit.ImageRenderingContext imageRenderingContext2 = imageRenderingContext;
        final Paint paint = imageRenderingContext.platformPaint instanceof Paint ? (Paint)imageRenderingContext.platformPaint : null;
        RenderJob renderJob = new RenderJob(new Runnable(){

            private com.sun.prism.paint.Color getClearColor() {
                if (paint == null) {
                    return com.sun.prism.paint.Color.WHITE;
                }
                if (paint.getType() == Paint.Type.COLOR) {
                    return (com.sun.prism.paint.Color)paint;
                }
                if (paint.isOpaque()) {
                    return com.sun.prism.paint.Color.TRANSPARENT;
                }
                return com.sun.prism.paint.Color.WHITE;
            }

            void draw(Graphics graphics, int n, int n2) {
                graphics.setDepthBuffer(imageRenderingContext2.depthBuffer);
                graphics.clear(this.getClearColor());
                if (paint != null && paint.getType() != Paint.Type.COLOR) {
                    graphics.setPaint(paint);
                    graphics.fillQuad(0.0f, 0.0f, n, n2);
                }
                if (imageRenderingContext2.scale != 1.0) {
                    graphics.scale((float)imageRenderingContext2.scale, (float)imageRenderingContext2.scale);
                }
                if (imageRenderingContext2.root != null) {
                    if (imageRenderingContext2.camera instanceof PrismCameraImpl) {
                        graphics.setCamera((PrismCameraImpl)imageRenderingContext2.camera);
                    }
                    NGNode nGNode = (NGNode)imageRenderingContext2.root;
                    nGNode.render(graphics, null, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                if (!resourceFactory.isDeviceReady()) {
                    return;
                }
                int n = (int)Math.ceil(imageRenderingContext2.width * imageRenderingContext2.scale);
                int n2 = (int)Math.ceil(imageRenderingContext2.height * imageRenderingContext2.scale);
                if (!resourceFactory.isOffscreenRenderingSupported() || n <= 0 || n2 <= 0) {
                    return;
                }
                RenderingContext renderingContext = resourceFactory.createRenderingContext(null);
                try {
                    renderingContext.begin();
                    PlatformImage platformImage = imageRenderingContext2.platformImage instanceof PlatformImage ? (PlatformImage)imageRenderingContext2.platformImage : new PlatformImage(null);
                    RTTexture rTTexture = platformImage.getRT(n, n2, resourceFactory);
                    if (rTTexture == null) {
                        return;
                    }
                    Graphics graphics = rTTexture.createGraphics();
                    this.draw(graphics, n, n2);
                    int[] nArray = platformImage.rt.getPixels();
                    if (nArray != null) {
                        platformImage.setImage(com.sun.prism.Image.fromIntArgbPreData(nArray, n, n2));
                    } else {
                        IntBuffer intBuffer = IntBuffer.allocate(n * n2);
                        if (platformImage.rt.readPixels(intBuffer)) {
                            platformImage.setImage(com.sun.prism.Image.fromIntArgbPreData(intBuffer, n, n2));
                        } else {
                            platformImage.dispose();
                            platformImage = null;
                        }
                    }
                    imageRenderingContext2.platformImage = platformImage;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                finally {
                    renderingContext.end();
                }
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        renderJob.setCompletionListener(new CompletionListener(){

            @Override
            public void done(RenderJob renderJob) {
                countDownLatch.countDown();
            }
        });
        Future future = this.addRenderJob(renderJob);
        while (true) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
        Object object2 = imageRenderingContext2.platformImage;
        imageRenderingContext2.platformImage = object;
        return object2;
    }

    @Override
    public Object toExternalImage(Object object, Object object2) {
        boolean bl = object instanceof com.sun.prism.Image;
        ExternalImageTools.IExporter iExporter = bl && object2 != null ? ExternalImageTools.getExporter(object2) : null;
        return iExporter != null ? iExporter.exportPrismImage((com.sun.prism.Image)object, object2) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> showFileChooser(TKStage tKStage, String string, File file, FileChooserType fileChooserType, List<FileChooser.ExtensionFilter> list) {
        Window window = null;
        TKStage tKStage2 = null;
        if (tKStage instanceof WindowStage) {
            window = ((WindowStage)tKStage).getPlatformWindow();
            tKStage2 = ((WindowStage)tKStage).getOwner();
        }
        try {
            if (tKStage2 instanceof WindowStage) {
                ((WindowStage)tKStage2).setEnabled(false);
            }
            List<File> list2 = CommonDialogs.showFileChooser(window, file, string, fileChooserType == FileChooserType.SAVE ? 1 : 0, fileChooserType == FileChooserType.OPEN_MULTIPLE, QuantumToolkit.convertExtensionFilters(list));
            return list2;
        }
        finally {
            if (tKStage2 instanceof WindowStage) {
                ((WindowStage)tKStage2).setEnabled(true);
            }
        }
    }

    private static List<CommonDialogs.ExtensionFilter> convertExtensionFilters(List<FileChooser.ExtensionFilter> list) {
        CommonDialogs.ExtensionFilter[] extensionFilterArray = new CommonDialogs.ExtensionFilter[list.size()];
        int n = 0;
        for (FileChooser.ExtensionFilter extensionFilter : list) {
            extensionFilterArray[n++] = new CommonDialogs.ExtensionFilter(extensionFilter.getDescription(), extensionFilter.getExtensions());
        }
        return Arrays.asList(extensionFilterArray);
    }

    @Override
    public long getMultiClickTime() {
        return View.getMultiClickTime();
    }

    @Override
    public int getMultiClickMaxX() {
        return View.getMultiClickMaxX();
    }

    @Override
    public int getMultiClickMaxY() {
        return View.getMultiClickMaxY();
    }

    static class PlatformImage
    implements ImageLoader {
        private RTTexture rt;
        private com.sun.prism.Image image;

        PlatformImage(com.sun.prism.Image image) {
            this.image = image;
        }

        RTTexture getRT(int n, int n2, ResourceFactory resourceFactory) {
            if (this.rt == null || this.rt.getContentWidth() != n || this.rt.getContentHeight() != n2) {
                if (this.rt != null) {
                    this.rt.dispose();
                }
                this.rt = resourceFactory.createRTTexture(n, n2);
            }
            return this.rt;
        }

        void dispose() {
            if (this.rt != null) {
                this.rt.dispose();
                this.rt = null;
            }
        }

        void setImage(com.sun.prism.Image image) {
            this.image = image;
        }

        @Override
        public boolean getError() {
            return this.image == null;
        }

        @Override
        public int getFrameCount() {
            return 1;
        }

        @Override
        public Object[] getFrames() {
            return new Object[]{this.image};
        }

        @Override
        public Object getFrame(int n) {
            return this.image;
        }

        @Override
        public int getFrameDelay(int n) {
            return 0;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }
    }
}

