/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.View;
import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.geometry.Point2D;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class GlassViewEventHandler
extends View.EventHandler {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private ViewScene scene;
    private int initialWidth;
    private int initialHeight;
    private final QuantumToolkit toolkit = (QuantumToolkit)QuantumToolkit.getToolkit();
    private boolean dragPerformed = false;
    private int mouseButtonPressedMask = 0;
    private ClipboardAssistance dropSourceAssistant;

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.initialWidth = 0;
        this.initialHeight = 0;
    }

    private boolean allowableFullScreenKeys(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n, int n2, char[] cArray, int n3) {
        if (!this.scene.getWindowStage().isTrustedFullScreen()) {
            return this.allowableFullScreenKeys(n2);
        }
        return true;
    }

    private boolean toolkit() {
        GlassViewEventHandler glassViewEventHandler = this;
        return glassViewEventHandler.toolkit.getFxUserThread() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleKeyEvent(View view, long l, int n, int n2, char[] cArray, int n3) {
        if (!this.toolkit()) {
            return;
        }
        GlassPrismKeyEvent glassPrismKeyEvent = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            switch (n) {
                case 111: {
                    if (n2 == 27 && view.isInFullscreen() && windowStage != null) {
                        windowStage.exitFullScreen();
                    }
                }
                case 112: 
                case 113: {
                    if (view.isInFullscreen() && !this.checkFullScreenKeyEvent(n, n2, cArray, n3)) {
                        return;
                    } else {
                        if (this.scene.sceneListener == null) return;
                        glassPrismKeyEvent = new GlassPrismKeyEvent(this.scene, n, n2, cArray, n3);
                        this.scene.sceneListener.keyEvent(glassPrismKeyEvent);
                        return;
                    }
                }
                default: {
                    if (!verbose) return;
                    System.out.println("handleKeyEvent: unhandled type: " + n);
                    return;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (!verbose) throw runtimeException;
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (!verbose) throw new RuntimeException(throwable);
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public void handleMouseEvent(View view, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        if (!this.toolkit()) {
            return;
        }
        boolean bl2 = this.dragPerformed;
        GlassPrismMouseEvent glassPrismMouseEvent = null;
        switch (n2) {
            case 212: {
                n9 = 32;
                break;
            }
            case 214: {
                n9 = 128;
                break;
            }
            case 213: {
                n9 = 64;
                break;
            }
            default: {
                n9 = 0;
            }
        }
        switch (n) {
            case 224: {
                if (n2 == 211) break;
                return;
            }
            case 222: {
                if ((this.mouseButtonPressedMask & n9) == 0) {
                    return;
                }
                this.mouseButtonPressedMask &= ~n9;
                break;
            }
            case 223: {
                this.dragPerformed = true;
                break;
            }
            case 221: {
                this.dragPerformed = false;
                this.mouseButtonPressedMask |= n9;
                break;
            }
            default: {
                if (!verbose) break;
                System.out.println("handleMouseEvent: unhandled type: " + n);
            }
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                glassPrismMouseEvent = new GlassPrismMouseEvent(this.scene, n, n2, n3, n4, n5, n6, n7, n8, bl, 0.0);
                this.scene.sceneListener.mouseEvent(glassPrismMouseEvent);
            }
            if (n == 222 && !bl2 && this.scene.sceneListener != null && this.toolkit()) {
                glassPrismMouseEvent = new GlassPrismMouseEvent(this.scene, 227, n2, n3, n4, n5, n6, n7, n8, bl, 0.0);
                this.scene.sceneListener.mouseEvent(glassPrismMouseEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleScrollEvent(View view, long l, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, int n7, int n8, int n9, double d3, double d4) {
        if (!this.toolkit()) {
            return;
        }
        GlassPrismMouseEvent glassPrismMouseEvent = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.scrollEvent(d, d2, d3, d4, n7, n6, n9, n8, n, n2, n3, n4, (n5 & 1) != 0, (n5 & 4) != 0, (n5 & 8) != 0, (n5 & 0x10) != 0);
                glassPrismMouseEvent = new GlassPrismMouseEvent(this.scene, 228, 0, n, n2, n3, n4, 0, n5, false, -d2);
                this.scene.sceneListener.mouseEvent(glassPrismMouseEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleInputMethodEvent(long l, String string, int[] nArray, int[] nArray2, byte[] byArray, int n, int n2) {
        try {
            if (this.scene.sceneListener != null && this.toolkit()) {
                GlassPrismInputMethodEvent glassPrismInputMethodEvent = new GlassPrismInputMethodEvent(this.scene, string, nArray, nArray2, byArray, n, n2);
                this.scene.sceneListener.inputMethodEvent(glassPrismInputMethodEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public double[] getInputMethodCandidatePos(int n) {
        Point2D point2D = this.scene.inputMethodRequests.getTextLocation(n);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return dArray;
    }

    @Override
    public int handleDragEnter(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = null;
        try {
            if (this.scene.dropTargetListener != null && this.toolkit()) {
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
                Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
                GlassDragEvent glassDragEvent = new GlassDragEvent(3, n, n2, n3, n4, dragboard, 0, this.scene, n5);
                transferMode = this.scene.dropTargetListener.dragEnter(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return this.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        try {
            if (this.scene.dropTargetListener != null && this.toolkit()) {
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
                Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
                GlassDragEvent glassDragEvent = new GlassDragEvent(5, 0, 0, 0, 0, dragboard, 0, this.scene, 0);
                this.scene.dropTargetListener.dragExit(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public int handleDragDrop(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = null;
        try {
            QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
            Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
            GlassDragEvent glassDragEvent = new GlassDragEvent(2, n, n2, n3, n4, dragboard, 0, this.scene, n5);
            if (this.scene.dropTargetListener != null && this.toolkit()) {
                transferMode = this.scene.dropTargetListener.drop(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return this.TransferModeToAction(transferMode);
    }

    @Override
    public int handleDragOver(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = null;
        try {
            if (this.scene.dropTargetListener != null && this.toolkit()) {
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
                Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
                GlassDragEvent glassDragEvent = new GlassDragEvent(4, n, n2, n3, n4, dragboard, 0, this.scene, n5);
                transferMode = this.scene.dropTargetListener.dragOver(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return this.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragStart(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        try {
            if (this.scene.dragGestureListener != null && this.toolkit()) {
                this.dropSourceAssistant = clipboardAssistance;
                QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(this.dropSourceAssistant);
                Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
                GlassDragEvent glassDragEvent = new GlassDragEvent(1, n2, n3, n4, n5, dragboard, n, this.scene, 0);
                this.scene.dragGestureListener.dragGestureRecognized(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void handleDragEnd(View view, int n) {
        if (this.scene.dragSourceListener != null && this.toolkit()) {
            QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(this.dropSourceAssistant);
            Dragboard dragboard = Dragboard.impl_create(quantumClipboard);
            GlassDragEvent glassDragEvent = new GlassDragEvent(2, 0, 0, 0, 0, dragboard, 0, this.scene, n);
            this.scene.dragSourceListener.dragDropEnd(glassDragEvent);
        }
    }

    @Override
    public void handleViewEvent(View view, long l, int n) {
        if (this.scene.sceneListener == null || !this.toolkit()) {
            return;
        }
        try {
            switch (n) {
                case 431: {
                    this.scene.entireSceneNeedsRepaint();
                    if (PrismSettings.isMac) {
                        QuantumRenderer.getToolkit().liveResizeRenderJob(this.scene);
                    }
                    break;
                }
                case 432: {
                    if (PrismSettings.verbose) {
                        System.out.println("RESIZE: " + System.nanoTime() + " w: " + view.getWidth() + " h: " + view.getHeight());
                    }
                    this.scene.sceneListener.changedSize(view.getWidth(), view.getHeight());
                    this.scene.entireSceneNeedsRepaint();
                    break;
                }
                case 433: {
                    this.scene.sceneListener.changedLocation(view.getX(), view.getY());
                    break;
                }
                case 441: 
                case 442: {
                    this.scene.getWindowStage().fullscreenChanged(n == 441);
                    break;
                }
                default: {
                    if (verbose) {
                        System.out.println("handleViewEvent: unhandled type: " + n);
                    }
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    private int TransferModeToAction(TransferMode transferMode) {
        if (transferMode == null) {
            return 0;
        }
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }
}

