/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.render.RenderJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;

public class CollectedFuture {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private ArrayList<GlassScene> dirtyScenes = new ArrayList();
    private ArrayList<GlassScene> dirtyMarker = new ArrayList();
    private ArrayList<GlassScene> dirtyWork = new ArrayList();
    private ArrayList<GlassScene> uploadScenes = new ArrayList();
    private AtomicBoolean hasDirty = new AtomicBoolean(false);
    private AtomicBoolean hasUpload = new AtomicBoolean(false);
    private CyclicBarrier pulseBarrier = new CyclicBarrier(2);
    private static CollectedFuture collector;

    private CollectedFuture() {
    }

    public static CollectedFuture getInstance() {
        if (collector == null) {
            collector = new CollectedFuture();
        }
        return collector;
    }

    public AtomicBoolean hasDirty() {
        return this.hasDirty;
    }

    public AtomicBoolean hasUpload() {
        return this.hasUpload;
    }

    public CyclicBarrier getPulseBarrier() {
        return this.pulseBarrier;
    }

    String sceneSize(GlassScene glassScene) {
        GlassStage glassStage = glassScene.glassStage;
        if (glassStage != null && glassStage instanceof WindowStage) {
            WindowStage windowStage = (WindowStage)glassStage;
            Window window = windowStage.platformWindow;
            return " (" + window.getWidth() + "," + window.getHeight() + ")";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirtyScene(GlassScene glassScene) {
        if (verbose) {
            System.out.println("CF.addDirtyScene: " + glassScene.hashCode() + this.sceneSize(glassScene));
        }
        CollectedFuture collectedFuture = this;
        synchronized (collectedFuture) {
            if (!this.dirtyScenes.contains(glassScene)) {
                this.dirtyScenes.add(glassScene);
            }
            this.hasDirty.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDirtyScene(GlassScene glassScene) {
        if (verbose) {
            System.out.println("CF.removeDirtyScene: " + glassScene.hashCode() + this.sceneSize(glassScene));
        }
        CollectedFuture collectedFuture = this;
        synchronized (collectedFuture) {
            this.dirtyScenes.remove(glassScene);
            this.hasDirty.set(!this.dirtyScenes.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUploadScene(GlassScene glassScene) {
        if (verbose) {
            System.out.println("CF.addUploadScene: " + glassScene.hashCode() + this.sceneSize(glassScene));
        }
        CollectedFuture collectedFuture = this;
        synchronized (collectedFuture) {
            if (!this.uploadScenes.contains(glassScene)) {
                this.uploadScenes.add(glassScene);
            }
            this.hasUpload.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUploadScene(GlassScene glassScene) {
        if (verbose) {
            System.out.println("CF.removeUploadScene: " + glassScene.hashCode() + this.sceneSize(glassScene));
        }
        CollectedFuture collectedFuture = this;
        synchronized (collectedFuture) {
            this.uploadScenes.remove(glassScene);
            this.hasUpload.set(!this.uploadScenes.isEmpty());
        }
    }

    void renderComplete(GlassScene glassScene) {
        if (verbose) {
            System.out.println("CF.renderComplete: " + glassScene.hashCode() + this.sceneSize(glassScene));
        }
        this.dirtyMarker.remove(glassScene);
        glassScene.frameRendered();
        if (this.dirtyMarker.isEmpty()) {
            try {
                this.pulseBarrier.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (BrokenBarrierException brokenBarrierException) {
                brokenBarrierException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void repaintAll() {
        if (this.hasDirty.get()) {
            Object object = this;
            synchronized (object) {
                this.pulseBarrier.reset();
                this.dirtyMarker.addAll(this.dirtyScenes);
                this.dirtyWork.addAll(this.dirtyScenes);
                this.dirtyScenes.clear();
            }
            if (verbose) {
                System.out.println("CF.repaintAll: #work: " + this.dirtyWork.size());
            }
            for (GlassScene glassScene : this.dirtyWork) {
                try {
                    glassScene.repaint();
                    glassScene.clearDirty();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                this.pulseBarrier.await();
                object = this;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                CollectedFuture collectedFuture = this;
                synchronized (collectedFuture) {
                    this.dirtyWork.clear();
                    assert (this.dirtyMarker.isEmpty());
                    this.hasDirty.set(!this.dirtyScenes.isEmpty());
                }
            }
            catch (BrokenBarrierException brokenBarrierException) {
                brokenBarrierException.printStackTrace();
                CollectedFuture collectedFuture = this;
                {
                    catch (Throwable throwable) {
                        CollectedFuture collectedFuture2 = this;
                        synchronized (collectedFuture2) {
                            this.dirtyWork.clear();
                            assert (this.dirtyMarker.isEmpty());
                            this.hasDirty.set(!this.dirtyScenes.isEmpty());
                        }
                        throw throwable;
                    }
                }
                synchronized (collectedFuture) {
                    this.dirtyWork.clear();
                    assert (this.dirtyMarker.isEmpty());
                    this.hasDirty.set(!this.dirtyScenes.isEmpty());
                }
            }
            synchronized (object) {
                this.dirtyWork.clear();
                assert (this.dirtyMarker.isEmpty());
                this.hasDirty.set(!this.dirtyScenes.isEmpty());
            }
        }
    }

    void uploadAll() {
        if (this.hasUpload.get()) {
            if (verbose) {
                System.out.println("CF.uploadAll: #upload: " + this.uploadScenes.size());
            }
            for (GlassScene glassScene : this.uploadScenes) {
                final ViewScene viewScene = (ViewScene)glassScene;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        RenderJob renderJob = (RenderJob)viewScene.getPenFuture();
                        Pixels pixels = (Pixels)renderJob.get();
                        viewScene.uploadPixels(pixels);
                    }
                };
                if (viewScene.getPlatformView() == null) continue;
                Application.postOnEventQueue(runnable);
            }
            this.uploadScenes.clear();
            this.hasUpload.set(false);
        }
    }
}

