/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.svgpath.util.io;

import com.sun.javafx.svgpath.util.io.CharDecoder;
import com.sun.javafx.svgpath.util.io.Messages;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractCharDecoder
implements CharDecoder {
    protected static final int BUFFER_SIZE = 8192;
    protected InputStream inputStream;
    protected byte[] buffer = new byte[8192];
    protected int position;
    protected int count;

    protected AbstractCharDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void dispose() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
    }

    protected void fillBuffer() throws IOException {
        this.count = this.inputStream.read(this.buffer, 0, 8192);
        this.position = 0;
    }

    protected void charError(String string) throws IOException {
        throw new IOException(Messages.formatMessage("invalid.char", new Object[]{string}));
    }

    protected void endOfStreamError(String string) throws IOException {
        throw new IOException(Messages.formatMessage("end.of.stream", new Object[]{string}));
    }

    @Override
    public abstract int readChar() throws IOException;
}

