/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.event.DirectEvent;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.event.EventUtil;
import com.sun.javafx.stage.FocusUngrabEvent;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.PopupWindow;

public final class PopupEventRedirector
extends EventRedirector {
    private static final KeyCombination ESCAPE_KEY_COMBINATION = KeyCombination.keyCombination("Esc");
    private final PopupWindow popupWindow;

    public PopupEventRedirector(PopupWindow popupWindow) {
        super(popupWindow);
        this.popupWindow = popupWindow;
    }

    @Override
    protected void handleRedirectedEvent(Object object, Event event) {
        if (event instanceof KeyEvent) {
            this.handleKeyEvent((KeyEvent)event);
            return;
        }
        EventType<? extends Event> eventType = event.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            this.handleMousePressedEvent(object, event);
            return;
        }
        if (eventType == FocusUngrabEvent.FOCUS_UNGRAB) {
            this.handleFocusUngrabEvent();
            return;
        }
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        Scene scene = this.popupWindow.getScene();
        if (scene != null) {
            EventTarget eventTarget;
            Node node = scene.impl_getFocusOwner();
            EventTarget eventTarget2 = eventTarget = node != null ? node : scene;
            if (EventUtil.fireEvent(eventTarget, new DirectEvent(keyEvent)) == null) {
                keyEvent.consume();
                return;
            }
        }
        if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && ESCAPE_KEY_COMBINATION.match(keyEvent)) {
            this.handleEscapeKeyPressedEvent();
        }
    }

    private void handleEscapeKeyPressedEvent() {
        if (this.popupWindow.isHideOnEscape()) {
            this.popupWindow.doAutoHide();
        }
    }

    private void handleMousePressedEvent(Object object, Event event) {
        if (this.popupWindow.getOwnerWindow() != object) {
            return;
        }
        if (this.popupWindow.isAutoHide() && !this.isOwnerNodeEvent(event)) {
            Event.fireEvent(this.popupWindow, new FocusUngrabEvent());
            this.popupWindow.doAutoHide();
        }
    }

    private void handleFocusUngrabEvent() {
        if (this.popupWindow.isAutoHide()) {
            this.popupWindow.doAutoHide();
        }
    }

    private boolean isOwnerNodeEvent(Event event) {
        Node node = this.popupWindow.getOwnerNode();
        if (node == null) {
            return false;
        }
        EventTarget eventTarget = event.getTarget();
        if (!(eventTarget instanceof Node)) {
            return false;
        }
        Node node2 = (Node)eventTarget;
        do {
            if (node2 != node) continue;
            return true;
        } while ((node2 = node2.getParent()) != null);
        return false;
    }
}

