/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public class TreeCellSkin
extends CellSkinBase<TreeCell<?>, TreeCellBehavior> {
    private static final Map<TreeView, Double> maxDisclosureWidthMap = new WeakHashMap<TreeView, Double>();
    @Styleable(property="-fx-indent", initial="10")
    private DoubleProperty indent = new SimpleDoubleProperty(this, "indent", 10.0);

    public final void setIndent(double d) {
        this.indentProperty().set(d);
    }

    public final double getIndent() {
        return this.indent.get();
    }

    public final DoubleProperty indentProperty() {
        return this.indent;
    }

    public TreeCellSkin(TreeCell<?> treeCell) {
        super(treeCell, new TreeCellBehavior(treeCell));
        this.updateDisclosureNode();
        this.registerChangeListener(treeCell.treeItemProperty(), "TREE_ITEM");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "TREE_ITEM") {
            this.updateDisclosureNode();
        }
    }

    private void updateDisclosureNode() {
        TreeItem treeItem = ((TreeCell)this.getSkinnable()).getTreeItem();
        if (treeItem == null) {
            return;
        }
        if (((TreeCell)this.getSkinnable()).isEmpty()) {
            return;
        }
        Node node = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        if (node == null) {
            return;
        }
        boolean bl = treeItem != null && !treeItem.isLeaf();
        node.setVisible(bl);
        if (node.getParent() == null) {
            this.getChildren().add(0, node);
        } else {
            node.toBack();
        }
    }

    @Override
    public void impl_processCSS(boolean bl) {
        this.updateDisclosureNode();
        super.impl_processCSS(bl);
    }

    @Override
    protected void layoutChildren() {
        double d;
        TreeItem treeItem = ((TreeCell)this.getSkinnable()).getTreeItem();
        if (treeItem == null) {
            return;
        }
        TreeView treeView = ((TreeCell)this.getSkinnable()).getTreeView();
        if (treeView == null) {
            return;
        }
        double d2 = this.getInsets().getLeft();
        double d3 = this.getInsets().getTop();
        double d4 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d5 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        Node node = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        int n = TreeView.getNodeLevel(((TreeCell)this.getSkinnable()).getTreeItem());
        if (!treeView.isShowRoot()) {
            --n;
        }
        double d6 = this.getIndent() * (double)n;
        d2 += d6;
        boolean bl = node != null && treeItem != null && !treeItem.isLeaf();
        double d7 = d = maxDisclosureWidthMap.containsKey(treeView) ? maxDisclosureWidthMap.get(treeView) : 0.0;
        if (bl) {
            d7 = node.prefWidth(-1.0);
            if (d7 > d) {
                maxDisclosureWidthMap.put(treeView, d7);
            }
            double d8 = node.prefHeight(-1.0);
            node.resize(d7, d8);
            this.positionInArea(node, d2, d3, d7, d5, 0.0, HPos.CENTER, VPos.CENTER);
        }
        int n2 = treeItem.getGraphic() == null ? 0 : 3;
        this.layoutLabelInArea(d2 += d7 + (double)n2, d3, d4 -= d6 + d7 + (double)n2, d5);
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = super.computePrefHeight(d);
        Node node = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        return node == null ? d2 : Math.max(node.prefHeight(-1.0), d2);
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = super.computePrefWidth(d);
        double d3 = this.getInsets().getLeft() + this.getInsets().getRight();
        TreeView treeView = ((TreeCell)this.getSkinnable()).getTreeView();
        if (treeView == null) {
            return d3;
        }
        TreeItem treeItem = ((TreeCell)this.getSkinnable()).getTreeItem();
        if (treeItem == null) {
            return d3;
        }
        d3 = d2;
        int n = TreeView.getNodeLevel(treeItem);
        if (!treeView.isShowRoot()) {
            --n;
        }
        d3 += this.getIndent() * (double)n;
        Node node = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        double d4 = maxDisclosureWidthMap.containsKey(treeView) ? maxDisclosureWidthMap.get(treeView) : 0.0;
        return d3 += Math.max(d4, node.prefWidth(-1.0));
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-indent".equals(string)) {
            this.setIndent((Double)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-indent".equals(string)) {
            return this.indent == null || !this.indent.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty INDENT = new StyleableProperty(TreeCellSkin.class, "indent");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(CellSkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, INDENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

