/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.util.Duration;

public abstract class TextInputControlSkin<T extends TextInputControl, B extends TextInputControlBehavior<T>>
extends SkinBase<T, B> {
    private static final boolean macOS = Utils.isMac();
    @Styleable(property="-fx-font", inherits=true)
    protected final ObjectProperty<Font> font = new SimpleObjectProperty<Font>(this, "font", Font.getDefault());
    protected final ObservableObjectValue<FontMetrics> fontMetrics = new ObjectBinding<FontMetrics>(){
        {
            this.bind(TextInputControlSkin.this.font);
        }

        @Override
        protected FontMetrics computeValue() {
            return Toolkit.getToolkit().getFontLoader().getFontMetrics((Font)TextInputControlSkin.this.font.get());
        }
    };
    @Styleable(property="-fx-text-fill", initial="black")
    protected final ObjectProperty<Paint> textFill = new SimpleObjectProperty<Color>(this, "textFill", Color.BLACK);
    @Styleable(property="-fx-prompt-text-fill", initial="gray")
    protected final ObjectProperty<Paint> promptTextFill = new SimpleObjectProperty<Color>(this, "promptTextFill", Color.GRAY);
    @Styleable(property="-fx-highlight-fill", initial="dodgerblue")
    protected final ObjectProperty<Paint> highlightFill = new SimpleObjectProperty<Color>(this, "highlightFill", Color.DODGERBLUE);
    @Styleable(property="-fx-highlight-text-fill", initial="white")
    protected final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty<Color>(this, "highlightTextFill", Color.WHITE);
    @Styleable(property="-fx-display-caret", initial="true")
    protected final BooleanProperty displayCaret = new SimpleBooleanProperty(this, "displayCaret", true);
    private BooleanProperty blink = new SimpleBooleanProperty(this, "blink", true);
    protected ObservableBooleanValue caretVisible;
    private Timeline caretTimeline = new Timeline();
    protected final Path caretPath = new Path();
    private int imstart;
    private int imlength;
    private List<Shape> imattrs = new ArrayList<Shape>();

    public TextInputControlSkin(T t, B b) {
        super(t, b);
        this.caretTimeline = new Timeline();
        this.caretTimeline.setCycleCount(-1);
        this.caretTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                TextInputControlSkin.this.blink.set(false);
            }
        }, new KeyValue[0]), new KeyFrame(Duration.seconds(0.5), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                TextInputControlSkin.this.blink.set(true);
            }
        }, new KeyValue[0]), new KeyFrame(Duration.seconds(1.0), new KeyValue[0])});
        this.caretVisible = new BooleanBinding((TextInputControl)t){
            final /* synthetic */ TextInputControl val$textInput;
            {
                this.val$textInput = textInputControl;
                this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), this.val$textInput.editableProperty(), TextInputControlSkin.this.displayCaret, TextInputControlSkin.this.blink);
            }

            @Override
            protected boolean computeValue() {
                return !TextInputControlSkin.this.blink.get() && TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && (!macOS || this.val$textInput.getCaretPosition() == this.val$textInput.getAnchor()) && !this.val$textInput.isDisabled() && this.val$textInput.isEditable();
            }
        };
        if (((Node)t).getOnInputMethodTextChanged() == null) {
            ((Node)t).setOnInputMethodTextChanged((EventHandler<InputMethodEvent>)new EventHandler<InputMethodEvent>(){

                @Override
                public void handle(InputMethodEvent inputMethodEvent) {
                    TextInputControlSkin.this.handleInputMethodEvent(inputMethodEvent);
                }
            });
        }
        ((Node)t).setInputMethodRequests(new InputMethodRequests(){

            @Override
            public Point2D getTextLocation(int n) {
                Scene scene = TextInputControlSkin.this.getScene();
                Window window = scene.getWindow();
                Rectangle2D rectangle2D = TextInputControlSkin.this.getCharacterBounds(TextInputControlSkin.this.imstart + n);
                Point2D point2D = TextInputControlSkin.this.localToScene(rectangle2D.getMinX(), rectangle2D.getMaxY());
                Point2D point2D2 = new Point2D(window.getX() + scene.getX() + point2D.getX() - 6.0, window.getY() + scene.getY() + point2D.getY() - 42.0);
                return point2D2;
            }

            @Override
            public int getLocationOffset(int n, int n2) {
                return TextInputControlSkin.this.getInsertionPoint(n, n2);
            }

            @Override
            public void cancelLatestCommittedText() {
            }

            @Override
            public String getSelectedText() {
                TextInputControl textInputControl = (TextInputControl)TextInputControlSkin.this.getSkinnable();
                IndexRange indexRange = textInputControl.getSelection();
                return textInputControl.getText(indexRange.getStart(), indexRange.getEnd());
            }
        });
    }

    @Override
    public void dispose() {
        this.caretTimeline.stop();
        this.caretTimeline = null;
    }

    public char getCharacter(int n) {
        return '\u0000';
    }

    public int getInsertionPoint(double d, double d2) {
        return 0;
    }

    public Rectangle2D getCharacterBounds(int n) {
        return null;
    }

    public void scrollCharacterToVisible(int n) {
    }

    protected void updateTextFill() {
    }

    protected void updateHighlightFill() {
    }

    protected void updateHighlightTextFill() {
    }

    protected void handleInputMethodEvent(InputMethodEvent inputMethodEvent) {
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        if (textInputControl.isEditable() && !textInputControl.textProperty().isBound() && !textInputControl.isDisabled()) {
            CharSequence charSequence;
            if (this.imlength != 0) {
                this.removeHighlight(this.imattrs);
                this.imattrs.clear();
                textInputControl.selectRange(this.imstart, this.imstart + this.imlength);
            }
            if (inputMethodEvent.getCommitted().length() != 0) {
                charSequence = inputMethodEvent.getCommitted();
                textInputControl.replaceText(textInputControl.getSelection(), (String)charSequence);
            }
            this.imstart = textInputControl.getSelection().getStart();
            charSequence = new StringBuilder();
            for (InputMethodTextRun object : inputMethodEvent.getComposed()) {
                ((StringBuilder)charSequence).append(object.getText());
            }
            this.imlength = ((StringBuilder)charSequence).length();
            if (this.imlength != 0) {
                textInputControl.replaceText(textInputControl.getSelection(), ((StringBuilder)charSequence).toString());
                int n = this.imstart;
                for (InputMethodTextRun inputMethodTextRun : inputMethodEvent.getComposed()) {
                    int n2 = n + inputMethodTextRun.getText().length();
                    this.createInputMethodAttributes(inputMethodTextRun.getHighlight(), n, n2);
                    n = n2;
                }
                this.addHighlight(this.imattrs, this.imstart);
                int n3 = inputMethodEvent.getCaretPosition();
                if (n3 >= 0 && n3 < this.imlength) {
                    textInputControl.selectRange(this.imstart + n3, this.imstart + n3);
                }
            }
        }
    }

    protected abstract PathElement[] getUnderlineShape(int var1, int var2);

    protected abstract PathElement[] getRangeShape(int var1, int var2);

    protected abstract void addHighlight(List<? extends Node> var1, int var2);

    protected abstract void removeHighlight(List<? extends Node> var1);

    private void createInputMethodAttributes(InputMethodHighlight inputMethodHighlight, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (PathElement pathElement : this.getUnderlineShape(n, n2)) {
            if (pathElement instanceof MoveTo) {
                d = d2 = ((MoveTo)pathElement).getX();
                d3 = d4 = ((MoveTo)pathElement).getY();
                continue;
            }
            if (pathElement instanceof LineTo) {
                d = d < ((LineTo)pathElement).getX() ? d : ((LineTo)pathElement).getX();
                d2 = d2 > ((LineTo)pathElement).getX() ? d2 : ((LineTo)pathElement).getX();
                d3 = d3 < ((LineTo)pathElement).getY() ? d3 : ((LineTo)pathElement).getY();
                d4 = d4 > ((LineTo)pathElement).getY() ? d4 : ((LineTo)pathElement).getY();
                continue;
            }
            if (pathElement instanceof HLineTo) {
                d = d < ((HLineTo)pathElement).getX() ? d : ((HLineTo)pathElement).getX();
                d2 = d2 > ((HLineTo)pathElement).getX() ? d2 : ((HLineTo)pathElement).getX();
                continue;
            }
            if (pathElement instanceof VLineTo) {
                d3 = d3 < ((VLineTo)pathElement).getY() ? d3 : ((VLineTo)pathElement).getY();
                d4 = d4 > ((VLineTo)pathElement).getY() ? d4 : ((VLineTo)pathElement).getY();
                continue;
            }
            if (!(pathElement instanceof ClosePath)) continue;
            Shape shape = null;
            if (inputMethodHighlight == InputMethodHighlight.SELECTED_RAW) {
                shape = new Path();
                ((Path)shape).getElements().addAll((PathElement[])this.getRangeShape(n, n2));
                shape.setFill(Color.BLUE);
                shape.setOpacity(0.3f);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_RAW) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth(d4 - d3);
                ObservableList<Double> observableList = shape.getStrokeDashArray();
                observableList.add(2.0);
                observableList.add(2.0);
            } else if (inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth((d4 - d3) * 3.0);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_CONVERTED) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth(d4 - d3);
            }
            shape.setManaged(false);
            shape.setSmooth(false);
            this.imattrs.add(shape);
        }
    }

    public void setCaretAnimating(boolean bl) {
        if (bl) {
            this.caretTimeline.play();
        } else {
            this.caretTimeline.stop();
            this.blink.set(true);
        }
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-font".equals(string)) {
            this.font.set((Font)object);
        } else if ("-fx-text-fill".equals(string)) {
            this.textFill.set((Paint)object);
        } else if ("-fx-prompt-text-fill".equals(string)) {
            this.promptTextFill.set((Paint)object);
        } else if ("-fx-highlight-fill".equals(string)) {
            this.highlightFill.set((Paint)object);
        } else if ("-fx-highlight-text-fill".equals(string)) {
            this.highlightTextFill.set((Paint)object);
        } else if ("-fx-display-caret".equals(string)) {
            this.displayCaret.set((Boolean)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        return "-fx-font".equals(string) || "-fx-text-fill".equals(string) || "-fx-prompt-text-fill".equals(string) || "-fx-highlight-fill".equals(string) || "-fx-highlight-text-fill".equals(string) || "-fx-display-caret".equals(string) || super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty FONT = new StyleableProperty(TextInputControlSkin.class, "font", StyleableProperty.FONT.getSubProperties());
        private static final StyleableProperty TEXT_FILL = new StyleableProperty(TextInputControlSkin.class, "textFill");
        private static final StyleableProperty PROMPT_TEXT_FILL = new StyleableProperty(TextInputControlSkin.class, "promptTextFill");
        private static final StyleableProperty HIGHLIGHT_FILL = new StyleableProperty(TextInputControlSkin.class, "highlightFill");
        private static final StyleableProperty HIGHLIGHT_TEXT_FILL = new StyleableProperty(TextInputControlSkin.class, "highlightTextFill");
        private static final StyleableProperty DISPLAY_CARET = new StyleableProperty(TextInputControlSkin.class, "displayCaret");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, TEXT_FILL, PROMPT_TEXT_FILL, HIGHLIGHT_FILL, HIGHLIGHT_TEXT_FILL, DISPLAY_CARET);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

