/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.control.TableCell;

public class TableCellSkin
extends CellSkinBase<TableCell, TableCellBehavior> {
    static final String DEFER_TO_PARENT_PREF_WIDTH = "deferToParentPrefWidth";
    private boolean isDeferToParentForPrefWidth = false;
    private boolean isSizeDirty = false;
    private InvalidationListener columnWidthListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCellSkin.this.isSizeDirty = true;
            TableCellSkin.this.requestLayout();
        }
    };
    private WeakInvalidationListener weakColumnWidthListener = new WeakInvalidationListener(this.columnWidthListener);

    public TableCellSkin(TableCell tableCell) {
        super(tableCell, new TableCellBehavior(tableCell));
        if (((TableCell)this.getSkinnable()).getTableColumn() != null) {
            ((TableCell)this.getSkinnable()).getTableColumn().widthProperty().addListener(new WeakInvalidationListener(this.weakColumnWidthListener));
        }
        this.registerChangeListener(tableCell.visibleProperty(), "VISIBLE");
        if (((TableCell)this.getSkinnable()).getProperties().containsKey(DEFER_TO_PARENT_PREF_WIDTH)) {
            this.isDeferToParentForPrefWidth = true;
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "VISIBLE") {
            this.setVisible(((TableCell)this.getSkinnable()).getTableColumn().isVisible());
        }
    }

    @Override
    protected void layoutChildren() {
        if (this.isSizeDirty) {
            this.resize(((TableCell)this.getSkinnable()).getTableColumn().getWidth(), this.getHeight());
            this.isSizeDirty = false;
        }
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        this.layoutLabelInArea(d, d2, d3, d4 - this.getPadding().getBottom());
    }

    @Override
    protected double computePrefWidth(double d) {
        if (this.isDeferToParentForPrefWidth) {
            return super.computePrefWidth(d);
        }
        return ((TableCell)this.getSkinnable()).getTableColumn().getWidth();
    }
}

