/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.behavior.ProgressBarBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ProgressBarSkin
extends SkinBase<ProgressBar, ProgressBarBehavior<ProgressBar>> {
    private StackPane bar;
    private StackPane track;
    private Rectangle clipRectangle;
    private double barWidth;
    @Styleable(property="-fx-indeterminate-bar-length", initial="60")
    private double indeterminateBarLength = 60.0;
    @Styleable(property="-fx-indeterminate-bar-escape", initial="true")
    private boolean indeterminateBarEscape = true;
    @Styleable(property="-fx-indeterminate-bar-flip", initial="true")
    private boolean indeterminateBarFlip = true;
    @Styleable(property="-fx-indeterminate-bar-animation-time", initial="2")
    private double indeterminateBarAnimationTime = 2.0;
    private Timeline indeterminateTimeline;
    private boolean timelineNulled = false;

    public ProgressBarSkin(ProgressBar progressBar) {
        super(progressBar, new ProgressBarBehavior<ProgressBar>(progressBar));
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ProgressBarSkin.this.initialize();
            }
        };
        progressBar.indeterminateProperty().addListener(invalidationListener);
        InvalidationListener invalidationListener2 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).isIndeterminate() && ProgressBarSkin.this.timelineNulled && ProgressBarSkin.this.indeterminateTimeline == null) {
                    ProgressBarSkin.this.timelineNulled = false;
                    ProgressBarSkin.this.createIndeterminateTimeline();
                }
                if (ProgressBarSkin.this.indeterminateTimeline != null) {
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).isVisible() && ((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() != null) {
                        ProgressBarSkin.this.indeterminateTimeline.play();
                    } else {
                        ProgressBarSkin.this.indeterminateTimeline.pause();
                        ProgressBarSkin.this.indeterminateTimeline = null;
                        ProgressBarSkin.this.timelineNulled = true;
                    }
                }
            }
        };
        progressBar.visibleProperty().addListener(invalidationListener2);
        progressBar.parentProperty().addListener(invalidationListener2);
        InvalidationListener invalidationListener3 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ProgressBarSkin.this.indeterminateTimeline != null) {
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() == null) {
                        ProgressBarSkin.this.indeterminateTimeline.pause();
                        ProgressBarSkin.this.indeterminateTimeline = null;
                        ProgressBarSkin.this.timelineNulled = true;
                    }
                } else if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() != null && ((ProgressBar)ProgressBarSkin.this.getSkinnable()).isIndeterminate()) {
                    ProgressBarSkin.this.timelineNulled = false;
                    ProgressBarSkin.this.createIndeterminateTimeline();
                    ProgressBarSkin.this.indeterminateTimeline.play();
                    ProgressBarSkin.this.requestLayout();
                }
            }
        };
        progressBar.sceneProperty().addListener(invalidationListener3);
        this.barWidth = (double)((int)(progressBar.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight()) * 2) * Math.min(1.0, Math.max(0.0, progressBar.getProgress())) / 2.0;
        InvalidationListener invalidationListener4 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ProgressBarSkin.this.updateProgress();
            }
        };
        progressBar.widthProperty().addListener(invalidationListener4);
        progressBar.progressProperty().addListener(invalidationListener4);
        this.clipRectangle = new Rectangle();
        this.setClip(this.clipRectangle);
        this.initialize();
        this.requestLayout();
    }

    private void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        boolean bl = progressBar.isIndeterminate();
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((String[])new String[]{"bar"});
        this.getChildren().setAll((Node[])new Node[]{this.track, this.bar});
    }

    private void createIndeterminateTimeline() {
        if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
        }
        double d = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d2 = this.indeterminateBarEscape ? -this.indeterminateBarLength : 0.0;
        double d3 = this.indeterminateBarEscape ? d : d - this.indeterminateBarLength;
        this.indeterminateTimeline = new Timeline();
        this.indeterminateTimeline.setAutoReverse(this.indeterminateBarFlip);
        this.indeterminateTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = FXCollections.observableArrayList();
        if (!this.indeterminateBarFlip) {
            this.bar.setScaleX(-1.0);
        }
        observableList.add(new KeyFrame(Duration.millis(0.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (ProgressBarSkin.this.indeterminateBarFlip) {
                    ProgressBarSkin.this.bar.setScaleX(ProgressBarSkin.this.bar.getScaleX() * -1.0);
                }
            }
        }, new KeyValue(this.bar.translateXProperty(), d2)));
        observableList.add(new KeyFrame(Duration.millis(this.indeterminateBarAnimationTime * 1000.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (ProgressBarSkin.this.indeterminateBarFlip) {
                    ProgressBarSkin.this.bar.setScaleX(ProgressBarSkin.this.bar.getScaleX() * -1.0);
                }
            }
        }, new KeyValue(this.bar.translateXProperty(), d3)));
        this.indeterminateTimeline.getKeyFrames().addAll((Collection<KeyFrame>)observableList);
    }

    private void updateProgress() {
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        this.barWidth = (double)((int)(progressBar.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight()) * 2) * Math.min(1.0, Math.max(0.0, progressBar.getProgress())) / 2.0;
        this.requestLayout();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
            this.indeterminateTimeline.getKeyFrames().clear();
            this.indeterminateTimeline = null;
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        return Math.max(100.0, this.getInsets().getLeft() + this.bar.prefWidth(this.getWidth()) + this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.getInsets().getTop() + this.bar.prefHeight(d) + this.getInsets().getBottom();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ProgressBar)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ProgressBar)this.getSkinnable()).prefHeight(d);
    }

    @Override
    protected void layoutChildren() {
        boolean bl = ((ProgressBar)this.getSkinnable()).isIndeterminate();
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        if (this.clipRectangle != null) {
            this.clipRectangle.setWidth(this.getWidth());
            this.clipRectangle.setHeight(this.getHeight());
        }
        this.track.resizeRelocate(d, d2, d3, d4);
        this.bar.resizeRelocate(d, d2, bl ? this.indeterminateBarLength : this.barWidth, this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom()));
        this.track.setVisible(true);
        if (bl) {
            this.createIndeterminateTimeline();
            if (((ProgressBar)this.getSkinnable()).isVisible()) {
                this.indeterminateTimeline.play();
            }
        } else if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
            this.indeterminateTimeline = null;
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-indeterminate-bar-length".equals(string)) {
            this.indeterminateBarLength = (Double)object;
        } else if ("-fx-indeterminate-bar-escape".equals(string)) {
            this.indeterminateBarEscape = (Boolean)object;
        } else if ("-fx-indeterminate-bar-flip".equals(string)) {
            this.indeterminateBarFlip = (Boolean)object;
        } else if ("-fx-indeterminate-bar-animation-time".equals(string)) {
            this.indeterminateBarAnimationTime = (Double)object;
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-indeterminate-bar-length".equals(string)) {
            return true;
        }
        if ("-fx-indeterminate-bar-escape".equals(string)) {
            return true;
        }
        if ("-fx-indeterminate-bar-flip".equals(string)) {
            return true;
        }
        if ("-fx-indeterminate-bar-animation-time".equals(string)) {
            return true;
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty INDETERMINATE_BAR_LENGTH = new StyleableProperty(ProgressBarSkin.class, "indeterminateBarLength");
        private static final StyleableProperty INDETERMINATE_BAR_ESCAPE = new StyleableProperty(ProgressBarSkin.class, "indeterminateBarEscape");
        private static final StyleableProperty INDETERMINATE_BAR_FLIP = new StyleableProperty(ProgressBarSkin.class, "indeterminateBarFlip");
        private static final StyleableProperty INDETERMINATE_BAR_ANIMATION_TIME = new StyleableProperty(ProgressBarSkin.class, "indeterminateBarAnimationTime");
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, INDETERMINATE_BAR_LENGTH, INDETERMINATE_BAR_ESCAPE, INDETERMINATE_BAR_FLIP, INDETERMINATE_BAR_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

