/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.Popup;
import javafx.stage.Window;

public class PopupControlSkin<C extends PopupControl>
implements Skin<C> {
    protected static int visiblePopupControlCount = 0;
    protected Node content;
    protected Node popupContent;
    protected boolean showing = false;
    protected Popup popup;
    protected double screenX;
    protected double screenY;

    protected void setShowing(boolean bl) {
        boolean bl2 = this.showing;
        this.showing = bl;
        this.showHidePopup(bl2);
    }

    protected void showHidePopup(boolean bl) {
        if (this.showing) {
            ++visiblePopupControlCount;
            this.showPopup();
        } else if (bl) {
            --visiblePopupControlCount;
            this.hidePopup();
        }
    }

    protected void onAutoHide() {
    }

    protected void showPopup() {
        Window window;
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoHide(true);
            this.popup.setAutoFix(true);
            this.popup.setOnAutoHide(new EventHandler<Event>(){

                @Override
                public void handle(Event event) {
                    PopupControlSkin.this.onAutoHide();
                }
            });
        }
        Scene scene = this.content == null ? null : this.content.getScene();
        Window window2 = window = scene == null ? null : scene.getWindow();
        if (window == null) {
            return;
        }
        this.popup.show(this.content, this.screenX, this.screenY);
        this.popup.getContent().setAll((Node[])new Node[]{this.popupContent});
        this.popupContent.impl_processCSS(true);
        if (this.popupContent instanceof Parent) {
            ((Parent)this.popupContent).requestLayout();
        }
        this.popupContent.autosize();
    }

    protected void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup.getContent().clear();
            this.popup = null;
        }
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public C getSkinnable() {
        return null;
    }
}

