/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

class NestedTableColumnHeader
extends TableColumnHeader {
    private final ListChangeListener<TableColumn> columnsListener = new ListChangeListener<TableColumn>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn> change) {
            NestedTableColumnHeader.this.setColumns(change.getList());
        }
    };
    private final InvalidationListener columnTextListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            NestedTableColumnHeader.this.label.setVisible(NestedTableColumnHeader.this.getTableColumn().getText() != null && !NestedTableColumnHeader.this.getTableColumn().getText().isEmpty());
        }
    };
    private final InvalidationListener resizePolicyListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            NestedTableColumnHeader.this.updateContent();
        }
    };
    private final WeakListChangeListener weakColumnsListener = new WeakListChangeListener<TableColumn>(this.columnsListener);
    private final WeakInvalidationListener weakColumnTextListener = new WeakInvalidationListener(this.columnTextListener);
    private final WeakInvalidationListener weakResizePolicyListener = new WeakInvalidationListener(this.resizePolicyListener);
    private static final int DRAG_RECT_WIDTH = 4;
    private ObservableList<? extends TableColumn> columns;
    private TableColumnHeader label;
    private List<TableColumnHeader> columnHeaders;
    private double lastX = 0.0;
    private double dragAnchorX = 0.0;
    private List<Rectangle> dragRects;

    public NestedTableColumnHeader(TableView tableView, TableColumn tableColumn) {
        super(tableView, tableColumn);
        this.getStyleClass().setAll((String[])new String[]{"nested-column-header"});
        this.setFocusTraversable(false);
        this.initUI();
        if (this.getTableColumn() == null && this.getTableView() != null) {
            this.setColumns(this.getTableView().getColumns());
        } else if (this.getTableColumn() != null) {
            this.setColumns(this.getTableColumn().getColumns());
        }
        this.getColumns().addListener(this.weakColumnsListener);
    }

    @Override
    public void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        super.setTableHeaderRow(tableHeaderRow);
        this.label.setTableHeaderRow(tableHeaderRow);
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            tableColumnHeader.setTableHeaderRow(tableHeaderRow);
        }
    }

    @Override
    public void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        super.setParentHeader(nestedTableColumnHeader);
        this.label.setParentHeader(nestedTableColumnHeader);
    }

    public ObservableList<? extends TableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(ObservableList<? extends TableColumn> observableList) {
        this.columns = observableList;
        ArrayList<TableColumnHeader> arrayList = new ArrayList<TableColumnHeader>(this.getColumnHeaders());
        this.getColumnHeaders().clear();
        for (int i = 0; i < this.getColumns().size(); ++i) {
            TableColumnHeader tableColumnHeader = null;
            TableColumn tableColumn = (TableColumn)this.getColumns().get(i);
            if (tableColumn == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!tableColumn.equals(arrayList.get(j).getTableColumn())) continue;
                tableColumnHeader = arrayList.get(j);
                break;
            }
            if (tableColumnHeader == null) {
                tableColumnHeader = this.createColumnHeader(tableColumn);
            }
            this.getColumnHeaders().add(tableColumnHeader);
        }
        this.updateContent();
    }

    public List<TableColumnHeader> getColumnHeaders() {
        if (this.columnHeaders == null) {
            this.columnHeaders = new ArrayList<TableColumnHeader>();
        }
        return this.columnHeaders;
    }

    private void initUI() {
        this.label = new TableColumnHeader(this.getTableView(), this.getTableColumn());
        this.label.setTableHeaderRow(this.getTableHeaderRow());
        this.label.setParentHeader(this.getParentHeader());
        this.label.setNestedColumnHeader(this);
        if (this.getTableColumn() != null) {
            this.getTableColumn().textProperty().addListener(this.weakColumnTextListener);
        }
        this.getTableView().columnResizePolicyProperty().addListener(this.weakResizePolicyListener);
        this.updateContent();
    }

    private void updateContent() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(this.label);
        arrayList.addAll(this.getColumnHeaders());
        this.rebuildDragRects();
        arrayList.addAll(this.dragRects);
        this.getChildren().setAll((Collection<Node>)arrayList);
    }

    private void rebuildDragRects() {
        this.dragRects = new ArrayList<Rectangle>();
        if (this.getColumns() == null) {
            return;
        }
        boolean bl = TableView.CONSTRAINED_RESIZE_POLICY.equals(this.getTableView().getColumnResizePolicy());
        for (int i = 0; !(i >= this.getColumns().size() || bl && i == this.getColumns().size() - 1); ++i) {
            final TableColumn tableColumn = (TableColumn)this.getColumns().get(i);
            Rectangle rectangle = new Rectangle();
            rectangle.setWidth(4.0);
            rectangle.setHeight(this.getHeight() - this.label.getHeight());
            rectangle.setFill(Color.TRANSPARENT);
            rectangle.setVisible(false);
            rectangle.setCursor(Cursor.H_RESIZE);
            rectangle.setSmooth(false);
            rectangle.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.isPrimaryButtonDown()) {
                        NestedTableColumnHeader.this.resizeToFit(tableColumn);
                    } else {
                        Rectangle rectangle = (Rectangle)mouseEvent.getSource();
                        double d = NestedTableColumnHeader.this.getTableHeaderRow().sceneToLocal(rectangle.localToScene(rectangle.getBoundsInLocal())).getMinX() + 2.0;
                        NestedTableColumnHeader.this.dragAnchorX = mouseEvent.getSceneX();
                        NestedTableColumnHeader.this.columnResizingStarted(d);
                    }
                    mouseEvent.consume();
                }
            });
            rectangle.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    NestedTableColumnHeader.this.columnResizing(tableColumn, mouseEvent);
                    mouseEvent.consume();
                }
            });
            rectangle.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    NestedTableColumnHeader.this.columnResizingComplete(tableColumn, mouseEvent);
                    mouseEvent.consume();
                }
            });
            this.dragRects.add(rectangle);
        }
    }

    private void columnResizingStarted(double d) {
        this.getTableHeaderRow().getColumnReorderLine().setLayoutX(d);
    }

    private void columnResizing(TableColumn tableColumn, MouseEvent mouseEvent) {
        double d = mouseEvent.getSceneX() - this.dragAnchorX;
        double d2 = d - this.lastX;
        boolean bl = this.getTableView().resizeColumn(tableColumn, d2);
        if (bl) {
            this.lastX = d;
        }
    }

    private void columnResizingComplete(TableColumn tableColumn, MouseEvent mouseEvent) {
        this.getTableHeaderRow().getColumnReorderLine().setTranslateX(0.0);
        this.getTableHeaderRow().getColumnReorderLine().setLayoutX(0.0);
        this.lastX = 0.0;
    }

    private void resizeToFit(TableColumn tableColumn) {
        Node node;
        ObservableList observableList = this.getTableView().getItems();
        if (observableList == null) {
            return;
        }
        Callback callback = tableColumn.getCellFactory();
        if (callback == null) {
            return;
        }
        TableCell tableCell = callback.call(tableColumn);
        if (tableCell == null) {
            return;
        }
        tableCell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double d = 10.0;
        Node node2 = node = tableCell.getSkin() == null ? null : tableCell.getSkin().getNode();
        if (node instanceof Region) {
            Region region = (Region)node;
            d = region.getInsets().getLeft() + region.getInsets().getRight();
        }
        int n = observableList.size();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            tableCell.updateTableColumn(tableColumn);
            tableCell.updateTableView(this.getTableView());
            tableCell.updateIndex(i);
            if ((tableCell.getText() == null || tableCell.getText().isEmpty()) && tableCell.getGraphic() == null) continue;
            this.getChildren().add(tableCell);
            tableCell.impl_processCSS(false);
            d2 = Math.max(d2, tableCell.prefWidth(20.0));
            this.getChildren().remove(tableCell);
        }
        tableColumn.impl_setWidth(d2 + d);
    }

    @Override
    protected void layoutChildren() {
        double d = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d2 = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        int n = (int)this.label.prefHeight(-1.0);
        if (this.label.isVisible()) {
            this.label.resize(d, n);
            this.label.relocate(this.getInsets().getLeft(), this.getInsets().getTop());
        }
        double d3 = this.getInsets().getLeft();
        int n2 = 0;
        for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
            if (!tableColumnHeader.isVisible()) continue;
            double d4 = tableColumnHeader.prefWidth(-1.0);
            tableColumnHeader.resize(d4, this.snapSize(d2 - (double)n));
            tableColumnHeader.relocate(d3, (double)n + this.getInsets().getTop());
            d3 += d4;
            if (n2 >= this.dragRects.size()) continue;
            Rectangle rectangle = this.dragRects.get(n2++);
            rectangle.setVisible(true);
            rectangle.setHeight(this.getHeight() - this.label.getHeight());
            rectangle.relocate(d3 - 2.0, this.getInsets().getTop() + (double)n);
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        if (this.getColumns() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                if (!tableColumnHeader.isVisible()) continue;
                d2 += tableColumnHeader.computePrefWidth(d);
            }
        }
        return d2;
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        if (this.getColumnHeaders() != null) {
            for (TableColumnHeader tableColumnHeader : this.getColumnHeaders()) {
                d2 = Math.max(d2, tableColumnHeader.prefHeight(-1.0));
            }
        }
        return d2 + this.label.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    private TableColumnHeader createColumnHeader(TableColumn tableColumn) {
        TableColumnHeader tableColumnHeader = tableColumn.getColumns().isEmpty() ? new TableColumnHeader(this.getTableView(), tableColumn) : new NestedTableColumnHeader(this.getTableView(), tableColumn);
        tableColumnHeader.setTableHeaderRow(this.getTableHeaderRow());
        tableColumnHeader.setParentHeader(this);
        return tableColumnHeader;
    }
}

