/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TextBinding;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public abstract class LabeledSkinBase<C extends Labeled, B extends BehaviorBase<C>>
extends SkinBase<C, B> {
    Text text;
    boolean invalidText = true;
    private Node graphic;
    double textWidth = Double.NEGATIVE_INFINITY;
    double ellipsisWidth = Double.NEGATIVE_INFINITY;
    final InvalidationListener graphicPropertyChangedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            LabeledSkinBase.this.invalidText = true;
            LabeledSkinBase.this.requestLayout();
        }
    };
    private Rectangle textClip;
    public TextBinding bindings;
    Line mnemonic_underscore;
    private boolean containsMnemonic = false;
    private KeyCode mnemonicCode;
    private Node labeledNode = null;

    public LabeledSkinBase(C c, B b) {
        super(c, b);
        this.text = new Text();
        this.textClip = new Rectangle();
        this.text.setClip(this.textClip);
        this.updateFill();
        this.updateFont();
        this.updateTextAlignment();
        this.updateUnderline();
        this.updateChildren();
        this.registerChangeListener(((Control)c).widthProperty(), "WIDTH");
        this.registerChangeListener(((Control)c).heightProperty(), "HEIGHT");
        this.registerChangeListener(((Labeled)c).textFillProperty(), "TEXT_FILL");
        this.registerChangeListener(((Labeled)c).fontProperty(), "FONT");
        this.registerChangeListener(((Labeled)c).graphicProperty(), "GRAPHIC");
        this.registerChangeListener(((Labeled)c).contentDisplayProperty(), "CONTENT_DISPLAY");
        this.registerChangeListener(((Labeled)c).labelPaddingProperty(), "LABEL_PADDING");
        this.registerChangeListener(((Labeled)c).graphicTextGapProperty(), "GRAPHIC_TEXT_GAP");
        this.registerChangeListener(((Labeled)c).alignmentProperty(), "ALIGNMENT");
        this.registerChangeListener(((Labeled)c).mnemonicParsingProperty(), "MNEMONIC_PARSING");
        this.registerChangeListener(((Labeled)c).textProperty(), "TEXT");
        this.registerChangeListener(((Labeled)c).textAlignmentProperty(), "TEXT_ALIGNMENT");
        this.registerChangeListener(((Labeled)c).textOverrunProperty(), "TEXT_OVERRUN");
        this.registerChangeListener(((Labeled)c).wrapTextProperty(), "WRAP_TEXT");
        this.registerChangeListener(((Labeled)c).underlineProperty(), "UNDERLINE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "WIDTH") {
            this.updateWrappingWidth();
            this.invalidText = true;
        } else if (string == "HEIGHT") {
            this.invalidText = true;
        } else if (string == "TEXT_FILL") {
            this.updateFill();
        } else if (string == "FONT") {
            this.updateFont();
            this.textMetricsChanged();
            this.invalidateWidths();
            this.ellipsisWidth = Double.NEGATIVE_INFINITY;
        } else if (string == "GRAPHIC") {
            this.updateChildren();
            this.textMetricsChanged();
        } else if (string == "CONTENT_DISPLAY") {
            this.updateChildren();
            this.textMetricsChanged();
        } else if (string == "LABEL_PADDING") {
            this.textMetricsChanged();
        } else if (string == "GRAPHIC_TEXT_GAP") {
            this.textMetricsChanged();
        } else if (string == "ALIGNMENT") {
            this.requestLayout();
        } else if (string == "MNEMONIC_PARSING") {
            this.textMetricsChanged();
        } else if (string == "TEXT") {
            this.updateChildren();
            this.textMetricsChanged();
            this.invalidateWidths();
        } else if (string == "TEXT_ALIGNMENT") {
            this.updateTextAlignment();
        } else if (string == "TEXT_OVERRUN") {
            this.textMetricsChanged();
        } else if (string == "WRAP_TEXT") {
            this.updateWrappingWidth();
            this.textMetricsChanged();
        } else if (string == "UNDERLINE") {
            this.updateUnderline();
            this.textMetricsChanged();
        }
    }

    private void textMetricsChanged() {
        this.invalidText = true;
        this.requestLayout();
    }

    private void invalidateWidths() {
        this.textWidth = Double.NEGATIVE_INFINITY;
    }

    void updateDisplayedText() {
        this.updateDisplayedText(-1.0, -1.0);
    }

    private void updateDisplayedText(double d, double d2) {
        if (this.invalidText) {
            String string;
            boolean bl;
            int n;
            Object object;
            KeyCodeCombination keyCodeCombination;
            Labeled labeled = (Labeled)this.getSkinnable();
            String string2 = labeled.getText();
            int n2 = -1;
            if (string2 != null && string2.length() > 0) {
                this.bindings = new TextBinding(string2);
                if (!Utils.isMac() && ((Labeled)this.getSkinnable()).isMnemonicParsing()) {
                    this.labeledNode = labeled instanceof Label ? ((Label)labeled).getLabelFor() : labeled;
                    n2 = this.bindings.getMnemonicIndex();
                }
            }
            if (this.containsMnemonic && (n2 == -1 || this.bindings != null && this.bindings.getMnemonic() != this.mnemonicCode)) {
                keyCodeCombination = new KeyCodeCombination(this.mnemonicCode, Utils.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
                object = (ObservableList)((Labeled)this.getSkinnable()).getParent().getScene().getMnemonics().get(keyCodeCombination);
                if (object != null) {
                    for (n = 0; n < object.size(); ++n) {
                        if (((Mnemonic)object.get(n)).getNode() != this.labeledNode) continue;
                        object.remove(n);
                    }
                }
                this.containsMnemonic = false;
                this.mnemonicCode = null;
            }
            if (string2 != null && string2.length() > 0 && n2 >= 0 && !this.containsMnemonic) {
                this.containsMnemonic = true;
                this.mnemonicCode = this.bindings.getMnemonic();
                keyCodeCombination = new KeyCodeCombination(this.mnemonicCode, Utils.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
                if (this.labeledNode != null) {
                    object = new Mnemonic(this.labeledNode, keyCodeCombination);
                    this.labeledNode.getParent().getScene().addMnemonic((Mnemonic)object);
                }
            }
            if (this.containsMnemonic) {
                string2 = this.bindings.getText();
                if (this.mnemonic_underscore == null) {
                    this.mnemonic_underscore = new Line();
                    this.mnemonic_underscore.setStartX(0.0);
                    this.mnemonic_underscore.setStartY(0.0);
                    this.mnemonic_underscore.setEndY(0.0);
                    this.mnemonic_underscore.getStyleClass().clear();
                    this.mnemonic_underscore.getStyleClass().setAll((String[])new String[]{"mnemonic-underline"});
                    this.getChildren().add(this.mnemonic_underscore);
                }
            } else {
                string2 = ((Labeled)this.getSkinnable()).isMnemonicParsing() && Utils.isMac() && this.bindings != null ? this.bindings.getText() : labeled.getText();
                if (this.mnemonic_underscore != null && this.getChildren().contains(this.mnemonic_underscore)) {
                    this.getChildren().remove(this.mnemonic_underscore);
                    this.mnemonic_underscore = null;
                }
            }
            int n3 = string2 != null ? string2.length() : 0;
            boolean bl2 = false;
            if (string2 != null && n3 > 0 && (n = string2.indexOf(10)) > -1 && n < n3 - 1) {
                bl2 = true;
            }
            boolean bl3 = labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT;
            Insets insets = this.getInsets();
            Insets insets2 = labeled.getLabelPadding();
            if (d == -1.0) {
                d = labeled.getWidth() - insets.getLeft() - insets.getRight() - insets2.getLeft() - insets2.getRight();
            }
            double d3 = Math.min(this.minWidth(-1.0), labeled.getWidth());
            if (bl3 && !this.isIgnoreGraphic()) {
                double d4 = labeled.getGraphic().getLayoutBounds().getWidth() + labeled.getGraphicTextGap();
                d -= d4;
                d3 -= d4;
            }
            d = Math.max(d3, d);
            boolean bl4 = bl = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM;
            if (d2 == -1.0) {
                d2 = labeled.getHeight() - insets.getTop() - insets.getBottom() - insets2.getTop() - insets2.getBottom();
            }
            double d5 = this.minHeight(d);
            if (bl && labeled.getGraphic() != null) {
                double d6 = labeled.getGraphic().getLayoutBounds().getHeight() + labeled.getGraphicTextGap();
                d2 -= d6;
                d5 -= d6;
            }
            d2 = Math.max(d5, d2);
            this.textClip.setWidth(d);
            this.textClip.setHeight(d2);
            this.updateWrappingWidth();
            Font font = this.text.getFont();
            OverrunStyle overrunStyle = labeled.getTextOverrun();
            if (labeled.isWrapText()) {
                string = com.sun.javafx.scene.control.skin.Utils.computeClippedWrappedText(font, string2, d, d2, overrunStyle);
            } else if (bl2) {
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = string2.split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(com.sun.javafx.scene.control.skin.Utils.computeClippedText(font, stringArray[i], d, overrunStyle));
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append('\n');
                }
                string = stringBuilder.toString();
            } else {
                string = com.sun.javafx.scene.control.skin.Utils.computeClippedText(font, string2, d, overrunStyle);
            }
            if (string != null && string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            this.text.setText(string);
            this.updateWrappingWidth();
            this.invalidText = false;
        }
    }

    private void updateFill() {
        this.text.setFill(((Labeled)this.getSkinnable()).getTextFill());
    }

    private void updateFont() {
        Font font = ((Labeled)this.getSkinnable()).getFont();
        this.text.setFont(font == null ? Font.getDefault() : font);
    }

    private void updateTextAlignment() {
        this.text.setTextAlignment(((Labeled)this.getSkinnable()).getTextAlignment());
    }

    private void updateUnderline() {
        this.text.setUnderline(((Labeled)this.getSkinnable()).isUnderline());
    }

    private void updateWrappingWidth() {
        Labeled labeled = (Labeled)this.getSkinnable();
        this.text.setWrappingWidth(0.0);
        if (labeled.isWrapText()) {
            double d = Math.min(this.text.prefWidth(-1.0), this.textClip.getWidth());
            this.text.setWrappingWidth((int)this.snapSize(d));
        }
    }

    protected void updateChildren() {
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        if (this.graphic != null) {
            this.graphic.layoutBoundsProperty().removeListener(this.graphicPropertyChangedListener);
        }
        this.graphic = labeled.getGraphic();
        if (this.isIgnoreGraphic()) {
            if (labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Node[])new Node[]{this.text});
            }
        } else {
            this.graphic.layoutBoundsProperty().addListener(this.graphicPropertyChangedListener);
            if (this.isIgnoreText()) {
                this.getChildren().setAll((Node[])new Node[]{this.graphic});
            } else {
                this.getChildren().setAll((Node[])new Node[]{this.graphic, this.text});
            }
        }
    }

    protected boolean isIgnoreGraphic() {
        return this.graphic == null || !this.graphic.isManaged() || ((Labeled)this.getSkinnable()).getContentDisplay() == ContentDisplay.TEXT_ONLY;
    }

    protected boolean isIgnoreText() {
        Labeled labeled = (Labeled)this.getSkinnable();
        String string = labeled.getText();
        return string == null || string.equals("") || labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY;
    }

    @Override
    protected double computeMinWidth(double d) {
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        OverrunStyle overrunStyle = labeled.getTextOverrun();
        String string = labeled.getText();
        boolean bl = string == null || string.isEmpty();
        double d2 = 0.0;
        if (!bl) {
            if (overrunStyle == OverrunStyle.CLIP) {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, string.substring(0, 1), 0.0);
                }
                d2 = this.textWidth;
            } else {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, string, 0.0);
                }
                if (this.ellipsisWidth == Double.NEGATIVE_INFINITY) {
                    this.ellipsisWidth = com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, "...", 0.0);
                }
                d2 = Math.min(this.textWidth, this.ellipsisWidth);
            }
        }
        Node node = labeled.getGraphic();
        if (this.isIgnoreGraphic()) {
            return d2;
        }
        if (this.isIgnoreText()) {
            return node.minWidth(-1.0);
        }
        if (labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT) {
            return d2 + node.minWidth(-1.0) + labeled.getGraphicTextGap();
        }
        return Math.max(d2, node.minWidth(-1.0));
    }

    @Override
    protected double computeMinHeight(double d) {
        Object object;
        double d2;
        int n;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String string = labeled.getText();
        if (string != null && string.length() > 0 && (n = string.indexOf(10)) >= 0) {
            string = string.substring(0, n);
        }
        double d3 = d2 = com.sun.javafx.scene.control.skin.Utils.computeTextHeight(font, string, 0.0);
        if (!this.isIgnoreGraphic()) {
            object = labeled.getGraphic();
            d3 = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM ? ((Node)object).minHeight(-1.0) + labeled.getGraphicTextGap() + d2 : Math.max(d2, ((Node)object).minHeight(-1.0));
        }
        object = this.getInsets();
        Insets insets = labeled.getLabelPadding();
        return ((Insets)object).getTop() + d3 + ((Insets)object).getBottom() + insets.getTop() - insets.getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String string = labeled.getText();
        boolean bl = string == null || string.isEmpty();
        Insets insets = this.getInsets();
        Insets insets2 = labeled.getLabelPadding();
        double d2 = insets.getLeft() + insets.getRight() + insets2.getLeft() + insets2.getRight();
        double d3 = bl ? 0.0 : com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, string, 0.0);
        Node node = labeled.getGraphic();
        if (this.isIgnoreGraphic()) {
            return d3 + d2;
        }
        if (this.isIgnoreText()) {
            return node.prefWidth(-1.0) + d2;
        }
        if (labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT) {
            return d3 + labeled.getGraphicTextGap() + node.prefWidth(-1.0) + d2;
        }
        return Math.max(d3, node.prefWidth(-1.0)) + d2;
    }

    @Override
    protected double computePrefHeight(double d) {
        Object object;
        double d2;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String string = labeled.getText();
        if (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        double d3 = d2 = com.sun.javafx.scene.control.skin.Utils.computeTextHeight(font, string, labeled.isWrapText() ? d : 0.0);
        if (!this.isIgnoreGraphic()) {
            object = labeled.getGraphic();
            d3 = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM ? ((Node)object).prefHeight(-1.0) + labeled.getGraphicTextGap() + d2 : Math.max(d2, ((Node)object).prefHeight(-1.0));
        }
        object = this.getInsets();
        Insets insets = labeled.getLabelPadding();
        return ((Insets)object).getTop() + d3 + ((Insets)object).getBottom() + insets.getTop() + insets.getBottom();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((Labeled)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((Labeled)this.getSkinnable()).prefHeight(d);
    }

    @Override
    public double getBaselineOffset() {
        this.updateDisplayedText();
        return this.text.getLayoutBounds().getMinY() + this.text.getLayoutY() + this.text.getBaselineOffset();
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double d = insets.getLeft();
        double d2 = insets.getTop();
        double d3 = this.getWidth() - (insets.getLeft() + insets.getRight());
        double d4 = this.getHeight() - (insets.getTop() + insets.getBottom());
        this.layoutLabelInArea(d, d2, d3, d4);
    }

    protected void layoutLabelInArea(double d, double d2, double d3, double d4) {
        this.layoutLabelInArea(d, d2, d3, d4, null);
    }

    protected void layoutLabelInArea(double d, double d2, double d3, double d4, Pos pos) {
        double d5;
        double d6;
        double d7;
        double d8;
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        if (pos == null) {
            pos = labeled.getAlignment();
        }
        HPos hPos = pos.getHpos();
        VPos vPos = pos.getVpos();
        boolean bl = this.isIgnoreGraphic();
        boolean bl2 = this.isIgnoreText();
        Insets insets = labeled.getLabelPadding();
        d += insets.getLeft();
        d2 += insets.getTop();
        d3 -= insets.getLeft() + insets.getRight();
        d4 -= insets.getTop() + insets.getBottom();
        if (bl) {
            d8 = 0.0;
            d7 = 0.0;
        } else if (bl2) {
            if (this.graphic.isResizable()) {
                Orientation orientation = this.graphic.getContentBias();
                if (orientation == Orientation.HORIZONTAL) {
                    d7 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d3, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    d8 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d4, this.graphic.minHeight(d7), this.graphic.maxHeight(d7));
                } else if (orientation == Orientation.VERTICAL) {
                    d8 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d4, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                    d7 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d3, this.graphic.minWidth(d8), this.graphic.maxHeight(d8));
                } else {
                    d7 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d3, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    d8 = com.sun.javafx.scene.control.skin.Utils.boundedSize(d4, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                }
                this.graphic.resize(d7, d8);
            } else {
                d7 = this.graphic.getLayoutBounds().getWidth();
                d8 = this.graphic.getLayoutBounds().getHeight();
            }
        } else {
            this.graphic.autosize();
            d7 = this.graphic.getLayoutBounds().getWidth();
            d8 = this.graphic.getLayoutBounds().getHeight();
        }
        if (bl2) {
            d6 = 0.0;
            d5 = 0.0;
            this.text.setText("");
        } else {
            this.updateDisplayedText(d3, d4);
            d5 = Math.min(this.text.getLayoutBounds().getWidth(), this.textClip.getWidth());
            d6 = Math.min(this.text.getLayoutBounds().getHeight(), this.textClip.getHeight());
        }
        double d9 = bl2 || bl ? 0.0 : labeled.getGraphicTextGap();
        double d10 = Math.max(d7, d5);
        double d11 = Math.max(d8, d6);
        if (contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM) {
            d11 = d8 + d9 + d6;
        } else if (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT) {
            d10 = d7 + d9 + d5;
        }
        double d12 = hPos == HPos.LEFT ? d : (hPos == HPos.RIGHT ? d + (d3 - d10) : d + (d3 - d10) / 2.0);
        double d13 = vPos == VPos.TOP ? d2 : (vPos == VPos.BOTTOM ? d2 + (d4 - d11) : d2 + (d4 - d11) / 2.0);
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        if (this.containsMnemonic) {
            Font font = this.text.getFont();
            String string = this.bindings.getText();
            d14 = com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, string.substring(0, this.bindings.getMnemonicIndex()), 0.0);
            d15 = com.sun.javafx.scene.control.skin.Utils.computeTextWidth(font, string.substring(this.bindings.getMnemonicIndex(), this.bindings.getMnemonicIndex() + 1), 0.0);
            d16 = com.sun.javafx.scene.control.skin.Utils.computeTextHeight(font, "_", 0.0);
        }
        this.text.setManaged(true);
        if (bl && bl2) {
            this.text.setManaged(false);
            this.text.relocate(this.snapPosition(d12), this.snapPosition(d13));
        } else if (bl) {
            this.text.relocate(this.snapPosition(d12), this.snapPosition(d13));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(d15 - 2.0);
                this.mnemonic_underscore.relocate(d12 + d14, d13 + d16 - 1.0);
            }
        } else if (bl2) {
            this.text.relocate(this.snapPosition(d12), this.snapPosition(d13));
            this.graphic.relocate(this.snapPosition(d12), this.snapPosition(d13));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(d15);
                this.mnemonic_underscore.setStrokeWidth(d16 / 10.0);
                this.mnemonic_underscore.relocate(d12 + d14, d13 + d16 - 1.0);
            }
        } else {
            double d17 = 0.0;
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = 0.0;
            if (contentDisplay == ContentDisplay.TOP) {
                d17 = d12 + (d10 - d7) / 2.0;
                d19 = d12 + (d10 - d5) / 2.0;
                d18 = d13;
                d20 = d18 + d8 + d9;
            } else if (contentDisplay == ContentDisplay.RIGHT) {
                d19 = d12;
                d17 = d19 + d5 + d9;
                d18 = d13 + (d11 - d8) / 2.0;
                d20 = d13 + (d11 - d6) / 2.0;
            } else if (contentDisplay == ContentDisplay.BOTTOM) {
                d17 = d12 + (d10 - d7) / 2.0;
                d19 = d12 + (d10 - d5) / 2.0;
                d20 = d13;
                d18 = d20 + d6 + d9;
            } else if (contentDisplay == ContentDisplay.LEFT) {
                d17 = d12;
                d19 = d17 + d7 + d9;
                d18 = d13 + (d11 - d8) / 2.0;
                d20 = d13 + (d11 - d6) / 2.0;
            } else if (contentDisplay == ContentDisplay.CENTER) {
                d17 = d12 + (d10 - d7) / 2.0;
                d19 = d12 + (d10 - d5) / 2.0;
                d18 = d13 + (d11 - d8) / 2.0;
                d20 = d13 + (d11 - d6) / 2.0;
            }
            this.text.relocate(this.snapPosition(d19), this.snapPosition(d20));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(d15);
                this.mnemonic_underscore.setStrokeWidth(d16 / 10.0);
                this.mnemonic_underscore.relocate(this.snapPosition(d19 + d14), this.snapPosition(d20 + d16 - 1.0));
            }
            this.graphic.relocate(this.snapPosition(d17), this.snapPosition(d18));
        }
        this.textClip.setX(this.text.getLayoutBounds().getMinX());
        this.textClip.setY(this.text.getLayoutBounds().getMinY());
    }
}

