/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.StackPane;

public class CheckBoxSkin
extends LabeledSkinBase<CheckBox, ButtonBehavior<CheckBox>> {
    private StackPane box = new StackPane();
    private StackPane innerbox;

    public CheckBoxSkin(CheckBox checkBox) {
        super(checkBox, new ButtonBehavior<CheckBox>(checkBox));
        this.box.getStyleClass().setAll((String[])new String[]{"box"});
        this.innerbox = new StackPane();
        this.innerbox.getStyleClass().setAll((String[])new String[]{"mark"});
        this.box.getChildren().add(this.innerbox);
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.getChildren().add(this.box);
    }

    @Override
    protected double computePrefWidth(double d) {
        return super.computePrefWidth(d) + this.snapSize(this.box.prefWidth(d));
    }

    @Override
    protected double computePrefHeight(double d) {
        return Math.max(super.computePrefHeight(d), this.getInsets().getTop() + this.box.prefHeight(d) + this.getInsets().getBottom());
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double d = this.getWidth() - insets.getLeft() - insets.getRight();
        double d2 = this.getHeight() - insets.getTop() - insets.getBottom();
        double d3 = this.box.prefWidth(-1.0);
        double d4 = this.box.prefHeight(-1.0);
        double d5 = Math.min(this.prefWidth(-1.0) - d3, d - this.snapSize(d3));
        double d6 = Math.min(this.prefHeight(d5), d2);
        double d7 = Math.max(d4, d6);
        double d8 = Utils.computeXOffset(d, d5 + d3, ((CheckBox)this.getSkinnable()).getAlignment().getHpos()) + insets.getLeft();
        double d9 = Utils.computeYOffset(d2, d7, ((CheckBox)this.getSkinnable()).getAlignment().getVpos()) + insets.getTop();
        this.layoutLabelInArea(d8 + d3, d9, d5, d7, Pos.CENTER_LEFT);
        this.box.resize(this.snapSize(d3), this.snapSize(d4));
        this.positionInArea(this.box, d8, d9, d3, d7, this.getBaselineOffset(), HPos.CENTER, VPos.CENTER);
    }
}

