/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class TreeViewBehavior<T>
extends BehaviorBase<TreeView<T>> {
    protected static final List<KeyBinding> TREE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private int selectPos = -1;
    private Callback<Void, Integer> onScrollPageUp;
    private Callback<Void, Integer> onScrollPageDown;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;

    @Override
    protected void callAction(String string) {
        if ("SelectPreviousRow".equals(string)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(string)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(string)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(string)) {
            this.selectLastRow();
        } else if ("SelectAllPageUp".equals(string)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(string)) {
            this.selectAllPageDown();
        } else if ("SelectAllToFirstRow".equals(string)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(string)) {
            this.selectAllToLastRow();
        } else if ("AlsoSelectNextRow".equals(string)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(string)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(string)) {
            this.clearSelection();
        } else if ("SelectAll".equals(string)) {
            this.selectAll();
        } else if ("ScrollUp".equals(string)) {
            this.scrollUp();
        } else if ("ScrollDown".equals(string)) {
            this.scrollDown();
        } else if ("ExpandRow".equals(string)) {
            this.expandRow();
        } else if ("CollapseRow".equals(string)) {
            this.collapseRow();
        } else if ("Edit".equals(string)) {
            this.edit();
        } else if ("CancelEdit".equals(string)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(string)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(string)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(string)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(string)) {
            this.selectAllToFocus();
        } else if ("FocusPageUp".equals(string)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(string)) {
            this.focusPageDown();
        } else {
            super.callAction(string);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TREE_VIEW_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.isShiftDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
        super.callActionForEvent(keyEvent);
    }

    public void setOnScrollPageUp(Callback<Void, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Void, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public TreeViewBehavior(TreeView treeView) {
        super(treeView);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.selectPos = -1;
        if (!((TreeView)this.getControl()).isFocused() && ((TreeView)this.getControl()).isFocusTraversable()) {
            ((TreeView)this.getControl()).requestFocus();
        }
    }

    private void clearSelection() {
        ((TreeView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollUp() {
        int n = -1;
        if (this.onScrollPageUp != null) {
            n = this.onScrollPageUp.call(null);
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void scrollDown() {
        int n = -1;
        if (this.onScrollPageDown != null) {
            n = this.onScrollPageDown.call(null);
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void focusFirstRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPageUp() {
        int n = this.onScrollPageUp.call(null);
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void focusPageDown() {
        int n = this.onScrollPageDown.call(null);
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void alsoSelectPreviousRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.selectPos > -1) {
            int n2 = this.selectPos < n ? n : n - 2;
            multipleSelectionModel.selectRange(this.selectPos, n2);
            this.selectPos = -1;
        } else if (this.isShiftDown && multipleSelectionModel.isSelected(n - 1)) {
            multipleSelectionModel.clearSelection(n);
            focusModel.focus(n - 1);
        } else {
            if (!multipleSelectionModel.isSelected(n)) {
                multipleSelectionModel.select(n);
            }
            multipleSelectionModel.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.selectPos > -1) {
            int n2 = this.selectPos > n ? n : n + 2;
            multipleSelectionModel.selectRange(this.selectPos, n2);
            this.selectPos = -1;
        } else if (this.isShiftDown && multipleSelectionModel.isSelected(n + 1)) {
            multipleSelectionModel.clearSelection(n);
            focusModel.focus(n);
        } else {
            if (!multipleSelectionModel.isSelected(n)) {
                multipleSelectionModel.select(n);
            }
            multipleSelectionModel.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void selectPreviousRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n <= 0) {
            return;
        }
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(n - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n == ((TreeView)this.getControl()).impl_getTreeItemCount() - 1) {
            return;
        }
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(n + 1);
        this.onSelectNextRow.run();
    }

    private void selectFirstRow() {
        if (((TreeView)this.getControl()).impl_getTreeItemCount() > 0) {
            ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        this.onMoveToLastCell.run();
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            this.selectPos = n = this.selectPos == -1 ? multipleSelectionModel.getSelectedIndex() : this.selectPos;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(0, n + 1);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            this.selectPos = n = this.selectPos == -1 ? multipleSelectionModel.getSelectedIndex() : this.selectPos;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, ((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        ((TreeView)this.getControl()).getSelectionModel().selectAll();
    }

    private void selectAllPageUp() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            this.selectPos = n = this.selectPos == -1 ? n : this.selectPos;
        }
        int n2 = this.onScrollPageUp.call(null);
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n2, n + 1);
    }

    private void selectAllPageDown() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            this.selectPos = n = this.selectPos == -1 ? n : this.selectPos;
        }
        int n2 = this.onScrollPageDown.call(null);
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, n2 + 1);
    }

    private void selectAllToFocus() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = multipleSelectionModel.getSelectedIndex();
        multipleSelectionModel.clearSelection();
        int n3 = n2;
        int n4 = n2 > n ? n - 1 : n + 1;
        multipleSelectionModel.selectRange(n3, n4);
    }

    private void expandRow() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        treeItem.setExpanded(true);
    }

    private void collapseRow() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        TreeItem treeItem2 = ((TreeView)this.getControl()).getRoot();
        if (treeItem2 == null) {
            return;
        }
        if (!((TreeView)this.getControl()).isShowRoot() && !treeItem.isExpanded() && treeItem2.equals(treeItem.getParent())) {
            return;
        }
        if (treeItem.isLeaf() || !treeItem.isExpanded()) {
            ((TreeView)this.getControl()).getSelectionModel().clearSelection();
            ((TreeView)this.getControl()).getSelectionModel().select(treeItem.getParent());
        } else {
            treeItem.setExpanded(false);
        }
    }

    private void cancelEdit() {
        ((TreeView)this.getControl()).edit(null);
    }

    private void edit() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        ((TreeView)this.getControl()).edit(treeItem);
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (multipleSelectionModel.isSelected(n)) {
            multipleSelectionModel.clearSelection(n);
        } else {
            multipleSelectionModel.select(n);
        }
    }

    static {
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").ctrl());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").ctrl());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        if (Utils.isMac()) {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SLASH, "SelectAll").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").meta());
        } else {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SLASH, "SelectAll").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").ctrl());
        }
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
    }
}

